/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.ant;

import com.ecc.ide.ant.RunAntInIDE;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.BuildProblemReporter;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.taskdefs.Copy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class BuildJspTask
extends Copy
implements BuildProblemReporter {
    public static String compileType = "jsp";
    protected String srcPath = null;
    protected String srcFile = null;
    protected String destPath = null;
    protected String subFolder = null;

    public void execute() {
        IFile file;
        IProject eclipseProject = this.getEclipseProject();
        if (this.srcPath != null && this.srcPath.length() > 0) {
            IFolder folder = eclipseProject.getFolder(this.srcPath);
            this.compile((IContainer)folder);
        } else if (this.srcFile != null && this.srcFile.length() > 0 && (file = eclipseProject.getFile(this.srcFile)).exists()) {
            this.compile(file);
        }
    }

    public void setSubFolder(String subFolder) {
        this.subFolder = subFolder;
    }

    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    protected void compile(IContainer folder) {
        block8: {
            try {
                if (!folder.exists()) break block8;
                try {
                    IResource[] resources = folder.members();
                    int i = 0;
                    while (i < resources.length) {
                        if (resources[i] instanceof IContainer) {
                            this.compile((IContainer)resources[i]);
                        } else if (resources[i] instanceof IFile) {
                            this.compile((IFile)resources[i]);
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void makeFolder(IProject project, String path) {
        try {
            path = path.replace('\\', '/');
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            while (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            String tempFolderName = "";
            while (path.indexOf("/") != -1) {
                tempFolderName = String.valueOf(tempFolderName) + "/" + path.substring(0, path.indexOf("/"));
                path = path.substring(path.indexOf("/") + 1, path.length());
                IFolder folder = project.getFolder(tempFolderName);
                if (folder.exists()) continue;
                folder.create(true, true, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final IProject getEclipseProject() {
        String prjId = this.getProject().getProperty("projectPath");
        if (prjId == null || prjId.length() == 0) {
            return null;
        }
        if (prjId.indexOf("\\") != -1) {
            prjId = prjId.substring(prjId.lastIndexOf("\\") + 1, prjId.length());
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject prj = projects[i];
            if (prj.getName().equals(prjId)) {
                return prj;
            }
            ++i;
        }
        return null;
    }

    public final void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        System.out.println(msg);
    }

    public final void reportProblem(int type, String msg, String detail) {
        System.out.println(msg);
    }

    protected void compile(IFile file) {
        Vector lss = this.getProject().getBuildListeners();
        DefaultLogger logger = null;
        int i = 0;
        while (i < lss.size()) {
            if (lss.elementAt(i) instanceof DefaultLogger) {
                logger = (DefaultLogger)lss.elementAt(i);
                logger.setMessageOutputLevel(0);
                break;
            }
            ++i;
        }
        if (compileType.equals(file.getFileExtension()) || "tsk".equals(file.getFileExtension())) {
            this.subFolder = IDEContent.getSubFolder(file.getFullPath().toOSString(), file.getName());
            String groupId = IDEContent.getGroupId(file.getFullPath().toOSString());
            String outputFolder = String.valueOf(this.destPath) + "/" + groupId + "/";
            if (this.subFolder.length() > 0) {
                outputFolder = String.valueOf(outputFolder) + this.subFolder + "/";
            }
            BuildJspTask.makeFolder(this.getEclipseProject(), outputFolder);
            boolean result = this.copy(file.getLocation().toOSString(), String.valueOf(this.getEclipseProject().getLocation().toOSString()) + "/" + outputFolder + file.getName());
            ++RunAntInIDE.buildCounter;
            if (result) {
                this.getProject().log("\"" + file.getFullPath().toOSString() + "\" is build.", 0);
            } else {
                this.getProject().log("\"" + file.getFullPath().toOSString() + "\" is build fail.", 0);
            }
            try {
                IFolder folder = null;
                folder = this.getEclipseProject().getFolder(outputFolder);
                folder.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (logger != null) {
            logger.setMessageOutputLevel(2);
        }
    }

    protected boolean copy(String srcFilePath, String destFilePath) {
        try {
            File file = new File(destFilePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            File srcFile = new File(srcFilePath);
            this.setProject(this.getProject());
            this.setTofile(file);
            this.setFile(srcFile);
            this.setOverwrite(true);
            super.execute();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

