/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.ant;

import com.ecc.emp.ide.builder.EMPBuilder;
import com.ecc.ide.ant.CommonTask;
import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.classloader.DynamicClassLoader;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.io.FileOutputStream;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public abstract class BuildTask
extends CommonTask
implements BuildProblemReporter {
    protected String srcPath = null;
    protected String srcFile = null;
    protected String destPath = null;
    protected String subFolder = null;

    public void execute() {
        IFile file;
        IProject eclipseProject = this.getEclipseProject();
        if (this.srcPath != null && this.srcPath.length() > 0) {
            IFolder folder = eclipseProject.getFolder(this.srcPath);
            this.compile((IContainer)folder);
        } else if (this.srcFile != null && this.srcFile.length() > 0 && (file = eclipseProject.getFile(this.srcFile)).exists()) {
            this.compile(file);
        }
    }

    public void setSubFolder(String subFolder) {
        this.subFolder = subFolder;
    }

    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    protected void compile(IContainer folder) {
        block8: {
            try {
                if (!folder.exists()) break block8;
                try {
                    IResource[] resources = folder.members();
                    int i = 0;
                    while (i < resources.length) {
                        if (resources[i] instanceof IContainer) {
                            this.compile((IContainer)resources[i]);
                        } else if (resources[i] instanceof IFile) {
                            this.compile((IFile)resources[i]);
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract void compile(IFile var1);

    public static void makeFolder(IProject project, String path) {
        try {
            path = path.replace('\\', '/');
            if (path.lastIndexOf(".") > path.lastIndexOf("/")) {
                path = path.substring(0, path.lastIndexOf("/"));
            }
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            while (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            String tempFolderName = "";
            while (path.indexOf("/") != -1) {
                tempFolderName = String.valueOf(tempFolderName) + "/" + path.substring(0, path.indexOf("/"));
                path = path.substring(path.indexOf("/") + 1, path.length());
                IFolder folder = project.getFolder(tempFolderName);
                if (folder.exists()) continue;
                folder.create(true, true, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EMPBuilder getBuilder(String className) {
        EMPBuilder builder = null;
        try {
            builder = (EMPBuilder)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            builder = (EMPBuilder)DynamicClassLoader.loadDynamicObject(this.getEclipseProject(), className);
        }
        return builder;
    }

    public XMLNode getServletNode(XMLNode webxmlNode, String servletName) {
        if (webxmlNode == null) {
            return null;
        }
        Vector nodes = webxmlNode.getChilds();
        int i = 0;
        while (i < nodes.size()) {
            XMLNode attrNode;
            String value;
            XMLNode child = (XMLNode)nodes.elementAt(i);
            if ("servlet".equals(child.getNodeName()) && (value = (attrNode = child.getChild("servlet-name")).getNodeValue()).equals(servletName)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public String getWebXmlRelaPath() {
        String webPath = "/WEB-INF/web.xml";
        IDEProjectSettings prjSettings = IDEContent.getPRJSettings(this.getEclipseProject());
        webPath = String.valueOf(prjSettings.getWebContentPath()) + webPath;
        return webPath;
    }

    public XMLNode getWebXmlNode() {
        IFile file = this.getEclipseProject().getFile(this.getWebXmlRelaPath());
        XMLNode webNode = this.loadXMLContent(file.getLocation().toOSString());
        return webNode;
    }

    public void sortAndSaveWebXml(XMLNode webxmlNode) throws Exception {
        String[] NodeList = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping", "session-config", "mime-mapping", "welcome-file-list", "error-page", "taglib", "resource-env-ref", "resource-ref", "security-constraint", "login-config", "security-role", "env-entry", "ejb-ref", "ejb-local-ref"};
        Vector nodes = webxmlNode.getChilds();
        int j = 0;
        while (j < NodeList.length) {
            int i = 0;
            while (i < nodes.size()) {
                XMLNode node = (XMLNode)nodes.elementAt(i);
                if (NodeList[j].equals(node.getNodeName())) {
                    this.removeExistedNode(webxmlNode, node, node.getNodeName(), node.getFirstNode().getNodeName());
                    webxmlNode.add(node);
                }
                ++i;
            }
            ++j;
        }
        StringBuffer strBuf = new StringBuffer();
        webxmlNode.toXMLContent(0, strBuf, true);
        FileOutputStream fo = new FileOutputStream(this.getEclipseProject().getFile(this.getWebXmlRelaPath()).getLocation().toOSString());
        fo.write(strBuf.toString().getBytes(IDEConstance.encoding));
        fo.close();
        IDEProjectSettings prjSettings = IDEContent.getPRJSettings(this.getEclipseProject());
        try {
            this.getEclipseProject().getFolder(String.valueOf(prjSettings.getWebContentPath()) + "/WEB-INF").refreshLocal(2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.toConsole("web.xml is build succ.");
    }

    private void removeExistedNode(XMLNode webxmlNode, XMLNode removeNode, String nodeName, String attrName) {
        if (webxmlNode == null || removeNode == null) {
            return;
        }
        String newServletName = removeNode.getChild(attrName).getNodeValue();
        Vector nodes = webxmlNode.getChilds();
        int i = 0;
        while (i < nodes.size()) {
            XMLNode nameNode;
            String value;
            XMLNode node = (XMLNode)nodes.elementAt(i);
            if (nodeName.equals(node.getNodeName()) && (value = (nameNode = node.getChild(attrName)).getNodeValue()).equals(newServletName)) {
                webxmlNode.remove(node);
                return;
            }
            ++i;
        }
    }

    public final void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        if (fileName != null && fileName.length() > 0 && e != null) {
            if (fileName.indexOf("\\") != -1) {
                fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
            }
            if (fileName.indexOf("/") != -1) {
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            }
            this.toConsole("[" + fileName + "] found:" + e.toString());
        }
        this.toConsole(msg);
    }

    public final void reportProblem(int type, String msg, String detail) {
    }
}

