/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.ant;

import com.ecc.ide.ant.CommonTask;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.refactor.IDEClassRefactor;
import java.io.FileWriter;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

public class CompilerAllTask
extends CommonTask {
    Vector result = new Vector();
    Vector files = new Vector();
    String srcFile = null;

    public void execute() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject[] projects = workspace.getRoot().getProjects();
            EditorProfile interfaces = ModuleUtility.getComponentProfile(projects[0], 41);
            Vector elements = interfaces.getElements();
            int i = 0;
            while (i < elements.size()) {
                EditorProfile profile;
                Element element = (Element)elements.elementAt(i);
                if ("defaultElement".equals(element.getLabel())) {
                    this.result = new Vector();
                    profile = new EditorProfile();
                    this.buildElement(profile, null);
                    this.saveProfile(profile, "c:\\refProfile.xml");
                } else {
                    this.result = new Vector();
                    profile = new EditorProfile();
                    this.buildElement(profile, element.getLabel());
                    this.saveProfile(profile, "c:\\" + element.getLabel() + ".xml");
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveProfile(EditorProfile profile, String profileFileName) {
        StringBuffer strBuf = new StringBuffer();
        profile.toXMLString(strBuf);
        try {
            FileWriter fw = new FileWriter(profileFileName);
            fw.write(strBuf.toString());
            fw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void buildElement(EditorProfile profile, String compilerType) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        int k = 0;
        while (k < projects.length) {
            IProject eclipseProject = projects[k];
            String srcPath = this.getProject().getProperty("javaSrcPath");
            IFolder folder = eclipseProject.getFolder(srcPath);
            try {
                this.getElements(folder, compilerType);
                int i = 0;
                while (i < this.result.size()) {
                    String elementName;
                    Element element = (Element)this.result.elementAt(i);
                    ElementCatalog extendCatalog = null;
                    int w = 0;
                    while (w < profile.getCagalogs().size()) {
                        ElementCatalog catalog = (ElementCatalog)profile.getCagalogs().elementAt(w);
                        if (element.destCatalog.equals(catalog.getCatalogName())) {
                            extendCatalog = catalog;
                            break;
                        }
                        ++w;
                    }
                    if (extendCatalog == null) {
                        extendCatalog = new ElementCatalog();
                        extendCatalog.setCatalogName(element.destCatalog);
                        extendCatalog.setLabel(element.destCatalog);
                        profile.add(extendCatalog);
                    }
                    if (profile.getElement(elementName = element.getElementName()) != null) {
                        profile.deleteElement(elementName);
                    }
                    extendCatalog.add(element);
                    XMLNode node = new XMLNode();
                    node.setAttrValue("id", elementName);
                    node.setAttrValue("allowedCount", "*");
                    node.setAttrValue("desc", elementName);
                    ElementChild elementChild = new ElementChild(node);
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++k;
        }
    }

    private void getElements(IFolder folder, String compilerType) {
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                block8: {
                    if (resources[i] instanceof IFile) {
                        try {
                            if (this.files.contains(resources[i])) break block8;
                            this.log("TYPE:" + compilerType + " " + ((IFile)resources[i]).getLocation().toOSString());
                            Element o = IDEClassRefactor.createElement((IFile)resources[i], compilerType);
                            if (o != null) {
                                this.result.add(o);
                                this.files.add(resources[i]);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (resources[i] instanceof IFolder) {
                        this.getElements((IFolder)resources[i], compilerType);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

