/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.ant;

import com.ecc.ide.ant.CommonTask;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.refactor.IDEClassRefactor;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class CompilerFunctionTask
extends CommonTask {
    Vector result = new Vector();
    String compilerType = "Function";
    String srcFile = null;

    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public void execute() {
        IProject eclipseProject = this.getEclipseProject();
        String srcPath = this.getProject().getProperty("javaSrcPath");
        IFolder folder = eclipseProject.getFolder(srcPath);
        try {
            if (this.srcFile == null || this.srcFile.length() == 0) {
                this.srcFile = this.getProject().getProperty("srcFile");
            }
            if (this.srcFile != null && this.srcFile.length() > 0) {
                try {
                    IFile file = eclipseProject.getFile(this.srcFile);
                    Element element = IDEClassRefactor.createElement(file, this.compilerType);
                    if (element != null) {
                        this.result.add(element);
                    }
                }
                catch (Exception file) {}
            } else {
                this.getElements(folder);
            }
            XMLNode functionDefines = IDEContent.getSettingNode(eclipseProject, 29);
            int i = 0;
            while (i < this.result.size()) {
                Element element = (Element)this.result.elementAt(i);
                String id = element.getElementName();
                XMLNode old = functionDefines.findIgnoreCaseThrowChildNode("Func", id);
                if (old != null) {
                    old.getParent().remove(old);
                }
                XMLNode groupNode = null;
                int w = 0;
                while (w < functionDefines.getChilds().size()) {
                    XMLNode child = (XMLNode)functionDefines.getChilds().elementAt(w);
                    if ("FuncGroup".equals(child.getNodeName()) && element.destCatalog.equals(child.getAttrValue("id"))) {
                        groupNode = child;
                        break;
                    }
                    ++w;
                }
                if (groupNode == null) {
                    groupNode = new XMLNode("FuncGroup");
                    groupNode.setAttrValue("id", element.destCatalog);
                    functionDefines.add(groupNode);
                }
                XMLNode function = new XMLNode("Func");
                function.setAttrValue("id", element.getElementName());
                function.setAttrValue("name", element.getLabel());
                function.setAttrValue("defineName", element.getElementName());
                function.setAttrValue("className", element.getImplClass());
                function.setAttrValue("document", element.getDocument());
                groupNode.add(function);
                ++i;
            }
            IDEContent.saveSettingNode(eclipseProject, 29);
            String webcontentpath = IDEContent.getPRJSettings(eclipseProject).getWebContentPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getElements(IFolder folder) {
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    try {
                        Element o = IDEClassRefactor.createElement((IFile)resources[i], this.compilerType);
                        if (o != null) {
                            this.result.add(o);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (resources[i] instanceof IFolder) {
                    this.getElements((IFolder)resources[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

