/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.ant;

import com.ecc.ide.ant.CommonTask;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.refactor.IDEClassRefactor;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class CompilerTask
extends CommonTask {
    Vector result = new Vector();
    String compilerType = "";
    String srcFile = null;
    StringBuffer msg = new StringBuffer("");

    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public void setCompilerType(String type) {
        try {
            this.compilerType = type;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void execute() {
        IProject eclipseProject = this.getEclipseProject();
        String srcPath = this.getProject().getProperty("javaSrcPath");
        IFolder folder = eclipseProject.getFolder(srcPath);
        try {
            Element element;
            EditorProfile profile = null;
            if ("EMPAction".equals(this.compilerType)) {
                profile = IDEProfile.getEditorProfile(eclipseProject, 5);
            }
            if ("EMPService".equals(this.compilerType)) {
                profile = IDEProfile.getEditorProfile(eclipseProject, 13);
            }
            if (this.srcFile == null || this.srcFile.length() == 0) {
                this.srcFile = this.getProject().getProperty("srcFile");
            }
            if (this.srcFile != null && this.srcFile.length() > 0) {
                try {
                    IFile file = eclipseProject.getFile(this.srcFile);
                    element = IDEClassRefactor.createElement(file, this.compilerType);
                    if (element != null) {
                        this.result.add(element);
                    }
                }
                catch (Exception file) {}
            } else {
                this.getElements(folder, profile);
            }
            int i = 0;
            while (i < this.result.size()) {
                String elementName;
                element = (Element)this.result.elementAt(i);
                ElementCatalog extendCatalog = null;
                int w = 0;
                while (w < profile.getCagalogs().size()) {
                    ElementCatalog catalog = (ElementCatalog)profile.getCagalogs().elementAt(w);
                    if (element.destCatalog.equals(catalog.getCatalogName())) {
                        extendCatalog = catalog;
                        break;
                    }
                    ++w;
                }
                if (extendCatalog == null) {
                    extendCatalog = new ElementCatalog();
                    extendCatalog.setCatalogName(element.destCatalog);
                    extendCatalog.setLabel(element.destCatalog);
                    profile.add(extendCatalog);
                }
                if (profile.getElement(elementName = element.getElementName()) != null) {
                    profile.deleteElement(elementName);
                }
                extendCatalog.add(element);
                XMLNode node = new XMLNode();
                node.setAttrValue("id", elementName);
                node.setAttrValue("allowedCount", "*");
                node.setAttrValue("desc", elementName);
                ElementChild child = new ElementChild(node);
                String rootElement = "";
                if ("EMPAction".equals(this.compilerType)) {
                    rootElement = "flow";
                }
                if ("EMPService".equals(this.compilerType)) {
                    rootElement = "Services";
                }
                profile.getElement(rootElement).addChild(child);
                ++i;
            }
            if (this.result.size() == 0) {
                return;
            }
            if ("EMPAction".equals(this.compilerType)) {
                IDEProfile.saveEditorProfile(eclipseProject, 5, profile);
            }
            if ("EMPService".equals(this.compilerType)) {
                IDEProfile.saveEditorProfile(eclipseProject, 13, profile);
            }
            this.log(new String(this.msg));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getElements(IFolder folder, EditorProfile profile) {
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    try {
                        Element o = IDEClassRefactor.createElement((IFile)resources[i], this.compilerType);
                        if (o != null) {
                            this.msg.append(" " + ((IFile)resources[i]).getLocation().toOSString() + "\n");
                            this.result.add(o);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (resources[i] instanceof IFolder) {
                    this.getElements((IFolder)resources[i], profile);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

