/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.ant;

import com.ecc.emp.ide.table.One2MultiWrapper;
import com.ecc.emp.ide.table.TableModelWrapper;
import com.ecc.ide.ant.BuildTask;
import com.ecc.ide.ant.CommonTask;
import com.ecc.ide.ant.TempletFile;
import com.ecc.ide.ant.TempletProperty;
import com.ecc.ide.ant.TempletRefFile;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.jsp.JspTagBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;

public class VelocityTask
extends CommonTask
implements BuildProblemReporter {
    private Vector properties = new Vector();
    private Vector items = new Vector();
    private Vector refItems = new Vector();
    private String modelFile = null;
    private String subPath = null;
    private String commitWay = null;
    private String templetPath = "designFiles/.templets";
    private String inputEncoding = "UTF-8";
    private String outputEncoding;
    private String javaEncoding = this.outputEncoding = "UTF-8";
    private String xmlEncoding = this.outputEncoding;
    private String jspEncoding = "UTF-8";
    private IProject project = null;
    private VelocityEngine engine = null;

    public TempletProperty createTempletProperty() {
        TempletProperty property = new TempletProperty();
        this.properties.add(property);
        return property;
    }

    public TempletFile createTempletFile() {
        TempletFile file = new TempletFile();
        this.items.add(file);
        return file;
    }

    public TempletFile createTempletRefFile() {
        TempletRefFile file = new TempletRefFile();
        this.refItems.add(file);
        return file;
    }

    public void setModelFile(String modelFile) {
        this.modelFile = modelFile;
    }

    public void setSubPath(String subPath) {
        this.subPath = subPath;
    }

    public void execute() {
        this.project = this.getEclipseProject();
        this.initVelocity();
        VelocityContext context = new VelocityContext();
        context.put("outputEncode", (Object)this.outputEncoding);
        context.put("javaEncode", (Object)this.javaEncoding);
        context.put("xmlEncode", (Object)this.xmlEncoding);
        context.put("jspEncode", (Object)this.jspEncoding);
        int i = 0;
        while (i < this.properties.size()) {
            TempletProperty property = (TempletProperty)this.properties.elementAt(i);
            String value = this.getProject().getProperty(property.id);
            context.put(property.id, (Object)value);
            ++i;
        }
        IFile modelFile = this.project.getFile(this.modelFile);
        if (!modelFile.exists()) {
            MessageDialog.openError(null, (String)"\u6a21\u578b\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef", (String)("\u8868\u6a21\u578b\u6587\u4ef6\uff1a" + modelFile.getLocation() + "\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        try {
            TableModelWrapper tableModel = TableModelWrapper.getModelWraInstance(modelFile);
            if ("true".equals(this.commitWay)) {
                tableModel.setChildTableName2Field();
            }
            context.put("TableModel", (Object)tableModel);
            context.put("subPath", (Object)this.subPath);
            String packageName = this.subPath.replace('/', '.');
            context.put("packageName", (Object)packageName);
            IFile propertyFile = this.project.getFile("designFiles/commons/jspTagGenerator.xml");
            XMLNode propNode = this.loadXMLContent(propertyFile.getLocation().toString());
            JspTagBuilder builder = JspTagBuilder.getInstance(this.project, propNode);
            context.put("JspBuilder", (Object)builder);
            int i2 = 0;
            while (i2 < this.items.size()) {
                TempletFile file = (TempletFile)this.items.elementAt(i2);
                this.runTemplet(file, context);
                ++i2;
            }
            List multiRefs = tableModel.getOne2multiList();
            int i3 = 0;
            while (i3 < multiRefs.size()) {
                One2MultiWrapper wrapper = (One2MultiWrapper)multiRefs.get(i3);
                TableModelWrapper refWrapper = wrapper.getModelWra();
                context.put("TableModel", (Object)refWrapper);
                int j = 0;
                while (j < this.refItems.size()) {
                    TempletRefFile refFile = (TempletRefFile)this.refItems.elementAt(j);
                    refFile = (TempletRefFile)refFile.clone();
                    refFile.tofile = refFile.tofile.replace('$', '#');
                    refFile.tofile = refFile.tofile.replace('{', '_');
                    refFile.tofile = refFile.tofile.replace('}', '_');
                    refFile.tofile = refFile.tofile.replaceAll("#_RefId_", refWrapper.getTableId());
                    refFile.tofile = refFile.tofile.replaceAll("#_refId_", refWrapper.getTableId().toLowerCase());
                    refFile.tofile = refFile.tofile.replaceAll("#_refPath_", wrapper.subPath);
                    this.runTemplet(refFile, context);
                    ++j;
                }
                ++i3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runTemplet(TempletFile file, VelocityContext context) throws IOException {
        String templetEncode = this.outputEncoding;
        if (file.templetId.endsWith("java")) {
            templetEncode = this.javaEncoding;
        } else if (file.templetId.endsWith("xml")) {
            templetEncode = this.xmlEncoding;
        } else if (file.templetId.endsWith("jsp")) {
            templetEncode = this.jspEncoding;
        }
        this.engine.setProperty("output.encoding", (Object)templetEncode);
        Template template = null;
        try {
            template = this.engine.getTemplate(String.valueOf(file.templetId) + ".vm");
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringWriter stringWriter = new StringWriter();
        try {
            template.merge((Context)context, (Writer)stringWriter);
            System.out.println(stringWriter.toString());
        }
        catch (Exception e) {
            this.reportProblem(2, "", "", file.tofile, e);
            this.toConsole("\"" + file.tofile + "\" is added failed.");
            return;
        }
        String content = stringWriter.toString();
        BuildTask.makeFolder(this.getEclipseProject(), file.tofile);
        String fileName = String.valueOf(this.getEclipseProject().getLocation().toOSString()) + "/" + file.tofile;
        File f = new File(fileName);
        if (!f.exists()) {
            f.createNewFile();
            this.toConsole("\"" + file.tofile + "\" is added.");
            FileOutputStream fo = new FileOutputStream(fileName);
            fo.write(content.getBytes(templetEncode));
            fo.close();
        } else if ("AUTOMERGE".equals(file.writeType)) {
            content = this.convert(content, fileName);
            FileOutputStream fo = new FileOutputStream(fileName);
            fo.write(content.getBytes(templetEncode));
            fo.close();
            this.toConsole("\"" + file.tofile + "\" is automerged.");
        } else if ("OVERWRITE".equals(file.writeType)) {
            FileOutputStream fo = new FileOutputStream(fileName);
            fo.write(content.getBytes(templetEncode));
            fo.close();
            this.toConsole("\"" + file.tofile + "\" is overwrited.");
        } else if ("SKIP".equals(file.writeType)) {
            this.toConsole("\"" + file.tofile + "\" is skiped.");
        }
    }

    private String convert(String target, String fileName) throws IOException {
        String usercode_begin_xml = "<!--user code begin-->";
        String usercode_end_xml = "<!--user code end-->";
        String usercode_begin_java = "/*--user code begin--*/";
        String usercode_end_java = "/*--user code end--*/";
        FileInputStream in = new FileInputStream(fileName);
        BufferedInputStream bin = new BufferedInputStream(in);
        int length = bin.available();
        byte[] bytes = new byte[length];
        bin.read(bytes);
        String source = new String(bytes);
        if (target.equals(source)) {
            return target;
        }
        target = this.replaceUserCode(target, source, usercode_begin_xml, usercode_end_xml);
        target = this.replaceUserCode(target, source, usercode_begin_java, usercode_end_java);
        return target;
    }

    private String replaceUserCode(String target, String source, String beginTag, String endTag) {
        try {
            int index = 0;
            int target_usercode_begin = 0;
            int target_usercode_end = 0;
            int source_usercode_begin = 0;
            int source_usercode_end = 0;
            String segment = "";
            if (target.indexOf(beginTag) > 0 && target.indexOf(endTag) > 0) {
                index = target.indexOf(beginTag, target_usercode_begin);
                while (index != -1) {
                    target_usercode_begin = index + beginTag.length();
                    target_usercode_end = target.indexOf(endTag, target_usercode_begin);
                    source_usercode_begin = source.indexOf(beginTag, source_usercode_begin);
                    source_usercode_end = source.indexOf(endTag, source_usercode_begin += beginTag.length());
                    segment = source.substring(source_usercode_begin, source_usercode_end);
                    target = String.valueOf(target.substring(0, target_usercode_begin)) + segment + target.substring(target_usercode_end);
                    target_usercode_begin = target_usercode_end + endTag.length();
                    index = target.indexOf(beginTag, target_usercode_begin);
                }
            }
        }
        catch (Exception ex) {
            this.toConsole("----\u76ee\u6807\u6587\u4ef6\u6807\u6ce8\u88ab\u7834\u574f\uff0c\u8fd4\u56de\u76ee\u6807\u6587\u4ef6\u5185\u5bb9.");
            return source;
        }
        return target;
    }

    private void initVelocity() {
        try {
            IDEProjectSettings prjSettings = new IDEProjectSettings(this.getEclipseProject());
            this.jspEncoding = prjSettings.getJSPEncoding();
            this.xmlEncoding = prjSettings.getXMLEncoding();
        }
        catch (Exception prjSettings) {
            // empty catch block
        }
        try {
            IFolder folder = this.getEclipseProject().getFolder(this.templetPath);
            this.templetPath = folder.getLocation().toString();
            Properties vProp = new Properties();
            vProp.setProperty("file.resource.loader.path", this.templetPath);
            vProp.setProperty("input.encoding", this.inputEncoding);
            vProp.setProperty("output.encoding", this.outputEncoding);
            this.engine = new VelocityEngine(vProp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processJoinedTable(XMLNode tableModel, String tableFilePath) {
        tableFilePath = tableFilePath.substring(0, tableFilePath.lastIndexOf("\\"));
        int i = 0;
        while (i < tableModel.getChild("table").getChilds().size()) {
            block9: {
                boolean isPrincipal = false;
                String relatedColumn = null;
                XMLNode refNode = (XMLNode)tableModel.getChild("table").getChilds().elementAt(i);
                if (!"refTable".equals(refNode.getNodeName())) break block9;
                if ("true".equals(refNode.getAttrValue("isPrincipal"))) {
                    isPrincipal = true;
                } else {
                    relatedColumn = refNode.getAttrValue("relatedColumn");
                }
                String refTablePath = String.valueOf(tableFilePath) + "\\" + refNode.getAttrValue("refId") + ".xml";
                try {
                    refNode = this.loadXMLContent(refTablePath);
                    int j = 0;
                    while (j < refNode.getChild("table").getChilds().size()) {
                        block11: {
                            XMLNode column;
                            block13: {
                                block12: {
                                    block10: {
                                        column = (XMLNode)refNode.getChild("table").getChilds().elementAt(j);
                                        if (!isPrincipal || !"op".equals(column.getNodeName())) break block10;
                                        tableModel.getChild("table").add(column);
                                        break block11;
                                    }
                                    if (!"column".equals(column.getNodeName()) || tableModel.getChild("table").findChildNode("column", column.getAttrValue("id")) != null) break block11;
                                    if (!isPrincipal) break block12;
                                    column.setAttrValue("isPrincipal", "true");
                                    break block13;
                                }
                                if (relatedColumn != null && relatedColumn.equals(column.getAttrValue("id"))) break block11;
                            }
                            tableModel.getChild("table").add(column);
                        }
                        ++j;
                    }
                }
                catch (Exception e) {
                    this.toConsole("Failed to load File:" + refTablePath);
                }
            }
            ++i;
        }
    }

    public final void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        if (fileName != null && fileName.length() > 0 && e != null) {
            if (fileName.indexOf("\\") != -1) {
                fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
            }
            if (fileName.indexOf("/") != -1) {
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            }
            this.toConsole("\n[" + fileName + "] found:" + e.toString());
        }
        this.toConsole(msg);
    }

    public final void reportProblem(int i, String s, String s1) {
    }

    public String getCommitWay() {
        return this.commitWay;
    }

    public void setCommitWay(String commitWay) {
        this.commitWay = commitWay;
    }
}

