/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.base;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.part.FileEditorInput;

public class IDEContent
implements ContentChangedListener {
    public static Object copyObj = null;
    private static IDEContent instance = new IDEContent();
    private static Hashtable settingNodes = new Hashtable();
    private static HashMap mapFile = new HashMap();
    private static HashMap mapTimeStamp = new HashMap();
    private static String title = "EMP IDE Console";
    private static MessageConsole console = null;
    private static MessageConsoleStream mos = null;
    private static PrintStream ps = null;

    private static String getContentId(IProject project, String bizId, int settingsType) {
        if (project == null) {
            return null;
        }
        String id = project.getName();
        id = bizId == null || bizId.length() == 0 ? String.valueOf(id) + "_G_" : String.valueOf(id) + "_" + bizId + "_";
        id = String.valueOf(id) + settingsType;
        return id;
    }

    public static XMLNode getSettingNode(IProject project, String bizId, int settingsType) throws Exception {
        String contentId = IDEContent.getContentId(project, bizId, settingsType);
        if (contentId == null) {
            return null;
        }
        if (settingNodes.containsKey(contentId)) {
            try {
                XMLNode result = (XMLNode)settingNodes.get(contentId);
                long timeStamp = (Long)mapTimeStamp.get(result);
                IFile file = (IFile)mapFile.get(result);
                if (file.getModificationStamp() == timeStamp) {
                    return result;
                }
                boolean w = false;
            }
            catch (Exception result) {
                // empty catch block
            }
        }
        IFile file = null;
        String settingsFileName = IDEContent.getSettingFileName(project, bizId, settingsType);
        if (settingsType == 27) {
            settingsFileName = String.valueOf(ECCIDEPlugin.getDir("/")) + settingsFileName;
        } else {
            file = project.getFile(settingsFileName);
            settingsFileName = project.getLocation() + settingsFileName;
        }
        if (settingsFileName != null) {
            try {
                XMLLoader xmlLoader = new XMLLoader();
                xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
                XMLNode node = (XMLNode)xmlLoader.loadXMLFile(settingsFileName);
                if (settingsType == 30 && node != null) {
                    node.addContentChangedListener(instance, project, settingsType);
                } else if (settingsType == 1 && node != null) {
                    node.addContentChangedListener(instance, project, settingsType);
                }
                if (node != null) {
                    settingNodes.put(contentId, node);
                    if (file != null) {
                        mapTimeStamp.put(node, new Long(file.getModificationStamp()));
                        mapFile.put(node, file);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (XMLNode)settingNodes.get(contentId);
    }

    public static void saveSettingNode(IProject project, String bizId, int settingsType) {
        block12: {
            String contentId = IDEContent.getContentId(project, bizId, settingsType);
            if (!settingNodes.containsKey(contentId)) {
                return;
            }
            try {
                String settingsFileName = project.getLocation() + IDEContent.getSettingFileName(project, bizId, settingsType);
                if (settingsFileName == null) break block12;
                IDEProjectSettings prjSettings = new IDEProjectSettings(IDEContent.getSettingNode(project, bizId, 35));
                XMLNode node = (XMLNode)settingNodes.get(contentId);
                StringBuffer strBuf = new StringBuffer();
                if (settingsType == 30) {
                    node.setEncoding("UTF-8");
                } else if (prjSettings.getSetXMLEncodeManually()) {
                    node.setEncoding(prjSettings.getXMLEncoding());
                }
                node.toXMLContent(0, strBuf);
                FileOutputStream fo = new FileOutputStream(settingsFileName);
                if (settingsType == 30) {
                    fo.write(strBuf.toString().getBytes("UTF-8"));
                } else if (prjSettings.getSetXMLEncodeManually()) {
                    fo.write(strBuf.toString().getBytes(prjSettings.getXMLEncoding()));
                } else {
                    fo.write(strBuf.toString().getBytes(IDEConstance.encoding));
                }
                fo.close();
                try {
                    IFile file = project.getFile(settingsFileName);
                    mapTimeStamp.put(node, new Long(file.getModificationStamp()));
                    mapFile.put(node, file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                project.getFolder("designFiles").refreshLocal(2, null);
            }
            catch (Exception e) {
                IDEContent.reportProblem(BuildProblemObject.ERROR, "internal error, unhandled exception", "", e, project, IDEConstance.getSettingFileName(settingsType));
            }
        }
    }

    public static void saveSettingNode(IProject project, String bizId, int settingsType, XMLNode node) {
        String contentId = IDEContent.getContentId(project, bizId, settingsType);
        settingNodes.put(contentId, node);
        IDEContent.saveSettingNode(project, bizId, settingsType);
    }

    public static void reportProblem(int type, String msg, String location, Exception e, IProject project, String fileName) {
    }

    private static String getSettingFileName(IProject project, String bizId, int settingsType) throws Exception {
        String fileName = IDEConstance.getSettingFileName(settingsType);
        if (bizId == null) {
            return fileName;
        }
        if (fileName.startsWith("/designFiles")) {
            return fileName;
        }
        fileName = settingsType == 38 ? "/designFiles/mvcs/" + bizId + fileName : "/designFiles/bizs/" + bizId + fileName;
        return fileName;
    }

    public void contentChanged(ContentChangedEvent event) {
        if (event == null) {
            return;
        }
        IProject project = (IProject)event.getOwner();
        int settingsType = event.getSourceType();
        String bizId = event.getBizId();
        IDEContent.saveSettingNode(project, bizId, settingsType);
    }

    public static void refreshSettings() {
        settingNodes = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshSettings(IProject project) {
        String name = String.valueOf(project.getName()) + "_";
        Hashtable hashtable = settingNodes;
        synchronized (hashtable) {
            Enumeration enu = settingNodes.keys();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                if (!key.startsWith(name)) continue;
                settingNodes.remove(key);
            }
        }
    }

    public static XMLNode getSettingNode(IProject project, int settingsType) throws Exception {
        return IDEContent.getSettingNode(project, null, settingsType);
    }

    public static void saveSettingNode(IProject project, int settingsType) {
        IDEContent.saveSettingNode(project, null, settingsType);
    }

    public static void saveSettingNode(IProject project, int settingsType, XMLNode node) {
        IDEContent.saveSettingNode(project, null, settingsType, node);
    }

    public static IDEProjectSettings getPRJSettings(IProject project) {
        try {
            XMLNode prjSettingsNode = IDEContent.getSettingNode(project, "", 35);
            IDEProjectSettings prjSettings = new IDEProjectSettings(prjSettingsNode);
            return prjSettings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IDEProjectSettings getDefaultPRJSettings(IProject project) {
        try {
            String settingsFileName = String.valueOf(ECCIDEPlugin.getDir("/buildDef/wizards/commons")) + "/EMPPrj.xml";
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode prjSettingsNode = (XMLNode)xmlLoader.loadXMLFile(settingsFileName);
            IDEProjectSettings prjSettings = new IDEProjectSettings(prjSettingsNode);
            try {
                IFile file = project.getFile(".settings\\org.eclipse.wst.common.component");
                XMLNode node = (XMLNode)xmlLoader.loadXMLFile(file.getLocation().toOSString());
                String webpath = node.findChild("wb-resource").getAttrValue("source-path").substring(1);
                node.findChild("wb-resource").getParent().remove(node.findChild("wb-resource"));
                prjSettings.setWebContentPath(webpath);
                String srcpath = node.findChild("wb-resource").getAttrValue("source-path").substring(1);
                prjSettings.setSrcPath(srcpath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return prjSettings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getSubFolder(String folderPath, String fileName) {
        String subFolder = IDEContent.getSubFolder(folderPath);
        if (fileName == null || subFolder.length() == 0) {
            return subFolder;
        }
        if (subFolder.indexOf(fileName) == -1) {
            return subFolder;
        }
        if (subFolder.endsWith(fileName)) {
            subFolder = subFolder.substring(0, subFolder.lastIndexOf(fileName));
        }
        return subFolder;
    }

    public static String getSubFolder(String folderPath) {
        if (folderPath == null || folderPath.length() == 0) {
            return "";
        }
        String grpId = IDEContent.getGroupId(folderPath);
        String temp = folderPath;
        if (folderPath.indexOf("designFiles") != -1) {
            temp = temp.substring(folderPath.indexOf("designFiles") + "designFiles".length(), folderPath.length());
        }
        if (grpId == null || grpId.length() == 0) {
            return temp;
        }
        temp = temp.substring(temp.indexOf(grpId) + grpId.length(), temp.length());
        return temp;
    }

    public static String getGroupId(String editingFileName) {
        String folder = "designFiles";
        String delim = "/";
        try {
            String temp = editingFileName;
            if (temp.indexOf(delim) == -1) {
                delim = "\\";
            }
            temp = temp.substring(temp.indexOf(folder) + folder.length());
            temp = temp.substring(temp.indexOf(delim) + 1);
            if ((temp = temp.substring(temp.indexOf(delim) + 1)).indexOf(delim) == -1) {
                return temp;
            }
            temp = temp.substring(0, temp.indexOf(delim));
            return temp;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getBizGroupIdFromMVCFile(IProject project, String mvcFileName) {
        try {
            String designFiles = "designFiles/mvcs/";
            String result = mvcFileName.substring(designFiles.length(), mvcFileName.length());
            String mvcGroupId = result = result.substring(0, result.indexOf("/"));
            IFile file = project.getFile(String.valueOf(designFiles) + mvcGroupId + "/mvcDefine.xml");
            XMLLoader loader = new XMLLoader();
            loader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            try {
                XMLNode node = (XMLNode)loader.loadXMLFile(file.getLocation().toOSString());
                XMLNode servletNode = node.findChild("servlet");
                XMLNode factoryNameNode = IDEContent.getInitParamValueNode(servletNode, "factoryName");
                String factoryName = factoryNameNode.getChild("#text").getTextValue();
                return factoryName;
            }
            catch (Exception exception) {
                return result;
            }
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String[] getMVCGrpRelated2BIZGrp(IProject project, String bizGrpId) {
        ArrayList<String> mvcGrpList = new ArrayList<String>();
        try {
            IFolder mvcsFolder = project.getFolder("designFiles/mvcs/");
            IResource[] mvcGrpFolders = mvcsFolder.members();
            int i = 0;
            while (i < mvcGrpFolders.length) {
                IFile defineFile;
                String aBizGrpId;
                if (mvcGrpFolders[i] instanceof IFolder && bizGrpId.equals(aBizGrpId = IDEContent.getBizGroupIdFromMVCFile(project, (defineFile = ((IFolder)mvcGrpFolders[i]).getFile("mvcDefine.xml")).getProjectRelativePath().toString()))) {
                    mvcGrpList.add(mvcGrpFolders[i].getName());
                }
                ++i;
            }
            return mvcGrpList.toArray(new String[0]);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IProject getProject(String projectId) {
        IWorkspace workSpace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workSpace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject prj = projects[i];
            if (prj.getName().equals(projectId)) {
                return prj;
            }
            ++i;
        }
        return null;
    }

    private static XMLNode getInitParamValueNode(XMLNode servletNode, String paramName) {
        int i = 0;
        while (i < servletNode.getChilds().size()) {
            String initParamName;
            XMLNode initParamNode = (XMLNode)servletNode.getChilds().elementAt(i);
            if ("init-param".equals(initParamNode.getNodeName()) && paramName.equals(initParamName = initParamNode.findChild("param-name").getChild("#text").getTextValue())) {
                return initParamNode.findChild("param-value");
            }
            ++i;
        }
        return null;
    }

    public static IFile getFile(XMLNode node) {
        return (IFile)mapFile.get(node);
    }

    public static boolean isAllTableDataInDict(IFile file) {
        try {
            XMLLoader xmlLoader2 = new XMLLoader();
            xmlLoader2.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode tableNode = (XMLNode)xmlLoader2.loadXMLContent(file.getContents());
            tableNode = tableNode.findChild("TableDefine");
            return IDEContent.isAllTableDataInDict(tableNode, file.getProject());
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAllTableDataInDict(XMLNode node, IProject project) {
        try {
            XMLNode dataDictionary = IDEContent.getSettingNode(project, 0);
            if (node == null) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= node.getChilds().size()) {
                    return true;
                }
                XMLNode columnNode = (XMLNode)node.getChilds().elementAt(i);
                if ("column".equals(columnNode.getNodeName())) {
                    String refId = columnNode.getAttrValue("dataName");
                    XMLNode dataElement = dataDictionary.findChildNodeWithAttrValue("dataElement", "id", refId);
                    XMLNode dataCollection = dataDictionary.findChildNodeWithAttrValue("dataCollection", "id", refId);
                    if (dataElement == null && dataCollection == null) {
                        return false;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public static IProject getCurrentProject() {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IFile file = ((FileEditorInput)page.getActiveEditor().getEditorInput()).getFile();
            return file.getProject();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IFile getFile(IProject project, String fileId, String extName) {
        if (project == null) {
            return null;
        }
        if (fileId == null || fileId.length() == 0) {
            return null;
        }
        try {
            String subFolderName = "";
            if ("acc".equals(extName)) {
                subFolderName = "channels";
            }
            IFolder folder = project.getFolder("designFiles");
            if (subFolderName != null && subFolderName.length() > 0) {
                folder = folder.getFolder(subFolderName);
            }
            return IDEContent.getFile(folder, fileId, extName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IFile getFile(IProject project, String grpId, String bizId, String extName) {
        if (project == null) {
            return null;
        }
        if (bizId == null || bizId.length() == 0) {
            return null;
        }
        if (extName == null || extName.length() == 0) {
            return null;
        }
        try {
            IFolder folder = project.getFolder("designFiles");
            if ("biz".equals(extName)) {
                folder = grpId != null ? folder.getFolder("bizs").getFolder(grpId) : folder.getFolder("bizs");
            }
            if ("mvc".equals(extName)) {
                folder = grpId != null ? folder.getFolder("mvcs").getFolder(grpId) : folder.getFolder("mvcs");
            }
            return IDEContent.getFile(folder, bizId, extName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static IFile getFile(IFolder folder, String bizId, String extName) {
        if (folder == null) {
            return null;
        }
        if (bizId == null || bizId.length() == 0) {
            return null;
        }
        try {
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                IFile result;
                if (members[i] instanceof IFile) {
                    IFile file = (IFile)members[i];
                    if ((String.valueOf(bizId) + "." + extName).equals(file.getName())) {
                        return file;
                    }
                }
                if (members[i] instanceof IFolder && (result = IDEContent.getFile((IFolder)members[i], bizId, extName)) != null) {
                    return result;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static PrintStream getConsole() {
        if (ps != null) {
            return ps;
        }
        if (console == null) {
            console = new MessageConsole(title, null);
        }
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        mos = console.newMessageStream();
        ps = new PrintStream((OutputStream)mos);
        return ps;
    }

    public static void clearConsole() {
        if (console != null) {
            console.clearConsole();
        }
    }

    public static XMLNode loadXMLContent(IFile file) {
        if (file == null || !file.exists()) {
            return null;
        }
        return IDEContent.loadXMLContent(file.getLocation().toOSString());
    }

    public static XMLNode loadXMLContent(String file) {
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        if (xmlLoader == null) {
            xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        }
        try {
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(file);
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDefaultBizGrpId(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            IResource[] resources = project.getFolder("designFiles").getFolder("bizs").members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFolder) {
                    return resources[i].getName();
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

