/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.base;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class IDEProfile {
    private static Hashtable ProjectProfiles = new Hashtable();
    private static Object[] commonProfiles = new Object[100];
    private static HashMap mapFile = new HashMap();
    private static HashMap mapTimeStamp = new HashMap();

    public static EditorProfile getEditorProfile(IProject project, int profileType) throws Exception {
        if (profileType == 32) {
            return IDEProfile.getWFProfile(project);
        }
        if (profileType != 5 && profileType != 13 && profileType != 9 && profileType != 14 && profileType != 40 && profileType != 41 && profileType != 27) {
            if (commonProfiles[profileType] != null) {
                try {
                    EditorProfile result = (EditorProfile)commonProfiles[profileType];
                    long timeStamp = (Long)mapTimeStamp.get(result);
                    IFile file = (IFile)mapFile.get(result);
                    if (file.getModificationStamp() == timeStamp) {
                        result.setProjectRootPath(project.getLocation().toString());
                        return result;
                    }
                }
                catch (Exception result) {
                    // empty catch block
                }
            }
            String fileName = String.valueOf(ECCIDEPlugin.getDir("/")) + IDEConstance.getProfileName(profileType);
            IFile file = project.getFile(fileName);
            try {
                XMLLoader xmlLoader = new XMLLoader();
                xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
                EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(fileName);
                IDEProfile.commonProfiles[profileType] = profile;
                mapTimeStamp.put(profile, new Long(file.getModificationStamp()));
                mapFile.put(profile, file);
            }
            catch (Exception e) {
                IDEProfile.reportProblem(BuildProblemObject.ERROR, "internal error, unhandled exception", "", e, project, IDEConstance.getProfileName(profileType));
            }
            ((EditorProfile)commonProfiles[profileType]).setProjectRootPath(project.getLocation().toString());
            return (EditorProfile)commonProfiles[profileType];
        }
        Object[] profiles = (Object[])ProjectProfiles.get(project);
        if (profiles == null) {
            profiles = new Object[100];
            ProjectProfiles.put(project, profiles);
        }
        if (profiles[profileType] != null) {
            try {
                EditorProfile result = (EditorProfile)profiles[profileType];
                long timeStamp = (Long)mapTimeStamp.get(result);
                IFile file = (IFile)mapFile.get(result);
                if (file.getModificationStamp() == timeStamp) {
                    result.setProjectRootPath(project.getLocation().toString());
                    return result;
                }
            }
            catch (Exception result) {
                // empty catch block
            }
        }
        String profileFileName = project.getLocation() + IDEConstance.getProfileName(profileType);
        IFile file = project.getFile(IDEConstance.getProfileName(profileType));
        if (profileFileName != null) {
            try {
                XMLLoader xmlLoader = new XMLLoader();
                xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
                EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(profileFileName);
                profiles[profileType] = profile;
                if (file != null) {
                    mapTimeStamp.put(profile, new Long(file.getModificationStamp()));
                    mapFile.put(profile, file);
                }
                profile.setProjectRootPath(project.getLocation().toString());
            }
            catch (Exception e) {
                IDEProfile.reportProblem(BuildProblemObject.ERROR, "internal error, unhandled exception", "", e, project, IDEConstance.getProfileName(profileType));
            }
        }
        ((EditorProfile)profiles[profileType]).setProjectRootPath(project.getLocation().toString());
        return (EditorProfile)profiles[profileType];
    }

    public static void saveEditorProfile(IProject project, int profileType) {
        Object[] profiles = (Object[])ProjectProfiles.get(project);
        if (profiles == null || profiles[profileType] == null) {
            return;
        }
        try {
            String profileFileName = project.getLocation() + IDEConstance.getProfileName(profileType);
            EditorProfile profile = (EditorProfile)profiles[profileType];
            StringBuffer strBuf = new StringBuffer();
            profile.toXMLString(strBuf);
            FileWriter fw = new FileWriter(profileFileName);
            fw.write(strBuf.toString());
            fw.close();
            try {
                IFile file = project.getFile(IDEConstance.getProfileName(profileType));
                mapTimeStamp.put(profile, new Long(file.getModificationStamp()));
                mapFile.put(profile, file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            project.getFolder("designFiles/commons").refreshLocal(2, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            IDEProfile.reportProblem(BuildProblemObject.ERROR, "internal error, unhandled exception", "", e, project, IDEConstance.getProfileName(profileType));
        }
    }

    public static void saveEditorProfile(IProject project, int profileType, EditorProfile profile) {
        Object[] profiles = (Object[])ProjectProfiles.get(project);
        if (profiles == null || profiles[profileType] == null) {
            return;
        }
        profiles[profileType] = profile;
        IDEProfile.saveEditorProfile(project, profileType);
    }

    public static void reportProblem(int type, String msg, String location, Exception e, IProject project, String fileName) {
        String detailMsg = msg;
        if (e != null) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            detailMsg = new String(bo.toByteArray());
        }
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, project.getName(), location, fileName);
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    public static void refreshSettings() {
        ProjectProfiles = new Hashtable();
        commonProfiles = new Object[100];
    }

    public static void refreshSettings(IProject project) {
        Object[] profiles = (Object[])ProjectProfiles.get(project);
        if (profiles != null) {
            ProjectProfiles.remove(project);
        }
        commonProfiles = new Object[100];
    }

    private static EditorProfile getWFProfile(IProject project) {
        IFile file = project.getFile("/designFiles/commons/studio.properties");
        Properties property = new Properties();
        try {
            property.load(file.getContents());
            EditorProfile profile = new EditorProfile();
            ElementCatalog cata = new ElementCatalog();
            cata.setCatalogName("root");
            profile.addElementCatalog(cata);
            Element flow = new Element();
            flow.setElementName("EMPWF");
            IDEProfile.readWFProfileAttr("Flow", property, flow);
            flow.setIconName("/icons/flow/EMPWF.gif");
            cata.addElement(flow);
            String[] nodenames = new String[]{"startnode", "endnode", "activenode", "autonode", "exceptionnode", "wholeautonode", "repairnode"};
            String[] nodedescs = new String[]{"\u5f00\u59cb\u8282\u70b9", "\u7ed3\u675f\u8282\u70b9", "\u6d3b\u52a8\u8282\u70b9", "\u81ea\u52a8\u8282\u70b9", "\u5f02\u5e38\u8282\u70b9", "\u5168\u5c40\u81ea\u52a8\u8282\u70b9", "\u8865\u507f\u8282\u70b9"};
            int w = 0;
            while (w < nodenames.length) {
                Element node = new Element();
                node.setElementName(nodenames[w]);
                node.setLabel(nodedescs[w]);
                IDEProfile.readWFProfileAttr("Node", property, node);
                cata.addElement(node);
                node.setIconName("/icons/flow/" + nodenames[w] + ".gif");
                node.setWrapperClassType("com.ecc.ide.workflow.WFElementWrapper");
                ElementChild child = new ElementChild();
                child.setAllowCount("*");
                child.setChildElementId(nodenames[w]);
                flow.addChild(child);
                ++w;
            }
            Element node = new Element();
            node.setElementName("transition");
            IDEProfile.readWFProfileAttr("Route", property, node);
            node.setIconName("/icons/flow/transition.gif");
            node.setWrapperClassType("com.ecc.ide.editor.visualflow.TransitionWrapper");
            cata.addElement(node);
            return profile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void readWFProfileAttr(String name, Properties property, Element node) {
        int flowSize = new Integer(property.getProperty(String.valueOf(name) + ".properties"));
        int i = 0;
        while (i < flowSize) {
            String editorType;
            ElementAttribute attr = new ElementAttribute();
            String id = property.getProperty(String.valueOf(name) + ".key" + (i + 1));
            attr.setAttrID(id);
            String attrname = property.getProperty(String.valueOf(name) + ".name" + (i + 1));
            try {
                attrname = new String(attrname.getBytes("ISO-8859-1"), "GBK");
            }
            catch (Exception exception) {
                // empty catch block
            }
            attr.setAttrName(attrname);
            String valueList = property.getProperty(String.valueOf(name) + ".list" + (i + 1));
            if (valueList != null) {
                try {
                    if (!valueList.endsWith(";")) {
                        valueList = String.valueOf(valueList) + ";";
                    }
                    valueList = new String(valueList.getBytes("ISO-8859-1"), "GBK");
                    while (valueList.indexOf(".") != -1) {
                        valueList = String.valueOf(valueList.substring(0, valueList.indexOf("."))) + "=" + valueList.substring(valueList.indexOf(".") + 1);
                    }
                    attr.setValueListStr(valueList);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ("5".equals(editorType = property.getProperty(String.valueOf(name) + ".type" + (i + 1)))) {
                attr.setAttrEditorClass("com.ecc.ide.editor.TextAreaPropertyEditor");
            }
            String required = property.getProperty(String.valueOf(name) + ".required" + (i + 1));
            if ("1".equals(editorType)) {
                attr.setMustSet(true);
            }
            node.addAttribute(attr);
            ++i;
        }
    }
}

