/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.ant.CommonTask;
import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class AbstractBuilder {
    public CommonTask commonTask;
    protected BuildProblemReporter reporter;
    protected IProgressMonitor monitor;
    protected String xmlEncoding = null;
    private XMLLoader xmlLoader = null;
    protected String srcFileName = null;
    protected String dstPath;

    public void setXMLEncoding(String value) {
        this.xmlEncoding = value;
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
        try {
            this.commonTask = (CommonTask)((Object)reporter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setProgressMonitor(IProgressMonitor imonitor) {
        this.monitor = imonitor;
    }

    public void setOutputPath(String path) {
        this.dstPath = path;
    }

    public void reportProblem(int type, String msg, String location) {
    }

    protected void reportProgress(String msg) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.subTask(msg);
    }

    protected void reportProgress(String msg, int worked) {
        if (this.reporter == null) {
            return;
        }
        this.reporter.reportProblem(0, msg, "");
    }

    protected void beginWork(String msg, int works) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.beginTask(msg, works);
    }

    protected void createFolder(String folderName) throws Exception {
        if (folderName == null || folderName.length() == 0) {
            return;
        }
        File file = new File(String.valueOf(this.dstPath) + "/" + folderName);
        if (file.exists()) {
            return;
        }
        file.mkdirs();
    }

    public XMLNode loadXMLContent(String file) {
        if (this.xmlLoader == null) {
            this.xmlLoader = new XMLLoader();
            this.xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        }
        try {
            XMLNode node = (XMLNode)this.xmlLoader.loadXMLFile(file);
            return node;
        }
        catch (Exception e) {
            this.reporter.reportProblem(2, "", file, file, e);
            return null;
        }
    }

    public void saveXMLFile(String fileName, XMLNode node) {
        try {
            File file = new File(fileName);
            if (file.exists()) {
                try {
                    file.delete();
                    file.createNewFile();
                }
                catch (Exception exception) {}
            } else {
                file.createNewFile();
            }
            StringBuffer strBuf = new StringBuffer();
            if (this.xmlEncoding != null) {
                node.setEncoding(this.xmlEncoding);
            }
            node.toXMLContent(0, strBuf, true);
            FileOutputStream fo = new FileOutputStream(fileName);
            if (this.xmlEncoding != null) {
                fo.write(strBuf.toString().getBytes(this.xmlEncoding));
            } else {
                fo.write(strBuf.toString().getBytes(IDEConstance.encoding));
            }
            fo.close();
        }
        catch (Exception e) {
            String string = e.toString();
        }
    }

    public void toConsole(String msg) {
        if (this.commonTask != null) {
            this.commonTask.toConsole(msg);
        }
    }
}

