/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.ant.ValidateTask;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.builder.format.FormatGenerator;
import com.ecc.ide.classloader.DynamicClassLoader;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.validater.RunValidate;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class BIZBuilder
extends AbstractBuilder {
    private XMLNode dataDictionary;
    private XMLNode hostSettings;
    private XMLNode packageType;
    private XMLNode service;
    private XMLNode fmtsNode;
    private XMLNode flow;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile serviceEditorProfile;
    private XMLNode MCITrxNode;
    private XMLNode trxNode;
    private XMLNode contextNode;
    private XMLNode operationNode;
    private IProject project;
    private XMLNode channelSettingsNode;

    public boolean buildMCITransaction(String srcFile) {
        try {
            IDEProjectSettings prjSettings = IDEContent.getPRJSettings(this.project);
            String autoValidate = prjSettings.getAutoValidate();
            if ("true".equalsIgnoreCase(autoValidate)) {
                String temp = this.project.getLocation().toOSString();
                IFile file = this.project.getFile(temp = srcFile.substring(srcFile.indexOf(temp) + temp.length(), srcFile.length()));
                boolean validateResult = RunValidate.validateFile(file, this.project, Class.forName(ValidateTask.bizValidateClass));
                if (!validateResult) {
                    return false;
                }
            }
        }
        catch (Exception prjSettings) {
            // empty catch block
        }
        this.srcFileName = srcFile;
        try {
            String chainedChannelId;
            String filePath = this.dstPath;
            this.trxNode = new XMLNode();
            this.MCITrxNode = this.loadXMLContent(this.srcFileName);
            String trxCode = this.MCITrxNode.getAttrValue("trxCode");
            this.trxNode.setNodeName("SelfDefinedOp.xml");
            this.trxNode.setAttrValue("id", trxCode);
            this.operationNode = new XMLNode();
            this.operationNode.setNodeName("EMPBusinessLogic");
            this.operationNode.setAttrValue("id", trxCode);
            this.operationNode.setAttrValue("operationContext", String.valueOf(trxCode) + "SrvCtx");
            this.buildTransactionFlow();
            this.buildCommonFmts();
            this.trxNode.add(this.operationNode);
            this.contextNode = new XMLNode();
            this.contextNode.setNodeName("context");
            this.contextNode.setAttrValue("id", String.valueOf(trxCode) + "SrvCtx");
            this.contextNode.setAttrValue("type", "op");
            if ("true".equals(this.MCITrxNode.getAttrValue("nonSessionTrx")) && (chainedChannelId = this.MCITrxNode.getAttrValue("chainedChannelId")) != null) {
                if ("Root".equals(chainedChannelId)) {
                    this.contextNode.setAttrValue("parent", "rootCtx");
                } else {
                    XMLNode channelNode = this.channelSettingsNode.findChildNode(chainedChannelId);
                    if (channelNode.getAttrValue("channelCtxName") != null) {
                        this.contextNode.setAttrValue("parent", channelNode.getAttrValue("channelCtxName"));
                    } else {
                        this.contextNode.setAttrValue("parent", String.valueOf(chainedChannelId) + "ChannelCtx");
                    }
                }
            }
            XMLNode refDataNode = new XMLNode();
            refDataNode.setNodeName("refKColl");
            refDataNode.setAttrValue("refId", String.valueOf(trxCode) + "SrvData");
            this.contextNode.add(refDataNode);
            this.trxNode.add(this.contextNode);
            XMLNode dataNode = new XMLNode();
            dataNode.setNodeName("kColl");
            dataNode.setAttrValue("id", String.valueOf(trxCode) + "SrvData");
            this.buildData(dataNode, this.MCITrxNode.getChild("datas"));
            this.trxNode.add(dataNode);
            this.buildServices();
            this.buildFormats();
            String fileName = String.valueOf(filePath) + "/" + trxCode + ".xml";
            this.saveXMLFile(fileName, this.trxNode);
        }
        catch (Exception e) {
            this.reporter.reportProblem(2, "", this.srcFileName, this.srcFileName, e);
            return false;
        }
        return true;
    }

    private void buildServices() {
        XMLNode servicesNode = this.MCITrxNode.getChild("services");
        if (servicesNode == null || servicesNode.getChilds() == null) {
            return;
        }
        int i = 0;
        while (i < servicesNode.getChilds().size()) {
            XMLNode serviceNode = (XMLNode)servicesNode.getChilds().elementAt(i);
            if (!"#text".equals(serviceNode.getNodeName())) {
                String svcId = serviceNode.getAttrValue("id");
                serviceNode = this.addServiceImplClass(serviceNode);
                this.trxNode.add(serviceNode);
                XMLNode refSvcNode = new XMLNode();
                refSvcNode.setNodeName("refService");
                refSvcNode.setAttrValue("refId", svcId);
                refSvcNode.setAttrValue("alias", svcId);
                refSvcNode.setAttrValue("type", "prv");
                this.contextNode.add(refSvcNode);
            }
            ++i;
        }
    }

    private XMLNode addServiceImplClass(XMLNode serviceNode) {
        String serviceName = serviceNode.getNodeName();
        Element element = this.serviceEditorProfile.getElement(serviceName);
        String implClass = element.getImplClass();
        if (serviceNode.getAttrValue("implClass") == null || serviceNode.getAttrValue("implClass").length() == 0) {
            serviceNode.setAttrValue("implClass", implClass);
        }
        int i = 0;
        while (i < serviceNode.getChilds().size()) {
            XMLNode temp = (XMLNode)serviceNode.getChilds().elementAt(i);
            if (!"#text".equals(temp.getNodeName()) && !"document".equals(temp.getNodeName())) {
                temp = this.addServiceImplClass(temp);
            }
            ++i;
        }
        return serviceNode;
    }

    private void buildTransactionFlow() {
        int i = 0;
        while (i < this.MCITrxNode.getChilds().size()) {
            XMLNode flowNode;
            XMLNode node = (XMLNode)this.MCITrxNode.getChilds().get(i);
            if ("operation".equals(node.getNodeName()) && (flowNode = node.getChild("flow")) != null) {
                XMLNode outputNode;
                XMLNode inputNode;
                XMLNode opNode = new XMLNode("operation");
                this.operationNode.add(opNode);
                opNode.setAttrValue("id", node.getAttrValue("id"));
                opNode.setAttrValue("name", node.getAttrValue("name"));
                opNode.setAttrValue("transaction", node.getAttrValue("transaction"));
                String refFlowId = node.getAttrValue("refFlowId");
                if (refFlowId != null && refFlowId.length() > 0) {
                    opNode.setAttrValue("refFlowId", refFlowId);
                }
                if ((inputNode = node.getChild("input")) != null) {
                    XMLNode inNode = new XMLNode("input");
                    this.buildInOutData(inNode, inputNode);
                    if (inNode.getChilds().size() > 0) {
                        opNode.add(inNode);
                    }
                }
                if ((outputNode = node.getChild("output")) != null) {
                    XMLNode outNode = new XMLNode("output");
                    this.buildInOutData(outNode, outputNode);
                    if (outNode.getChilds().size() > 0) {
                        opNode.add(outNode);
                    }
                }
                XMLNode nflowNode = new XMLNode("flow");
                opNode.add(nflowNode);
                this.buildOperationFlow(nflowNode, flowNode);
            }
            ++i;
        }
    }

    private void buildCommonFmts() {
        int i = 0;
        while (i < this.fmtsNode.getChilds().size()) {
            XMLNode formatNode = (XMLNode)this.fmtsNode.getChilds().elementAt(i);
            if ("format".equalsIgnoreCase(formatNode.getNodeName())) {
                XMLNode refFmtNode = new XMLNode("refFormat");
                String fmtId = formatNode.getAttrValue("id");
                refFmtNode.setAttrValue("name", fmtId);
                refFmtNode.setAttrValue("refId", fmtId);
                this.operationNode.add(refFmtNode);
            }
            ++i;
        }
    }

    private void buildOperationFlow(XMLNode operationNode, XMLNode flowNode) {
        XMLNode actionNode;
        int i = 0;
        while (i < flowNode.getChilds().size()) {
            actionNode = (XMLNode)flowNode.getChilds().elementAt(i);
            if ("startAction".equalsIgnoreCase(actionNode.getNodeName())) {
                flowNode.getChilds().remove(actionNode);
                flowNode.getChilds().add(0, actionNode);
            }
            ++i;
        }
        int k = 0;
        while (k < flowNode.getChilds().size()) {
            actionNode = (XMLNode)flowNode.getChilds().elementAt(k);
            if (!(actionNode.getNodeName().equals("attributes") || "validateEnd".equals(actionNode.getNodeName()) || "document".equals(actionNode.getNodeName()) || "#text".equals(actionNode.getNodeName()) || "transition".equals(actionNode.getNodeName()))) {
                XMLNode stepNode = new XMLNode();
                if ("validator".equals(actionNode.getNodeName())) {
                    stepNode.setNodeName("validator");
                    stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                } else {
                    stepNode.setNodeName("action");
                    if ("ExtendedAction".equals(actionNode.getNodeName())) {
                        stepNode.setAttrValue("id", actionNode.getAttrValue("extendId"));
                    } else {
                        stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                    }
                }
                operationNode.add(stepNode);
                if (this.flowEditorProfile.getElement(actionNode.getNodeName()) != null) {
                    stepNode.setAttrValue("implClass", this.flowEditorProfile.getElement(actionNode.getNodeName()).getImplClass());
                }
                Enumeration keys = actionNode.getAttrs().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height")) continue;
                    stepNode.setAttrValue(key, actionNode.getAttrValue(key));
                }
                if (actionNode.getChilds() != null) {
                    XMLNode transitionNode;
                    int i2 = 0;
                    while (i2 < actionNode.getChilds().size()) {
                        transitionNode = (XMLNode)actionNode.getChilds().elementAt(i2);
                        if ("transition".equalsIgnoreCase(transitionNode.getNodeName())) {
                            String condition = transitionNode.getAttrValue("condition");
                            String tid = transitionNode.getAttrValue("id");
                            if (!(condition != null && condition.trim().length() != 0 || tid != null && tid.length() != 0)) {
                                actionNode.getChilds().remove(transitionNode);
                                actionNode.getChilds().add(transitionNode);
                            }
                        }
                        ++i2;
                    }
                    int j = 0;
                    while (j < actionNode.getChilds().size()) {
                        if ("ExtendedAction".equals(actionNode.getNodeName())) break;
                        transitionNode = (XMLNode)actionNode.getChilds().elementAt(j);
                        if (!"transition".equals(transitionNode.getNodeName())) {
                            if ("CallBiz".equals(actionNode.getNodeName())) {
                                if ("input".equals(transitionNode.getNodeName())) {
                                    stepNode.add(transitionNode);
                                }
                                if ("output".equals(transitionNode.getNodeName())) {
                                    stepNode.add(transitionNode);
                                }
                                if ("service".equals(transitionNode.getNodeName())) {
                                    stepNode.add(transitionNode);
                                }
                            }
                        } else {
                            String dst = transitionNode.getAttrValue("dest");
                            String idStr = transitionNode.getAttrValue("id");
                            XMLNode trNode = new XMLNode("transition");
                            trNode.setAttrValue("dest", dst);
                            if (idStr != null) {
                                trNode.setAttrValue("condition", "$retValue='" + idStr + "'");
                            } else {
                                trNode.setAttrValue("condition", transitionNode.getAttrValue("condition"));
                            }
                            stepNode.add(trNode);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < actionNode.getChilds().size()) {
                        XMLNode childNode = (XMLNode)actionNode.getChilds().elementAt(j);
                        if ("flow".equals(childNode.getNodeName())) {
                            this.buildOperationFlow(stepNode, childNode);
                        }
                        ++j;
                    }
                    if ("ExtendedAction".equals(actionNode.getNodeName())) {
                        this.buildOperationFlow(stepNode, actionNode);
                    }
                }
            }
            ++k;
        }
    }

    private void buildInOutData(XMLNode dataNode, XMLNode defNode) {
        XMLNode datas = defNode;
        if (datas == null || datas.getChilds() == null) {
            return;
        }
        int i = 0;
        while (i < datas.getChilds().size()) {
            XMLNode refNode = (XMLNode)datas.getChilds().elementAt(i);
            if (!"#text".equals(refNode.getNodeName())) {
                if ("refData".equals(refNode.getNodeName())) {
                    XMLNode childNode;
                    String refId = refNode.getAttrValue("refId");
                    String defaultValue = refNode.getAttrValue("defaultValue");
                    String dataId = refId;
                    int idx = refId.lastIndexOf(46);
                    if (idx != -1) {
                        dataId = refId.substring(idx + 1);
                    }
                    if ((childNode = this.dataDictionary.findChildNode(dataId)) != null) {
                        XMLNode fieldNode = new XMLNode("field");
                        fieldNode.setAttrValue("id", refId);
                        fieldNode.setAttrValue("dataType", childNode.getAttrValue("dataType"));
                        dataNode.add(fieldNode);
                    }
                } else if ("refColl".equals(refNode.getNodeName())) {
                    XMLNode iCollNode = new XMLNode("iColl");
                    iCollNode.setAttrValue("id", refNode.getAttrValue("refId"));
                    dataNode.add(iCollNode);
                    XMLNode kCollNode = new XMLNode("kColl");
                    iCollNode.add(kCollNode);
                    refNode.removeAllChilds();
                    XMLNode tempICollNode = this.dataDictionary.findChildNode(refNode.getAttrValue("refId"));
                    int w = 0;
                    while (w < tempICollNode.getChilds().size()) {
                        XMLNode tempChild = (XMLNode)tempICollNode.getChilds().elementAt(w);
                        if (!"#text".equals(tempChild.getNodeName())) {
                            refNode.add(tempChild);
                        }
                        ++w;
                    }
                    this.buildInOutData(kCollNode, refNode);
                }
            }
            ++i;
        }
    }

    private void buildData(XMLNode dataNode, XMLNode defNode) {
        XMLNode datas = defNode;
        if (datas == null || datas.getChilds() == null) {
            return;
        }
        int i = 0;
        while (i < datas.getChilds().size()) {
            XMLNode refNode = (XMLNode)datas.getChilds().elementAt(i);
            if (!"#text".equals(refNode.getNodeName())) {
                XMLNode newRefNode;
                if ("dataGroup".equals(refNode.getNodeName())) {
                    newRefNode = new XMLNode("kColl");
                    newRefNode.setAttrValue("id", refNode.getAttrValue("id"));
                    dataNode.add(newRefNode);
                    int k = 0;
                    while (k < refNode.getChilds().size()) {
                        XMLNode aRefNode = (XMLNode)refNode.getChilds().elementAt(k);
                        String nodeName = aRefNode.getNodeName();
                        if (!"#text".equals(nodeName)) {
                            String refId = aRefNode.getAttrValue("refId");
                            String defaultValue = aRefNode.getAttrValue("defaultValue");
                            XMLNode childNode = this.dataDictionary.findChildNode(refId);
                            if (childNode != null) {
                                this.addDataDefine(newRefNode, childNode, defaultValue);
                            }
                        }
                        ++k;
                    }
                } else if ("refCommData".equals(refNode.getNodeName())) {
                    newRefNode = new XMLNode("refData");
                    newRefNode.setAttrValue("refId", refNode.getAttrValue("refId"));
                    dataNode.add(newRefNode);
                } else {
                    String accessStr;
                    String refId = refNode.getAttrValue("refId");
                    String defaultValue = refNode.getAttrValue("defaultValue");
                    XMLNode childNode = this.dataDictionary.findChildNode(refId);
                    if (childNode != null && ((accessStr = refNode.getAttrValue("access")) == null || "private".equals(accessStr))) {
                        this.addDataDefine(dataNode, childNode, defaultValue);
                    }
                }
            }
            ++i;
        }
    }

    private void addDataDefine(XMLNode dataNode, XMLNode dictionaryNode, String value) {
        String nodeName = dictionaryNode.getNodeName();
        XMLNode node = new XMLNode();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            if ("true".equals(dictionaryNode.getAttrValue("isSecureField"))) {
                node.setNodeName("secureField");
            } else {
                node.setNodeName("field");
            }
            node.setAttrValue("id", dictionaryNode.getAttrValue("id"));
            node.setAttrValue("value", dictionaryNode.getAttrValue("value"));
            if (value != null) {
                node.setAttrValue("value", value);
            }
            String dataType = dictionaryNode.getAttrValue("dataType");
            node.setAttrValue("dataType", dataType);
            dataNode.add(node);
        } else if (nodeName.equals("dataCollection")) {
            node.setNodeName("iColl");
            node.setAttrValue("id", dictionaryNode.getAttrValue("id"));
            dataNode.add(node);
            XMLNode kNode = new XMLNode();
            kNode.setNodeName("kColl");
            node.add(kNode);
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    if ("refData".equals(aNode.getNodeName())) {
                        String refId = aNode.getAttrValue("refId");
                        XMLNode dicNode = this.dataDictionary.findChildNode(refId);
                        if (dicNode != null) {
                            this.addDataDefine(kNode, dicNode, null);
                        }
                    } else {
                        this.addDataDefine(kNode, aNode, null);
                    }
                }
                ++i;
            }
        } else if (nodeName.equals("refData")) {
            node.setNodeName("field");
            node.setAttrValue("id", dictionaryNode.getAttrValue("refId"));
            node.setAttrValue("value", dictionaryNode.getAttrValue("value"));
            dataNode.add(node);
        }
    }

    private void buildFormats() {
        XMLNode fmtsNode;
        XMLNode hostAccessNode = this.MCITrxNode.getChild("hostAccess");
        if (hostAccessNode != null) {
            int i = 0;
            while (i < hostAccessNode.getChilds().size()) {
                XMLNode hostNode = (XMLNode)hostAccessNode.getChilds().elementAt(i);
                if (!"#text".equals(hostNode.getNodeName())) {
                    XMLNode repNode;
                    XMLNode reqNode;
                    String id = hostNode.getAttrValue("id");
                    String hostId = hostNode.getAttrValue("hostId");
                    if (id.equals("default")) {
                        id = "";
                    }
                    if ((reqNode = hostNode.getChild("request")) != null && reqNode.getChilds() != null && reqNode.getChilds().size() > 0) {
                        String fmtName;
                        XMLNode fmtNode;
                        String headMsgID = null;
                        if ("true".equals(reqNode.getAttrValue("refToHead"))) {
                            headMsgID = String.valueOf(hostId) + "RepHeadFmt";
                        }
                        if ((fmtNode = this.genPackageFmt(headMsgID, reqNode)) != null) {
                            String fmtId;
                            fmtName = fmtId = String.valueOf(id) + hostId + "ReqFmt";
                            fmtNode.setAttrValue("id", fmtId);
                            this.trxNode.add(fmtNode);
                            XMLNode refFmtNode = new XMLNode();
                            refFmtNode.setNodeName("refFormat");
                            refFmtNode.setAttrValue("name", fmtName);
                            refFmtNode.setAttrValue("refId", fmtId);
                            this.operationNode.add(refFmtNode);
                        }
                        if ("true".equals(reqNode.getAttrValue("refToHead"))) {
                            XMLNode refReqHeadFmtNode = new XMLNode();
                            refReqHeadFmtNode.setNodeName("refFormat");
                            fmtName = String.valueOf(hostId) + "ReqHeadFmt";
                            refReqHeadFmtNode.setAttrValue("name", fmtName);
                            refReqHeadFmtNode.setAttrValue("refId", String.valueOf(hostId) + "ReqHeadFmt");
                            this.operationNode.add(refReqHeadFmtNode);
                        }
                    }
                    if ((repNode = hostNode.getChild("reply")) != null && repNode.getChilds() != null && repNode.getChilds().size() > 0) {
                        String fmtName;
                        XMLNode fmtNode;
                        String headMsgID = null;
                        if ("true".equals(repNode.getAttrValue("refToHead"))) {
                            headMsgID = String.valueOf(hostId) + "RepHeadFmt";
                        }
                        if ((fmtNode = this.genPackageFmt(headMsgID, repNode)) != null) {
                            String fmtId;
                            fmtName = fmtId = String.valueOf(id) + hostId + "RepFmt";
                            fmtNode.setAttrValue("id", fmtId);
                            this.trxNode.add(fmtNode);
                            XMLNode refFmtNode = new XMLNode();
                            refFmtNode.setNodeName("refFormat");
                            refFmtNode.setAttrValue("name", fmtName);
                            refFmtNode.setAttrValue("refId", fmtId);
                            this.operationNode.add(refFmtNode);
                        }
                        if ("true".equals(repNode.getAttrValue("refToHead"))) {
                            XMLNode refRepHeadFmtNode = new XMLNode();
                            refRepHeadFmtNode.setNodeName("refFormat");
                            fmtName = String.valueOf(hostId) + "RepHeadFmt";
                            refRepHeadFmtNode.setAttrValue("name", fmtName);
                            refRepHeadFmtNode.setAttrValue("refId", String.valueOf(hostId) + "RepHeadFmt");
                            this.operationNode.add(refRepHeadFmtNode);
                        }
                    }
                }
                ++i;
            }
        }
        if ((fmtsNode = this.MCITrxNode.getChild("formats")) == null || fmtsNode.getChilds().size() == 0) {
            return;
        }
        Vector childs = fmtsNode.getChilds();
        int i = 0;
        while (i < childs.size()) {
            XMLNode fmtNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(fmtNode.getNodeName())) {
                XMLNode fmtDefNode;
                String fmtId = fmtNode.getAttrValue("id");
                XMLNode datasNode = fmtNode.getChild("datas");
                if (datasNode != null && (fmtDefNode = this.genPackageFmt(null, datasNode)) != null) {
                    fmtDefNode.setAttrValue("id", fmtNode.getAttrValue("id"));
                    this.trxNode.add(fmtDefNode);
                    XMLNode refFmtNode = new XMLNode();
                    refFmtNode.setNodeName("refFormat");
                    refFmtNode.setAttrValue("name", fmtNode.getAttrValue("id"));
                    refFmtNode.setAttrValue("refId", fmtNode.getAttrValue("id"));
                    this.operationNode.add(refFmtNode);
                }
            }
            ++i;
        }
    }

    private XMLNode genPackageFmt(String headMsgID, XMLNode aNode) {
        String pkgType = aNode.getAttrValue("packageType");
        if (pkgType == null) {
            this.reporter.reportProblem(0, "\u7f16\u8bd1\u5931\u8d25:packageType Not set!", null, null, null);
            return null;
        }
        XMLNode pkgNode = this.packageType.findChildNode(pkgType);
        if (pkgNode == null) {
            this.reporter.reportProblem(0, "packageType [" + pkgType + "] not found!", null, null, null);
        } else {
            String fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
            if (fmtBuilderClass == null) {
                this.reporter.reportProblem(0, "format generater class not found", null, null, null);
            } else {
                try {
                    FormatGenerator fmtGen = null;
                    try {
                        fmtGen = (FormatGenerator)Class.forName(fmtBuilderClass).newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        fmtGen = (FormatGenerator)DynamicClassLoader.loadDynamicObject(this.project, fmtBuilderClass);
                    }
                    fmtGen.setMessageHeadID(headMsgID);
                    XMLNode fmtNode = fmtGen.generateFormatNode(aNode, this.dataDictionary, this.project);
                    return fmtNode;
                }
                catch (Exception e) {
                    String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Error_failed_to_build_request_fmt_for_host_[_85")) + "] Exception: " + e;
                    this.reporter.reportProblem(0, msg, null, null, e);
                }
            }
        }
        return null;
    }

    public XMLNode getFlow() {
        return this.flow;
    }

    public static BIZBuilder getInstance(IProject project, String groupId) {
        BIZBuilder builder = new BIZBuilder();
        try {
            builder.project = project;
            builder.dataEditorProfile = IDEProfile.getEditorProfile(project, 1);
            builder.flowEditorProfile = ModuleUtility.getActionFlowProfile(project);
            builder.serviceEditorProfile = ModuleUtility.getServiceProfile(project);
            builder.dataDictionary = IDEContent.getSettingNode(project, 0);
            builder.flow = IDEContent.getSettingNode(project, groupId, 5);
            builder.hostSettings = IDEContent.getSettingNode(project, groupId, 11);
            builder.packageType = ModuleUtility.getPackageTypeNode(project);
            builder.channelSettingsNode = IDEContent.getSettingNode(project, groupId, 19);
            builder.fmtsNode = IDEContent.getSettingNode(project, groupId, 25);
            IDEProjectSettings prjSettings = IDEContent.getPRJSettings(project);
            if (prjSettings.getSetXMLEncodeManually()) {
                builder.setXMLEncoding(prjSettings.getXMLEncoding());
            }
        }
        catch (Exception e) {
            return null;
        }
        return builder;
    }
}

