/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.builder.format.FormatGenerator;
import com.ecc.ide.classloader.DynamicClassLoader;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class BizGrpBuilder
extends AbstractBuilder {
    private XMLNode dataDictionary;
    private XMLNode hostSettings;
    private XMLNode packageType;
    private XMLNode service;
    private XMLNode fmtsNode;
    private XMLNode flow;
    private XMLNode nodeDefine;
    private XMLNode dataTypeDefNode;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile serviceEditorProfile;
    private IProject project = null;
    private String bizGrpId = null;

    public void buildProject() {
        try {
            this.buildContextAndData();
            this.buildCommonFlow();
            this.buildFormats();
            this.buildServices();
            this.buildSettings();
            this.buildDataType();
        }
        catch (Exception e) {
            e.printStackTrace();
            super.reportProblem(2, String.valueOf(Messages.getString("MCIProjectBuilder.Failed_to_build_the_MCI_Project_!_Exception___1")) + e, "");
        }
        this.reportProgress(Messages.getString("MCIProjectBuilder.Build_finished._1"), 10);
    }

    private void buildDataType() {
        IFile srcFile_1;
        String srcPath = "designFiles/commons/";
        IDEProjectSettings prjSettings = IDEContent.getPRJSettings(this.project);
        String destPath = String.valueOf(prjSettings.getWebContentPath()) + "/WEB-INF/bizs/" + this.bizGrpId + "/";
        IFile srcFile = this.project.getFile(String.valueOf(srcPath) + "dataType.xml");
        if (srcFile.exists()) {
            IFile destFile = this.project.getFile(String.valueOf(destPath) + "dataType.xml");
            try {
                if (destFile.exists()) {
                    destFile.delete(true, null);
                }
                srcFile.copy(destFile.getFullPath(), true, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if ((srcFile_1 = this.project.getFile(String.valueOf(srcPath) + "dataTypeDef.xml")).exists()) {
            IFile destFile = this.project.getFile(String.valueOf(destPath) + "dataTypeDef.xml");
            try {
                if (destFile.exists()) {
                    destFile.delete(true, null);
                }
                srcFile_1.copy(destFile.getFullPath(), true, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private void buildCommonFlow() {
        this.reportProgress(Messages.getString("MCIProjectBuilder.Build_MCI_Common_Flow_2"), 5);
        XMLNode operationNode = new XMLNode();
        operationNode.setNodeName("operations.xml");
        int i = 0;
        while (i < this.flow.getChilds().size()) {
            XMLNode flowNode = (XMLNode)this.flow.getChilds().elementAt(i);
            if (!"#text".equals(flowNode.getNodeName())) {
                XMLNode opNode = new XMLNode();
                opNode.setNodeName("flow");
                opNode.setAttrValue("id", flowNode.getAttrValue("id"));
                operationNode.add(opNode);
                if (flowNode.getAttrValue("implClass") != null) {
                    opNode.setNodeName(flowNode.getAttrValue("implClass"));
                }
                if (flowNode.getChilds() != null) {
                    this.buildOperationFlow(opNode, flowNode);
                }
            }
            ++i;
        }
        String fileName = String.valueOf(this.dstPath) + "/operations.xml";
        this.saveXMLFile(fileName, operationNode);
    }

    private void buildOperationFlow(XMLNode operationNode, XMLNode flowNode) {
        XMLNode actionNode;
        int i = 0;
        while (i < flowNode.getChilds().size()) {
            actionNode = (XMLNode)flowNode.getChilds().elementAt(i);
            if ("startAction".equalsIgnoreCase(actionNode.getNodeName())) {
                flowNode.getChilds().remove(actionNode);
                flowNode.getChilds().add(0, actionNode);
            }
            ++i;
        }
        int k = 0;
        while (k < flowNode.getChilds().size()) {
            actionNode = (XMLNode)flowNode.getChilds().elementAt(k);
            if (!(actionNode.getNodeName().equals("attributes") || "validateEnd".equals(actionNode.getNodeName()) || "document".equals(actionNode.getNodeName()) || "#text".equals(actionNode.getNodeName()) || "transition".equals(actionNode.getNodeName()))) {
                XMLNode stepNode = new XMLNode();
                if ("validator".equals(actionNode.getNodeName())) {
                    stepNode.setNodeName("validator");
                    stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                } else {
                    stepNode.setNodeName("action");
                    stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                }
                operationNode.add(stepNode);
                if (this.flowEditorProfile.getElement(actionNode.getNodeName()) != null) {
                    stepNode.setAttrValue("implClass", this.flowEditorProfile.getElement(actionNode.getNodeName()).getImplClass());
                } else {
                    super.reportProblem(2, String.valueOf(Messages.getString("MCITransactionBuilder.No_set_implement_class_for_OpStep[_7")) + actionNode.getNodeName() + "]!", "");
                }
                Enumeration keys = actionNode.getAttrs().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height")) continue;
                    stepNode.setAttrValue(key, actionNode.getAttrValue(key));
                }
                if (actionNode.getChilds() != null) {
                    XMLNode transitionNode;
                    int i2 = 0;
                    while (i2 < actionNode.getChilds().size()) {
                        String condition;
                        transitionNode = (XMLNode)actionNode.getChilds().elementAt(i2);
                        if ("transition".equalsIgnoreCase(transitionNode.getNodeName()) && ((condition = transitionNode.getAttrValue("condition")) == null || condition.trim().length() == 0)) {
                            actionNode.getChilds().remove(transitionNode);
                            actionNode.getChilds().add(transitionNode);
                        }
                        ++i2;
                    }
                    int j = 0;
                    while (j < actionNode.getChilds().size()) {
                        transitionNode = (XMLNode)actionNode.getChilds().elementAt(j);
                        if ("transition".equals(transitionNode.getNodeName())) {
                            String dst = transitionNode.getAttrValue("dest");
                            String idStr = transitionNode.getAttrValue("id");
                            XMLNode trNode = new XMLNode("transition");
                            trNode.setAttrValue("dest", dst);
                            if (idStr != null) {
                                trNode.setAttrValue("condition", "$retValue='" + idStr + "'");
                            } else {
                                trNode.setAttrValue("condition", transitionNode.getAttrValue("condition"));
                            }
                            stepNode.add(trNode);
                        }
                        ++j;
                    }
                }
            }
            ++k;
        }
    }

    private void buildServices() {
        String fileName = String.valueOf(this.dstPath) + "/services.xml";
        int i = 0;
        while (i < this.service.getChilds().size()) {
            XMLNode serviceNode = (XMLNode)this.service.getChilds().elementAt(i);
            if (!"#text".equals(serviceNode.getNodeName())) {
                this.addServiceImplClass(serviceNode);
            }
            ++i;
        }
        this.saveXMLFile(fileName, this.service);
    }

    private XMLNode addServiceImplClass(XMLNode serviceNode) {
        try {
            String serviceName = serviceNode.getNodeName();
            Element element = this.serviceEditorProfile.getElement(serviceName);
            if (element == null) {
                return serviceNode;
            }
            String implClass = element.getImplClass();
            if (serviceNode.getAttrValue("implClass") == null || serviceNode.getAttrValue("implClass").length() == 0) {
                serviceNode.setAttrValue("implClass", implClass);
            }
            int i = 0;
            while (i < serviceNode.getChilds().size()) {
                XMLNode temp = (XMLNode)serviceNode.getChilds().elementAt(i);
                if (!"#text".equals(temp.getNodeName()) && !"document".equals(temp.getNodeName())) {
                    temp = this.addServiceImplClass(temp);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serviceNode;
    }

    private void buildContextAndData() {
        XMLNode contextNode = new XMLNode();
        contextNode.setNodeName("contexts.xml");
        XMLNode rootContextNode = new XMLNode();
        rootContextNode.setNodeName("context");
        rootContextNode.setAttrValue("id", "rootCtx");
        rootContextNode.setAttrValue("type", "root");
        XMLNode refRootKColl = new XMLNode();
        refRootKColl.setNodeName("refKColl");
        refRootKColl.setAttrValue("refId", "rootKColl");
        rootContextNode.add(refRootKColl);
        contextNode.add(rootContextNode);
        XMLNode dataNode = new XMLNode();
        dataNode.setNodeName("data.xml");
        XMLNode rootDataNode = new XMLNode();
        rootDataNode.setNodeName("kColl");
        rootDataNode.setAttrValue("id", "rootKColl");
        dataNode.add(rootDataNode);
        this.processRootNodeDefine(rootContextNode, rootDataNode);
        XMLNode commDatas = this.nodeDefine.getChild("CommonData");
        this.processCommonDataDefine(dataNode, commDatas);
        this.processNodeDefine(contextNode, dataNode);
        String fileName = String.valueOf(this.dstPath) + "/data.xml";
        this.saveXMLFile(fileName, dataNode);
        fileName = String.valueOf(this.dstPath) + "/contexts.xml";
        this.saveXMLFile(fileName, contextNode);
    }

    private void processRootNodeDefine(XMLNode rootContextNode, XMLNode rootKCollNode) {
        XMLNode dataRefNode = this.nodeDefine.getChild("root").getChild("datas");
        int k = 0;
        while (dataRefNode != null && k < dataRefNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)dataRefNode.getChilds().elementAt(k);
            if (!"#text".equals(aNode.getNodeName())) {
                String refId;
                XMLNode refDataNode;
                if ("dataGroup".equals(aNode.getNodeName())) {
                    XMLNode newRefNode = new XMLNode("kColl");
                    newRefNode.setAttrValue("id", aNode.getAttrValue("id"));
                    rootKCollNode.add(newRefNode);
                    int i = 0;
                    while (i < aNode.getChilds().size()) {
                        XMLNode aRefNode = (XMLNode)aNode.getChilds().elementAt(i);
                        String nodeName = aRefNode.getNodeName();
                        if (!"#text".equals(nodeName)) {
                            String refId2 = aRefNode.getAttrValue("refId");
                            String defaultValue = aRefNode.getAttrValue("defaultValue");
                            XMLNode childNode = this.dataDictionary.findChildNode(refId2);
                            if (childNode != null) {
                                this.addDataDefine(newRefNode, childNode, defaultValue);
                            }
                        }
                        ++i;
                    }
                }
                if ((refDataNode = this.dataDictionary.findChildNode(refId = aNode.getAttrValue("refId"))) != null) {
                    this.addDataDefine(rootKCollNode, refDataNode, aNode.getAttrValue("defaultValue"));
                }
            }
            ++k;
        }
        XMLNode svcRefNode = this.nodeDefine.getChild("root").getChild("refServices");
        int k2 = 0;
        while (svcRefNode != null && k2 < svcRefNode.getChilds().size()) {
            String svcid;
            XMLNode svcNode;
            XMLNode aNode = (XMLNode)svcRefNode.getChilds().elementAt(k2);
            if (!"#text".equals(aNode.getNodeName()) && (svcNode = this.service.findChildNode(svcid = aNode.getAttrValue("id"))) != null) {
                XMLNode refSvcNode = new XMLNode();
                refSvcNode.setNodeName("refService");
                refSvcNode.setAttrValue("refId", svcid);
                refSvcNode.setAttrValue("alias", svcid);
                refSvcNode.setAttrValue("type", "service");
                rootContextNode.add(refSvcNode);
            }
            ++k2;
        }
    }

    private void processNodeDefine(XMLNode contextNode, XMLNode dataNode) {
        Vector childs = this.nodeDefine.findChild("channelSettings").getChilds();
        int i = 0;
        while (i < childs.size()) {
            XMLNode aChannelNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aChannelNode.getNodeName())) {
                String nodeId = aChannelNode.getAttrValue("id");
                String channelCtxName = aChannelNode.getAttrValue("channelCtxName");
                String channelSessionCtxName = aChannelNode.getAttrValue("channelSessionName");
                XMLNode channelContextNode = new XMLNode();
                channelContextNode.setNodeName("context");
                if (channelCtxName != null) {
                    channelContextNode.setAttrValue("id", channelCtxName);
                } else {
                    channelCtxName = String.valueOf(nodeId) + "ChannelCtx";
                    channelContextNode.setAttrValue("id", channelCtxName);
                }
                channelContextNode.setAttrValue("type", "channel");
                channelContextNode.setAttrValue("parent", "rootCtx");
                XMLNode refChannelKColl = new XMLNode();
                refChannelKColl.setNodeName("refKColl");
                refChannelKColl.setAttrValue("refId", String.valueOf(nodeId) + "ChannelKColl");
                channelContextNode.add(refChannelKColl);
                boolean needChannelCtx = false;
                if (contextNode.findChildNode(channelCtxName) == null) {
                    needChannelCtx = true;
                    contextNode.add(channelContextNode);
                }
                XMLNode sessionContextNode = new XMLNode();
                sessionContextNode.setNodeName("context");
                if (channelSessionCtxName != null) {
                    sessionContextNode.setAttrValue("id", channelSessionCtxName);
                } else {
                    sessionContextNode.setAttrValue("id", String.valueOf(nodeId) + "SessionCtx");
                }
                sessionContextNode.setAttrValue("type", "session");
                if (channelCtxName != null) {
                    sessionContextNode.setAttrValue("parent", channelCtxName);
                } else {
                    sessionContextNode.setAttrValue("parent", String.valueOf(nodeId) + "ChannelCtx");
                }
                XMLNode refSessionKColl = new XMLNode();
                refSessionKColl.setNodeName("refKColl");
                refSessionKColl.setAttrValue("refId", String.valueOf(nodeId) + "SessionKColl");
                sessionContextNode.add(refSessionKColl);
                contextNode.add(sessionContextNode);
                XMLNode channelDataNode = new XMLNode();
                channelDataNode.setNodeName("kColl");
                channelDataNode.setAttrValue("id", String.valueOf(nodeId) + "ChannelKColl");
                dataNode.add(channelDataNode);
                XMLNode sessionDataNode = new XMLNode();
                sessionDataNode.setNodeName("kColl");
                sessionDataNode.setAttrValue("id", String.valueOf(nodeId) + "SessionKColl");
                if (needChannelCtx) {
                    dataNode.add(sessionDataNode);
                }
                XMLNode dataRefNode = aChannelNode.getChild("sessionDatas");
                int k = 0;
                while (dataRefNode != null && k < dataRefNode.getChilds().size()) {
                    String refId;
                    XMLNode refDataNode;
                    XMLNode aNode = (XMLNode)dataRefNode.getChilds().elementAt(k);
                    if (!"#text".equals(aNode.getNodeName()) && (refDataNode = this.dataDictionary.findChildNode(refId = aNode.getAttrValue("refId"))) != null) {
                        String access = aNode.getAttrValue("access");
                        if ("common".equals(access)) {
                            this.addDataDefine(channelDataNode, refDataNode, aNode.getAttrValue("defaultValue"));
                        } else {
                            this.addDataDefine(sessionDataNode, refDataNode, aNode.getAttrValue("defaultValue"));
                        }
                    }
                    ++k;
                }
                XMLNode svcRefNode = aChannelNode.getChild("refServices");
                int k2 = 0;
                while (svcRefNode != null && k2 < svcRefNode.getChilds().size()) {
                    String svcid;
                    XMLNode svcNode;
                    XMLNode aNode = (XMLNode)svcRefNode.getChilds().elementAt(k2);
                    if (!"#text".equals(aNode.getNodeName()) && (svcNode = this.service.findChildNode(svcid = aNode.getAttrValue("id"))) != null) {
                        XMLNode refSvcNode = new XMLNode();
                        refSvcNode.setNodeName("refService");
                        refSvcNode.setAttrValue("refId", svcid);
                        refSvcNode.setAttrValue("alias", svcid);
                        refSvcNode.setAttrValue("type", "service");
                        String access = aNode.getAttrValue("access");
                        if ("common".equals(access)) {
                            channelContextNode.add(refSvcNode);
                        } else {
                            sessionContextNode.add(refSvcNode);
                        }
                    }
                    ++k2;
                }
            }
            ++i;
        }
    }

    private void buildFormats() {
        this.reportProgress(Messages.getString("MCIProjectBuilder.Buidl_MCI_Host_Formats_7"), 9);
        XMLNode fmtRootNode = new XMLNode();
        fmtRootNode.setNodeName("formats.xml");
        int i = 0;
        while (i < this.hostSettings.getChilds().size()) {
            XMLNode hostNode = (XMLNode)this.hostSettings.getChilds().elementAt(i);
            if (!"#text".equals(hostNode.getNodeName())) {
                XMLNode repNode;
                XMLNode repDatasNode;
                String hostId = hostNode.getAttrValue("id");
                XMLNode reqNode = hostNode.getChild("request");
                XMLNode reqDatasNode = reqNode.getChild("datas");
                if (reqDatasNode != null && reqDatasNode.getChilds() != null && reqDatasNode.getChilds().size() > 0) {
                    super.reportProblem(0, "Build Request package for host[" + hostId + "]...", "");
                    XMLNode fmtNode = this.genPackageFmt(reqDatasNode);
                    if (fmtNode != null) {
                        fmtNode.setAttrValue("id", String.valueOf(hostId) + "ReqHeadFmt");
                        fmtRootNode.add(fmtNode);
                    }
                }
                if ((repDatasNode = (repNode = hostNode.getChild("reply")).getChild("datas")) != null && repDatasNode.getChilds() != null && repDatasNode.getChilds().size() > 0) {
                    super.reportProblem(0, "Build Reply package for host[" + hostId + "]...", "");
                    XMLNode fmtNode = this.genPackageFmt(repDatasNode);
                    if (fmtNode != null) {
                        fmtNode.setAttrValue("id", String.valueOf(hostId) + "RepHeadFmt");
                        fmtRootNode.add(fmtNode);
                    }
                }
            }
            ++i;
        }
        if (this.fmtsNode != null) {
            Vector childs = this.fmtsNode.getChilds();
            int i2 = 0;
            while (i2 < childs.size()) {
                XMLNode fmtNode = (XMLNode)childs.elementAt(i2);
                if (!"#text".equals(fmtNode.getNodeName())) {
                    XMLNode fmtDefNode;
                    String fmtId = fmtNode.getAttrValue("id");
                    XMLNode datasNode = fmtNode.getChild("datas");
                    if (datasNode != null && (fmtDefNode = this.genPackageFmt(datasNode)) != null) {
                        fmtDefNode.setAttrValue("id", fmtNode.getAttrValue("id"));
                        fmtRootNode.add(fmtDefNode);
                    }
                }
                ++i2;
            }
        }
        String fileName = String.valueOf(this.dstPath) + "/formats.xml";
        this.saveXMLFile(fileName, fmtRootNode);
    }

    private void buildSettings() {
        String fileName = String.valueOf(this.dstPath) + "/settings.xml";
        try {
            this.saveXMLFile(fileName, IDEContent.getSettingNode(this.project, this.bizGrpId, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private XMLNode genPackageFmt(XMLNode aNode) {
        String pkgType = aNode.getAttrValue("packageType");
        if (pkgType == null) {
            super.reportProblem(2, "packageType Not set!", "");
            return null;
        }
        XMLNode pkgNode = this.packageType.findChildNode(pkgType);
        if (pkgNode == null) {
            super.reportProblem(2, "packageType [" + pkgType + "] not found!", "");
        } else {
            String fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
            if (fmtBuilderClass == null) {
                String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_81")) + pkgType + "]!";
            } else {
                try {
                    FormatGenerator fmtGen = null;
                    try {
                        fmtGen = (FormatGenerator)Class.forName(fmtBuilderClass).newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        fmtGen = (FormatGenerator)DynamicClassLoader.loadDynamicObject(this.project, fmtBuilderClass);
                    }
                    XMLNode fmtNode = fmtGen.generateFormatNode(aNode, this.dataDictionary, this.project);
                    return fmtNode;
                }
                catch (Exception e) {
                    String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Error_failed_to_build_request_fmt_for_host_[_85")) + "] Exception: " + e;
                    super.reportProblem(2, msg, "");
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void addDataDefine(XMLNode dataNode, XMLNode dictionaryNode, String value) {
        String nodeName = dictionaryNode.getNodeName();
        XMLNode node = new XMLNode();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            String dataType;
            if ("true".equals(dictionaryNode.getAttrValue("isSecureField"))) {
                node.setNodeName("secureField");
            } else {
                node.setNodeName("field");
            }
            node.setAttrValue("id", dictionaryNode.getAttrValue("id"));
            node.setAttrValue("value", dictionaryNode.getAttrValue("value"));
            if (value != null) {
                node.setAttrValue("value", value);
            }
            if ((dataType = dictionaryNode.getAttrValue("dataType")) != null) {
                node.setAttrValue("dataType", dataType);
            }
            dataNode.add(node);
        } else if (nodeName.equals("dataCollection")) {
            node.setNodeName("iColl");
            node.setAttrValue("id", dictionaryNode.getAttrValue("id"));
            dataNode.add(node);
            XMLNode kNode = new XMLNode();
            kNode.setNodeName("kColl");
            node.add(kNode);
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    if ("refData".equals(aNode.getNodeName())) {
                        String refId = aNode.getAttrValue("refId");
                        XMLNode dicNode = this.dataDictionary.findChildNode(refId);
                        if (dicNode != null) {
                            this.addDataDefine(kNode, dicNode, null);
                        }
                    } else {
                        this.addDataDefine(kNode, aNode, null);
                    }
                }
                ++i;
            }
        } else if (nodeName.equals("refData")) {
            node.setNodeName("field");
            node.setAttrValue("id", dictionaryNode.getAttrValue("refId"));
            node.setAttrValue("value", dictionaryNode.getAttrValue("value"));
            dataNode.add(node);
        }
    }

    private void copyDataTypeAttr(XMLNode node, XMLNode dictionaryNode) {
        Hashtable attrs = dictionaryNode.getAttrs();
        Enumeration keys = attrs.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)attrs.get(key);
            if (key.equals("id") || key.equals("access") || key.equals("label") || key.equals("dataType") || key.equals("isSecureField") || key.equals("isCommon")) continue;
            node.setAttrValue(key, value);
        }
    }

    public static BizGrpBuilder getInstance(IProject project, String bizGrpId) {
        BizGrpBuilder builder = new BizGrpBuilder();
        builder.setBizGrpId(bizGrpId);
        builder.setProject(project);
        IDEProjectSettings prjSettings = IDEContent.getPRJSettings(project);
        if (prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(prjSettings.getXMLEncoding());
        }
        try {
            builder.dataEditorProfile = IDEProfile.getEditorProfile(project, 1);
            builder.flowEditorProfile = ModuleUtility.getActionFlowProfile(project);
            builder.serviceEditorProfile = ModuleUtility.getServiceProfile(project);
            builder.dataDictionary = IDEContent.getSettingNode(project, 0);
            builder.hostSettings = IDEContent.getSettingNode(project, 11);
            builder.packageType = ModuleUtility.getPackageTypeNode(project);
            builder.dataTypeDefNode = IDEContent.getSettingNode(project, 33);
            builder.flow = IDEContent.getSettingNode(project, bizGrpId, 5);
            builder.service = IDEContent.getSettingNode(project, bizGrpId, 12);
            builder.nodeDefine = IDEContent.getSettingNode(project, bizGrpId, 19);
            builder.fmtsNode = IDEContent.getSettingNode(project, bizGrpId, 25);
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder.setOutputPath(String.valueOf(project.getLocation().toOSString()) + "/" + prjSettings.getWebContentPath() + "/WEB-INF/bizs/" + bizGrpId);
        String folderPath = String.valueOf(prjSettings.getWebContentPath()) + "/WEB-INF/bizs/" + bizGrpId;
        try {
            IFolder folder = project.getFolder(folderPath);
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            if (!(folder = project.getFolder(String.valueOf(folderPath) + "/operations")).exists()) {
                folder.create(true, true, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder;
    }

    private void processCommonDataDefine(XMLNode pNode, XMLNode commDatas) {
        int i = 0;
        while (i < commDatas.getChilds().size()) {
            XMLNode refNode = (XMLNode)commDatas.getChilds().elementAt(i);
            if (!"#text".equals(refNode.getNodeName())) {
                if ("dataGroup".equals(refNode.getNodeName())) {
                    XMLNode newRefNode = new XMLNode("kColl");
                    newRefNode.setAttrValue("id", refNode.getAttrValue("id"));
                    pNode.add(newRefNode);
                    int k = 0;
                    while (k < refNode.getChilds().size()) {
                        XMLNode aRefNode = (XMLNode)refNode.getChilds().elementAt(k);
                        String nodeName = aRefNode.getNodeName();
                        if (!"#text".equals(nodeName)) {
                            String refId = aRefNode.getAttrValue("refId");
                            String defaultValue = aRefNode.getAttrValue("defaultValue");
                            XMLNode childNode = this.dataDictionary.findChildNode(refId);
                            if (childNode == null) {
                                String msg = String.valueOf(Messages.getString("MCITransactionBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_66")) + refId + "]!";
                                super.reportProblem(2, msg, "");
                            } else {
                                this.addDataDefine(newRefNode, childNode, defaultValue);
                            }
                        }
                        ++k;
                    }
                }
                String refId = refNode.getAttrValue("refId");
                String defaultValue = refNode.getAttrValue("defaultValue");
                XMLNode childNode = this.dataDictionary.findChildNode(refId);
                if (childNode == null) {
                    String msg = String.valueOf(Messages.getString("MCITransactionBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_66")) + refId + "]!";
                    super.reportProblem(2, msg, "");
                } else {
                    this.addDataDefine(pNode, childNode, defaultValue);
                }
            }
            ++i;
        }
    }

    private void addCommonDataDefine(XMLNode rootDataNode, XMLNode node) {
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode childNode = (XMLNode)node.getChilds().elementAt(i);
            if ("dataGroup".equals(childNode.getNodeName())) {
                this.addCommonDataDefine(rootDataNode, childNode);
            } else if ("common".equals(childNode.getAttrValue("access"))) {
                this.addDataDefine(rootDataNode, childNode, childNode.getAttrValue("defaultValue"));
            }
            ++i;
        }
    }

    public void setBizGrpId(String bizGrpId) {
        this.bizGrpId = bizGrpId;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

