/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;

public class FunctionBuilder
extends AbstractBuilder {
    private String srcFileName = "";

    public void buildFunction(String srcFile) {
        this.srcFileName = srcFile;
        try {
            String systemFuctionPath = ModuleUtility.getFunctionProfile();
            XMLNode oldFunction = this.loadXMLContent(this.srcFileName);
            if (oldFunction == null) {
                return;
            }
            this.reportProgress("\u6b63\u5728\u521b\u5efa........");
            XMLNode functionNode = new XMLNode("Fuction");
            functionNode.setNodeName("FunctionDef");
            this.buildXmlHead(functionNode);
            ArrayList functions = new ArrayList();
            this.getFunNode(functions, oldFunction);
            this.beginWork("build function.xml.....", functions.size());
            XMLNode functionsNode = new XMLNode("functions");
            functionsNode.setNodeName("Functions");
            functionsNode.setAttrValue("id", "Functions");
            this.buildSystemFuc(systemFuctionPath, functionsNode);
            int i = 0;
            while (i < functions.size()) {
                XMLNode node = (XMLNode)functions.get(i);
                this.buildFunctionNode(node, functionsNode);
                this.reportProgress("funtion is building......", i + 1);
                ++i;
            }
            functionNode.add(functionsNode);
            File file = new File(srcFile);
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            this.saveXMLFile(String.valueOf(this.dstPath) + "/" + fileName + ".xml", functionNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getFunNode(ArrayList functions, XMLNode oldFunction) {
        int i = 0;
        while (i < oldFunction.getChilds().size()) {
            XMLNode node = (XMLNode)oldFunction.getChilds().elementAt(i);
            if (!"#text".equals(node.getNodeName())) {
                if ("FuncGroup".equals(node.getNodeName())) {
                    this.getFunNode(functions, node);
                } else {
                    functions.add(node);
                }
            }
            ++i;
        }
    }

    private void buildFunctionNode(XMLNode node, XMLNode fuctionNode) {
        String functionId = node.getAttrValue("id");
        this.reportProgress("build fuction " + functionId + "......");
        XMLNode ctxFuctionNode = fuctionNode.findChildNode("Func", functionId);
        if (ctxFuctionNode == null) {
            ctxFuctionNode = new XMLNode("Fuction");
            fuctionNode.add(ctxFuctionNode);
        } else {
            ctxFuctionNode.removeAllChilds();
        }
        ctxFuctionNode.setAttrValue("id", functionId);
        ctxFuctionNode.setAttrValue("name", node.getAttrValue("name"));
        ctxFuctionNode.setAttrValue("class", node.getAttrValue("className"));
    }

    private void buildXmlHead(XMLNode fuctionNode) {
        XMLNode headNode = new XMLNode("classMap");
        headNode.setNodeName("classMap");
        XMLNode newNode = new XMLNode("map");
        newNode.setNodeName("map");
        newNode.setAttrValue("id", "Functions");
        newNode.setAttrValue("class", "com.ecc.util.formula.function.FunctionManager");
        headNode.add(newNode);
        fuctionNode.add(headNode);
    }

    private void buildSystemFuc(String srcFile, XMLNode node) {
        String srcFileName = srcFile;
        try {
            XMLNode SysFunction = this.loadXMLContent(srcFileName);
            if (SysFunction == null) {
                return;
            }
            ArrayList SysFuc = new ArrayList();
            this.getFunNode(SysFuc, SysFunction);
            int i = 0;
            while (i < SysFuc.size()) {
                XMLNode Sysnode = (XMLNode)SysFuc.get(i);
                this.buildFunctionNode(Sysnode, node);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FunctionBuilder getInstance(IProject prj) {
        IDEProjectSettings prjSettings = IDEContent.getPRJSettings(prj);
        String settingsPath = String.valueOf(prjSettings.getWebContentPath()) + "/WEB-INF";
        String targetPath = prj.getLocation() + "/" + settingsPath;
        FunctionBuilder builder = new FunctionBuilder();
        builder.setOutputPath(targetPath);
        if (prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(prjSettings.getXMLEncoding());
        }
        return builder;
    }
}

