/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IProject;

public class GRDBuilder
extends AbstractBuilder {
    XMLNode srcNode = null;
    XMLNode destNode = null;
    XMLNode bodyNode = null;
    XMLNode docNode = null;
    String hdDivId = "hd";
    String ftDivId = "ft";
    XMLNode mainUnit = null;
    XMLNode headNode = null;
    String area_content_str = "";
    String relaDiv_str = "";
    String helpDiv_str = "";
    String advertDiv_str = "";
    String menuData_str = "";
    String menu1_str = "";
    String menu2_str = "";
    String menu3_str = "";
    String menu4_str = "";
    String menu5_str = "";
    String headSource_str = "";
    String footSource_str = "";
    Vector divs = new Vector();
    Vector workbenchs = new Vector();
    Hashtable menubars = new Hashtable();
    XMLNode contentSrcNode = null;
    String pagemode = "doc3";
    String jspEncoding = "UTF-8";

    public void buildGRDModel(String srcFile) {
        this.srcFileName = srcFile;
        try {
            this.reportProgress("Load GRD model file: " + srcFile, 1);
            this.srcNode = this.loadXMLContent(this.srcFileName);
            if (this.srcNode == null) {
                return;
            }
            this.getDesktopNode();
            this.getHeadNode();
            this.getContentNode();
            this.getFootNode();
            this.getMenuNode();
            File file = new File(srcFile);
            String fileName = file.getName();
            String path = "designFiles\\mvcs\\" + IDEContent.getGroupId(srcFile);
            String folderName = srcFile.substring(srcFile.indexOf(path) + path.length(), srcFile.lastIndexOf("\\"));
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            this.saveXMLFile(String.valueOf(this.dstPath) + folderName + "/" + fileName + ".jsp", this.destNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            super.reportProblem(2, "failed to build the MVC model" + e, this.srcFileName);
        }
        this.reportProgress(Messages.getString("MCITransactionBuilder.Build_finished._4"), 10);
    }

    public void buildGridNode(XMLNode targetParentNode, XMLNode gridDefineNode) {
        if (targetParentNode == null) {
            return;
        }
        int mode = 0;
        try {
            mode = new Integer(gridDefineNode.getAttrValue("mode"));
        }
        catch (Exception e) {
            mode = 0;
        }
        String classStr = this.getLayoutMode(mode);
        XMLNode contentGridNode = new XMLNode("div");
        contentGridNode.setAttrValue("class", classStr);
        targetParentNode.add(contentGridNode);
        boolean first = true;
        int i = 0;
        while (i < gridDefineNode.getChilds().size()) {
            XMLNode unitDefineNode = (XMLNode)gridDefineNode.getChilds().elementAt(i);
            if ("unit".equals(unitDefineNode.getNodeName())) {
                XMLNode unitNode = new XMLNode("div");
                if (first) {
                    first = false;
                    unitNode.setAttrValue("class", String.valueOf(classStr) + "-ul");
                } else {
                    unitNode.setAttrValue("class", String.valueOf(classStr) + "-ur");
                }
                this.buildUnitNode(unitNode, unitDefineNode);
                contentGridNode.add(unitNode);
            }
            ++i;
        }
    }

    public void buildUnitNode(XMLNode unitTargetNode, XMLNode unitSrcNode) {
        int i = 0;
        while (i < unitSrcNode.getChilds().size()) {
            XMLNode panelDefineNode = (XMLNode)unitSrcNode.getChilds().elementAt(i);
            if ("panel".equals(panelDefineNode.getNodeName())) {
                this.buildPanelNode(unitTargetNode, panelDefineNode);
            }
            if ("div".equals(panelDefineNode.getNodeName())) {
                this.buildDivNode(unitTargetNode, panelDefineNode);
            }
            if ("menubar".equals(panelDefineNode.getNodeName())) {
                this.buildMenuBarNode(unitTargetNode, panelDefineNode);
            }
            if ("grid".equals(panelDefineNode.getNodeName())) {
                this.buildGridNode(unitTargetNode, panelDefineNode);
            }
            if ("customContent".equals(panelDefineNode.getNodeName())) {
                this.buildCustomNode(unitTargetNode, panelDefineNode);
            }
            ++i;
        }
    }

    public void buildCustomNode(XMLNode unitTargetNode, XMLNode unitSrcNode) {
        String content = unitSrcNode.getAttrValue("content");
        if (content == null || content.length() == 0) {
            return;
        }
        content = String.valueOf(content) + "\n";
        XMLNode textNode = new XMLNode("#text");
        textNode.setTextValue(content);
        unitTargetNode.add(textNode);
    }

    public void buildPanelNode(XMLNode targetParentNode, XMLNode unitSrcNode) {
        String[] styles;
        XMLNode panelNode = new XMLNode("ctp:panel");
        String name = unitSrcNode.getAttrValue("id");
        String title = unitSrcNode.getAttrValue("title");
        String dataSrc = unitSrcNode.getAttrValue("source");
        String height = unitSrcNode.getAttrValue("panelHeight");
        String style = unitSrcNode.getAttrValue("style");
        panelNode.setAttrValue("name", name);
        panelNode.setAttrValue("title", title);
        panelNode.setAttrValue("dataSrc", dataSrc);
        if (height != null && height.length() > 0) {
            panelNode.setAttrValue("height", height);
        }
        if ((styles = this.getArrayFromStr(style)) != null && styles.length != 0) {
            int i = 0;
            while (i < styles.length) {
                String attr = styles[i];
                if (attr.length() != 0) {
                    panelNode.setAttrValue(attr, "true");
                }
                ++i;
            }
        }
        targetParentNode.add(panelNode);
    }

    private void buildMenuBarNode(XMLNode targetParentNode, XMLNode menuBarSrcNode) {
        XMLNode panelNode = new XMLNode("div");
        String name = menuBarSrcNode.getAttrValue("id");
        String classname = menuBarSrcNode.getAttrValue("class");
        panelNode.setAttrValue("id", name);
        panelNode.setAttrValue("class", classname);
        targetParentNode.add(panelNode);
        this.menubars.put(name, menuBarSrcNode);
    }

    private void buildDivNode(XMLNode targetParentNode, XMLNode divSrcNode) {
        XMLNode panelNode = new XMLNode("div");
        String name = divSrcNode.getAttrValue("id");
        String classname = divSrcNode.getAttrValue("class");
        panelNode.setAttrValue("id", name);
        panelNode.setAttrValue("class", classname);
        targetParentNode.add(panelNode);
        this.divs.add(divSrcNode);
        int w = 0;
        while (w < divSrcNode.getChilds().size()) {
            XMLNode benchDefineNode = (XMLNode)divSrcNode.getChilds().elementAt(w);
            if ("workbench".equals(benchDefineNode.getNodeName())) {
                XMLNode benchNode = new XMLNode("div");
                String name1 = benchDefineNode.getAttrValue("id");
                String classname1 = benchDefineNode.getAttrValue("class");
                benchNode.setAttrValue("id", name1);
                benchNode.setAttrValue("class", classname1);
                panelNode.add(benchNode);
                this.workbenchs.add(benchDefineNode);
            }
            if ("div".equals(benchDefineNode.getNodeName())) {
                this.buildDivNode(panelNode, benchDefineNode);
            }
            if ("panel".equals(benchDefineNode.getNodeName())) {
                this.buildPanelNode(panelNode, benchDefineNode);
            }
            if ("customContent".equals(benchDefineNode.getNodeName())) {
                this.buildCustomNode(panelNode, benchDefineNode);
            }
            ++w;
        }
    }

    public void getContentNode() {
        block11: {
            if (this.destNode == null) {
                this.getDesktopNode();
            }
            if (this.contentSrcNode == null) break block11;
            XMLNode bdNode = new XMLNode("div");
            bdNode.setAttrValue("id", "bd");
            bdNode.setTextValue("");
            this.docNode.add(bdNode);
            int mode = this.getMode();
            if (this.isUnitStyle()) {
                boolean mainUnitFlag = false;
                int i = 0;
                while (i < this.contentSrcNode.getChilds().size()) {
                    XMLNode unitSrcNode = (XMLNode)this.contentSrcNode.getChilds().elementAt(i);
                    if ("unit".equals(unitSrcNode.getNodeName())) {
                        if (!mainUnitFlag) {
                            mainUnitFlag = true;
                            this.mainUnit = new XMLNode("div");
                            this.mainUnit.setAttrValue("id", "yui-main");
                            XMLNode main_bUnit = new XMLNode("div");
                            main_bUnit.setAttrValue("class", "yui-b");
                            this.mainUnit.add(main_bUnit);
                            bdNode.add(this.mainUnit);
                            this.buildUnitNode(main_bUnit, unitSrcNode);
                        } else {
                            XMLNode unitNode = new XMLNode("div");
                            unitNode.setAttrValue("class", "yui-b");
                            bdNode.add(unitNode);
                            this.buildUnitNode(unitNode, unitSrcNode);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.contentSrcNode.getChilds().size()) {
                    XMLNode childNode = (XMLNode)this.contentSrcNode.getChilds().elementAt(i);
                    if ("grid".equals(childNode.getNodeName())) {
                        this.buildGridNode(bdNode, childNode);
                    }
                    if ("div".equals(childNode.getNodeName())) {
                        this.buildDivNode(bdNode, childNode);
                    }
                    if ("panel".equals(childNode.getNodeName())) {
                        this.buildPanelNode(bdNode, childNode);
                    }
                    ++i;
                }
            }
        }
    }

    private int getMode() {
        int mode = 5;
        XMLNode contentSrcNode = this.srcNode.findChild("content");
        if (contentSrcNode != null) {
            try {
                mode = new Integer(contentSrcNode.getAttrValue("mode"));
            }
            catch (Exception e) {
                mode = 5;
            }
        }
        return mode;
    }

    public void getMenuNode() {
        XMLNode divNode;
        XMLNode menubar;
        String selfDef;
        if (this.destNode == null) {
            this.getDesktopNode();
        }
        XMLNode menuSrcNode = this.srcNode.findChild("menu");
        String title = this.srcNode.getAttrValue("title");
        if (title == null) {
            title = "";
        }
        if ((selfDef = this.srcNode.getAttrValue("selfDef")) == null) {
            selfDef = "";
        }
        if (menuSrcNode != null) {
            this.relaDiv_str = menuSrcNode.getAttrValue("RelativeDiv");
            this.advertDiv_str = menuSrcNode.getAttrValue("AdvertDiv");
            this.area_content_str = menuSrcNode.getAttrValue("ContentDiv");
            this.helpDiv_str = menuSrcNode.getAttrValue("HelpDiv");
            this.menuData_str = menuSrcNode.getAttrValue("MenuData");
            this.menu1_str = menuSrcNode.getAttrValue("menu1");
            this.menu2_str = menuSrcNode.getAttrValue("menu2");
            this.menu3_str = menuSrcNode.getAttrValue("menu3");
            this.menu4_str = menuSrcNode.getAttrValue("menu4");
            this.menu5_str = menuSrcNode.getAttrValue("menu5");
        }
        String text = "\r\n<META http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.jspEncoding + "\" />\r\n";
        text = String.valueOf(text) + "<title>" + title + "</title>\r\n";
        String include = this.srcNode.getAttrValue("style");
        String[] styles = this.getArrayFromStr(include);
        if (styles == null || styles.length == 0) {
            text = String.valueOf(text) + "<ctp:yuiInclude tabType=\"round\"/>\r\n";
        } else {
            text = String.valueOf(text) + "<ctp:yuiInclude tabType=\"round\"";
            int i = 0;
            while (i < styles.length) {
                String attr = styles[i];
                if (attr.length() != 0) {
                    text = String.valueOf(text) + " " + attr + "=\"true\"";
                }
                ++i;
            }
            text = String.valueOf(text) + "/>\r\n";
        }
        if ("doc".equals(this.pagemode)) {
            try {
                String pageWidthStr = this.srcNode.getAttrValue("pageWidth");
                int pageWidth = new Integer(pageWidthStr);
                float pageWidthEm = (float)pageWidth / 13.0f;
                String pageWidthEmStr = new Float(pageWidthEm).toString();
                if (pageWidthEmStr.indexOf(".") != -1 && pageWidthEmStr.length() - pageWidthEmStr.indexOf(".") > 3) {
                    pageWidthEmStr = pageWidthEmStr.substring(0, pageWidthEmStr.indexOf(".") + 3);
                }
                text = String.valueOf(text) + "<style>\r\n\t#doc {\r\n\t\tmargin:auto;text-align:left;\r\n\t\twidth:" + pageWidthEmStr + "em;\r\n\t\tmin-width:" + pageWidthStr + "px;}\r\n\t</style>\r\n";
            }
            catch (Exception pageWidthStr) {
                // empty catch block
            }
        }
        if (selfDef != null && selfDef.length() > 0) {
            text = String.valueOf(text) + selfDef + "\r\n";
        }
        text = String.valueOf(text) + "<script type=\"text/JavaScript\" language=\"JavaScript\">\r\n\t";
        text = String.valueOf(text) + "var empMenu;\r\n\t";
        text = String.valueOf(text) + "var empWorkBench;\r\n\t";
        text = String.valueOf(text) + "function loadContent(){\r\n\t\t";
        if (menuSrcNode != null) {
            text = String.valueOf(text) + "empMenu = new EMP.widget.EMPMenu('empMenu');\r\n\t\t";
            String defaultMenuId = menuSrcNode.getAttrValue("defaultMenuId");
            if (defaultMenuId != null && defaultMenuId.length() > 0) {
                text = String.valueOf(text) + "empMenu.setDefaultMenuId('" + defaultMenuId + "');\r\n\t";
            }
        }
        if (this.menu1_str != null && this.menu1_str.length() > 0) {
            menubar = (XMLNode)this.menubars.get(this.menu1_str);
            text = this.addMenuBarToHead(1, this.menu1_str, menubar, text);
        }
        if (this.menu2_str != null && this.menu2_str.length() > 0) {
            menubar = (XMLNode)this.menubars.get(this.menu2_str);
            text = this.addMenuBarToHead(2, this.menu2_str, menubar, text);
        }
        if (this.menu3_str != null && this.menu3_str.length() > 0) {
            menubar = (XMLNode)this.menubars.get(this.menu3_str);
            text = this.addMenuBarToHead(3, this.menu3_str, menubar, text);
        }
        if (this.menu4_str != null && this.menu4_str.length() > 0) {
            menubar = (XMLNode)this.menubars.get(this.menu4_str);
            text = this.addMenuBarToHead(4, this.menu4_str, menubar, text);
        }
        if (this.menu5_str != null && this.menu5_str.length() > 0) {
            menubar = (XMLNode)this.menubars.get(this.menu5_str);
            text = this.addMenuBarToHead(5, this.menu5_str, menubar, text);
        }
        if (this.area_content_str != null && this.area_content_str.length() > 0) {
            text = String.valueOf(text) + "\tempMenu.registContentArea('" + this.area_content_str + "');\r\n\t\t";
            XMLNode temp = this.destNode.findIgnoreCaseThrowChildNode("div", this.area_content_str);
            if (temp != null) {
                temp.setNodeName("iframe");
                temp.setAttrValue("name", this.area_content_str);
            }
        }
        if (this.relaDiv_str != null && this.relaDiv_str.length() > 0) {
            text = String.valueOf(text) + "empMenu.registRelativeArea('" + this.relaDiv_str + "');\r\n\t\t";
        }
        if (this.helpDiv_str != null && this.helpDiv_str.length() > 0) {
            text = String.valueOf(text) + "empMenu.registHelpArea('" + this.helpDiv_str + "');\r\n\t\t";
        }
        if (this.advertDiv_str != null && this.advertDiv_str.length() > 0) {
            text = String.valueOf(text) + "empMenu.registAdvertArea('" + this.advertDiv_str + "');\r\n\t\t";
        }
        if (this.menuData_str != null && this.menuData_str.length() > 0) {
            text = String.valueOf(text) + "empMenu.loadMenuData('<ctp:jspURL jspFileName=\"" + this.menuData_str + "\"/>');\r\n\t\t";
        }
        int i = 0;
        while (i < this.divs.size()) {
            divNode = (XMLNode)this.divs.elementAt(i);
            String id = divNode.getAttrValue("id");
            String source = divNode.getAttrValue("source");
            if (id != null && id.length() > 0 && source != null && source.length() > 0) {
                text = String.valueOf(text) + "var href = \"<ctp:jspURL jspFileName=\"" + source + "\"/>\";\r\n\t\t" + "empMenu.updateAreaContent(href, \"" + id + "\", \"\" );\r\n\t\t";
            }
            ++i;
        }
        i = 0;
        while (i < this.workbenchs.size()) {
            divNode = (XMLNode)this.workbenchs.elementAt(i);
            String id = divNode.getAttrValue("id");
            String orientation = divNode.getAttrValue("orientation");
            if (orientation == null || orientation.length() == 0) {
                orientation = "top";
            }
            if (id != null && id.length() > 0 && orientation != null && orientation.length() > 0) {
                text = String.valueOf(text) + "empWorkBench = new EMP.widget.WorkBench( {id:'" + id + "', orientation:'" + orientation + "'});\r\n\t\tempMenu.setEMPWorkBench( empWorkBench );\r\n\t\t";
                break;
            }
            ++i;
        }
        text = String.valueOf(text) + "}\r\n</script>\r\n";
        XMLNode textNode = new XMLNode("#text");
        textNode.setTextValue(text);
        this.headNode.add(textNode);
    }

    public void getHeadNode() {
        XMLNode headSrcNode;
        if (this.destNode == null) {
            this.getDesktopNode();
        }
        if ((headSrcNode = this.srcNode.findChild("head")) != null) {
            int i = 0;
            while (i < headSrcNode.getChilds().size()) {
                XMLNode panelSrcNode = (XMLNode)headSrcNode.getChilds().elementAt(i);
                if ("div".equals(panelSrcNode.getNodeName())) {
                    this.buildDivNode(this.docNode, panelSrcNode);
                }
                if ("menubar".equals(panelSrcNode.getNodeName())) {
                    this.buildMenuBarNode(this.docNode, panelSrcNode);
                }
                ++i;
            }
        }
    }

    public void getFootNode() {
        XMLNode footSrcNode;
        if (this.destNode == null) {
            this.getDesktopNode();
        }
        if ((footSrcNode = this.srcNode.findChild("foot")) != null) {
            int i = 0;
            while (i < footSrcNode.getChilds().size()) {
                XMLNode panelSrcNode = (XMLNode)footSrcNode.getChilds().elementAt(i);
                if ("div".equals(panelSrcNode.getNodeName())) {
                    this.buildDivNode(this.docNode, panelSrcNode);
                }
                if ("panel".equals(panelSrcNode.getNodeName())) {
                    this.buildPanelNode(this.docNode, panelSrcNode);
                }
                ++i;
            }
        }
    }

    public void getDesktopNode() {
        if (this.destNode == null) {
            this.destNode = new XMLNode("html");
            this.destNode.setLineEnd(false);
            this.headNode = new XMLNode("head");
            this.destNode.add(this.headNode);
            this.bodyNode = new XMLNode("body");
            this.bodyNode.setAttrValue("id", "yahoo-com");
            this.bodyNode.setAttrValue("onLoad", "loadContent()");
            this.destNode.add(this.bodyNode);
            this.docNode = new XMLNode("div");
            this.pagemode = this.srcNode.getAttrValue("mode");
            if (this.pagemode == null || this.pagemode.length() == 0) {
                this.pagemode = "doc3";
            }
            if (this.pagemode.equals("doc1")) {
                this.docNode.setAttrValue("id", "doc");
            } else {
                this.docNode.setAttrValue("id", this.pagemode);
            }
            this.bodyNode.add(this.docNode);
            this.contentSrcNode = this.srcNode.findChild("content");
            if (this.contentSrcNode != null && this.isUnitStyle()) {
                int mode = 0;
                try {
                    mode = new Integer(this.contentSrcNode.getAttrValue("mode"));
                }
                catch (Exception e) {
                    mode = 0;
                }
                this.docNode.setAttrValue("class", this.getLayoutMode(mode));
            }
        }
    }

    public static GRDBuilder getInstance(IProject prj) {
        IDEProjectSettings prjSettings = IDEContent.getPRJSettings(prj);
        String settingsPath = String.valueOf(prjSettings.getWebContentPath()) + "/WEB-INF";
        String targetPath = prj.getLocation() + "/" + settingsPath;
        GRDBuilder builder = new GRDBuilder();
        if (prjSettings.getSetJSPEncodeManually()) {
            builder.setjspEncoding(prjSettings.getJSPEncoding());
        }
        builder.setOutputPath(targetPath);
        if (prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(prjSettings.getXMLEncoding());
        }
        return builder;
    }

    public void saveXMLFile(String fileName, XMLNode node) {
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            StringBuffer strBuf = new StringBuffer();
            if (this.jspEncoding != null) {
                node.setEncoding(this.jspEncoding);
            }
            node.toYUIContent(0, strBuf, true);
            FileOutputStream fo = new FileOutputStream(fileName);
            String temp = strBuf.toString();
            temp = temp.substring(temp.indexOf("?>") + 2);
            temp = "<%@page language=\"java\" contentType=\"text/html; charset=" + this.jspEncoding + "\"%>\n<%@taglib uri=\"/WEB-INF/ctp.tld\" prefix=\"ctp\" %>\n<%@taglib uri=\"/WEB-INF/emp.tld\" prefix=\"emp\" %>\n<%@taglib uri=\"/WEB-INF/c.tld\" prefix=\"c\" %>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n" + temp;
            if (this.jspEncoding != null) {
                fo.write(temp.getBytes(this.jspEncoding));
            } else {
                fo.write(temp.getBytes(IDEConstance.encoding));
            }
            fo.close();
        }
        catch (Exception e) {
            String msg = e.toString();
            this.reportProblem(2, msg, "");
            e.printStackTrace();
        }
    }

    private String getLayoutMode(int mode) {
        String classStr = "";
        if (mode < 5) {
            classStr = "yui-g";
            if (mode == 0) {
                classStr = "yui-g";
            }
            if (mode == 1) {
                classStr = "yui-gc";
            }
            if (mode == 2) {
                classStr = "yui-gd";
            }
            if (mode == 3) {
                classStr = "yui-ge";
            }
            if (mode == 4) {
                classStr = "yui-gf";
            }
        } else {
            classStr = "yui-t1";
            if (mode == 5) {
                classStr = "yui-t1";
            }
            if (mode == 6) {
                classStr = "yui-t2";
            }
            if (mode == 7) {
                classStr = "yui-t3";
            }
            if (mode == 8) {
                classStr = "yui-t4";
            }
            if (mode == 9) {
                classStr = "yui-t5";
            }
            if (mode == 10) {
                classStr = "yui-t6";
            }
        }
        return classStr;
    }

    public boolean isUnitStyle() {
        if (this.contentSrcNode == null) {
            return false;
        }
        int i = 0;
        while (i < this.contentSrcNode.getChilds().size()) {
            XMLNode node = (XMLNode)this.contentSrcNode.getChilds().elementAt(i);
            if ("unit".equals(node.getNodeName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String addMenuBarToHead(int index, String id, XMLNode menubar, String text) {
        String style = menubar.getAttrValue("style");
        style = style == null || "1".equals(style) ? "" : ",style:\"" + style + "\"";
        if ("3".equals(menubar.getAttrValue("style"))) {
            style = ",style:\"tree\"";
        }
        String normalClass = "";
        String activeClass = "";
        String value = menubar.getAttrValue("menustyle");
        if (value != null && value.indexOf(";") != -1) {
            activeClass = value.substring(0, value.indexOf(";"));
            normalClass = value.substring(value.indexOf(";") + 1);
            if (normalClass.endsWith(";")) {
                normalClass = normalClass.substring(0, normalClass.length() - 1);
            }
        }
        text = String.valueOf(text) + "\tvar menuBar" + index + " = new EMP.widget.MenuBar({id:\"" + id + "\"";
        if (normalClass.length() > 0) {
            text = String.valueOf(text) + ",normalClass:\"" + normalClass + "\"";
        }
        if (activeClass.length() > 0) {
            text = String.valueOf(text) + ", activeClass:\"" + activeClass + "\"";
        }
        text = String.valueOf(text) + style + "});\r\n\t\tempMenu.registMenuBar( menuBar" + index + ");\r\n\t";
        return text;
    }

    private String[] getArrayFromStr(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return null;
        }
        Vector<String> temp = new Vector<String>();
        while (str.indexOf(";") != -1) {
            String value = str.substring(0, str.indexOf(";"));
            temp.add(value);
            str = str.substring(str.indexOf(";") + 1);
        }
        temp.add(str);
        String[] result = new String[temp.size()];
        int i = 0;
        while (i < temp.size()) {
            result[i] = (String)temp.elementAt(i);
            ++i;
        }
        return result;
    }

    public void setjspEncoding(String jspEncoding) {
        this.jspEncoding = jspEncoding;
    }
}

