/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.editor.XMLNode;
import java.io.File;
import java.util.Vector;

public class HTMLTransactionBuilder
extends AbstractBuilder {
    private String filePath;
    private String serverSettingsPath;
    private XMLNode jsFunctionNode;
    private String jspPath;

    public void setJspPath(String value) {
        this.jspPath = value;
    }

    public void setJSFunctionNode(XMLNode node) {
        this.jsFunctionNode = node;
    }

    public void setTargetPath(String path) {
        this.dstPath = path;
    }

    public void buildHtmlTransaction(String fileName) {
        String relativeJspPath;
        this.reportProgress(Messages.getString("HTMLTransactionBuilder.Loading_HTML_Transaction_file_..._1"));
        XMLNode xmlContent = this.loadXMLContent(fileName);
        if (xmlContent == null) {
            return;
        }
        String settingPath = null;
        String classify = null;
        try {
            classify = xmlContent.getAttrValue("classify");
            if (classify != null && classify.length() > 0) {
                this.filePath = this.dstPath;
                settingPath = this.dstPath;
            } else {
                this.filePath = this.dstPath;
                settingPath = this.dstPath;
            }
            File file = new File(this.filePath);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            super.reportProblem(2, String.valueOf(Messages.getString("HTMLTransactionBuilder.Faild_to_create_classify_folder_[_3")) + classify + "]. Exception: " + e, fileName);
        }
        if (this.jspPath != null && this.jspPath.length() > 0) {
            relativeJspPath = String.valueOf(this.jspPath) + "/";
            if (classify != null && classify.length() > 0) {
                relativeJspPath = String.valueOf(relativeJspPath) + classify + "/";
            }
        } else {
            relativeJspPath = classify != null && classify.length() > 0 ? String.valueOf(classify) + "/" : "";
        }
        try {
            XMLNode transNode = new XMLNode();
            transNode.setNodeName("transitions");
            String trxCode = xmlContent.getAttrValue("trxCode");
            XMLNode node = xmlContent.getChild("jsps");
            super.beginWork(Messages.getString("HTMLTransactionBuilder.Build_the_transaction_defines..._2"), node.getChilds().size());
            int i = 0;
            while (node != null && i < node.getChilds().size()) {
                XMLNode jspNode = (XMLNode)node.getChilds().elementAt(i);
                if (jspNode.getNodeName().equals("refSrvOp")) {
                    this.reportProgress(String.valueOf(Messages.getString("HTMLTransactionBuilder.Build_refSrvOp[_3")) + jspNode.getAttrValue("name") + "]", i);
                    XMLNode refNode = new XMLNode();
                    refNode.setNodeName(jspNode.getNodeName());
                    refNode.setAttrValue("name", jspNode.getAttrValue("name"));
                    Vector childs = (Vector)jspNode.getChilds().clone();
                    int j = 0;
                    while (j < childs.size()) {
                        XMLNode transitionNode = (XMLNode)childs.elementAt(j);
                        if (!"#text".equals(transitionNode.getNodeName())) {
                            String dstJSP = transitionNode.getAttrValue("dest");
                            if (node.findChildNodeNamed("jsp", dstJSP) != null) {
                                refNode.add(transitionNode);
                                String dst = String.valueOf(relativeJspPath) + transitionNode.getAttrValue("dest");
                                transitionNode.setAttrValue("dest", dst);
                            } else if (node.findChildNodeNamed("refJsp", dstJSP) != null) {
                                refNode.add(transitionNode);
                            } else {
                                this.reportProblem(2, "Transition of Server [" + jspNode.getAttrValue("name") + "] transition to unknow JSP:[" + dstJSP + "].\nPlease open the JSP flow define page to let the editor delete automatically.", "");
                            }
                        }
                        ++j;
                    }
                    transNode.add(refNode);
                } else if (!jspNode.getNodeName().equals("jsp")) {
                    // empty if block
                }
                ++i;
            }
            File file = new File(settingPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.reportProgress(Messages.getString("HTMLTransactionBuilder.Save_to_file..._9"));
            this.saveXMLFile(String.valueOf(settingPath) + "/" + trxCode + ".xml", transNode);
            this.reportProgress(Messages.getString("HTMLTransactionBuilder.Build_OK._10"), node.getChilds().size());
        }
        catch (Exception e) {
            super.reportProblem(2, String.valueOf(Messages.getString("HTMLTransactionBuilder.Failed_to_build_html_xml_content_exception___18")) + e, fileName);
            e.printStackTrace();
        }
    }
}

