/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.document.word.WordDocument;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualContentToImage;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.File;

public class HTMLTrxDesignDocumentBuilder
extends AbstractBuilder {
    WordDocument document = null;
    private EditorProfile htmlEditorProfile = null;
    private EditorProfile jspFlowEditorProfile = null;
    private XMLLoader xmlLoader = null;
    private XMLNode HTMLTrxNode;

    public void buildHtmlTransaction(String srcFile, WordDocument doc) {
        this.document = doc;
        if (this.document == null) {
            return;
        }
        try {
            String filePath = this.dstPath;
            this.HTMLTrxNode = this.loadXMLContent(srcFile);
            if (this.HTMLTrxNode == null) {
                return;
            }
            this.reportProgress(Messages.getString("HTMLTrxDesignDocumentBuilder.Loading_HTML_Transaction_file_..._1"), 1);
            String classify = null;
            try {
                classify = this.HTMLTrxNode.getAttrValue("classify");
                super.createFolder(classify);
                if (classify != null && classify.length() > 0) {
                    filePath = String.valueOf(this.dstPath) + "/" + classify;
                }
            }
            catch (Exception e) {
                super.reportProblem(2, String.valueOf(Messages.getString("HTMLTrxDesignDocumentBuilder.Faild_to_create_classify_folder_[_3")) + classify + "]. Exception: " + e, srcFile);
            }
            String trxCode = this.HTMLTrxNode.getAttrValue("trxCode");
            String trxName = this.HTMLTrxNode.getAttrValue("trxName");
            String trxDes = this.HTMLTrxNode.getDocument();
            this.reportProgress(Messages.getString("HTMLTrxDesignDocumentBuilder.Build_HTML_Transaction_Description_2"), 2);
            this.document.find(Messages.getString("HTMLTrxDesignDocumentBuilder.HTML_u4EA4_u6613_u540D_u79F0_9"));
            this.document.typeText(trxName);
            this.document.gotoFirst(1);
            this.document.find(Messages.getString("HTMLTrxDesignDocumentBuilder._u4EA4_u6613_u5C5E_u6027_u5B9A_u4E49_11"));
            this.document.moveDown(5, 1);
            this.document.setStyle(Messages.getString("HTMLTrxDesignDocumentBuilder._u6B63_u6587_12"));
            this.document.typeText(trxDes);
            String[] titles = new String[]{Messages.getString("HTMLTrxDesignDocumentBuilder._u4EA4_u6613_u540D_u79F0_13"), Messages.getString("HTMLTrxDesignDocumentBuilder._u4EA4_u6613_u7801_14"), Messages.getString("HTMLTrxDesignDocumentBuilder._u4EA4_u6613_u63CF_u8FF0_15"), Messages.getString("HTMLTrxDesignDocumentBuilder._u4EA4_u6613_u5206_u7C7B_16"), ""};
            this.document.addTable(2, 4, titles);
            this.document.typeText(trxName);
            this.document.moveRight(1, 1);
            this.document.typeText(trxCode);
            this.document.moveRight(1, 1);
            this.document.typeText(trxDes);
            this.document.moveRight(1, 1);
            this.document.typeText(classify);
            this.document.moveRight(1, 1);
            this.document.moveToHome();
            this.document.gotoFirst(1);
            this.document.find(Messages.getString("HTMLTrxDesignDocumentBuilder._u8BBF_u95EE_u670D_u52A1_u5668_u7AEF_u4EA4_u6613_22"));
            this.document.moveDown(5, 1);
            this.document.setStyle(Messages.getString("HTMLTrxDesignDocumentBuilder._u6B63_u6587_23"));
            XMLNode refServs = this.HTMLTrxNode.getChild("jsps");
            if (refServs != null && refServs.getChilds().size() > 0) {
                int i = 0;
                while (i < refServs.getChilds().size()) {
                    XMLNode refServ = (XMLNode)refServs.getChilds().elementAt(i);
                    if ("refSrvOp".equals(refServ.getNodeName())) {
                        this.document.typeText(String.valueOf(refServ.getAttrValue("name")) + "\r\n");
                    }
                    ++i;
                }
                this.reportProgress(Messages.getString("HTMLTrxDesignDocumentBuilder.Build_JSP_Files_3"), 2);
                this.buildJspViewDesc(refServs);
                this.reportProgress(Messages.getString("HTMLTrxDesignDocumentBuilder.Build_JSP_flow_4"), 2);
                this.buildJspFlowDesc(refServs);
            }
            String fileName = String.valueOf(filePath) + Messages.getString("HTMLTrxDesignDocumentBuilder./HTML_u4EA4_u6613__28") + trxName + "_" + trxCode + Messages.getString("HTMLTrxDesignDocumentBuilder.__u8BE6_u7EC6_u8BBE_u8BA1_u6587_u6863.doc_30");
            this.reportProgress(Messages.getString("HTMLTrxDesignDocumentBuilder.Save_to_file..._5"), 1);
            this.saveFile(fileName);
            this.reportProgress(Messages.getString("HTMLTrxDesignDocumentBuilder.Build_finished._6"), 1);
        }
        catch (Exception e) {
            String fileName = String.valueOf(this.dstPath) + "errorHTMLTrxDocument.doc";
            this.saveFile(fileName);
            e.printStackTrace();
            super.reportProblem(2, String.valueOf(Messages.getString("HTMLTrxDesignDocumentBuilder.Failed_to_build_the_HTML_transaction_!_Exception___31")) + e, srcFile);
        }
    }

    private void buildJspViewDesc(XMLNode jspsNode) {
        if (this.document == null) {
            return;
        }
        if (jspsNode == null) {
            return;
        }
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("HTMLTrxDesignDocumentBuilder._u4EA4_u6613_u753B_u9762_u5B9A_u4E49_33"));
        this.document.moveDown(5, 1);
        int i = 0;
        while (i < jspsNode.getChilds().size()) {
            XMLNode jspNode = (XMLNode)jspsNode.getChilds().elementAt(i);
            if ("jsp".equals(jspNode.getNodeName())) {
                this.reportProgress(String.valueOf(Messages.getString("HTMLTrxDesignDocumentBuilder.Build_JSP_File_Descriptoin[_7")) + jspNode.getAttrValue("name") + "]");
                this.document.setStyle(Messages.getString("HTMLTrxDesignDocumentBuilder._u6807_u9898_3_35"));
                this.document.typeText(jspNode.getAttrValue("name") + "\r\n");
                this.document.setStyle(Messages.getString("HTMLTrxDesignDocumentBuilder._u6B63_u6587_39"));
                this.document.typeText(Messages.getString("HTMLTrxDesignDocumentBuilder._u5982_u56FE_uFF1A_r_n_40"));
                VisualContentToImage visual = new VisualContentToImage();
                try {
                    visual.setFlowEditorProfile(this.htmlEditorProfile);
                    visual.setXMLContent(jspNode);
                }
                catch (Exception e) {
                    return;
                }
                String fileName = String.valueOf(this.dstPath) + "/jspImage_" + i + ".jpg";
                visual.saveToImageFile(fileName, 0);
                visual.isImageOK();
                this.document.addPicture(fileName);
                File imageFile = new File(fileName);
                imageFile.delete();
                this.document.typeText("\r\n");
            }
            ++i;
        }
    }

    private void buildJspFlowDesc(XMLNode jspsNode) {
        int j;
        if (this.document == null) {
            return;
        }
        if (jspsNode == null) {
            return;
        }
        this.reportProgress(Messages.getString("HTMLTrxDesignDocumentBuilder.Build_HTML_Transaction_Flow_10"), 2);
        this.document.find(Messages.getString("HTMLTrxDesignDocumentBuilder._u4EA4_u6613_u6D41_u7A0B_u63CF_u8FF0_48"));
        this.document.moveDown(5, 1);
        this.document.setStyle(Messages.getString("HTMLTrxDesignDocumentBuilder._u6B63_u6587_49"));
        String[] titles = new String[]{Messages.getString("HTMLTrxDesignDocumentBuilder._u4EA4_u6613_u6B65_u9AA4_50"), Messages.getString("HTMLTrxDesignDocumentBuilder._u6761_u4EF6_51"), Messages.getString("HTMLTrxDesignDocumentBuilder._u6D41_u8F6C_52"), ""};
        this.document.addTable(2, 3, titles);
        int i = 0;
        while (i < jspsNode.getChilds().size()) {
            XMLNode jspNode = (XMLNode)jspsNode.getChilds().elementAt(i);
            if ("jsp".equals(jspNode.getNodeName())) {
                String jspName = jspNode.getAttrValue("name");
                j = 0;
                while (j < jspNode.getChilds().size()) {
                    XMLNode formNode = (XMLNode)jspNode.getChilds().elementAt(j);
                    if ("form".equals(formNode.getNodeName())) {
                        this.document.typeText(String.valueOf(jspName) + "/" + formNode.getAttrValue("name"));
                        this.document.moveRight(1, 1);
                        this.document.typeText("Action");
                        this.document.moveRight(1, 1);
                        this.document.typeText(formNode.getAttrValue("srvOpName"));
                        this.document.insertRowsBelow(1);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < jspsNode.getChilds().size()) {
            XMLNode refOpNode = (XMLNode)jspsNode.getChilds().elementAt(i);
            if ("refSrvOp".equals(refOpNode.getNodeName())) {
                String OPName = refOpNode.getAttrValue("name");
                j = 0;
                while (j < refOpNode.getChilds().size()) {
                    XMLNode transitionNode = (XMLNode)refOpNode.getChilds().elementAt(j);
                    if ("transition".equals(transitionNode.getNodeName())) {
                        this.document.typeText(OPName);
                        this.document.moveRight(1, 1);
                        String condition = transitionNode.getAttrValue("condition");
                        if (condition != null) {
                            this.document.typeText(condition);
                        } else {
                            this.document.typeText("Action");
                        }
                        this.document.moveRight(1, 1);
                        this.document.typeText(transitionNode.getAttrValue("dest"));
                    }
                    ++j;
                }
                this.document.insertRowsBelow(1);
            }
            ++i;
        }
        this.document.moveDown(5, 2);
        this.document.typeText(Messages.getString("HTMLTrxDesignDocumentBuilder._u5982_u56FE_uFF1A_r_n_69"));
        VisualContentToImage visual = new VisualContentToImage();
        try {
            visual.setFlowEditorProfile(this.jspFlowEditorProfile);
            visual.setXMLContent(jspsNode);
        }
        catch (Exception e) {
            return;
        }
        visual.saveToImageFile(String.valueOf(this.dstPath) + "/jspFlowImage.jpg", 0);
        visual.isImageOK();
        this.document.addPicture(String.valueOf(this.dstPath) + "/jspFlowImage.jpg");
        File imageFile = new File(String.valueOf(this.dstPath) + "/jspFlowImage.jpg");
        imageFile.delete();
        this.document.typeText("\r\n");
        this.document.moveDown(5, 1);
    }

    public void setHtmlEditorProfile(EditorProfile profile) {
        this.htmlEditorProfile = profile;
    }

    public void setJspFlowEditorProfile(EditorProfile profile) {
        this.jspFlowEditorProfile = profile;
    }

    private void saveFile(String fileName) {
        try {
            this.document.saveAs(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

