/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.builder.StateMachineBuilder;
import com.ecc.ide.builder.format.FormatGenerator;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IProject;

public class MCIProjectBuilder
extends AbstractBuilder {
    private IProject project;
    private XMLNode dataDictionary;
    private XMLNode hostSettings;
    private XMLNode packageType;
    private XMLNode service;
    private XMLNode fmtsNode;
    private XMLNode flow;
    private XMLNode channelNode;
    private XMLNode dataTypeDefNode;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile serviceEditorProfile;
    private EditorProfile stateMachineProfile;
    private EditorProfile stateProfile;
    private XMLNode commonStates;
    private XMLNode commonStateMachineNode;
    private boolean buildStateMachineAsOperation = false;

    public void setBuildStateMachineAsOperation(boolean value) {
        this.buildStateMachineAsOperation = value;
    }

    public void setDataTypeDefNode(XMLNode node) {
        this.dataTypeDefNode = node;
    }

    public void setFmtsNode(XMLNode node) {
        this.fmtsNode = node;
    }

    public void setCommonStateMachine(XMLNode node) {
        this.commonStateMachineNode = node;
    }

    public void setStateMachineEditorProfile(EditorProfile profile) {
        this.stateMachineProfile = profile;
    }

    public void setStateEditorProfile(EditorProfile profile) {
        this.stateProfile = profile;
    }

    public void setCommonStates(XMLNode states) {
        this.commonStates = states;
    }

    public void setFlowEditorProfile(EditorProfile profile) {
        this.flowEditorProfile = profile;
    }

    public void setServiceEditorProfile(EditorProfile profile) {
        this.serviceEditorProfile = profile;
    }

    public void setService(XMLNode serv) {
        this.service = serv;
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setHostSettings(XMLNode node) {
        this.hostSettings = node;
    }

    public void setPackageType(XMLNode node) {
        this.packageType = node;
    }

    public void setChannelNode(XMLNode node) {
        this.channelNode = node;
    }

    public void buildProject() {
        try {
            this.buildContextAndData();
            this.buildCommonFlow();
            this.buildFormats();
            this.buildServices();
        }
        catch (Exception e) {
            e.printStackTrace();
            super.reportProblem(2, String.valueOf(Messages.getString("MCIProjectBuilder.Failed_to_build_the_MCI_Project_!_Exception___1")) + e, "");
        }
        this.reportProgress(Messages.getString("MCIProjectBuilder.Build_finished._1"), 10);
    }

    private void buildCommonFlow() {
        this.reportProgress(Messages.getString("MCIProjectBuilder.Build_MCI_Common_Flow_2"), 5);
        XMLNode operationNode = new XMLNode();
        operationNode.setNodeName("operations.xml");
        int i = 0;
        while (i < this.flow.getChilds().size()) {
            XMLNode flowNode = (XMLNode)this.flow.getChilds().elementAt(i);
            if (!"#text".equals(flowNode.getNodeName())) {
                XMLNode opNode = new XMLNode();
                opNode.setNodeName("Operation");
                opNode.setAttrValue("id", flowNode.getAttrValue("id"));
                operationNode.add(opNode);
                if (flowNode.getAttrValue("implClass") != null) {
                    opNode.setNodeName(flowNode.getAttrValue("implClass"));
                }
                if (flowNode.getChilds() != null) {
                    this.buildOpFlow(opNode, flowNode);
                }
            }
            ++i;
        }
        this.buildStateMachine(operationNode);
        String fileName = String.valueOf(this.dstPath) + "/operations.xml";
        this.saveXMLFile(fileName, operationNode);
    }

    private void buildOpFlow(XMLNode opNode, XMLNode flowNode) {
        int k = 0;
        while (k < flowNode.getChilds().size()) {
            XMLNode actionNode = (XMLNode)flowNode.getChilds().elementAt(k);
            if (!("#text".equals(actionNode.getNodeName()) || actionNode.getNodeName().equals("attributes") || "END".equals(actionNode.getNodeName()) || "validateEnd".equals(actionNode.getNodeName()) || "document".equals(actionNode.getNodeName()) || "transition".equals(actionNode.getNodeName()))) {
                XMLNode stepNode = new XMLNode();
                if ("validator".equals(actionNode.getNodeName())) {
                    stepNode.setNodeName("validator");
                    stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                } else {
                    stepNode.setNodeName("opStep");
                    stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                }
                opNode.add(stepNode);
                if (this.flowEditorProfile.getElement(actionNode.getNodeName()) != null) {
                    stepNode.setAttrValue("implClass", this.flowEditorProfile.getElement(actionNode.getNodeName()).getImplClass());
                } else {
                    super.reportProblem(2, String.valueOf(Messages.getString("MCITransactionBuilder.No_set_implement_class_for_OpStep[_7")) + actionNode.getNodeName() + "]!", "");
                }
                Enumeration keys = actionNode.getAttrs().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height")) continue;
                    stepNode.setAttrValue(key, actionNode.getAttrValue(key));
                }
                if (actionNode.getChilds() != null) {
                    int j = 0;
                    while (j < actionNode.getChilds().size()) {
                        XMLNode transitionNode = (XMLNode)actionNode.getChilds().elementAt(j);
                        String dst = transitionNode.getAttrValue("dest");
                        String idStr = transitionNode.getAttrValue("id");
                        if (dst != null) {
                            if (dst.startsWith("END") || dst.startsWith("validateEnd")) {
                                dst = "end";
                            }
                            if (idStr == null || idStr.length() == 0) {
                                idStr = "Other";
                            }
                            String key = "on" + idStr + "Do";
                            stepNode.setAttrValue(key, dst);
                        }
                        ++j;
                    }
                    this.buildOpFlow(stepNode, actionNode);
                }
            }
            ++k;
        }
    }

    private void buildStateMachine(XMLNode pNode) {
        this.reportProgress(Messages.getString("MCIProjectBuilder.Building_the_stateMachine..._1"), 5);
        StateMachineBuilder stateMachineBuilder = new StateMachineBuilder();
        stateMachineBuilder.setBuilder(this);
        stateMachineBuilder.setStateEditorProfile(this.stateProfile);
        stateMachineBuilder.setStateMachineEditorProfile(this.stateMachineProfile);
        stateMachineBuilder.setCommonStateMachine(this.commonStateMachineNode);
        stateMachineBuilder.setCommonStates(this.commonStates);
        int i = 0;
        while (i < this.commonStateMachineNode.getChilds().size()) {
            XMLNode stateMachineNode = (XMLNode)this.commonStateMachineNode.getChilds().elementAt(i);
            if (!"#text".equals(stateMachineNode.getNodeName())) {
                XMLNode opNode = stateMachineBuilder.buildStateMachine(stateMachineNode);
                pNode.add(opNode);
            }
            ++i;
        }
    }

    private void buildServices() {
        String fileName = String.valueOf(this.dstPath) + "/services.xml";
        this.saveXMLFile(fileName, this.service);
    }

    private void buildDataTypeDef() {
        this.reportProgress(Messages.getString("MCIProjectBuilder.Buidl_MCI_Context_And_Data_6"), 2);
        XMLNode typeNode = new XMLNode("dsetype.xml");
        int i = 0;
        while (i < this.dataTypeDefNode.getChilds().size()) {
            XMLNode node = (XMLNode)this.dataTypeDefNode.getChilds().elementAt(i);
            if ("dataType".equals(node.getNodeName())) {
                XMLNode aTypeNode = new XMLNode("type");
                aTypeNode.setAttrValue("id", node.getAttrValue("id"));
                aTypeNode.setAttrValue("implClass", "com.ecc.cte.base.DataField");
                typeNode.add(aTypeNode);
                XMLNode descNode = new XMLNode("Descriptor");
                aTypeNode.add(descNode);
                descNode.setAttrValue("id", "typeDefault");
                descNode.setAttrValue("implClass", "com.ecc.cte.base.bizdata.implement.StringDefinition");
                XMLNode convertorNode = new XMLNode("Converter");
                descNode.add(convertorNode);
                convertorNode.setAttrValue("convTypes", "default");
                convertorNode.setAttrValue("implClass", node.getAttrValue("convertorClass"));
                XMLNode validatorNode = new XMLNode("Validator");
                descNode.add(validatorNode);
                validatorNode.setAttrValue("implClass", node.getAttrValue("validatorClass"));
            }
            ++i;
        }
        String fileName = String.valueOf(this.dstPath) + "/dsetype.xml";
        this.saveXMLFile(fileName, typeNode);
    }

    private void buildContextAndData() {
        this.reportProgress(Messages.getString("MCIProjectBuilder.Buidl_MCI_Context_And_Data_6"), 2);
        XMLNode contextNode = new XMLNode();
        contextNode.setNodeName("contexts.xml");
        XMLNode rootContextNode = new XMLNode();
        rootContextNode.setNodeName("context");
        rootContextNode.setAttrValue("id", "rootCtx");
        rootContextNode.setAttrValue("type", "root");
        XMLNode refRootKColl = new XMLNode();
        refRootKColl.setNodeName("refKColl");
        refRootKColl.setAttrValue("refId", "rootKColl");
        rootContextNode.add(refRootKColl);
        contextNode.add(rootContextNode);
        XMLNode dataNode = new XMLNode();
        dataNode.setNodeName("data.xml");
        XMLNode rootDataNode = new XMLNode();
        rootDataNode.setNodeName("kColl");
        rootDataNode.setAttrValue("id", "rootKColl");
        dataNode.add(rootDataNode);
        this.addCommonDataDefine(rootDataNode, this.dataDictionary);
        this.processChannelNode(contextNode, dataNode);
        XMLNode commDatas = this.dataDictionary.getChild("CommonData");
        this.processCommonDataDefine(dataNode, commDatas);
        int i = 0;
        while (i < this.service.getChilds().size()) {
            XMLNode childNode = (XMLNode)this.service.getChilds().elementAt(i);
            String svcid = childNode.getAttrValue("id");
            if ("common".equals(childNode.getAttrValue("access"))) {
                XMLNode refSvcNode = new XMLNode();
                refSvcNode.setNodeName("refService");
                refSvcNode.setAttrValue("refId", svcid);
                refSvcNode.setAttrValue("alias", svcid);
                refSvcNode.setAttrValue("type", "common");
                rootContextNode.add(refSvcNode);
            }
            ++i;
        }
        String fileName = String.valueOf(this.dstPath) + "/data.xml";
        this.saveXMLFile(fileName, dataNode);
        fileName = String.valueOf(this.dstPath) + "/contexts.xml";
        this.saveXMLFile(fileName, contextNode);
    }

    private void processCommonDataDefine(XMLNode pNode, XMLNode commDatas) {
        int i = 0;
        while (i < commDatas.getChilds().size()) {
            XMLNode refNode = (XMLNode)commDatas.getChilds().elementAt(i);
            if (!"#text".equals(refNode.getNodeName())) {
                if ("dataGroup".equals(refNode.getNodeName())) {
                    XMLNode newRefNode = new XMLNode("kColl");
                    newRefNode.setAttrValue("id", refNode.getAttrValue("id"));
                    pNode.add(newRefNode);
                    int k = 0;
                    while (k < refNode.getChilds().size()) {
                        XMLNode aRefNode = (XMLNode)refNode.getChilds().elementAt(k);
                        String nodeName = aRefNode.getNodeName();
                        if (!"#text".equals(nodeName)) {
                            String refId = aRefNode.getAttrValue("refId");
                            String defaultValue = aRefNode.getAttrValue("defaultValue");
                            XMLNode childNode = this.dataDictionary.findChildNode(refId);
                            if (childNode == null) {
                                String msg = String.valueOf(Messages.getString("MCITransactionBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_66")) + refId + "]!";
                                super.reportProblem(2, msg, "");
                            } else {
                                this.addDataDefine(newRefNode, childNode, defaultValue);
                            }
                        }
                        ++k;
                    }
                }
                String refId = refNode.getAttrValue("refId");
                String defaultValue = refNode.getAttrValue("defaultValue");
                XMLNode childNode = this.dataDictionary.findChildNode(refId);
                if (childNode == null) {
                    String msg = String.valueOf(Messages.getString("MCITransactionBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_66")) + refId + "]!";
                    super.reportProblem(2, msg, "");
                } else {
                    this.addDataDefine(pNode, childNode, defaultValue);
                }
            }
            ++i;
        }
    }

    private void processChannelNode(XMLNode contextNode, XMLNode dataNode) {
        Vector childs = this.channelNode.getChilds();
        int i = 0;
        while (i < childs.size()) {
            XMLNode aChannelNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aChannelNode.getNodeName())) {
                String channelId = aChannelNode.getAttrValue("id");
                String channelCtxName = aChannelNode.getAttrValue("channelCtxName");
                String channelSessionCtxName = aChannelNode.getAttrValue("channelSessionName");
                XMLNode channelContextNode = new XMLNode();
                channelContextNode.setNodeName("context");
                if (channelCtxName != null) {
                    channelContextNode.setAttrValue("id", channelCtxName);
                } else {
                    channelCtxName = String.valueOf(channelId) + "ChannelCtx";
                    channelContextNode.setAttrValue("id", channelCtxName);
                }
                channelContextNode.setAttrValue("type", "channel");
                channelContextNode.setAttrValue("parent", "rootCtx");
                XMLNode refChannelKColl = new XMLNode();
                refChannelKColl.setNodeName("refKColl");
                refChannelKColl.setAttrValue("refId", String.valueOf(channelId) + "ChannelKColl");
                channelContextNode.add(refChannelKColl);
                boolean needChannelCtx = false;
                if (contextNode.findChildNode(channelCtxName) == null) {
                    needChannelCtx = true;
                    contextNode.add(channelContextNode);
                }
                XMLNode sessionContextNode = new XMLNode();
                sessionContextNode.setNodeName("context");
                if (channelSessionCtxName != null) {
                    sessionContextNode.setAttrValue("id", channelSessionCtxName);
                } else {
                    sessionContextNode.setAttrValue("id", String.valueOf(channelId) + "SessionCtx");
                }
                sessionContextNode.setAttrValue("type", "session");
                if (channelCtxName != null) {
                    sessionContextNode.setAttrValue("parent", channelCtxName);
                } else {
                    sessionContextNode.setAttrValue("parent", String.valueOf(channelId) + "ChannelCtx");
                }
                XMLNode refSessionKColl = new XMLNode();
                refSessionKColl.setNodeName("refKColl");
                refSessionKColl.setAttrValue("refId", String.valueOf(channelId) + "SessionKColl");
                sessionContextNode.add(refSessionKColl);
                contextNode.add(sessionContextNode);
                XMLNode channelDataNode = new XMLNode();
                channelDataNode.setNodeName("kColl");
                channelDataNode.setAttrValue("id", String.valueOf(channelId) + "ChannelKColl");
                dataNode.add(channelDataNode);
                XMLNode sessionDataNode = new XMLNode();
                sessionDataNode.setNodeName("kColl");
                sessionDataNode.setAttrValue("id", String.valueOf(channelId) + "SessionKColl");
                if (needChannelCtx) {
                    dataNode.add(sessionDataNode);
                }
                XMLNode dataRefNode = aChannelNode.getChild("sessionDatas");
                int k = 0;
                while (dataRefNode != null && k < dataRefNode.getChilds().size()) {
                    XMLNode aNode = (XMLNode)dataRefNode.getChilds().elementAt(k);
                    if (!"#text".equals(aNode.getNodeName())) {
                        String refId = aNode.getAttrValue("refId");
                        XMLNode refDataNode = this.dataDictionary.findChildNode(refId);
                        if (refDataNode == null) {
                            String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Channel_define_[_2")) + channelId + Messages.getString("MCIProjectBuilder.]_refer_to_undefined_dataElement_[_3") + refId + "]";
                            this.reportProblem(2, msg, "");
                        } else {
                            String access = aNode.getAttrValue("access");
                            if ("common".equals(access)) {
                                this.addDataDefine(channelDataNode, refDataNode, aNode.getAttrValue("defaultValue"));
                            } else {
                                this.addDataDefine(sessionDataNode, refDataNode, aNode.getAttrValue("defaultValue"));
                            }
                        }
                    }
                    ++k;
                }
                XMLNode svcRefNode = aChannelNode.getChild("refServices");
                int k2 = 0;
                while (svcRefNode != null && k2 < svcRefNode.getChilds().size()) {
                    XMLNode aNode = (XMLNode)svcRefNode.getChilds().elementAt(k2);
                    if (!"#text".equals(aNode.getNodeName())) {
                        String svcid = aNode.getAttrValue("id");
                        XMLNode svcNode = this.service.findChildNode(svcid);
                        if (svcNode == null) {
                            String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Channel_define_[_5")) + channelId + Messages.getString("MCIProjectBuilder.]_refer_to_undefined_service_[_6") + svcid + "]";
                            this.reportProblem(2, msg, "");
                        } else {
                            XMLNode refSvcNode = new XMLNode();
                            refSvcNode.setNodeName("refService");
                            refSvcNode.setAttrValue("refId", svcid);
                            refSvcNode.setAttrValue("alias", svcid);
                            refSvcNode.setAttrValue("type", "service");
                            String access = aNode.getAttrValue("access");
                            if ("common".equals(access)) {
                                channelContextNode.add(refSvcNode);
                            } else {
                                sessionContextNode.add(refSvcNode);
                            }
                        }
                    }
                    ++k2;
                }
            }
            ++i;
        }
    }

    private void addCommonDataDefine(XMLNode rootDataNode, XMLNode node) {
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode childNode = (XMLNode)node.getChilds().elementAt(i);
            if ("dataGroup".equals(childNode.getNodeName())) {
                this.addCommonDataDefine(rootDataNode, childNode);
            } else if ("common".equals(childNode.getAttrValue("access"))) {
                this.addDataDefine(rootDataNode, childNode, childNode.getAttrValue("defaultValue"));
            }
            ++i;
        }
    }

    private void buildFormats() {
        this.reportProgress(Messages.getString("MCIProjectBuilder.Buidl_MCI_Host_Formats_7"), 9);
        XMLNode fmtRootNode = new XMLNode();
        fmtRootNode.setNodeName("formats.xml");
        int i = 0;
        while (i < this.hostSettings.getChilds().size()) {
            XMLNode hostNode = (XMLNode)this.hostSettings.getChilds().elementAt(i);
            if (!"#text".equals(hostNode.getNodeName())) {
                XMLNode repNode;
                XMLNode repDatasNode;
                String hostId = hostNode.getAttrValue("id");
                XMLNode reqNode = hostNode.getChild("request");
                XMLNode reqDatasNode = reqNode.getChild("datas");
                if (reqDatasNode != null && reqDatasNode.getChilds() != null && reqDatasNode.getChilds().size() > 0) {
                    super.reportProblem(0, "Build Request package for host[" + hostId + "]...", "");
                    XMLNode fmtNode = this.genPackageFmt(reqDatasNode);
                    if (fmtNode != null) {
                        fmtNode.setAttrValue("id", String.valueOf(hostId) + "ReqHeadFmt");
                        fmtRootNode.add(fmtNode);
                    }
                }
                if ((repDatasNode = (repNode = hostNode.getChild("reply")).getChild("datas")) != null && repDatasNode.getChilds() != null && repDatasNode.getChilds().size() > 0) {
                    super.reportProblem(0, "Build Reply package for host[" + hostId + "]...", "");
                    XMLNode fmtNode = this.genPackageFmt(repDatasNode);
                    if (fmtNode != null) {
                        fmtNode.setAttrValue("id", String.valueOf(hostId) + "RepHeadFmt");
                        fmtRootNode.add(fmtNode);
                    }
                }
            }
            ++i;
        }
        if (this.fmtsNode != null) {
            Vector childs = this.fmtsNode.getChilds();
            super.reportProblem(0, "Build Common packages ...", "");
            int i2 = 0;
            while (i2 < childs.size()) {
                XMLNode fmtNode = (XMLNode)childs.elementAt(i2);
                if (!"#text".equals(fmtNode.getNodeName())) {
                    XMLNode fmtDefNode;
                    String fmtId = fmtNode.getAttrValue("id");
                    super.reportProblem(0, "Build package for format ID[" + fmtId + "]...", "");
                    XMLNode datasNode = fmtNode.getChild("datas");
                    if (datasNode != null && (fmtDefNode = this.genPackageFmt(datasNode)) != null) {
                        fmtDefNode.setAttrValue("id", fmtNode.getAttrValue("id"));
                        fmtRootNode.add(fmtDefNode);
                    }
                }
                ++i2;
            }
        }
        String fileName = String.valueOf(this.dstPath) + "/formats.xml";
        this.saveXMLFile(fileName, fmtRootNode);
    }

    private XMLNode genPackageFmt(XMLNode aNode) {
        String pkgType = aNode.getAttrValue("packageType");
        if (pkgType == null) {
            super.reportProblem(2, "packageType Not set!", "");
            return null;
        }
        XMLNode pkgNode = this.packageType.findChildNode(pkgType);
        if (pkgNode == null) {
            super.reportProblem(2, "packageType [" + pkgType + "] not found!", "");
        } else {
            String fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
            if (fmtBuilderClass == null) {
                String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_81")) + pkgType + "]!";
            } else {
                try {
                    FormatGenerator fmtGen = (FormatGenerator)Class.forName(fmtBuilderClass).newInstance();
                    XMLNode fmtNode = fmtGen.generateFormatNode(aNode, this.dataDictionary, this.project);
                    return fmtNode;
                }
                catch (Exception e) {
                    String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Error_failed_to_build_request_fmt_for_host_[_85")) + "] Exception: " + e;
                    super.reportProblem(2, msg, "");
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void addDataDefine(XMLNode dataNode, XMLNode dictionaryNode, String value) {
        String nodeName = dictionaryNode.getNodeName();
        XMLNode node = new XMLNode();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            String dataType;
            if ("true".equals(dictionaryNode.getAttrValue("isSecureField"))) {
                node.setNodeName("secureField");
            } else {
                node.setNodeName("field");
            }
            node.setAttrValue("id", dictionaryNode.getAttrValue("id"));
            node.setAttrValue("value", dictionaryNode.getAttrValue("value"));
            if (value != null) {
                node.setAttrValue("value", value);
            }
            if ((dataType = dictionaryNode.getAttrValue("dataType")) != null) {
                node.setAttrValue("type", dataType);
            }
            dataNode.add(node);
        } else if (nodeName.equals("dataCollection")) {
            node.setNodeName("iColl");
            node.setAttrValue("id", dictionaryNode.getAttrValue("id"));
            dataNode.add(node);
            XMLNode kNode = new XMLNode();
            kNode.setNodeName("kColl");
            node.add(kNode);
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    if ("refData".equals(aNode.getNodeName())) {
                        String refId = aNode.getAttrValue("refId");
                        XMLNode dicNode = this.dataDictionary.findChildNode(refId);
                        if (dicNode == null) {
                            String msg = "Collection [" + node.getAttrValue("id") + "] data refer to [" + refId + "] Not define in dictionary!";
                            this.reportProblem(2, msg, "");
                        } else {
                            this.addDataDefine(kNode, dicNode, null);
                        }
                    } else {
                        this.addDataDefine(kNode, aNode, null);
                    }
                }
                ++i;
            }
        } else if (nodeName.equals("refData")) {
            node.setNodeName("field");
            node.setAttrValue("id", dictionaryNode.getAttrValue("refId"));
            node.setAttrValue("value", dictionaryNode.getAttrValue("value"));
            dataNode.add(node);
        }
    }

    private void copyDataTypeAttr(XMLNode node, XMLNode dictionaryNode) {
        Hashtable attrs = dictionaryNode.getAttrs();
        Enumeration keys = attrs.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)attrs.get(key);
            if (key.equals("id") || key.equals("access") || key.equals("label") || key.equals("dataType") || key.equals("isSecureField") || key.equals("isCommon")) continue;
            node.setAttrValue(key, value);
        }
    }

    public XMLNode getFlow() {
        return this.flow;
    }

    public void setFlow(XMLNode flow) {
        this.flow = flow;
    }

    public static void main(String[] argv) {
        MCIProjectBuilder test = new MCIProjectBuilder();
        try {
            String fileName = "/profiles/dataDictionaryEditorProfile.xml";
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(fileName);
            test.setDataDictionaryEditorProfile(profile);
            profile = (EditorProfile)xmlLoader.loadXMLFile("/profiles/srvActionProfile.xml");
            test.setFlowEditorProfile(profile);
            profile = (EditorProfile)xmlLoader.loadXMLFile("/profiles/srvServiceProfile.xml");
            test.setServiceEditorProfile(profile);
            XMLLoader xmlLoader1 = new XMLLoader();
            xmlLoader1.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader1.loadXMLFile("/dataDictionary.xml");
            test.setDataDictionary(node);
            XMLLoader xmlLoader2 = new XMLLoader();
            xmlLoader2.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode flowNode = (XMLNode)xmlLoader2.loadXMLFile("/serverFlow.xml");
            test.setFlow(flowNode);
            XMLNode hostSettingsNode = (XMLNode)xmlLoader2.loadXMLFile("/profiles/hostProfiles.xml");
            test.setHostSettings(hostSettingsNode);
            XMLNode packageType = (XMLNode)xmlLoader2.loadXMLFile("/profiles/hostPackageProfile.xml");
            test.setPackageType(packageType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        test.setOutputPath("");
        test.buildProject();
    }

    public static MCIProjectBuilder getInstance(IProject project) {
        MCIProjectBuilder builder = new MCIProjectBuilder();
        try {
            builder.setDataDictionaryEditorProfile(IDEProfile.getEditorProfile(project, 1));
            builder.setFlowEditorProfile(IDEProfile.getEditorProfile(project, 5));
            builder.setServiceEditorProfile(IDEProfile.getEditorProfile(project, 13));
            builder.setDataDictionary(IDEContent.getSettingNode(project, 0));
            builder.setFlow(IDEContent.getSettingNode(project, 5));
            builder.setHostSettings(IDEContent.getSettingNode(project, 11));
            builder.setPackageType(IDEContent.getSettingNode(project, 14));
            builder.setService(IDEContent.getSettingNode(project, 12));
            builder.setChannelNode(IDEContent.getSettingNode(project, 19));
            builder.setStateMachineEditorProfile(IDEProfile.getEditorProfile(project, 23));
            builder.setStateEditorProfile(IDEProfile.getEditorProfile(project, 5));
            builder.setCommonStates(IDEContent.getSettingNode(project, 23));
            builder.setCommonStateMachine(IDEContent.getSettingNode(project, 21));
            builder.setBuildStateMachineAsOperation(ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("buildStateMachineAsOperation"));
            builder.setFmtsNode(IDEContent.getSettingNode(project, 25));
            builder.setDataTypeDefNode(IDEContent.getSettingNode(project, 33));
            builder.project = project;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder;
    }
}

