/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.MVCBuilder11;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.resources.IProject;

public class MVCBuilder
extends AbstractBuilder {
    private XMLNode dataDictionary;
    private XMLNode flow;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;

    public void buildMVCModel(String srcFile) {
        this.srcFileName = srcFile;
        try {
            this.reportProgress("Load MVC model file: " + srcFile, 1);
            XMLNode modelDefNode = this.loadXMLContent(this.srcFileName);
            if (modelDefNode == null) {
                return;
            }
            XMLNode contextNode = new XMLNode();
            contextNode.setNodeName("actionDefines");
            ArrayList<XMLNode> actions = new ArrayList<XMLNode>();
            int i = 0;
            while (i < modelDefNode.getChilds().size()) {
                XMLNode node = (XMLNode)modelDefNode.getChilds().elementAt(i);
                if ("action".equals(node.getNodeName())) {
                    actions.add(node);
                }
                ++i;
            }
            i = 0;
            while (i < actions.size()) {
                XMLNode actionNode = (XMLNode)actions.get(i);
                this.buildAction(actionNode, modelDefNode, contextNode);
                ++i;
            }
            File file = new File(srcFile);
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            this.saveXMLFile(String.valueOf(this.dstPath) + "/" + fileName + ".xml", contextNode);
        }
        catch (Exception e) {
            super.reportProblem(2, "failed to build the MVC model" + e, this.srcFileName);
        }
    }

    private void buildAction(XMLNode actionNode, XMLNode modelDefNode, XMLNode contextNode) {
        String actionId = actionNode.getAttrValue("id");
        XMLNode ctxActionNode = contextNode.findChildNode("action", actionId);
        if (ctxActionNode == null) {
            ctxActionNode = new XMLNode("action");
            contextNode.add(ctxActionNode);
        } else {
            ctxActionNode.removeAllChilds();
        }
        ctxActionNode.setAttrValue("id", actionId);
        ctxActionNode.setAttrValue("type", actionNode.getAttrValue("type"));
        ctxActionNode.setAttrValue("endValue", actionNode.getAttrValue("endValue"));
        this.copyNodeAttributes(actionNode, ctxActionNode, "x;y;width;height;name;");
        int i = 0;
        while (i < actionNode.getChilds().size()) {
            XMLNode refNode;
            XMLNode aRef = (XMLNode)actionNode.getChilds().get(i);
            if (aRef.getNodeName().equals("selfDefNode")) {
                XMLNode selfDefNode = aRef.getFirstNode();
                if (selfDefNode != null) {
                    ctxActionNode.add(selfDefNode);
                }
            } else if ("reference".equals(aRef.getNodeName()) && (refNode = modelDefNode.findChildNodeNamed(aRef.getAttrValue("dest"))) != null) {
                XMLNode outputViewNode;
                XMLNode jspNode = null;
                if (refNode.getNodeName().equals("flow")) {
                    XMLNode flowNode = this.buildFlowNode(refNode, modelDefNode);
                    outputViewNode = this.buildOutputViewNode(refNode, modelDefNode);
                    ctxActionNode.add(flowNode);
                    ctxActionNode.add(outputViewNode);
                } else if (refNode.getNodeName().equals("chartView")) {
                    XMLNode chartNode = this.buildChartNode(refNode);
                    outputViewNode = ctxActionNode.findChildNodeNamed("Map", "outputViews");
                    if (outputViewNode == null) {
                        outputViewNode = new XMLNode("Map");
                        outputViewNode.setAttrValue("name", "outputViews");
                        outputViewNode.setAttrValue("class", "java.util.HashMap");
                        ctxActionNode.add(outputViewNode);
                    }
                    outputViewNode.add(chartNode);
                } else {
                    if (refNode.getNodeName().equals("jspWizzardView")) {
                        refNode = this.buildWizardNode(refNode, modelDefNode, ctxActionNode, 0);
                    }
                    if (refNode.getNodeName().equals("view")) {
                        jspNode = new XMLNode("jspView");
                        ctxActionNode.add(jspNode);
                        jspNode.setAttrValue("id", refNode.getAttrValue("id"));
                        jspNode.setAttrValue("url", refNode.getAttrValue("jspFile"));
                    }
                    if (refNode.getNodeName().equals("modelUpdater")) {
                        XMLNode updaterNode = this.buildModelUpdaterNode(refNode);
                        ctxActionNode.add(updaterNode);
                    } else {
                        int k = 0;
                        while (k < refNode.getChilds().size()) {
                            XMLNode dstNode;
                            XMLNode vrNode = (XMLNode)refNode.getChilds().elementAt(k);
                            if ("reference".equals(vrNode.getNodeName()) && (dstNode = modelDefNode.findChildNodeNamed(vrNode.getAttrValue("dest"))) != null) {
                                if ("flow".equals(dstNode.getNodeName())) {
                                    XMLNode flowNode = this.buildFlowNode(dstNode, modelDefNode);
                                    XMLNode outputViewNode2 = this.buildOutputViewNode(dstNode, modelDefNode);
                                    ctxActionNode.add(flowNode);
                                    ctxActionNode.add(outputViewNode2);
                                } else if (jspNode != null) {
                                    XMLNode updaterNode = this.buildModelUpdaterNode(dstNode);
                                    updaterNode.setAttrValue("viewId", jspNode.getAttrValue("id"));
                                    ctxActionNode.add(updaterNode);
                                }
                            }
                            ++k;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private XMLNode buildWizardNode(XMLNode refNode, XMLNode modelDefNode, XMLNode ctxActionNode, int pageIndex) {
        XMLNode wizardNode = new XMLNode("jspWizzardView");
        wizardNode.setAttrValue("id", refNode.getAttrValue("id"));
        wizardNode.setAttrValue("url", refNode.getAttrValue("jspFile"));
        wizardNode.setAttrValue("pageIndex", String.valueOf(pageIndex++));
        ctxActionNode.add(wizardNode);
        XMLNode retNode = refNode;
        int k = 0;
        while (k < refNode.getChilds().size()) {
            XMLNode dstNode;
            XMLNode vrNode = (XMLNode)refNode.getChilds().elementAt(k);
            if ("reference".equals(vrNode.getNodeName()) && (dstNode = modelDefNode.findChildNodeNamed(vrNode.getAttrValue("dest"))) != null) {
                if ("jspWizzardView".equals(dstNode.getNodeName())) {
                    retNode = this.buildWizardNode(dstNode, modelDefNode, ctxActionNode, pageIndex);
                } else if ("modelUpdater".equals(dstNode.getNodeName())) {
                    XMLNode updaterNode = this.buildModelUpdaterNode(dstNode);
                    updaterNode.setAttrValue("viewId", refNode.getAttrValue("id"));
                    ctxActionNode.add(updaterNode);
                }
            }
            ++k;
        }
        return retNode;
    }

    private XMLNode buildChartNode(XMLNode node) {
        XMLNode chartNode = new XMLNode("chartView");
        chartNode.setAttrValue("id", node.getAttrValue("id"));
        chartNode.setAttrValue("class", node.getAttrValue("class"));
        chartNode.setAttrValue("type", node.getAttrValue("type"));
        chartNode.setAttrValue("imageTitle", node.getAttrValue("imageTitle"));
        chartNode.setAttrValue("imageDomain", node.getAttrValue("imageDomain"));
        chartNode.setAttrValue("imageRange", node.getAttrValue("imageRange"));
        chartNode.setAttrValue("chartType", node.getAttrValue("chartType"));
        chartNode.setAttrValue("iCollName", node.getAttrValue("iCollName"));
        chartNode.setAttrValue("valueFieldName", node.getAttrValue("valueFieldName"));
        chartNode.setAttrValue("keyFieldName", node.getAttrValue("keyFieldName"));
        chartNode.setAttrValue("categoryFieldName", node.getAttrValue("categoryFieldName"));
        chartNode.setAttrValue("seriesFields", node.getAttrValue("seriesFields"));
        chartNode.setAttrValue("seriesNames", node.getAttrValue("seriesNames"));
        return chartNode;
    }

    private void copyNodeAttributes(XMLNode srcNode, XMLNode dstNode, String exclude) {
        Enumeration keys = srcNode.getAttrs().keys();
        while (keys.hasMoreElements()) {
            String attrName = (String)keys.nextElement();
            if (exclude.indexOf(String.valueOf(attrName) + ";") != -1) continue;
            String value = srcNode.getAttrValue(attrName);
            dstNode.setAttrValue(attrName, value);
        }
    }

    private XMLNode buildModelUpdaterNode(XMLNode node) {
        XMLNode datasNode;
        XMLNode updaterNode = new XMLNode("modelUpdator");
        String classStr = node.getAttrValue("class");
        if (classStr != null && classStr.length() > 0) {
            updaterNode.setAttrValue("class", classStr);
        }
        if ((datasNode = node.getChild("datas")) == null || datasNode.getChilds().size() == 0) {
            return updaterNode;
        }
        XMLNode kCollNode = new XMLNode("kColl");
        updaterNode.add(kCollNode);
        int i = 0;
        while (i < datasNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)datasNode.getChilds().get(i);
            if ("refData".equals(aNode.getNodeName())) {
                if (aNode.getChilds().size() > 1) {
                    String id = aNode.getAttrValue("refId");
                    int k = 0;
                    while (k < aNode.getChilds().size()) {
                        XMLNode kNode = (XMLNode)aNode.getChilds().get(k);
                        if ("refData".equals(kNode.getNodeName())) {
                            XMLNode fieldNode = new XMLNode("field");
                            if (kNode.getAttrValue("srcDataName") != null) {
                                fieldNode.setAttrValue("id", kNode.getAttrValue("srcDataName"));
                                fieldNode.setAttrValue("dstName", String.valueOf(id) + "." + kNode.getAttrValue("refId"));
                            } else {
                                fieldNode.setAttrValue("id", aNode.getAttrValue("refId"));
                                fieldNode.setAttrValue("dstName", String.valueOf(id) + "." + kNode.getAttrValue("refId"));
                            }
                            fieldNode.setAttrValue("type", aNode.getAttrValue("type"));
                            fieldNode.setAttrValue("required", aNode.getAttrValue("required"));
                            kCollNode.add(fieldNode);
                        }
                        ++k;
                    }
                } else {
                    XMLNode fieldNode = new XMLNode("field");
                    if (aNode.getAttrValue("srcDataName") != null) {
                        fieldNode.setAttrValue("id", aNode.getAttrValue("srcDataName"));
                        fieldNode.setAttrValue("dstName", aNode.getAttrValue("refId"));
                    } else {
                        fieldNode.setAttrValue("id", aNode.getAttrValue("refId"));
                    }
                    fieldNode.setAttrValue("type", aNode.getAttrValue("type"));
                    fieldNode.setAttrValue("required", aNode.getAttrValue("required"));
                    kCollNode.add(fieldNode);
                }
            } else if ("refColl".equals(aNode.getNodeName())) {
                XMLNode iCollNode = new XMLNode("iColl");
                kCollNode.add(iCollNode);
                iCollNode.setAttrValue("id", aNode.getAttrValue("refId"));
                XMLNode kColl = new XMLNode("kColl");
                iCollNode.add(kColl);
                int k = 0;
                while (k < aNode.getChilds().size()) {
                    XMLNode kNode = (XMLNode)aNode.getChilds().get(k);
                    if ("refData".equals(kNode.getNodeName())) {
                        XMLNode fieldNode = new XMLNode("field");
                        if (kNode.getAttrValue("srcDataName") != null) {
                            fieldNode.setAttrValue("id", kNode.getAttrValue("srcDataName"));
                            fieldNode.setAttrValue("dstName", kNode.getAttrValue("refId"));
                        } else {
                            fieldNode.setAttrValue("id", kNode.getAttrValue("refId"));
                        }
                        fieldNode.setAttrValue("type", kNode.getAttrValue("type"));
                        fieldNode.setAttrValue("required", kNode.getAttrValue("required"));
                        kColl.add(fieldNode);
                    }
                    ++k;
                }
            }
            ++i;
        }
        return updaterNode;
    }

    private XMLNode buildFlowNode(XMLNode node, XMLNode modelNode) {
        String retValue;
        XMLNode flowNode = new XMLNode("refFlow");
        flowNode.setAttrValue("flowId", node.getAttrValue("id"));
        if (node.getAttrValue("op") != null) {
            flowNode.setAttrValue("op", node.getAttrValue("op"));
        } else {
            flowNode.setAttrValue("op", node.getAttrValue("refId"));
        }
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode transitionNode = (XMLNode)node.getChilds().elementAt(i);
            if ("transition".equalsIgnoreCase(transitionNode.getNodeName())) {
                String condition = transitionNode.getAttrValue("condition");
                retValue = transitionNode.getAttrValue("retValue");
                if (!(condition != null && condition.trim().length() != 0 || retValue != null && retValue.trim().length() != 0)) {
                    node.getChilds().remove(transitionNode);
                    node.getChilds().add(transitionNode);
                }
            }
            ++i;
        }
        i = 0;
        while (i < node.getChilds().size()) {
            XMLNode aNode = (XMLNode)node.getChilds().get(i);
            if ("transition".equals(aNode.getNodeName())) {
                XMLNode transitionNode = new XMLNode("transition");
                flowNode.add(transitionNode);
                retValue = aNode.getAttrValue("retValue");
                if (retValue != null && retValue.trim().length() != 0) {
                    retValue = "$retValue='" + retValue + "'";
                    transitionNode.setAttrValue("condition", retValue);
                } else {
                    transitionNode.setAttrValue("condition", aNode.getAttrValue("condition"));
                }
                transitionNode.setAttrValue("dest", aNode.getAttrValue("dest"));
            }
            ++i;
        }
        return flowNode;
    }

    private XMLNode buildOutputViewNode(XMLNode node, XMLNode modelNode) {
        XMLNode outputViewNode = new XMLNode("Map");
        outputViewNode.setAttrValue("name", "outputViews");
        outputViewNode.setAttrValue("class", "java.util.HashMap");
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode aNode = (XMLNode)node.getChilds().get(i);
            if ("transition".equals(aNode.getNodeName())) {
                XMLNode viewNode = new XMLNode("jspView");
                XMLNode viewModelNode = modelNode.findChildNodeNamed(aNode.getAttrValue("dest"));
                viewNode.setAttrValue("id", aNode.getAttrValue("dest"));
                viewNode.setAttrValue("url", viewModelNode.getAttrValue("jspFile"));
                outputViewNode.add(viewNode);
            }
            ++i;
        }
        return outputViewNode;
    }

    public static MVCBuilder getInstance(IProject prj) {
        IDEProjectSettings prjSettings = IDEContent.getPRJSettings(prj);
        if ("2.1".equals(prjSettings.getPrjVersion())) {
            String settingsPath = String.valueOf(prjSettings.getWebContentPath()) + "/WEB-INF";
            String targetPath = prj.getLocation() + "/" + settingsPath;
            MVCBuilder builder = new MVCBuilder();
            builder.setOutputPath(targetPath);
            if (prjSettings.getSetXMLEncodeManually()) {
                builder.setXMLEncoding(prjSettings.getXMLEncoding());
            }
            return builder;
        }
        String settingsPath = String.valueOf(prjSettings.getWebContentPath()) + "/WEB-INF";
        String targetPath = prj.getLocation() + "/" + settingsPath;
        MVCBuilder11 builder = new MVCBuilder11();
        builder.setOutputPath(targetPath);
        if (prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(prjSettings.getXMLEncoding());
        }
        return builder;
    }
}

