/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Enumeration;

public class StateMachineBuilder {
    private EditorProfile stateMachineProfile;
    private EditorProfile stateProfile;
    private XMLNode commonStates;
    private XMLNode commonStateMachineNode;
    private boolean buildStateMachineAsOperation = false;
    private AbstractBuilder builder;

    public void setBuilder(AbstractBuilder builder) {
        this.builder = builder;
    }

    public void setBuildStateMachineAsOperation(boolean value) {
        this.buildStateMachineAsOperation = value;
    }

    public void setCommonStateMachine(XMLNode node) {
        this.commonStateMachineNode = node;
    }

    public void setStateMachineEditorProfile(EditorProfile profile) {
        this.stateMachineProfile = profile;
    }

    public void setStateEditorProfile(EditorProfile profile) {
        this.stateProfile = profile;
    }

    public void setCommonStates(XMLNode states) {
        this.commonStates = states;
    }

    public XMLNode buildStateMachine(XMLNode stateMachineNode) {
        XMLNode opNode = new XMLNode();
        opNode.setNodeName("StateMachineOp");
        opNode.setAttrValue("id", stateMachineNode.getAttrValue("id"));
        if (stateMachineNode.getChilds() == null) {
            return opNode;
        }
        int k = 0;
        while (k < stateMachineNode.getChilds().size()) {
            XMLNode aStateNode = (XMLNode)stateMachineNode.getChilds().elementAt(k);
            if (!(aStateNode.getNodeName().equals("attributes") || aStateNode.getNodeName().equals("document") || "#text".equals(aStateNode.getNodeName()))) {
                String stateId = null;
                XMLNode stateNode = new XMLNode();
                stateNode.setNodeName("State");
                opNode.add(stateNode);
                XMLNode actionsNode = new XMLNode();
                actionsNode.setNodeName("Actions");
                stateNode.add(actionsNode);
                XMLNode transitionsNode = new XMLNode();
                transitionsNode.setNodeName("Transitions");
                stateNode.add(transitionsNode);
                if (!"State".equals(aStateNode.getNodeName())) {
                    stateId = aStateNode.getNodeName();
                    int ia = 0;
                    while (ia < aStateNode.getChilds().size()) {
                        XMLNode aNode = (XMLNode)aStateNode.getChilds().elementAt(ia);
                        if (aNode.getNodeName().equals("transition")) {
                            String dst = aNode.getAttrValue("dest");
                            String idStr = aNode.getAttrValue("id");
                            XMLNode transitionNode = new XMLNode();
                            transitionNode.setNodeName("transition");
                            transitionNode.setAttrValue("id", idStr);
                            XMLNode dstNode = stateMachineNode.findChildNodeNamed(dst);
                            if (dstNode != null && !"State".equals(dstNode.getNodeName())) {
                                transitionNode.setAttrValue("targetState", dstNode.getNodeName());
                            } else if (dstNode != null) {
                                transitionNode.setAttrValue("targetState", dstNode.getAttrValue("id"));
                            }
                            Enumeration keys = aNode.getAttrs().keys();
                            while (keys.hasMoreElements()) {
                                String key = (String)keys.nextElement();
                                if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height") || key.equals("id") || key.equals("dest")) continue;
                                transitionNode.setAttrValue(key, aNode.getAttrValue(key));
                            }
                            transitionsNode.add(transitionNode);
                        }
                        ++ia;
                    }
                    aStateNode = this.commonStates.findChildNode(aStateNode.getNodeName());
                } else {
                    stateId = aStateNode.getAttrValue("id");
                }
                stateNode.setAttrValue("id", stateId);
                if (aStateNode == null) {
                    if (this.builder != null) {
                        this.builder.reportProblem(2, "State machine [" + stateMachineNode.getAttrValue("id") + "] refer to undefined common state: [" + stateId + "]!", "");
                    }
                } else {
                    String implClassName = aStateNode.getAttrValue("implClass");
                    if (implClassName != null && implClassName.length() > 0) {
                        stateNode.setAttrValue("implClass", implClassName);
                    }
                    int ia = 0;
                    while (ia < aStateNode.getChilds().size()) {
                        XMLNode aNode = (XMLNode)aStateNode.getChilds().elementAt(ia);
                        if (!aNode.getNodeName().equals("document") && !"#text".equals(aNode.getNodeName())) {
                            if (aNode.getNodeName().equals("transition")) {
                                String dst = aNode.getAttrValue("dest");
                                String idStr = aNode.getAttrValue("id");
                                XMLNode transitionNode = new XMLNode();
                                transitionNode.setNodeName("transition");
                                transitionNode.setAttrValue("id", idStr);
                                XMLNode dstNode = stateMachineNode.findChildNodeNamed(dst);
                                if (dstNode != null && !"State".equals(dstNode.getNodeName())) {
                                    transitionNode.setAttrValue("targetState", dstNode.getNodeName());
                                } else if (dstNode != null) {
                                    transitionNode.setAttrValue("targetState", dstNode.getAttrValue("id"));
                                }
                                Enumeration keys = aNode.getAttrs().keys();
                                while (keys.hasMoreElements()) {
                                    String key = (String)keys.nextElement();
                                    if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height") || key.equals("id") || key.equals("dest")) continue;
                                    transitionNode.setAttrValue(key, aNode.getAttrValue(key));
                                }
                                transitionsNode.add(transitionNode);
                            } else if (!"END".equals(aNode.getNodeName())) {
                                XMLNode stepNode = new XMLNode();
                                stepNode.setNodeName("opStep");
                                stepNode.setAttrValue("id", aNode.getAttrValue("name"));
                                actionsNode.add(stepNode);
                                if (this.stateProfile.getElement(aNode.getNodeName()) != null) {
                                    stepNode.setAttrValue("implClass", this.stateProfile.getElement(aNode.getNodeName()).getImplClass());
                                } else if (this.builder != null) {
                                    this.builder.reportProblem(2, String.valueOf(Messages.getString("MCIProjectBuilder.No_set_implement_class_for_OpStep[_3")) + aNode.getNodeName() + "]!", "");
                                }
                                Enumeration keys = aNode.getAttrs().keys();
                                while (keys.hasMoreElements()) {
                                    String key = (String)keys.nextElement();
                                    if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height")) continue;
                                    stepNode.setAttrValue(key, aNode.getAttrValue(key));
                                }
                                if (aNode.getChilds() != null) {
                                    int j = 0;
                                    while (j < aNode.getChilds().size()) {
                                        XMLNode transitionNode = (XMLNode)aNode.getChilds().elementAt(j);
                                        String dst = transitionNode.getAttrValue("dest");
                                        String idStr = transitionNode.getAttrValue("id");
                                        if (dst != null) {
                                            if (dst.startsWith("END")) {
                                                dst = "end";
                                            }
                                            if (idStr == null || idStr.length() == 0) {
                                                idStr = "Other";
                                            }
                                            String key = "on" + idStr + "Do";
                                            stepNode.setAttrValue(key, dst);
                                        }
                                        ++j;
                                    }
                                }
                            }
                        }
                        ++ia;
                    }
                }
            }
            ++k;
        }
        return opNode;
    }
}

