/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import org.eclipse.core.resources.IProject;

public class TableBuilder
extends AbstractBuilder {
    private String tablesPath = "designFiles/tables/";
    private IProject project = null;

    public static TableBuilder getInstance(IProject project) {
        TableBuilder builder = new TableBuilder();
        try {
            builder.project = project;
            IDEProjectSettings prjSettings = IDEContent.getPRJSettings(project);
            if (prjSettings.getSetXMLEncodeManually()) {
                builder.setXMLEncoding(prjSettings.getXMLEncoding());
            }
        }
        catch (Exception e) {
            return null;
        }
        return builder;
    }

    public boolean buildTableModel(String srcFile) {
        this.srcFileName = srcFile;
        try {
            String filePath = this.dstPath;
            XMLNode srcNode = this.loadXMLContent(this.srcFileName);
            String modelId = srcNode.findChild("TableModel").getAttrValue("id");
            String fileName = String.valueOf(filePath) + "/" + modelId + ".xml";
            XMLNode destNode = this.buildDestNode(srcNode);
            this.saveXMLFile(fileName, destNode);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private XMLNode buildDestNode(XMLNode srcNode) {
        XMLNode srcTable = srcNode.getChild("TableModel");
        XMLNode destNode = new XMLNode(String.valueOf(srcTable.getAttrValue("id")) + ".xml");
        XMLNode destTable = new XMLNode("TableModel");
        destTable.setAttrValue("id", srcTable.getAttrValue("id"));
        destTable.setAttrValue("cnname", srcTable.getAttrValue("cnname"));
        destTable.setAttrValue("dbTableName", srcTable.getAttrValue("dbTableName"));
        destNode.add(destTable);
        int i = 0;
        while (i < srcTable.getChilds().size()) {
            XMLNode dNode;
            XMLNode sNode = (XMLNode)srcTable.getChilds().elementAt(i);
            if ("Field".equals(sNode.getNodeName())) {
                dNode = new XMLNode("Field");
                dNode.setAttrValue("id", sNode.getAttrValue("id"));
                dNode.setAttrValue("cnname", sNode.getAttrValue("cnname"));
                dNode.setAttrValue("columnName", sNode.getAttrValue("columnName"));
                dNode.setAttrValue("isPK", sNode.getAttrValue("isPK"));
                dNode.setAttrValue("canBeNull", sNode.getAttrValue("canBeNull"));
                dNode.setAttrValue("isEncrypted", sNode.getAttrValue("isEncrypted"));
                dNode.setAttrValue("length", sNode.getAttrValue("length"));
                dNode.setAttrValue("JDBCType", sNode.getAttrValue("JDBCType"));
                if ("true".equals(sNode.getAttrValue("isPK"))) {
                    dNode.setAttrValue("pkGenerator", sNode.getAttrValue("pkGenerator"));
                }
                destTable.add(dNode);
            } else if ("One2OneRef".equals(sNode.getNodeName())) {
                dNode = new XMLNode("One2OneRef");
                dNode.setAttrValue("refModelId", sNode.getAttrValue("refModelId"));
                dNode.setAttrValue("fromField", sNode.getAttrValue("fromField"));
                dNode.setAttrValue("toField", sNode.getAttrValue("toField"));
                destTable.add(dNode);
            } else if ("One2MultiRef".equals(sNode.getNodeName())) {
                dNode = new XMLNode("One2MultiRef");
                dNode.setAttrValue("refModelId", sNode.getAttrValue("refModelId"));
                dNode.setAttrValue("fromField", sNode.getAttrValue("fromField"));
                dNode.setAttrValue("toField", sNode.getAttrValue("toField"));
                destTable.add(dNode);
            }
            ++i;
        }
        return destNode;
    }
}

