/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.builder.StateMachineBuilder;
import com.ecc.ide.builder.format.FormatGenerator;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Vector;

public class TellerProjectBuilder
extends AbstractBuilder {
    private XMLNode dataDictionary;
    private XMLNode msgHeader;
    private XMLNode fmtsNode;
    private XMLNode packageType;
    private XMLNode flow;
    private XMLNode service;
    private EditorProfile serviceEditorProfile;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile stateMachineProfile;
    private EditorProfile stateProfile;
    private XMLNode commonStates;
    private XMLNode commonStateMachineNode;
    private boolean buildStateMachineAsOperation = false;

    public void setBuildStateMachineAsOperation(boolean value) {
        this.buildStateMachineAsOperation = value;
    }

    public void setCommonStateMachine(XMLNode node) {
        this.commonStateMachineNode = node;
    }

    public void setFmtsNode(XMLNode node) {
        this.fmtsNode = node;
    }

    public void setStateMachineEditorProfile(EditorProfile profile) {
        this.stateMachineProfile = profile;
    }

    public void setStateEditorProfile(EditorProfile profile) {
        this.stateProfile = profile;
    }

    public void setCommonStates(XMLNode states) {
        this.commonStates = states;
    }

    public void setFlowEditorProfile(EditorProfile profile) {
        this.flowEditorProfile = profile;
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setServiceEditorProfile(EditorProfile profile) {
        this.serviceEditorProfile = profile;
    }

    public void setService(XMLNode serv) {
        this.service = serv;
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setMsgHeader(XMLNode node) {
        this.msgHeader = node;
    }

    public void setPackageType(XMLNode node) {
        this.packageType = node;
    }

    public void buildProject() {
        try {
            this.buildContextAndData();
            this.buildCommonFlow();
            this.buildFormats();
            this.buildServices();
        }
        catch (Exception e) {
            super.reportProblem(2, String.valueOf(Messages.getString("TellerProjectBuilder.Failed_to_build_the_Teller_Project_!_Exception___1")) + e, "");
        }
        this.reportProgress(Messages.getString("TellerProjectBuilder.Build_finished._1"), 10);
    }

    private void buildCommonFlow() {
        this.reportProgress(Messages.getString("TellerProjectBuilder.Build_Teller_Common_Flow_2"), 5);
        XMLNode operationNode = new XMLNode();
        operationNode.setNodeName("operations.xml");
        int i = 0;
        while (i < this.flow.getChilds().size()) {
            XMLNode flowNode = (XMLNode)this.flow.getChilds().elementAt(i);
            XMLNode buildFlowNode = new XMLNode();
            operationNode.add(buildFlowNode);
            buildFlowNode.setNodeName("ClientOperation");
            buildFlowNode.setAttrValue("id", flowNode.getAttrValue("id"));
            int j = 0;
            while (j < flowNode.getChilds().size()) {
                XMLNode actionNode = (XMLNode)flowNode.getChilds().elementAt(j);
                XMLNode stepsNode = new XMLNode();
                if (!("attributes".equals(actionNode.getNodeName()) || "document".equals(actionNode.getNodeName()) || "#text".equals(actionNode.getNodeName()) || "END".equals(actionNode.getNodeName()))) {
                    buildFlowNode.add(stepsNode);
                    stepsNode.setNodeName("opStep");
                    stepsNode.setAttrValue("id", actionNode.getAttrValue("name"));
                    if (this.flowEditorProfile.getElement(actionNode.getNodeName()) != null) {
                        stepsNode.setAttrValue("implClass", this.flowEditorProfile.getElement(actionNode.getNodeName()).getImplClass());
                    } else {
                        super.reportProblem(2, String.valueOf(Messages.getString("TellerProjectBuilder.No_set_implement_class_for_OpStep[_6")) + actionNode.getNodeName() + "]!", "");
                    }
                    Enumeration keys = actionNode.getAttrs().keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height")) continue;
                        stepsNode.setAttrValue(key, actionNode.getAttrValue(key));
                    }
                    if (actionNode.getChilds() != null) {
                        int k = 0;
                        while (k < actionNode.getChilds().size()) {
                            XMLNode transitionNode = (XMLNode)actionNode.getChilds().elementAt(k);
                            String dst = transitionNode.getAttrValue("dest");
                            String idStr = transitionNode.getAttrValue("id");
                            if (dst != null) {
                                if (dst.startsWith("END")) {
                                    dst = "end";
                                }
                                if (idStr == null || idStr.length() == 0) {
                                    idStr = "Other";
                                }
                                String key = "on" + idStr + "Do";
                                stepsNode.setAttrValue(key, dst);
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        this.buildStateMachine(operationNode);
        String fileName = String.valueOf(this.dstPath) + "/operations.xml";
        this.saveXMLFile(fileName, operationNode);
    }

    private void buildStateMachine(XMLNode pNode) {
        this.reportProgress(Messages.getString("TellerProjectBuilder.Building_the_stateMachine..._1"), 5);
        StateMachineBuilder stateMachineBuilder = new StateMachineBuilder();
        stateMachineBuilder.setBuilder(this);
        stateMachineBuilder.setStateEditorProfile(this.stateProfile);
        stateMachineBuilder.setStateMachineEditorProfile(this.stateMachineProfile);
        stateMachineBuilder.setCommonStateMachine(this.commonStateMachineNode);
        stateMachineBuilder.setCommonStates(this.commonStates);
        int i = 0;
        while (i < this.commonStateMachineNode.getChilds().size()) {
            XMLNode stateMachineNode = (XMLNode)this.commonStateMachineNode.getChilds().elementAt(i);
            XMLNode opNode = stateMachineBuilder.buildStateMachine(stateMachineNode);
            pNode.add(opNode);
            ++i;
        }
    }

    private void buildServices() {
        String fileName = String.valueOf(this.dstPath) + "/services.xml";
        try {
            FileWriter fw = new FileWriter(fileName);
            StringBuffer strBuf = new StringBuffer();
            this.service.toXMLContent(0, strBuf, true);
            fw.write(strBuf.toString());
            fw.close();
        }
        catch (Exception e) {
            String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Error_failed_to_Save_XMLContent_Exception___109")) + e;
            super.reportProblem(2, msg, "");
            e.printStackTrace();
        }
    }

    private void buildContextAndData() {
        XMLNode childNode;
        this.reportProgress(Messages.getString("TellerProjectBuilder.Build_Teller_Context_And_Data_9"), 1);
        XMLNode contextNode = new XMLNode();
        contextNode.setNodeName("contexts.xml");
        XMLNode rootContextNode = new XMLNode();
        rootContextNode.setNodeName("context");
        rootContextNode.setAttrValue("id", "rootCtx");
        rootContextNode.setAttrValue("type", "root");
        XMLNode refRootKColl = new XMLNode();
        refRootKColl.setNodeName("refKColl");
        refRootKColl.setAttrValue("refId", "rootKColl");
        rootContextNode.add(refRootKColl);
        contextNode.add(rootContextNode);
        XMLNode sessionContextNode = new XMLNode();
        sessionContextNode.setNodeName("context");
        sessionContextNode.setAttrValue("id", "sessionCtx");
        sessionContextNode.setAttrValue("type", "session");
        XMLNode refSessionKColl = new XMLNode();
        refSessionKColl.setNodeName("refKColl");
        refSessionKColl.setAttrValue("refId", "sessionKColl");
        sessionContextNode.add(refSessionKColl);
        contextNode.add(sessionContextNode);
        XMLNode dataNode = new XMLNode();
        dataNode.setNodeName("data.xml");
        XMLNode rootDataNode = new XMLNode();
        rootDataNode.setNodeName("kColl");
        rootDataNode.setAttrValue("id", "rootKColl");
        dataNode.add(rootDataNode);
        XMLNode sessionDataNode = new XMLNode();
        sessionDataNode.setNodeName("kColl");
        sessionDataNode.setAttrValue("id", "sessionKColl");
        dataNode.add(sessionDataNode);
        int i = 0;
        while (i < this.dataDictionary.getChilds().size()) {
            childNode = (XMLNode)this.dataDictionary.getChilds().elementAt(i);
            if ("common".equals(childNode.getAttrValue("access"))) {
                this.addDataDefine(rootDataNode, childNode);
            } else if ("session".equals(childNode.getAttrValue("access"))) {
                this.addDataDefine(sessionDataNode, childNode);
            }
            ++i;
        }
        i = 0;
        while (i < this.service.getChilds().size()) {
            XMLNode refSvcNode;
            childNode = (XMLNode)this.service.getChilds().elementAt(i);
            String svcid = childNode.getAttrValue("id");
            if ("common".equals(childNode.getAttrValue("access"))) {
                refSvcNode = new XMLNode();
                refSvcNode.setNodeName("refService");
                refSvcNode.setAttrValue("refId", svcid);
                refSvcNode.setAttrValue("alias", svcid);
                refSvcNode.setAttrValue("type", "common");
                rootContextNode.add(refSvcNode);
            } else if ("session".equals(childNode.getAttrValue("access"))) {
                refSvcNode = new XMLNode();
                refSvcNode.setNodeName("refService");
                refSvcNode.setAttrValue("refId", svcid);
                refSvcNode.setAttrValue("alias", svcid);
                refSvcNode.setAttrValue("type", "session");
                sessionContextNode.add(refSvcNode);
            }
            ++i;
        }
        String fileName = String.valueOf(this.dstPath) + "/data.xml";
        this.saveXMLFile(fileName, dataNode);
        fileName = String.valueOf(this.dstPath) + "/contexts.xml";
        this.saveXMLFile(fileName, contextNode);
    }

    private void buildFormats() {
        XMLNode repNode;
        this.reportProgress(Messages.getString("TellerProjectBuilder.Build_Teller_Format_Head_10"), 8);
        XMLNode fmtRootNode = new XMLNode();
        fmtRootNode.setNodeName("formats.xml");
        XMLNode reqNode = this.msgHeader.getChild("reqHeadDatas");
        if (reqNode != null && reqNode.getChilds().size() > 0) {
            super.reportProblem(0, "Build Teller Request head package ...", "");
            String fmtId = "SisalRequestFmt";
            XMLNode fmtNode = this.genPackageFmt(reqNode);
            if (fmtNode != null) {
                fmtNode.setAttrValue("id", fmtId);
                fmtRootNode.add(fmtNode);
            }
        }
        if ((repNode = this.msgHeader.getChild("repHeadDatas")) != null && repNode.getChilds().size() > 0) {
            super.reportProblem(0, "Build Teller Reply head package ...", "");
            String fmtId = "SisalReplyFmt";
            XMLNode fmtNode = this.genPackageFmt(repNode);
            if (fmtNode != null) {
                fmtNode.setAttrValue("id", fmtId);
                fmtRootNode.add(fmtNode);
            }
        }
        if (this.fmtsNode != null) {
            Vector childs = this.fmtsNode.getChilds();
            super.reportProblem(0, "Build Common packages ...", "");
            int i = 0;
            while (i < childs.size()) {
                XMLNode fmtNode = (XMLNode)childs.elementAt(i);
                if (!"#text".equals(fmtNode.getNodeName())) {
                    XMLNode fmtDefNode;
                    String fmtId = fmtNode.getAttrValue("id");
                    super.reportProblem(0, "Build package for format ID[" + fmtId + "]...", "");
                    XMLNode datasNode = fmtNode.getChild("datas");
                    if (datasNode != null && (fmtDefNode = this.genPackageFmt(datasNode)) != null) {
                        fmtDefNode.setAttrValue("id", fmtNode.getAttrValue("id"));
                        fmtRootNode.add(fmtDefNode);
                    }
                }
                ++i;
            }
        }
        String fileName = String.valueOf(this.dstPath) + "/formats.xml";
        this.saveXMLFile(fileName, fmtRootNode);
    }

    private XMLNode genPackageFmt(XMLNode aNode) {
        XMLNode pkgNode;
        String pkgType = aNode.getAttrValue("packageType");
        if (pkgType == null && (pkgType == null || pkgType.length() == 0)) {
            pkgType = "StringFmt";
        }
        if ((pkgNode = this.packageType.findChildNode(pkgType)) == null) {
            super.reportProblem(2, "packageType [" + pkgType + "] not found!", "");
        } else {
            String fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
            if (fmtBuilderClass == null) {
                String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_81")) + pkgType + "]!";
            } else {
                try {
                    FormatGenerator fmtGen = (FormatGenerator)Class.forName(fmtBuilderClass).newInstance();
                    XMLNode fmtNode = fmtGen.generateFormatNode(aNode, this.dataDictionary, null);
                    return fmtNode;
                }
                catch (Exception e) {
                    String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Error_failed_to_build_request_fmt_for_host_[_85")) + "] Exception: " + e;
                    super.reportProblem(2, msg, "");
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void addDataDefine(XMLNode dataNode, XMLNode dictionaryNode) {
        String nodeName = dictionaryNode.getNodeName();
        XMLNode node = new XMLNode();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            node.setNodeName("field");
            node.setAttrValue("id", dictionaryNode.getAttrValue("id"));
            node.setAttrValue("value", dictionaryNode.getAttrValue("value"));
            String value = dictionaryNode.getAttrValue("defaultValue");
            if (value != null) {
                node.setAttrValue("value", value);
            }
            dataNode.add(node);
        } else if (nodeName.equals("dataCollection")) {
            node.setNodeName("iColl");
            node.setAttrValue("id", dictionaryNode.getAttrValue("id"));
            dataNode.add(node);
            XMLNode kNode = new XMLNode();
            kNode.setNodeName("kColl");
            node.add(kNode);
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                this.addDataDefine(kNode, aNode);
                ++i;
            }
        } else if (nodeName.equals("refData")) {
            node.setNodeName("field");
            node.setAttrValue("id", dictionaryNode.getAttrValue("refId"));
            node.setAttrValue("value", dictionaryNode.getAttrValue("value"));
            dataNode.add(node);
        }
    }

    public XMLNode getFlow() {
        return this.flow;
    }

    public void setFlow(XMLNode flow) {
        this.flow = flow;
    }
}

