/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.document.word.WordDocument;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.visualeditor.VisualContentToImage;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class TellerProjectDocumentBuilder
extends AbstractBuilder {
    private XMLNode dataDictionary;
    private XMLNode msgHeader;
    private XMLNode packageType;
    private XMLNode services;
    private XMLNode flows;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile serviceEditorProfile;
    private String projectRootPath;
    private Vector opStepList = null;
    private Vector opList = null;
    private WordDocument document;

    public void setFlowEditorProfile(EditorProfile profile) {
        this.flowEditorProfile = profile;
    }

    public void setServiceEditorProfile(EditorProfile profile) {
        this.serviceEditorProfile = profile;
    }

    public void setService(XMLNode node) {
        this.services = node;
    }

    public void setRootPath(String rootPath) {
        this.projectRootPath = rootPath;
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setMsgHeader(XMLNode node) {
        this.msgHeader = node;
    }

    public void setPackageType(XMLNode node) {
        this.packageType = node;
    }

    public void buildTellerProjectDesignDocument(WordDocument doc) {
        this.document = doc;
        try {
            String filePath = this.dstPath;
            this.buildDataType();
            this.buildData();
            this.buildCommonFlow();
            this.buildFormats();
            this.buildServices();
            this.buildOpStepProfile();
            this.buildServiceProfile();
            this.buildOpStatistic();
            String fileName = String.valueOf(filePath) + Messages.getString("TellerProjectDocumentBuilder./Teller_u9879_u76EE_1") + Messages.getString("TellerProjectDocumentBuilder.__u8BBE_u8BA1_u6587_u6863.doc_2");
            this.saveFile(fileName);
        }
        catch (Exception e) {
            String fileName = String.valueOf(this.dstPath) + "errorTellerPrjDocument.doc";
            this.saveFile(fileName);
            e.printStackTrace();
            super.reportProblem(2, String.valueOf(Messages.getString("TellerProjectDocumentBuilder.Failed_to_build_the_MCI_Project_!_Exception___3")) + e, "");
        }
        this.reportProgress(Messages.getString("TellerProjectDocumentBuilder.Build_finished._1"), 10);
    }

    private void buildOpStatistic() {
        if (this.document == null) {
            return;
        }
        this.reportProgress("\u751f\u6210Teller \u4ea4\u6613\u548c\u4ea4\u6613\u6b65\u9aa4\u7edf\u8ba1", 1);
        this.opStepList = new Vector();
        Vector childs = this.flowEditorProfile.getElement("flow").getChilds();
        int i = 0;
        while (i < childs.size()) {
            ElementChild child = (ElementChild)childs.elementAt(i);
            XMLNode opStepNode = new XMLNode();
            opStepNode.setNodeName(child.getChildElementId());
            opStepNode.setAttrValue("refInOp", "");
            this.opStepList.add(opStepNode);
            ++i;
        }
        this.opList = new Vector();
        String TellerTrxPath = (String.valueOf(this.projectRootPath) + "/designFiles/tellerTrxs").replace('\\', '/');
        this.scanTellerOpList(TellerTrxPath);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u4ea4\u6613\u548c\u4ea4\u6613\u6b65\u9aa4\u7edf\u8ba1");
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6807\u9898 2");
        this.document.typeText("Teller \u4ea4\u6613\u5217\u8868\r\n");
        this.document.setStyle("\u6b63\u6587");
        String[] titles = new String[]{"OpCode", "\u4ea4\u6613\u5206\u7ec4", "\u4ea4\u6613\u540d\u79f0", "\u670d\u52a1\u5668\u7aefOpCode", "\u5f15\u7528\u4e3b\u6d41\u7a0b", "\u6d41\u7a0bID", "\u63cf\u8ff0", ""};
        this.document.addTable(2, 7, titles);
        int i2 = 0;
        while (i2 < this.opList.size()) {
            XMLNode opNode = (XMLNode)this.opList.elementAt(i2);
            if (!"#text".equals(opNode.getNodeName())) {
                this.document.typeText(opNode.getAttrValue("code"));
                this.document.moveRight(1, 1);
                this.document.typeText(opNode.getAttrValue("classify"));
                this.document.moveRight(1, 1);
                this.document.typeText(opNode.getAttrValue("name"));
                this.document.moveRight(1, 1);
                this.document.typeText(opNode.getAttrValue("srvOpCode"));
                this.document.moveRight(1, 1);
                this.document.typeText(opNode.getAttrValue("refToMainFlow"));
                this.document.moveRight(1, 1);
                this.document.typeText(opNode.getAttrValue("flowId"));
                this.document.moveRight(1, 1);
                String desc = opNode.getAttrValue("description");
                if (desc == null) {
                    desc = "";
                }
                this.document.typeText(desc);
                this.document.insertRowsBelow(1);
            }
            ++i2;
        }
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6807\u9898 2");
        this.document.typeText("Action\u5f15\u7528\u7edf\u8ba1\r\n");
        this.document.setStyle("\u6b63\u6587");
        String[] titles1 = new String[]{"Action", "\u63cf\u8ff0", "\u5f15\u7528Op", ""};
        this.document.addTable(2, 3, titles1);
        int i3 = 0;
        while (i3 < this.opStepList.size()) {
            XMLNode opStepNode = (XMLNode)this.opStepList.elementAt(i3);
            this.document.typeText(opStepNode.getNodeName());
            this.document.moveRight(1, 1);
            String desc = null;
            try {
                desc = this.flowEditorProfile.getElement(opStepNode.getNodeName()).getDocument();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (desc == null) {
                desc = "";
            }
            this.document.typeText(desc);
            this.document.moveRight(1, 1);
            String refOp = opStepNode.getAttrValue("refInOp");
            if (refOp == null) {
                refOp = " ";
            }
            this.document.typeText(refOp.replace(';', '\n'));
            this.document.insertRowsBelow(1);
            ++i3;
        }
        this.document.moveDown(5, 1);
    }

    private void buildOpStepProfile() {
        if (this.document == null) {
            return;
        }
        this.reportProgress("\u751f\u6210Teller \u4ea4\u6613\u6b65\u9aa4\u63cf\u8ff0", 1);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u4ea4\u6613\u6b65\u9aa4\u63cf\u8ff0");
        this.document.moveDown(5, 1);
        Vector stepCatalog = this.flowEditorProfile.getCagalogs();
        int i = 0;
        while (i < stepCatalog.size()) {
            ElementCatalog catalog = (ElementCatalog)stepCatalog.elementAt(i);
            if (!catalog.getCatalogName().equals("Flow") && !catalog.getCatalogName().equals("flow")) {
                this.document.setStyle("\u6807\u9898 2");
                this.document.typeText(String.valueOf(catalog.getLabel()) + "\u7c7b\r\n");
                int j = 0;
                while (j < catalog.getElements().size()) {
                    Element stepEle = (Element)catalog.getElements().elementAt(j);
                    this.document.setStyle("\u6807\u9898 3");
                    this.document.typeText(String.valueOf(stepEle.getElementName()) + "\r\n");
                    this.document.setStyle("\u6b63\u6587");
                    this.document.typeText("\u540d\u79f0:  " + stepEle.getLabel() + "\r\n");
                    this.document.typeText("\u5b9e\u73b0\u7c7b:  ");
                    this.document.typeText(stepEle.getImplClass());
                    this.document.typeText("\r\n");
                    this.document.typeText("\u63cf\u8ff0:\r\n");
                    this.document.typeText(stepEle.getDocument());
                    this.document.typeText("\r\n");
                    if (stepEle.getAttributes() != null && stepEle.getAttributes().size() > 0) {
                        this.document.typeText("\u5c5e\u6027\u5b9a\u4e49:\r\n");
                        String[] title = new String[]{"\u5c5e\u6027ID", "\u7c7b\u578b", "\u53ef\u9009\u503c", ""};
                        this.document.addTable(2, 3, title);
                        int k = 0;
                        while (k < stepEle.getAttributes().size()) {
                            ElementAttribute attr = (ElementAttribute)stepEle.getAttributes().elementAt(k);
                            this.document.typeText(attr.getAttrID());
                            this.document.moveRight(1, 1);
                            this.document.typeText(attr.getAttrType());
                            this.document.moveRight(1, 1);
                            this.document.typeText(attr.getValueListStr());
                            this.document.insertRowsBelow(1);
                            ++k;
                        }
                        this.document.moveDown(5, 1);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void buildServiceProfile() {
        if (this.document == null) {
            return;
        }
        this.reportProgress("\u751f\u6210Teller \u670d\u52a1\u5b9a\u4e49\u63cf\u8ff0", 1);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u670d\u52a1\u5b9a\u4e49\u63cf\u8ff0");
        this.document.moveDown(5, 1);
        Vector stepCatalog = this.serviceEditorProfile.getCagalogs();
        int i = 0;
        while (i < stepCatalog.size()) {
            ElementCatalog catalog = (ElementCatalog)stepCatalog.elementAt(i);
            this.document.setStyle("\u6807\u9898 2");
            this.document.typeText(String.valueOf(catalog.getLabel()) + "\u7c7b\r\n");
            int j = 0;
            while (j < catalog.getElements().size()) {
                Element serviceEle = (Element)catalog.getElements().elementAt(j);
                if (serviceEle.getImplClass() != null && serviceEle.getImplClass().length() != 0) {
                    int k;
                    String[] title;
                    this.document.setStyle("\u6807\u9898 3");
                    this.document.typeText(String.valueOf(serviceEle.getElementName()) + "\r\n");
                    this.document.setStyle("\u6b63\u6587");
                    this.document.typeText("\u540d\u79f0:  " + serviceEle.getLabel() + "\r\n");
                    this.document.typeText("\u5b9e\u73b0\u7c7b:  ");
                    this.document.typeText(serviceEle.getImplClass());
                    this.document.typeText("\r\n");
                    this.document.typeText("\u63cf\u8ff0:\r\n");
                    this.document.typeText(serviceEle.getDocument());
                    this.document.typeText("\r\n");
                    if (serviceEle.getAttributes() != null && serviceEle.getAttributes().size() > 0) {
                        this.document.typeText("\u5c5e\u6027\u5b9a\u4e49:\r\n");
                        title = new String[]{"\u5c5e\u6027ID", "\u7c7b\u578b", "\u53ef\u9009\u503c", "\u8bf4\u660e", ""};
                        this.document.addTable(2, 4, title);
                        k = 0;
                        while (k < serviceEle.getAttributes().size()) {
                            ElementAttribute attr = (ElementAttribute)serviceEle.getAttributes().elementAt(k);
                            this.document.typeText(attr.getAttrID());
                            this.document.moveRight(1, 1);
                            this.document.typeText(attr.getAttrType());
                            this.document.moveRight(1, 1);
                            this.document.typeText(attr.getValueListStr());
                            this.document.moveRight(1, 1);
                            this.document.typeText(attr.getDocument());
                            this.document.insertRowsBelow(1);
                            ++k;
                        }
                        this.document.moveDown(5, 1);
                    }
                    if (serviceEle.getChilds() != null && serviceEle.getChilds().size() > 0) {
                        this.document.typeText("\u5b50\u5143\u7d20\u5b9a\u4e49:\r\n");
                        title = new String[]{"\u5b50\u5143\u7d20ID", "\u5141\u8bb8\u4e2a\u6570", ""};
                        this.document.addTable(2, 2, title);
                        k = 0;
                        while (k < serviceEle.getChilds().size()) {
                            ElementChild child = (ElementChild)serviceEle.getChilds().elementAt(k);
                            this.document.typeText(child.getChildElementId());
                            this.document.moveRight(1, 1);
                            this.document.typeText(child.getAlowCount());
                            this.document.insertRowsBelow(1);
                            ++k;
                        }
                        this.document.moveDown(5, 1);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void scanTellerOpList(String path) {
        try {
            File TrxPathFolder = new File(path);
            String[] files = TrxPathFolder.list();
            int i = 0;
            while (i < files.length) {
                try {
                    FileInputStream in = new FileInputStream(String.valueOf(path) + "/" + files[i]);
                    if (in != null) {
                        if (!files[i].endsWith(".ttx")) {
                            ((InputStream)in).close();
                        } else {
                            XMLNode TellerTrxNode = this.loadXMLContent(in);
                            ((InputStream)in).close();
                            String classify = TellerTrxNode.getAttrValue("classify");
                            if (classify == null || classify.length() == 0) {
                                classify = "";
                            }
                            String opCode = TellerTrxNode.getAttrValue("trxCode");
                            opCode = String.valueOf(opCode) + "CltOp";
                            String srvOpCode = TellerTrxNode.getAttrValue("srvTrxCode");
                            srvOpCode = String.valueOf(srvOpCode) + "SrvOp";
                            String name = TellerTrxNode.getAttrValue("trxName");
                            String refMainFlow = TellerTrxNode.getAttrValue("refToMainFlow");
                            if (refMainFlow == null || refMainFlow.length() == 0) {
                                refMainFlow = "false";
                            }
                            String flowId = "";
                            if (refMainFlow.equals("false")) {
                                XMLNode flowNode = TellerTrxNode.getChild("flow");
                                if (flowNode != null) {
                                    flowId = flowNode.getAttrValue("id");
                                }
                            } else {
                                XMLNode refFlowNode = TellerTrxNode.getChild("refFlow");
                                if (refFlowNode != null) {
                                    flowId = refFlowNode.getAttrValue("refId");
                                }
                            }
                            String description = TellerTrxNode.getDocument();
                            XMLNode opNode = new XMLNode();
                            opNode.setNodeName("Op");
                            opNode.setAttrValue("code", opCode);
                            opNode.setAttrValue("srvOpCode", srvOpCode);
                            opNode.setAttrValue("classify", classify);
                            opNode.setAttrValue("name", name);
                            opNode.setAttrValue("refToMainFlow", refMainFlow);
                            opNode.setAttrValue("flowId", flowId);
                            opNode.setAttrValue("description", description);
                            this.opList.add(opNode);
                            if (refMainFlow == null || refMainFlow.length() == 0 || refMainFlow.equals("true")) {
                                return;
                            }
                            XMLNode flowNode = TellerTrxNode.getChild("flow");
                            if (flowNode == null || flowNode.getChilds().size() == 0) {
                                return;
                            }
                            int j = 0;
                            while (j < flowNode.getChilds().size()) {
                                XMLNode opStepNode = (XMLNode)flowNode.getChilds().elementAt(j);
                                if (!"#text".equals(opStepNode.getNodeName())) {
                                    this.registOpStep(opStepNode.getNodeName(), opCode);
                                }
                                ++j;
                            }
                        }
                    }
                }
                catch (FileNotFoundException ee) {
                    this.scanTellerOpList(String.valueOf(path) + "/" + files[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registOpStep(String opStepName, String opCode) {
        int i = 0;
        while (i < this.opStepList.size()) {
            XMLNode opStepNode = (XMLNode)this.opStepList.elementAt(i);
            if (opStepNode.getNodeName().equals(opStepName)) {
                String refInOp = opStepNode.getAttrValue("refInOp");
                if (refInOp == null) {
                    refInOp = "";
                }
                if (refInOp.indexOf(opCode) != -1) break;
                opStepNode.setAttrValue("refInOp", String.valueOf(refInOp) + opCode + ";");
                break;
            }
            ++i;
        }
    }

    private XMLNode loadXMLContent(InputStream in) {
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        try {
            XMLNode node = (XMLNode)xmlLoader.loadXMLContent(in);
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void saveFile(String fileName) {
        try {
            this.document.saveAs(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XMLNode getFlow() {
        return this.flows;
    }

    public void setFlow(XMLNode flow) {
        this.flows = flow;
    }

    private void addDataDefine(XMLNode dictionaryNode) {
        String nodeName = dictionaryNode.getNodeName();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getDocument());
        } else if (nodeName.equals("dataCollection")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 2);
            this.document.typeText(" " + dictionaryNode.getDocument());
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.document.insertRowsBelow(1);
                    this.document.typeText(String.valueOf(dictionaryNode.getAttrValue("id")) + ".");
                    this.addDataDefine(aNode);
                }
                ++i;
            }
        } else if (nodeName.equals("refData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
        } else if (nodeName.equals("selectData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getDocument());
            if (dictionaryNode.getAttrValue("refDataColl") != null) {
                this.document.typeText(" " + dictionaryNode.getAttrValue("refDataColl"));
            }
            if (dictionaryNode.getAttrValue("values") != null) {
                this.document.typeText(" " + dictionaryNode.getAttrValue("values"));
            }
        }
    }

    private void buildCommonFlow() {
        if (this.document == null) {
            return;
        }
        this.reportProgress(Messages.getString("TellerProjectDocumentBuilder.Build_Teller_Common_Flow_Description_2"), 2);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerProjectDocumentBuilder._u516C_u5171_u6D41_u7A0B_u5B9A_u4E49_37"));
        this.document.moveDown(5, 1);
        this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6B63_u6587_38"));
        int n = 0;
        while (n < this.flows.getChilds().size()) {
            XMLNode flowNode = (XMLNode)this.flows.getChilds().elementAt(n);
            if (!"#text".equals(flowNode.getNodeName())) {
                if (flowNode.getChilds() == null) {
                    return;
                }
                String flowID = flowNode.getAttrValue("id");
                XMLNode stepsNode = new XMLNode();
                stepsNode.setNodeName("flow");
                stepsNode.setAttrValue("id", flowID);
                this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6807_u9898_2_42"));
                this.document.typeText(Messages.getString("TellerProjectDocumentBuilder._u6D41_u7A0B_uFF1A_43"));
                this.document.typeText(flowNode.getAttrValue("id") + "\r\n");
                this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6B63_u6587_47"));
                int i = 0;
                while (i < flowNode.getChilds().size()) {
                    XMLNode actionStepNode = (XMLNode)flowNode.getChilds().elementAt(i);
                    if (!("#text".equals(actionStepNode.getNodeName()) || "status".equals(actionStepNode.getNodeName()) || "END".equals(actionStepNode.getNodeName()))) {
                        XMLNode stepNode = new XMLNode();
                        stepsNode.add(stepNode);
                        stepNode.setNodeName("opStep");
                        stepNode.setAttrValue("id", actionStepNode.getAttrValue("name"));
                        Enumeration keys = actionStepNode.getAttrs().keys();
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height") || key.equals("id") || key.equals("implClass")) continue;
                            stepNode.setAttrValue(key, actionStepNode.getAttrValue(key));
                        }
                        if (actionStepNode.getChilds() != null) {
                            int k = 0;
                            while (k < actionStepNode.getChilds().size()) {
                                XMLNode transitionNode = (XMLNode)actionStepNode.getChilds().elementAt(k);
                                String dst = transitionNode.getAttrValue("dest");
                                String idStr = transitionNode.getAttrValue("id");
                                if (dst != null && idStr != null) {
                                    String key = "on" + idStr + "Do";
                                    stepNode.setAttrValue(key, dst);
                                }
                                ++k;
                            }
                        }
                    }
                    ++i;
                }
                StringBuffer sBuff = new StringBuffer();
                stepsNode.toXMLContent(0, sBuff);
                this.document.typeText(String.valueOf(sBuff.toString()) + "\r\n");
                this.document.typeText(Messages.getString("TellerProjectDocumentBuilder._u5982_u56FE_uFF1A_r_n_65"));
                VisualContentToImage visual = new VisualContentToImage();
                try {
                    visual.setFlowEditorProfile(this.flowEditorProfile);
                    visual.setXMLContent(flowNode);
                    visual.saveToImageFile(String.valueOf(this.dstPath) + "/flowImage_" + flowID + ".jpg", 0);
                    visual.isImageOK();
                    this.document.addPicture(String.valueOf(this.dstPath) + "/flowImage_" + flowID + ".jpg");
                    File imageFile = new File(String.valueOf(this.dstPath) + "/flowImage_" + flowID + ".jpg");
                    imageFile.delete();
                    this.document.typeText("\r\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    private void buildData() {
        this.reportProgress(Messages.getString("TellerProjectDocumentBuilder.Build_Teller_Data_Description_3"), 1);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerProjectDocumentBuilder._u6570_u636E_u5B57_u5178_u5B9A_u4E49_73"));
        this.document.moveDown(5, 1);
        this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6B63_u6587_74"));
        String[] titles = new String[]{Messages.getString("TellerProjectDocumentBuilder._u540D_u79F0_75"), Messages.getString("TellerProjectDocumentBuilder._u4E2D_u6587_u540D_u79F0_76"), Messages.getString("TellerProjectDocumentBuilder._u7C7B_u578B_77"), Messages.getString("TellerProjectDocumentBuilder._u63CF_u8FF0_78"), ""};
        this.document.addTable(2, 4, titles);
        int i = 0;
        while (i < this.dataDictionary.getChilds().size()) {
            XMLNode childNode = (XMLNode)this.dataDictionary.getChilds().elementAt(i);
            if (!"#text".equals(childNode.getNodeName())) {
                if (childNode == null) {
                    String msg = Messages.getString("TellerProjectDocumentBuilder.MCI_dictionary__file_error__!_80");
                    super.reportProblem(2, msg, "");
                } else if ("common".equals(childNode.getAttrValue("access")) || "session".equals(childNode.getAttrValue("access"))) {
                    this.addDataDefine(childNode);
                    this.document.insertRowsBelow(1);
                }
            }
            ++i;
        }
    }

    private void buildDataType() {
        if (this.document == null) {
            return;
        }
        this.reportProgress(Messages.getString("TellerProjectDocumentBuilder.Build_Teller_Data_Type_Description_4"), 1);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerProjectDocumentBuilder._u6570_u636E_u7C7B_u578B_u5B9A_u4E49_86"));
        this.document.moveDown(5, 1);
        this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6B63_u6587_87"));
        String[] title = new String[]{"ID", Messages.getString("TellerProjectDocumentBuilder._u957F_u5EA6_89"), Messages.getString("TellerProjectDocumentBuilder._u683C_u5F0F_90"), "Pattern", Messages.getString("TellerProjectDocumentBuilder._u63CF_u8FF0_92"), ""};
        this.document.addTable(2, 5, title);
        XMLNode dataTypes = this.dataDictionary.getChild("DataTypes");
        if (dataTypes == null) {
            return;
        }
        int i = 0;
        while (i < dataTypes.getChilds().size()) {
            XMLNode dataType = (XMLNode)dataTypes.getChilds().elementAt(i);
            if (!"#text".equals(dataType.getNodeName())) {
                this.document.typeText(dataType.getAttrValue("id"));
                this.document.moveRight(1, 1);
                this.document.typeText(dataType.getAttrValue("length"));
                this.document.moveRight(1, 1);
                this.document.typeText(dataType.getAttrValue("dataFmt"));
                this.document.moveRight(1, 1);
                this.document.typeText(dataType.getAttrValue("pattern"));
                this.document.moveRight(1, 1);
                this.document.typeText(dataType.getDocument());
                this.document.insertRowsBelow(1);
            }
            ++i;
        }
        this.document.moveDown(5, 1);
        this.document.typeText("\r\n");
    }

    private void buildFormats() {
        XMLNode repNode;
        if (this.document == null) {
            return;
        }
        this.reportProgress(Messages.getString("TellerProjectDocumentBuilder.Build_Teller_Format_Head_Description_5"), 1);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerProjectDocumentBuilder._u670D_u52A1_u5668_u8BBF_u95EE_u53CA_u62A5_u6587_u5934_u5B9A_u4E49_106"));
        XMLNode reqNode = this.msgHeader.getChild("reqHeadDatas");
        if (reqNode != null && reqNode.getChilds() != null && reqNode.getChilds().size() > 0) {
            this.document.moveDown(5, 1);
            this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6807_u9898_2_108"));
            this.document.typeText(Messages.getString("TellerProjectDocumentBuilder._u8BF7_u6C42_u62A5_u6587_u5934_uFF1A_r_n_109"));
            this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6B63_u6587_110"));
            try {
                String[] fieldNames = new String[]{Messages.getString("TellerProjectDocumentBuilder._u540D_u79F0_111"), Messages.getString("TellerProjectDocumentBuilder._u4E2D_u6587_u540D_u79F0_112"), Messages.getString("TellerProjectDocumentBuilder._u5907_u6CE8_113"), ""};
                this.document.addTable(2, 3, fieldNames);
                int k = 0;
                while (k < reqNode.getChilds().size()) {
                    XMLNode reqField = (XMLNode)reqNode.getChilds().elementAt(k);
                    String refId = reqField.getAttrValue("refId");
                    if (refId != null) {
                        this.document.typeText(refId);
                        this.document.moveRight(1, 1);
                        try {
                            XMLNode childNode = this.dataDictionary.findChildNode(refId);
                            if (childNode != null) {
                                this.document.typeText(childNode.getAttrValue("label"));
                            } else {
                                this.reportProblem(2, "refer to undefined data:" + refId, "");
                            }
                            this.document.moveRight(1, 1);
                            if ("refColl".equals(reqField.getNodeName())) {
                                this.document.typeText("iColl");
                            }
                        }
                        catch (Exception childNode) {
                            // empty catch block
                        }
                        this.document.insertRowsBelow(1);
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                String msg = String.valueOf(Messages.getString("TellerProjectDocumentBuilder.Error_failed_to_build_request_fmt_for_Server_Exception___121")) + e;
                super.reportProblem(2, msg, "");
                e.printStackTrace();
            }
        }
        if ((repNode = this.msgHeader.getChild("repHeadDatas")) != null && repNode.getChilds() != null && repNode.getChilds().size() > 0) {
            this.document.moveDown(5, 1);
            this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6807_u9898_2_124"));
            this.document.typeText(Messages.getString("TellerProjectDocumentBuilder._u54CD_u5E94_u62A5_u6587_u5934_uFF1A_r_n_125"));
            this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6B63_u6587_126"));
            try {
                String[] fieldNames = new String[]{Messages.getString("TellerProjectDocumentBuilder._u540D_u79F0_127"), Messages.getString("TellerProjectDocumentBuilder._u4E2D_u6587_u540D_u79F0_128"), Messages.getString("TellerProjectDocumentBuilder._u5907_u6CE8_129"), ""};
                this.document.addTable(2, 3, fieldNames);
                int k = 0;
                while (k < repNode.getChilds().size()) {
                    XMLNode repField = (XMLNode)repNode.getChilds().elementAt(k);
                    String refId = repField.getAttrValue("refId");
                    if (refId != null) {
                        this.document.typeText(refId);
                        this.document.moveRight(1, 1);
                        try {
                            XMLNode childNode = this.dataDictionary.findChildNode(refId);
                            if (childNode != null) {
                                this.document.typeText(childNode.getAttrValue("label"));
                            } else {
                                this.reportProblem(2, "Refer to undefiend data: " + refId, "");
                            }
                            this.document.moveRight(1, 1);
                            if ("refColl".equals(repField.getNodeName())) {
                                this.document.typeText("iColl");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.document.insertRowsBelow(1);
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                String msg = String.valueOf(Messages.getString("TellerProjectDocumentBuilder.Error_failed_to_build_request_fmt_for_Server_Exception___137")) + e;
                super.reportProblem(2, msg, "");
                e.printStackTrace();
            }
        }
    }

    private void buildServices() {
        if (this.document == null) {
            return;
        }
        if (this.services == null || this.services.getChilds() == null) {
            return;
        }
        this.reportProgress(Messages.getString("TellerProjectDocumentBuilder.Build_Teller_Service_Description_6"), 1);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerProjectDocumentBuilder._u516C_u5171_u670D_u52A1_u5B9A_u4E49_139"));
        this.document.moveDown(5, 1);
        int i = 0;
        while (i < this.services.getChilds().size()) {
            XMLNode serviceNode = (XMLNode)this.services.getChilds().elementAt(i);
            if (!"#text".equals(serviceNode.getNodeName())) {
                String svcId = serviceNode.getAttrValue("id");
                this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6807_u9898_2_141"));
                this.document.typeText(svcId + "\r\n");
                this.document.setStyle(Messages.getString("TellerProjectDocumentBuilder._u6B63_u6587_144"));
                String[] titles = new String[]{Messages.getString("TellerProjectDocumentBuilder._u670D_u52A1ID_145"), Messages.getString("TellerProjectDocumentBuilder._u670D_u52A1_u7C7B_u578B_146"), Messages.getString("TellerProjectDocumentBuilder._u8BF4_u660E_147"), ""};
                this.document.addTable(2, 3, titles);
                this.document.typeText(svcId);
                this.document.moveRight(1, 1);
                this.document.typeText(serviceNode.getNodeName());
                this.document.moveRight(1, 1);
                this.document.typeText(serviceNode.getDocument());
                this.document.moveRight(2, 1);
                this.document.typeText(Messages.getString("TellerProjectDocumentBuilder._u5B9A_u4E49_u63CF_u8FF0_uFF1A_r_n_154"));
                StringBuffer sBuff = new StringBuffer();
                serviceNode.toXMLContent(0, sBuff);
                this.document.typeText(String.valueOf(sBuff.toString()) + "\r\n");
            }
            ++i;
        }
    }
}

