/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.builder.StateMachineBuilder;
import com.ecc.ide.builder.format.FormatGenerator;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Enumeration;
import java.util.Vector;

public class TellerTransactionBuilder
extends AbstractBuilder {
    private String srcFileName = null;
    private XMLNode dataDictionary;
    private XMLNode fmtHeader;
    private XMLNode packageType;
    private XMLNode service;
    private XMLNode flow;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile serviceEditorProfile;
    private XMLLoader xmlLoader = null;
    private XMLNode TellerTrxNode;
    private XMLNode trxNode;
    private XMLNode contextNode;
    private XMLNode operationNode;
    private EditorProfile stateMachineProfile;
    private EditorProfile stateProfile;
    private XMLNode commonStates;
    private XMLNode commonStateMachineNode;
    private boolean buildStateMachineAsOperation = false;

    public void setBuildStateMachineAsOperation(boolean value) {
        this.buildStateMachineAsOperation = value;
    }

    public void setCommonStateMachine(XMLNode node) {
        this.commonStateMachineNode = node;
    }

    public void setStateMachineEditorProfile(EditorProfile profile) {
        this.stateMachineProfile = profile;
    }

    public void setStateEditorProfile(EditorProfile profile) {
        this.stateProfile = profile;
    }

    public void setCommonStates(XMLNode states) {
        this.commonStates = states;
    }

    public void setFlowEditorProfile(EditorProfile profile) {
        this.flowEditorProfile = profile;
    }

    public void setServiceEditorProfile(EditorProfile profile) {
        this.serviceEditorProfile = profile;
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setFmtHeader(XMLNode node) {
        this.fmtHeader = node;
    }

    public void setPackageType(XMLNode node) {
        this.packageType = node;
    }

    public void buildTellerTransaction(String srcFile) {
        this.srcFileName = srcFile;
        try {
            this.reportProgress(Messages.getString("TellerTransactionBuilder.Load_Teller_Transaction_File_..._1"));
            String filePath = this.dstPath;
            this.trxNode = new XMLNode();
            this.trxNode.setNodeName("SelfDefinedOp.xml");
            this.TellerTrxNode = this.loadXMLContent(srcFile);
            this.reportProgress(Messages.getString("TellerTransactionBuilder.Build_the_trx..._2"), 1);
            String classify = null;
            try {
                classify = this.TellerTrxNode.getAttrValue("classify");
                super.createFolder(classify);
                if (classify != null && classify.length() > 0) {
                    filePath = String.valueOf(this.dstPath) + "/" + classify;
                }
            }
            catch (Exception e) {
                super.reportProblem(2, String.valueOf(Messages.getString("TellerTransactionBuilder.Faild_to_create_classify_folder_[_4")) + classify + "]. Exception: " + e, this.srcFileName);
            }
            String trxCode = this.TellerTrxNode.getAttrValue("trxCode");
            this.operationNode = new XMLNode();
            this.operationNode.setNodeName("ClientOperation");
            this.operationNode.setAttrValue("id", String.valueOf(trxCode) + "CltOp");
            this.operationNode.setAttrValue("operationContext", String.valueOf(trxCode) + "CltCtx");
            String srvTrxCode = this.TellerTrxNode.getAttrValue("srvTrxCode");
            if (srvTrxCode != null && srvTrxCode.length() > 0) {
                this.operationNode.setAttrValue("serverOperation", String.valueOf(srvTrxCode) + "SrvOp");
            }
            this.buildTransactionFlow();
            this.trxNode.add(this.operationNode);
            this.reportProgress(Messages.getString("TellerTransactionBuilder.Build_Teller_Transaction_Context_3"));
            this.contextNode = new XMLNode();
            this.contextNode.setNodeName("context");
            this.contextNode.setAttrValue("id", String.valueOf(trxCode) + "CltCtx");
            this.contextNode.setAttrValue("type", "op");
            this.contextNode.setAttrValue("parent", "sessionCtx");
            XMLNode refDataNode = new XMLNode();
            refDataNode.setNodeName("refKColl");
            refDataNode.setAttrValue("refId", String.valueOf(trxCode) + "CltData");
            this.contextNode.add(refDataNode);
            this.trxNode.add(this.contextNode);
            XMLNode dataNode = new XMLNode();
            dataNode.setNodeName("kColl");
            dataNode.setAttrValue("id", String.valueOf(trxCode) + "CltData");
            this.buildData(dataNode);
            this.trxNode.add(dataNode);
            this.buildServices();
            this.buildFormats();
            XMLNode deviceDefNode = this.TellerTrxNode.findChild("DeviceOutDefine");
            if (deviceDefNode != null) {
                deviceDefNode.setAttrValue("id", "deviceAccessSvc");
                int i = 0;
                while (i < deviceDefNode.getChilds().size()) {
                    XMLNode aNode = (XMLNode)deviceDefNode.getChilds().elementAt(i);
                    if ("DeviceDefine".equals(aNode.getNodeName()) && "receipt".equals(aNode.getAttrValue("type"))) {
                        String refFileName = classify != null ? String.valueOf(classify) + "/" + trxCode + aNode.getAttrValue("refId") : String.valueOf(trxCode) + aNode.getAttrValue("refId");
                        aNode.setAttrValue("refId", refFileName);
                    }
                    ++i;
                }
                this.trxNode.add(deviceDefNode);
                XMLNode refSvcNode = new XMLNode();
                refSvcNode.setNodeName("refService");
                refSvcNode.setAttrValue("refId", "deviceAccessSvc");
                refSvcNode.setAttrValue("alias", "deviceAccessSvc");
                refSvcNode.setAttrValue("type", "SVC");
                this.contextNode.add(refSvcNode);
            }
            String fileName = String.valueOf(filePath) + "/" + trxCode + "CltOp.xml";
            this.saveXMLFile(fileName, this.trxNode);
        }
        catch (Exception e) {
            super.reportProblem(2, String.valueOf(Messages.getString("TellerTransactionBuilder.Failed_to_build_the_Teller_transaction_!_Exception___31")) + e, this.srcFileName);
        }
        this.reportProgress(Messages.getString("TellerTransactionBuilder.Build_finished._4"), 10);
    }

    private void buildServices() {
        this.reportProgress(Messages.getString("TellerTransactionBuilder.Build_Teller_Transaction_Service_5"), 3);
        XMLNode servicesNode = this.TellerTrxNode.getChild("services");
        if (servicesNode == null || servicesNode.getChilds() == null) {
            return;
        }
        int i = 0;
        while (i < servicesNode.getChilds().size()) {
            XMLNode serviceNode = (XMLNode)servicesNode.getChilds().elementAt(i);
            if (!"#text".equals(serviceNode.getNodeName())) {
                String svcId = serviceNode.getAttrValue("id");
                this.trxNode.add(serviceNode);
                XMLNode refSvcNode = new XMLNode();
                refSvcNode.setNodeName("refService");
                refSvcNode.setAttrValue("refId", svcId);
                refSvcNode.setAttrValue("alias", svcId);
                refSvcNode.setAttrValue("type", "prv");
                this.contextNode.add(refSvcNode);
            }
            ++i;
        }
    }

    private void buildTransactionFlow() {
        this.reportProgress(Messages.getString("TellerTransactionBuilder.Build_Teller_Transaction_Flow_6"));
        String useStateMachine = this.TellerTrxNode.getAttrValue("useStateMachine");
        if (useStateMachine != null && "true".equals(useStateMachine)) {
            this.buildStateMachineFlow();
        } else {
            this.buildOperationFlow();
        }
    }

    private void buildOperationFlow() {
        if ("true".equals(this.TellerTrxNode.getAttrValue("refToMainFlow"))) {
            XMLNode refFlowNode = this.TellerTrxNode.getChild("refFlow");
            if (refFlowNode == null) {
                String msg = String.valueOf(Messages.getString("MCITransactionBuilder.Error_MCI_Transaction_Define_fine_[_16")) + Messages.getString("MCITransactionBuilder.]_refFlow_not_defined_!_17");
                super.reportProblem(2, msg, this.srcFileName);
            } else {
                String flowId = refFlowNode.getAttrValue("refId");
                if (flowId == null) {
                    String msg = String.valueOf(Messages.getString("MCITransactionBuilder.Error_MCI_Transaction_Define_fine_[_20")) + Messages.getString("MCITransactionBuilder.]_refFlow_node__s_refId_not_defined_!_21");
                    super.reportProblem(2, msg, this.srcFileName);
                } else {
                    this.operationNode.setAttrValue("refFlow", flowId);
                    XMLNode comFlowNode = this.flow.findChildNode(flowId);
                    if (comFlowNode != null) {
                        XMLNode attrsNode = comFlowNode.getChild("attributes");
                        int i = 0;
                        while (i < attrsNode.getChilds().size()) {
                            XMLNode attrNode = (XMLNode)attrsNode.getChilds().elementAt(i);
                            if ("attr".equals(attrNode.getNodeName())) {
                                String attrId = attrNode.getAttrValue("id");
                                this.operationNode.setAttrValue(attrId, refFlowNode.getAttrValue(attrId));
                            }
                            ++i;
                        }
                    } else {
                        String msg = "Operation define refer to not defined comm flow def: " + flowId;
                        super.reportProblem(2, msg, this.srcFileName);
                    }
                }
            }
            this.reportProgress(Messages.getString("MCITransactionBuilder.Buidl_MCI_Transaction_Flow_6"), 2);
            XMLNode flowNode = this.TellerTrxNode.findChildNode("flow", "extendFlow");
            int k = 0;
            while (k < flowNode.getChilds().size()) {
                XMLNode actionNode = (XMLNode)flowNode.getChilds().elementAt(k);
                if ("extendFlow".equals(actionNode.getNodeName())) {
                    XMLNode stepNode = new XMLNode();
                    stepNode.setNodeName("opStep");
                    stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                    this.operationNode.add(stepNode);
                    if (this.flowEditorProfile.getElement(actionNode.getNodeName()) != null) {
                        stepNode.setAttrValue("implClass", this.flowEditorProfile.getElement(actionNode.getNodeName()).getImplClass());
                    } else {
                        super.reportProblem(2, String.valueOf(Messages.getString("MCITransactionBuilder.No_set_implement_class_for_OpStep[_7")) + actionNode.getNodeName() + "]!", "");
                    }
                    this.buildOpFlow(stepNode, actionNode);
                }
                ++k;
            }
            return;
        }
        XMLNode flowNode = this.TellerTrxNode.findChildNode("flow", "privateFlow");
        if (flowNode == null && (flowNode = this.TellerTrxNode.getChild("flow")) != null && "extendFlow".equals(flowNode.getAttrValue("id"))) {
            return;
        }
        if (flowNode == null || flowNode.getChilds() == null) {
            return;
        }
        String flowImplClass = flowNode.getAttrValue("implClass");
        if (flowImplClass != null && flowImplClass.length() > 0) {
            this.operationNode.setNodeName(flowImplClass);
        }
        if (flowNode.getChilds() == null) {
            return;
        }
        this.reportProgress(Messages.getString("MCITransactionBuilder.Buidl_MCI_Transaction_Flow_6"), 2);
        this.buildOpFlow(this.operationNode, flowNode);
    }

    private void buildOpFlow(XMLNode opNode, XMLNode flowNode) {
        int k = 0;
        while (k < flowNode.getChilds().size()) {
            XMLNode actionNode = (XMLNode)flowNode.getChilds().elementAt(k);
            if (!(actionNode.getNodeName().equals("attributes") || "END".equals(actionNode.getNodeName()) || "validateEnd".equals(actionNode.getNodeName()) || "document".equals(actionNode.getNodeName()) || "#text".equals(actionNode.getNodeName()) || "transition".equals(actionNode.getNodeName()))) {
                XMLNode stepNode = new XMLNode();
                if ("validator".equals(actionNode.getNodeName())) {
                    stepNode.setNodeName("validator");
                    stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                } else {
                    stepNode.setNodeName("opStep");
                    stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                }
                opNode.add(stepNode);
                if (this.flowEditorProfile.getElement(actionNode.getNodeName()) != null) {
                    stepNode.setAttrValue("implClass", this.flowEditorProfile.getElement(actionNode.getNodeName()).getImplClass());
                } else {
                    super.reportProblem(2, String.valueOf(Messages.getString("MCITransactionBuilder.No_set_implement_class_for_OpStep[_7")) + actionNode.getNodeName() + "]!", "");
                }
                Enumeration keys = actionNode.getAttrs().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height")) continue;
                    stepNode.setAttrValue(key, actionNode.getAttrValue(key));
                }
                if (actionNode.getChilds() != null) {
                    int j = 0;
                    while (j < actionNode.getChilds().size()) {
                        XMLNode transitionNode = (XMLNode)actionNode.getChilds().elementAt(j);
                        String dst = transitionNode.getAttrValue("dest");
                        String idStr = transitionNode.getAttrValue("id");
                        if (dst != null) {
                            if (dst.startsWith("END") || dst.startsWith("validateEnd")) {
                                dst = "end";
                            }
                            if (idStr == null || idStr.length() == 0) {
                                idStr = "Other";
                            }
                            String key = "on" + idStr + "Do";
                            stepNode.setAttrValue(key, dst);
                        }
                        ++j;
                    }
                    this.buildOpFlow(stepNode, actionNode);
                }
            }
            ++k;
        }
    }

    private void buildStateMachineFlow() {
        this.operationNode.setNodeName("StateMachineOp");
        String refStateMachineFlag = this.TellerTrxNode.getAttrValue("refToStateMachine");
        if (refStateMachineFlag != null && "true".equals(refStateMachineFlag)) {
            XMLNode refStateMachineNode = this.TellerTrxNode.getChild("refStateMachine");
            if (refStateMachineNode == null) {
                return;
            }
            String flowID = refStateMachineNode.getAttrValue("refId");
            this.operationNode.setAttrValue("refStateMachine", flowID);
            return;
        }
        XMLNode stateMachineNode = this.TellerTrxNode.getChild("StateMachine");
        if (stateMachineNode == null) {
            return;
        }
        StateMachineBuilder stateMachineBuilder = new StateMachineBuilder();
        stateMachineBuilder.setBuilder(this);
        stateMachineBuilder.setStateEditorProfile(this.stateProfile);
        stateMachineBuilder.setStateMachineEditorProfile(this.stateMachineProfile);
        stateMachineBuilder.setCommonStateMachine(this.commonStateMachineNode);
        stateMachineBuilder.setCommonStates(this.commonStates);
        XMLNode opNode = stateMachineBuilder.buildStateMachine(stateMachineNode);
        int i = 0;
        while (i < opNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)opNode.getChilds().elementAt(i);
            this.operationNode.add(aNode);
            ++i;
        }
    }

    private void buildData(XMLNode dataNode) {
        this.reportProgress(Messages.getString("TellerTransactionBuilder.Build_Teller_Transaction_Data_13"), 3);
        XMLNode datas = this.TellerTrxNode.getChild("datas");
        if (datas == null || datas.getChilds() == null) {
            return;
        }
        int i = 0;
        while (i < datas.getChilds().size()) {
            XMLNode refNode = (XMLNode)datas.getChilds().elementAt(i);
            if (!"#text".equals(refNode.getNodeName())) {
                String refId = refNode.getAttrValue("refId");
                String defaultValue = refNode.getAttrValue("defaultValue");
                XMLNode childNode = this.dataDictionary.findChildNode(refId);
                if (childNode == null) {
                    String msg = String.valueOf(Messages.getString("TellerTransactionBuilder.Error_Teller_Transaction_file_refer_to_unknow_dataDefine_[_86")) + refId + "]!";
                    super.reportProblem(2, msg, this.srcFileName);
                } else if ("private".equals(refNode.getAttrValue("access")) || "private".equals(childNode.getAttrValue("access"))) {
                    this.addDataDefine(dataNode, childNode, defaultValue);
                }
            }
            ++i;
        }
    }

    private void buildFormats() {
        XMLNode fmtsNode;
        XMLNode viewsNode;
        String msg;
        String fmtBuilderClass;
        XMLNode pkgNode;
        XMLNode repNode;
        String msg2;
        String msg3;
        String msg4;
        this.reportProgress(Messages.getString("TellerTransactionBuilder.Build_Teller_Transaction_Format_14"), 3);
        String trxCode = this.TellerTrxNode.getAttrValue("trxCode");
        XMLNode reqNode = this.TellerTrxNode.getChild("srvRequest");
        if (reqNode != null && reqNode.getChilds() != null && reqNode.getChilds().size() > 0) {
            String pkgType = null;
            try {
                pkgType = reqNode.getAttrValue("packageType");
                if (pkgType == null || pkgType.length() == 0) {
                    pkgType = "StringFmt";
                }
            }
            catch (Exception e) {
                pkgType = "StringFmt";
            }
            if (pkgType == null) {
                String msg5 = Messages.getString("TellerTransactionBuilder.Error_Warnning_packageType_not_defined_for_host_Server__s_request_!_96");
                super.reportProblem(2, msg5, this.srcFileName);
                return;
            }
            XMLNode pkgNode2 = this.packageType.findChildNode(pkgType);
            if (pkgNode2 == null) {
                msg4 = String.valueOf(Messages.getString("TellerTransactionBuilder.Error_Unknown_package_type_[_98")) + pkgType + Messages.getString("TellerTransactionBuilder.]_for_host_Server__s_request_!_99");
                super.reportProblem(2, msg4, this.srcFileName);
            } else {
                String fmtBuilderClass2 = pkgNode2.getAttrValue("fmtGenClass");
                if (fmtBuilderClass2 == null) {
                    msg3 = String.valueOf(Messages.getString("TellerTransactionBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_102")) + pkgType + "]!";
                    super.reportProblem(2, msg3, this.srcFileName);
                } else {
                    try {
                        String fmtId = String.valueOf(trxCode) + "ReqFmt";
                        String fmtName = "csRequestFormat";
                        FormatGenerator fmtGen = (FormatGenerator)Class.forName(fmtBuilderClass2).newInstance();
                        XMLNode fmtNode = fmtGen.generateFormatNode(reqNode, this.dataDictionary, null);
                        fmtNode.setAttrValue("id", fmtId);
                        if ("true".equals(reqNode.getAttrValue("refToHead"))) {
                            XMLNode refHeadNode = new XMLNode();
                            refHeadNode.setNodeName("refFmt");
                            refHeadNode.setAttrValue("refId", "SisalRequestFmt");
                            Vector orgFields = fmtNode.getChild("record").getChilds();
                            orgFields.insertElementAt(refHeadNode, 0);
                        }
                        this.trxNode.add(fmtNode);
                        XMLNode refFmtNode = new XMLNode();
                        refFmtNode.setNodeName("refFormat");
                        refFmtNode.setAttrValue("name", fmtName);
                        refFmtNode.setAttrValue("refId", fmtId);
                        this.operationNode.add(refFmtNode);
                    }
                    catch (Exception e) {
                        msg2 = String.valueOf(Messages.getString("TellerTransactionBuilder.Error_failed_to_build_request_fmt_for_Server_Exception___117")) + e;
                        super.reportProblem(2, msg2, this.srcFileName);
                        e.printStackTrace();
                    }
                }
            }
        }
        if ((repNode = this.TellerTrxNode.getChild("srvReply")) != null && repNode.getChilds() != null && repNode.getChilds().size() > 0) {
            String pkgType = null;
            try {
                pkgType = reqNode.getAttrValue("packageType");
                if (pkgType == null || pkgType.length() == 0) {
                    pkgType = "StringFmt";
                }
            }
            catch (Exception e) {
                pkgType = "StringFmt";
            }
            if (pkgType == null) {
                msg4 = Messages.getString("TellerTransactionBuilder.Error_Warnning_packageType_not_defined_for_host_Server__s_reply_!_123");
                super.reportProblem(2, msg4, this.srcFileName);
                return;
            }
            pkgNode = this.packageType.findChildNode(pkgType);
            if (pkgNode == null) {
                msg3 = String.valueOf(Messages.getString("TellerTransactionBuilder.Error_Unknown_package_type_[_125")) + pkgType + Messages.getString("TellerTransactionBuilder.]_for_Server__s_reply_!_126");
                super.reportProblem(2, msg3, this.srcFileName);
            } else {
                fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
                if (fmtBuilderClass == null) {
                    msg2 = String.valueOf(Messages.getString("TellerTransactionBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_129")) + pkgType + "]!";
                    super.reportProblem(2, msg2, this.srcFileName);
                } else {
                    try {
                        String fmtId = String.valueOf(trxCode) + "RepFmt";
                        String fmtName = "csReplyFormat";
                        FormatGenerator fmtGen = (FormatGenerator)Class.forName(fmtBuilderClass).newInstance();
                        XMLNode fmtNode = fmtGen.generateFormatNode(repNode, this.dataDictionary, null);
                        fmtNode.setAttrValue("id", fmtId);
                        if ("true".equals(repNode.getAttrValue("refToHead"))) {
                            XMLNode refHeadNode = new XMLNode();
                            refHeadNode.setNodeName("refFmt");
                            refHeadNode.setAttrValue("refId", "SisalReplyFmt");
                            Vector orgFields = fmtNode.getChild("record").getChilds();
                            orgFields.insertElementAt(refHeadNode, 0);
                        }
                        this.trxNode.add(fmtNode);
                        XMLNode refFmtNode = new XMLNode();
                        refFmtNode.setNodeName("refFormat");
                        refFmtNode.setAttrValue("name", fmtName);
                        refFmtNode.setAttrValue("refId", fmtId);
                        this.operationNode.add(refFmtNode);
                    }
                    catch (Exception e) {
                        msg = String.valueOf(Messages.getString("TellerTransactionBuilder.Error_failed_to_build_reply_fmt_for_Server_Exception___144")) + e;
                        super.reportProblem(2, msg, this.srcFileName);
                        e.printStackTrace();
                    }
                }
            }
        }
        FormatGenerator fmtGen = null;
        pkgNode = this.packageType.findChildNode("StringFmt");
        if (pkgNode == null) {
            msg3 = String.valueOf(Messages.getString("TellerTransactionBuilder.Error_Unknown_package_type_[_98")) + "StringFmt" + Messages.getString("TellerTransactionBuilder.]_for_host_Server__s_request_!_99");
            super.reportProblem(2, msg3, this.srcFileName);
            return;
        }
        fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
        if (fmtBuilderClass == null) {
            msg2 = String.valueOf(Messages.getString("TellerTransactionBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_102")) + "StringFmt" + "]!";
            super.reportProblem(2, msg2, this.srcFileName);
            return;
        }
        try {
            fmtGen = (FormatGenerator)Class.forName(fmtBuilderClass).newInstance();
        }
        catch (Exception ee) {
            msg = String.valueOf(Messages.getString("TellerTransactionBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_102")) + "StringFmt" + "]!";
            super.reportProblem(2, msg, this.srcFileName);
            return;
        }
        XMLNode linkTasks = this.TellerTrxNode.getChild("trxLinks");
        if (linkTasks != null && linkTasks.getChilds() != null) {
            int i = 0;
            while (i < linkTasks.getChilds().size()) {
                XMLNode linkTask = (XMLNode)linkTasks.getChilds().elementAt(i);
                if (linkTask.getChild("linkOutData") == null || linkTask.getChild("linkOutData").getChilds() == null || linkTask.getChild("linkInData") == null || linkTask.getChild("linkInData").getChilds() == null) {
                    String msg6 = String.valueOf(Messages.getString("TellerTransactionBuilder._u4EA4_u6613_10")) + this.TellerTrxNode.getAttrValue("trxCode") + Messages.getString("TellerTransactionBuilder._u8054_u52A8__12") + linkTask.getAttrValue("trxCode") + Messages.getString("TellerTransactionBuilder._u5B9A_u4E49_u9519_u8BEF_14");
                    this.reportProblem(2, msg6, this.srcFileName);
                } else {
                    String inFmtId = this.TellerTrxNode.getAttrValue("trxCode") + "_" + linkTask.getAttrValue("trxCode") + "_inFmt";
                    String outFmtId = this.TellerTrxNode.getAttrValue("trxCode") + "_" + linkTask.getAttrValue("trxCode") + "_outFmt";
                    XMLNode refInFmtNode = new XMLNode();
                    refInFmtNode.setNodeName("refFormat");
                    refInFmtNode.setAttrValue("name", inFmtId);
                    refInFmtNode.setAttrValue("refId", inFmtId);
                    this.operationNode.add(refInFmtNode);
                    XMLNode inFmtNode = fmtGen.generateFormatNode(linkTask.getChild("linkInData"), this.dataDictionary, null);
                    inFmtNode.setAttrValue("id", inFmtId);
                    this.trxNode.add(inFmtNode);
                    XMLNode refOutFmtNode = new XMLNode();
                    refOutFmtNode.setNodeName("refFormat");
                    refOutFmtNode.setAttrValue("name", outFmtId);
                    refOutFmtNode.setAttrValue("refId", outFmtId);
                    this.operationNode.add(refOutFmtNode);
                    XMLNode outFmtNode = fmtGen.generateFormatNode(linkTask.getChild("linkOutData"), this.dataDictionary, null);
                    outFmtNode.setAttrValue("id", outFmtId);
                    this.trxNode.add(outFmtNode);
                }
                ++i;
            }
        }
        if ((viewsNode = this.TellerTrxNode.getChild("views")) != null && viewsNode.getChilds() != null) {
            int i = 0;
            while (i < viewsNode.getChilds().size()) {
                block46: {
                    XMLNode viewNode = null;
                    XMLNode tmpNode = (XMLNode)viewsNode.getChilds().elementAt(i);
                    if ("view".equals(tmpNode.getNodeName())) {
                        try {
                            viewNode = ((XMLNode)viewsNode.getChilds().elementAt(i)).getChild("viewDef").getChild("OperationPanel");
                        }
                        catch (Exception e) {
                            break block46;
                        }
                        if (viewNode != null && viewNode.getChilds() != null) {
                            int j = 0;
                            while (j < viewNode.getChilds().size()) {
                                XMLNode linkTask = (XMLNode)viewNode.getChilds().elementAt(j);
                                if (linkTask.getNodeName().equals("LinkBean") && linkTask.getAttrValue("linkTaskCode") != null && linkTask.getAttrValue("linkTaskCode").length() != 0) {
                                    if (linkTask.getChild("linkOutData") == null || linkTask.getChild("linkOutData").getChilds() == null || linkTask.getChild("linkInData") == null || linkTask.getChild("linkInData").getChilds() == null) {
                                        String msg7 = String.valueOf(Messages.getString("TellerTransactionBuilder._u4EA4_u6613_46")) + this.TellerTrxNode.getAttrValue("trxCode") + Messages.getString("TellerTransactionBuilder._u8054_u52A8__48") + linkTask.getAttrValue("linkTaskCode") + Messages.getString("TellerTransactionBuilder._u5B9A_u4E49_u9519_u8BEF_50");
                                        this.reportProblem(2, msg7, this.srcFileName);
                                    } else {
                                        String linkPoint = linkTask.getAttrValue("linkPoint");
                                        int idx = linkPoint.indexOf(46);
                                        linkPoint = linkPoint.substring(0, idx);
                                        String inFmtId = String.valueOf(linkPoint) + this.TellerTrxNode.getAttrValue("trxCode") + "_" + linkTask.getAttrValue("linkTaskCode") + "_inFmt";
                                        String outFmtId = String.valueOf(linkPoint) + this.TellerTrxNode.getAttrValue("trxCode") + "_" + linkTask.getAttrValue("linkTaskCode") + "_outFmt";
                                        XMLNode refInFmtNode = new XMLNode();
                                        refInFmtNode.setNodeName("refFormat");
                                        refInFmtNode.setAttrValue("name", inFmtId);
                                        refInFmtNode.setAttrValue("refId", inFmtId);
                                        this.operationNode.add(refInFmtNode);
                                        XMLNode inFmtNode = fmtGen.generateFormatNode(linkTask.getChild("linkInData"), this.dataDictionary, null);
                                        inFmtNode.setAttrValue("id", inFmtId);
                                        this.trxNode.add(inFmtNode);
                                        XMLNode refOutFmtNode = new XMLNode();
                                        refOutFmtNode.setNodeName("refFormat");
                                        refOutFmtNode.setAttrValue("name", outFmtId);
                                        refOutFmtNode.setAttrValue("refId", outFmtId);
                                        this.operationNode.add(refOutFmtNode);
                                        XMLNode outFmtNode = fmtGen.generateFormatNode(linkTask.getChild("linkOutData"), this.dataDictionary, null);
                                        outFmtNode.setAttrValue("id", outFmtId);
                                        this.trxNode.add(outFmtNode);
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        if ((fmtsNode = this.TellerTrxNode.getChild("formats")) == null || fmtsNode.getChilds().size() == 0) {
            return;
        }
        Vector childs = fmtsNode.getChilds();
        super.reportProblem(0, "Build Common packages ...", "");
        int i = 0;
        while (i < childs.size()) {
            XMLNode fmtNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(fmtNode.getNodeName())) {
                XMLNode fmtDefNode;
                String fmtId = fmtNode.getAttrValue("id");
                super.reportProblem(0, "Build package for format ID[" + fmtId + "]...", "");
                XMLNode datasNode = fmtNode.getChild("datas");
                if (datasNode != null && (fmtDefNode = this.genPackageFmt(null, datasNode)) != null) {
                    fmtDefNode.setAttrValue("id", fmtNode.getAttrValue("id"));
                    this.trxNode.add(fmtDefNode);
                    XMLNode refFmtNode = new XMLNode();
                    refFmtNode.setNodeName("refFormat");
                    refFmtNode.setAttrValue("name", fmtNode.getAttrValue("id"));
                    refFmtNode.setAttrValue("refId", fmtNode.getAttrValue("id"));
                    this.operationNode.add(refFmtNode);
                }
            }
            ++i;
        }
    }

    private XMLNode genPackageFmt(String headMsgID, XMLNode aNode) {
        String pkgType = aNode.getAttrValue("packageType");
        if (pkgType == null) {
            super.reportProblem(2, "packageType Not set!", "");
            return null;
        }
        XMLNode pkgNode = this.packageType.findChildNode(pkgType);
        if (pkgNode == null) {
            super.reportProblem(2, "packageType [" + pkgType + "] not found!", "");
        } else {
            String fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
            if (fmtBuilderClass == null) {
                String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_81")) + pkgType + "]!";
            } else {
                try {
                    FormatGenerator fmtGen = (FormatGenerator)Class.forName(fmtBuilderClass).newInstance();
                    fmtGen.setMessageHeadID(headMsgID);
                    XMLNode fmtNode = fmtGen.generateFormatNode(aNode, this.dataDictionary, null);
                    return fmtNode;
                }
                catch (Exception e) {
                    String msg = String.valueOf(Messages.getString("MCIProjectBuilder.Error_failed_to_build_request_fmt_for_host_[_85")) + "] Exception: " + e;
                    super.reportProblem(2, msg, "");
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void buildTellerView(String srcFile) {
        try {
            String filePath = this.dstPath;
            String fileName = null;
            this.TellerTrxNode = this.loadXMLContent(srcFile);
            String classify = null;
            try {
                classify = this.TellerTrxNode.getAttrValue("classify");
                super.createFolder(classify);
                if (classify != null && classify.length() > 0) {
                    filePath = String.valueOf(this.dstPath) + "/" + classify;
                }
            }
            catch (Exception e) {
                super.reportProblem(2, String.valueOf(Messages.getString("TellerTransactionBuilder.Faild_to_create_classify_folder_[_148")) + classify + "]. Exception: " + e, this.srcFileName);
            }
            String trxCode = this.TellerTrxNode.getAttrValue("trxCode");
            fileName = String.valueOf(trxCode) + "View.xml";
            XMLNode viewsNode = this.TellerTrxNode.getChild("views");
            if (viewsNode == null || viewsNode.getChilds() == null) {
                return;
            }
            int i = 0;
            while (i < viewsNode.getChilds().size()) {
                XMLNode viewNode = (XMLNode)viewsNode.getChilds().elementAt(i);
                if (!"#text".equals(viewNode.getNodeName())) {
                    fileName = String.valueOf(trxCode) + viewNode.getAttrValue("id");
                    XMLNode buildViewNode = (XMLNode)viewNode.getChild("viewDef").getChild("OperationPanel").clone();
                    XMLNode cloneViewNode = (XMLNode)buildViewNode.clone();
                    int j = 0;
                    while (j < cloneViewNode.getChilds().size()) {
                        XMLNode viewEle = (XMLNode)cloneViewNode.getChilds().elementAt(j);
                        if (viewEle.getNodeName().equals("LinkBean")) {
                            while (viewEle.getChilds().size() > 0) {
                                XMLNode childNode = (XMLNode)viewEle.getChilds().elementAt(0);
                                viewEle.remove(childNode);
                            }
                        }
                        ++j;
                    }
                    fileName = String.valueOf(filePath) + "/" + fileName;
                    this.saveXMLFile(fileName, cloneViewNode);
                }
                ++i;
            }
        }
        catch (Exception e) {
            super.reportProblem(2, String.valueOf(Messages.getString("TellerTransactionBuilder.Failed_to_build_the_Teller_View_!_Exception___160")) + e, srcFile);
        }
    }

    public void buildTellerReceiptReference() {
        try {
            String fileName = null;
            XMLNode voucherOutNode = new XMLNode();
            voucherOutNode.setNodeName("VoucherOutDefine");
            voucherOutNode.setAttrValue("id", "voucher");
            String classify = null;
            classify = this.TellerTrxNode.getAttrValue("classify");
            String trxCode = this.TellerTrxNode.getAttrValue("trxCode");
            fileName = "Receipt" + trxCode + ".xml";
            XMLNode receiptsNode = this.TellerTrxNode.getChild("receipts");
            if (receiptsNode == null || receiptsNode.getChilds() == null) {
                return;
            }
            int i = 0;
            while (i < receiptsNode.getChilds().size()) {
                XMLNode receiptNode = (XMLNode)receiptsNode.getChilds().elementAt(i);
                if (!"#text".equals(receiptNode.getNodeName())) {
                    String receiptID = receiptNode.getAttrValue("id");
                    XMLNode node = new XMLNode();
                    node.setNodeName("VoucherDef");
                    node.setAttrValue("id", receiptID);
                    node.setAttrValue("voucherType", "receipt");
                    String fName = String.valueOf(trxCode) + receiptID;
                    if (classify != null) {
                        fName = String.valueOf(classify) + "/" + fName;
                    }
                    node.setAttrValue("voucherDefFile", fName);
                    node.setAttrValue("voucherName", receiptNode.getAttrValue("voucherName"));
                    voucherOutNode.add(node);
                }
                ++i;
            }
            if (voucherOutNode.getChilds().size() > 0) {
                this.trxNode.add(voucherOutNode);
                XMLNode refSvcNode = new XMLNode();
                refSvcNode.setNodeName("refService");
                refSvcNode.setAttrValue("refId", "voucher");
                refSvcNode.setAttrValue("alias", "voucher");
                refSvcNode.setAttrValue("type", "voucher");
                this.contextNode.add(refSvcNode);
            }
        }
        catch (Exception e) {
            super.reportProblem(2, String.valueOf(Messages.getString("TellerTransactionBuilder.Failed_to_build_the_Teller_Receipt_!_Exception___176")) + e, "");
        }
    }

    public void buildTellerReceipt(String srcFile) {
        try {
            String filePath = this.dstPath;
            String fileName = null;
            this.TellerTrxNode = this.loadXMLContent(srcFile);
            XMLNode voucherOutNode = new XMLNode();
            voucherOutNode.setNodeName("VoucherOutDefine");
            voucherOutNode.setAttrValue("id", "voucher");
            String classify = null;
            try {
                classify = this.TellerTrxNode.getAttrValue("classify");
                super.createFolder(classify);
                if (classify != null && classify.length() > 0) {
                    filePath = String.valueOf(this.dstPath) + "/" + classify;
                }
            }
            catch (Exception e) {
                super.reportProblem(2, String.valueOf(Messages.getString("TellerTransactionBuilder.Faild_to_create_classify_folder_[_163")) + classify + "]. Exception: " + e, this.srcFileName);
            }
            String trxCode = this.TellerTrxNode.getAttrValue("trxCode");
            fileName = "Receipt" + trxCode + ".xml";
            XMLNode receiptsNode = this.TellerTrxNode.getChild("receipts");
            if (receiptsNode == null || receiptsNode.getChilds() == null) {
                return;
            }
            int i = 0;
            while (i < receiptsNode.getChilds().size()) {
                XMLNode receiptNode = (XMLNode)receiptsNode.getChilds().elementAt(i);
                if (!"#text".equals(receiptNode.getNodeName())) {
                    String receiptID = receiptNode.getAttrValue("id");
                    fileName = String.valueOf(trxCode) + receiptID;
                    XMLNode buildReceiptNode = (XMLNode)receiptNode.getChild("receiptDef").getChild("Receipt").clone();
                    fileName = String.valueOf(filePath) + "/" + fileName;
                    this.saveXMLFile(fileName, buildReceiptNode);
                    XMLNode node = new XMLNode();
                    node.setNodeName("VoucherDef");
                    node.setAttrValue("id", receiptID);
                    node.setAttrValue("voucherType", "receipt");
                    String fName = String.valueOf(trxCode) + receiptID;
                    if (classify != null) {
                        fName = String.valueOf(classify) + "/" + fName;
                    }
                    node.setAttrValue("voucherDefFile", fName);
                    node.setAttrValue("voucherName", receiptNode.getAttrValue("name"));
                    voucherOutNode.add(node);
                }
                ++i;
            }
            if (voucherOutNode.getChilds().size() > 0) {
                this.trxNode.add(voucherOutNode);
            }
        }
        catch (Exception e) {
            super.reportProblem(2, String.valueOf(Messages.getString("TellerTransactionBuilder.Failed_to_build_the_Teller_Receipt_!_Exception___176")) + e, srcFile);
        }
    }

    private void addDataDefine(XMLNode dataNode, XMLNode dictionaryNode, String defaultValue) {
        String nodeName = dictionaryNode.getNodeName();
        XMLNode node = new XMLNode();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            node.setNodeName("field");
            node.setAttrValue("id", dictionaryNode.getAttrValue("id"));
            if (defaultValue != null) {
                node.setAttrValue("value", defaultValue);
            } else {
                node.setAttrValue("value", dictionaryNode.getAttrValue("value"));
            }
            dataNode.add(node);
        } else if (nodeName.equals("dataCollection")) {
            node.setNodeName("iColl");
            node.setAttrValue("id", dictionaryNode.getAttrValue("id"));
            dataNode.add(node);
            XMLNode kNode = new XMLNode();
            kNode.setNodeName("kColl");
            node.add(kNode);
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.addDataDefine(kNode, aNode, null);
                }
                ++i;
            }
        } else if (nodeName.equals("refData")) {
            node.setNodeName("field");
            node.setAttrValue("id", dictionaryNode.getAttrValue("refId"));
            node.setAttrValue("value", dictionaryNode.getAttrValue("value"));
            dataNode.add(node);
        }
    }

    public XMLNode getFlow() {
        return this.flow;
    }

    public void setFlow(XMLNode flow) {
        this.flow = flow;
    }
}

