/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.document.word.WordDocument;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualContentToImage;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.File;
import java.util.Enumeration;

public class TellerTrxDesignDocumentBuilder
extends AbstractBuilder {
    private String srcFileName = null;
    WordDocument document = null;
    private XMLNode dataDictionary;
    private XMLNode formatHeader;
    private XMLNode service;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile serviceEditorProfile;
    private EditorProfile viewEditorProfile;
    private EditorProfile receiptEditorProfile;
    private XMLLoader xmlLoader = null;
    private XMLNode TellerTrxNode;

    public void setFlowEditorProfile(EditorProfile profile) {
        this.flowEditorProfile = profile;
    }

    public void setServiceEditorProfile(EditorProfile profile) {
        this.serviceEditorProfile = profile;
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setServerFmtHeader(XMLNode node) {
        this.formatHeader = node;
    }

    public void setViewEditorProfile(EditorProfile profile) {
        this.viewEditorProfile = profile;
    }

    public void setReceiptEditorProfile(EditorProfile profile) {
        this.receiptEditorProfile = profile;
    }

    public void buildTellerTrxDesignDocument(String srcFile, WordDocument doc) {
        this.srcFileName = srcFile;
        this.document = doc;
        try {
            this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Load_Teller_Transaction_File_..._1"));
            String filePath = this.dstPath;
            this.TellerTrxNode = this.loadXMLContent(srcFile);
            this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Building_the_Teller_Transaction_design_File_..._2"), 1);
            String classify = null;
            try {
                classify = this.TellerTrxNode.getAttrValue("classify");
                super.createFolder(classify);
                if (classify != null && classify.length() > 0) {
                    filePath = String.valueOf(this.dstPath) + "/" + classify;
                }
            }
            catch (Exception e) {
                super.reportProblem(2, String.valueOf(Messages.getString("TellerTrxDesignDocumentBuilder.Faild_to_create_classify_folder_[_3")) + classify + "]. Exception: " + e, this.srcFileName);
            }
            String trxCode = this.TellerTrxNode.getAttrValue("trxCode");
            String trxName = this.TellerTrxNode.getAttrValue("trxName");
            String trxDes = this.TellerTrxNode.getDocument();
            String srvTrxCode = this.TellerTrxNode.getAttrValue("srvTrxCode");
            this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Build_Teller_Transaction_Description_3"));
            this.document.find(Messages.getString("TellerTrxDesignDocumentBuilder.Teller_u4EA4_u6613_u540D_u79F0_10"));
            this.document.typeText(trxName);
            this.document.moveDown(5, 2);
            this.document.gotoFirst(1);
            this.document.find(Messages.getString("TellerTrxDesignDocumentBuilder._u4EA4_u6613_u5C5E_u6027_u5B9A_u4E49_11"));
            this.document.moveDown(5, 1);
            this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_12"));
            this.document.typeText(trxDes);
            String[] titles = new String[]{"", "", "", "", ""};
            this.document.addTable(2, 4, titles);
            this.document.moveUp(5, 1);
            this.document.moveRight(1, 1);
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u4EA4_u6613_u540D_u79F0_uFF1A_18"));
            this.document.moveRight(1, 1);
            this.document.typeText(trxName);
            this.document.moveRight(1, 1);
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u4EA4_u6613_u63CF_u8FF0_uFF1A_20"));
            this.document.moveRight(1, 1);
            this.document.moveRight(1, 1);
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u4EA4_u6613_u7801_uFF1A_22"));
            this.document.moveRight(1, 1);
            this.document.typeText(trxCode);
            this.document.moveRight(1, 1);
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u670D_u52A1_u5668_u4EA4_u6613_u7801_uFF1A_24"));
            this.document.moveRight(1, 1);
            this.document.typeText(srvTrxCode);
            this.document.insertRowsBelow(1);
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder.Operation_u540D_u79F0_uFF1A_26"));
            this.document.moveRight(1, 1);
            this.document.typeText(String.valueOf(trxCode) + "SrvOp");
            this.document.moveRight(1, 1);
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u91D1_u878D_u4EA4_u6613_uFF1A_28"));
            this.document.moveRight(1, 1);
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u672A_u5B9E_u73B0_29"));
            this.buildData();
            this.buildView();
            this.buildFormats();
            this.buildFlow();
            this.buildServices();
            this.buildReceipt();
            this.buildLinkTask();
            String fileName = String.valueOf(filePath) + Messages.getString("TellerTrxDesignDocumentBuilder./Teller_u4EA4_u6613__30") + trxName + "_" + trxCode + Messages.getString("TellerTrxDesignDocumentBuilder.__u8BE6_u7EC6_u8BBE_u8BA1_u6587_u6863.doc_32");
            this.saveFile(fileName);
        }
        catch (Exception e) {
            String fileName = String.valueOf(this.dstPath) + "errorTellerTrxDocument.doc";
            this.saveFile(fileName);
            e.printStackTrace();
            super.reportProblem(2, String.valueOf(Messages.getString("TellerTrxDesignDocumentBuilder.Failed_to_build_the_mci_transaction_!_Exception___33")) + e, this.srcFileName);
        }
        this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Build_finished._4"), 10);
    }

    private void buildServices() {
        this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Build_Teller_Transaction_Service_Description_5"), 1);
        XMLNode servicesNode = this.TellerTrxNode.getChild("services");
        if (servicesNode == null || servicesNode.getChilds() == null) {
            return;
        }
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerTrxDesignDocumentBuilder._u670D_u52A1_u5B9A_u4E49_36"));
        int i = 0;
        while (i < servicesNode.getChilds().size()) {
            XMLNode serviceNode = (XMLNode)servicesNode.getChilds().elementAt(i);
            if (!"#text".equals(serviceNode.getNodeName())) {
                String svcId = serviceNode.getAttrValue("id");
                this.document.moveDown(5, 1);
                this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6807_u9898_3_38"));
                this.document.typeText(svcId + "\r\n");
                this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_41"));
                String[] titles = new String[]{Messages.getString("TellerTrxDesignDocumentBuilder._u670D_u52A1ID_42"), Messages.getString("TellerTrxDesignDocumentBuilder._u670D_u52A1_u7C7B_u578B_43"), Messages.getString("TellerTrxDesignDocumentBuilder._u8BF4_u660E_44"), ""};
                this.document.addTable(2, 3, titles);
                this.document.typeText(svcId);
                this.document.moveRight(1, 1);
                this.document.typeText(serviceNode.getNodeName());
                this.document.moveRight(1, 1);
                this.document.typeText(serviceNode.getDocument());
                this.document.moveDown(5, 1);
                this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u5B9A_u4E49_u63CF_u8FF0_uFF1A_50"));
                this.document.moveDown(5, 1);
                StringBuffer sBuff = new StringBuffer();
                serviceNode.toXMLContent(0, sBuff);
                this.document.typeText(String.valueOf(sBuff.toString()) + "\r\n");
            }
            ++i;
        }
    }

    void buildView() {
        try {
            this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Build_Teller_Transaction_View_Description_6"), 1);
            XMLNode viewsNode = this.TellerTrxNode.getChild("views");
            if (viewsNode == null || viewsNode.getChilds().size() == 0) {
                return;
            }
            this.document.moveToHome();
            this.document.gotoFirst(1);
            this.document.find(Messages.getString("TellerTrxDesignDocumentBuilder._u4EA4_u6613_u753B_u9762_u5B9A_u4E49_53"));
            this.document.moveDown(5, 1);
            int i = 0;
            while (i < viewsNode.getChilds().size()) {
                XMLNode viewNode = (XMLNode)viewsNode.getChilds().elementAt(i);
                if (!"#text".equals(viewNode.getNodeName())) {
                    String viewID = viewNode.getAttrValue("id");
                    String viewType = viewNode.getAttrValue("viewType");
                    String viewFileName = viewNode.getAttrValue("viewFileName");
                    XMLNode buildViewNode = (XMLNode)viewNode.getChild("viewDef").getChild("OperationPanel").clone();
                    this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6807_u9898_3_59"));
                    this.document.typeText(String.valueOf(Messages.getString("TellerTrxDesignDocumentBuilder._u753B_u9762_uFF1A__60")) + viewID + "\r\n");
                    this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_62"));
                    String[] title = new String[]{Messages.getString("TellerTrxDesignDocumentBuilder._u753B_u9762ID_63"), Messages.getString("TellerTrxDesignDocumentBuilder._u753B_u9762_u7C7B_u578B_64"), Messages.getString("TellerTrxDesignDocumentBuilder._u753B_u9762_u6587_u4EF6_65"), ""};
                    this.document.addTable(2, 3, title);
                    this.document.typeText(viewID);
                    this.document.moveRight(1, 1);
                    this.document.typeText(viewType);
                    this.document.moveRight(1, 1);
                    this.document.typeText(viewFileName);
                    this.document.moveRight(1, 1);
                    this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u5B9A_u4E49_uFF1A_r_n_69"));
                    StringBuffer sBuff = new StringBuffer();
                    buildViewNode.toXMLContent(0, sBuff);
                    this.document.typeText(String.valueOf(sBuff.toString()) + "\r\n");
                    this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u753B_u9762_u663E_u793A_uFF1A_r_n_71"));
                    VisualContentToImage visual = new VisualContentToImage();
                    try {
                        visual.setFlowEditorProfile(this.viewEditorProfile);
                        visual.setXMLContent(buildViewNode);
                        visual.saveToImageFile(String.valueOf(this.dstPath) + "/viewImage_" + viewID + ".jpg", 0);
                        visual.isImageOK();
                        this.document.addPicture(String.valueOf(this.dstPath) + "/viewImage_" + viewID + ".jpg");
                        File imageFile = new File(String.valueOf(this.dstPath) + "/viewImage_" + viewID + ".jpg");
                        imageFile.delete();
                        this.document.typeText("\r\n");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            super.reportProblem(2, String.valueOf(Messages.getString("TellerTrxDesignDocumentBuilder.Failed_to_build_the_Teller_View_!_Exception___79")) + e, this.srcFileName);
        }
    }

    void buildReceipt() {
        try {
            this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Build_Teller_Transaction_Receipt_Description_7"), 1);
            XMLNode receiptsNode = this.TellerTrxNode.getChild("receipts");
            if (receiptsNode == null || receiptsNode.getChilds().size() == 0) {
                return;
            }
            this.document.moveToHome();
            this.document.gotoFirst(1);
            this.document.find(Messages.getString("TellerTrxDesignDocumentBuilder._u51ED_u8BC1_u5B9A_u4E49_82"));
            this.document.moveDown(5, 1);
            int i = 0;
            while (i < receiptsNode.getChilds().size()) {
                XMLNode receiptNode = (XMLNode)receiptsNode.getChilds().elementAt(i);
                if (!"#text".equals(receiptNode.getNodeName())) {
                    String receiptID = receiptNode.getAttrValue("id");
                    XMLNode buildReceiptNode = (XMLNode)receiptNode.getChild("receiptDef").getChild("Receipt").clone();
                    String outputCondition = buildReceiptNode.getAttrValue("outputCondition");
                    String viewName = buildReceiptNode.getAttrValue("name");
                    this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6807_u9898_3_88"));
                    this.document.typeText(String.valueOf(Messages.getString("TellerTrxDesignDocumentBuilder._u51ED_u8BC1_uFF1A__89")) + receiptID + "\r\n");
                    this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_91"));
                    String[] title = new String[]{Messages.getString("TellerTrxDesignDocumentBuilder._u51ED_u8BC1ID_92"), Messages.getString("TellerTrxDesignDocumentBuilder._u8F93_u51FA_u6761_u4EF6_93"), Messages.getString("TellerTrxDesignDocumentBuilder._u51ED_u8BC1_u540D_u79F0_94"), ""};
                    this.document.addTable(2, 3, title);
                    this.document.typeText(receiptID);
                    this.document.moveRight(1, 1);
                    this.document.typeText(outputCondition);
                    this.document.moveRight(1, 1);
                    this.document.typeText(viewName);
                    this.document.moveRight(1, 1);
                    this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u5B9A_u4E49_uFF1A_r_n_98"));
                    StringBuffer sBuff = new StringBuffer();
                    buildReceiptNode.toXMLContent(0, sBuff);
                    this.document.typeText(String.valueOf(sBuff.toString()) + "\r\n");
                    this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u51ED_u8BC1_u6837_u5F0F_uFF1A_r_n_100"));
                    VisualContentToImage visual = new VisualContentToImage();
                    try {
                        visual.setFlowEditorProfile(this.receiptEditorProfile);
                        visual.setXMLContent(buildReceiptNode);
                        visual.saveToImageFile(String.valueOf(this.dstPath) + "/receiptImage_" + receiptID + ".jpg", 0);
                        visual.isImageOK();
                        this.document.addPicture(String.valueOf(this.dstPath) + "/receiptImage_" + receiptID + ".jpg");
                        File imageFile = new File(String.valueOf(this.dstPath) + "/receiptImage_" + receiptID + ".jpg");
                        imageFile.delete();
                        this.document.typeText("\r\n");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            super.reportProblem(2, String.valueOf(Messages.getString("TellerTrxDesignDocumentBuilder.Failed_to_build_the_Receipt_!_Exception___108")) + e, this.srcFileName);
        }
    }

    private void buildFlow() {
        if (this.document == null) {
            return;
        }
        this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Build_Teller_Transaction_Flow_Description_8"), 1);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerTrxDesignDocumentBuilder._u6D41_u7A0B_u5B9A_u4E49_112"));
        this.document.moveDown(5, 1);
        this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_113"));
        String refFlowFlag = this.TellerTrxNode.getAttrValue("refToMainFlow");
        if (refFlowFlag != null && "true".equals(refFlowFlag)) {
            XMLNode refFlowNode = this.TellerTrxNode.getChild("refFlow");
            if (refFlowNode == null) {
                return;
            }
            String flowID = refFlowNode.getAttrValue("refId");
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u5F15_u7528_u4E3B_u6D41_u7A0B_uFF1A_117"));
            this.document.typeText(flowID + "\r\n");
            return;
        }
        XMLNode flowNode = this.TellerTrxNode.getChild("flow");
        if (flowNode == null) {
            return;
        }
        if (flowNode.getAttrValue("refFlow") != null && flowNode.getAttrValue("refFlow").length() > 0) {
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u5F15_u7528_u4E3B_u6D41_u7A0B_uFF1A_117"));
            this.document.typeText(flowNode.getAttrValue("refFlow") + "\r\n");
        }
        if (flowNode.getChilds() == null || flowNode.getChilds().size() == 0) {
            return;
        }
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerTrxDesignDocumentBuilder._u516C_u5171_u6D41_u7A0B_u5B9A_u4E49_121"));
        this.document.moveDown(5, 1);
        this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_122"));
        String flowID = flowNode.getAttrValue("id");
        XMLNode stepsNode = new XMLNode();
        stepsNode.setNodeName("flow");
        stepsNode.setAttrValue("id", flowID);
        this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6807_u9898_3_126"));
        this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u6D41_u7A0B_uFF1A_127"));
        this.document.typeText(flowNode.getAttrValue("id") + "\r\n");
        this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_131"));
        int i = 0;
        while (i < flowNode.getChilds().size()) {
            XMLNode actionStepNode = (XMLNode)flowNode.getChilds().elementAt(i);
            String nodeName = actionStepNode.getNodeName();
            if (!("#text".equals(nodeName) || "status".equals(nodeName) || "END".equals(nodeName))) {
                XMLNode stepNode = new XMLNode();
                stepsNode.add(stepNode);
                stepNode.setNodeName("opStep");
                stepNode.setAttrValue("id", actionStepNode.getAttrValue("name"));
                Enumeration keys = actionStepNode.getAttrs().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height") || key.equals("id") || key.equals("implClass")) continue;
                    stepNode.setAttrValue(key, actionStepNode.getAttrValue(key));
                }
                if (actionStepNode.getChilds() != null) {
                    int k = 0;
                    while (k < actionStepNode.getChilds().size()) {
                        XMLNode transitionNode = (XMLNode)actionStepNode.getChilds().elementAt(k);
                        String dst = transitionNode.getAttrValue("dest");
                        String idStr = transitionNode.getAttrValue("id");
                        if (dst != null && idStr != null) {
                            String key = "on" + idStr + "Do";
                            stepNode.setAttrValue(key, dst);
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
        StringBuffer sBuff = new StringBuffer();
        stepsNode.toXMLContent(0, sBuff);
        this.document.typeText(String.valueOf(sBuff.toString()) + "\r\n");
        this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u5982_u56FE_uFF1A_r_n_149"));
        VisualContentToImage visual = new VisualContentToImage();
        try {
            visual.setFlowEditorProfile(this.flowEditorProfile);
            visual.setXMLContent(flowNode);
            visual.saveToImageFile(String.valueOf(this.dstPath) + "/flowImage_" + flowID + ".jpg", 0);
            visual.isImageOK();
            this.document.addPicture(String.valueOf(this.dstPath) + "/flowImage_" + flowID + ".jpg");
            File imageFile = new File(String.valueOf(this.dstPath) + "/flowImage_" + flowID + ".jpg");
            imageFile.delete();
            this.document.typeText("\r\n");
        }
        catch (Exception e) {
            return;
        }
    }

    private void buildData() {
        this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Build_Teller_Transaction_Data_Description_9"), 1);
        XMLNode datas = this.TellerTrxNode.getChild("datas");
        if (datas == null || datas.getChilds() == null) {
            return;
        }
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerTrxDesignDocumentBuilder._u4EA4_u6613_u6570_u636E_u5B9A_u4E49_158"));
        this.document.moveDown(5, 1);
        this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_159"));
        String[] titles = new String[]{Messages.getString("TellerTrxDesignDocumentBuilder._u540D_u79F0_160"), Messages.getString("TellerTrxDesignDocumentBuilder._u4E2D_u6587_u540D_u79F0_161"), Messages.getString("TellerTrxDesignDocumentBuilder._u7C7B_u578B_162"), Messages.getString("TellerTrxDesignDocumentBuilder._u63CF_u8FF0_163"), "\u7f3a\u7701\u503c", ""};
        this.document.addTable(2, 5, titles);
        int i = 0;
        while (i < datas.getChilds().size()) {
            XMLNode refNode = (XMLNode)datas.getChilds().elementAt(i);
            if (!"#text".equals(refNode.getNodeName())) {
                String refId = refNode.getAttrValue("refId");
                String defaultValue = refNode.getAttrValue("defaultValue");
                XMLNode childNode = this.dataDictionary.findChildNode(refId);
                if (childNode == null) {
                    String msg = String.valueOf(Messages.getString("TellerTrxDesignDocumentBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_166")) + refId + "]!";
                    super.reportProblem(2, msg, this.srcFileName);
                } else if ("private".equals(childNode.getAttrValue("access"))) {
                    this.addDataDefine(childNode, defaultValue);
                    this.document.insertRowsBelow(1);
                }
            }
            ++i;
        }
    }

    private void buildFormats() {
        XMLNode repNode;
        if (this.document == null) {
            return;
        }
        this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Build_Teller_Transaction_Format_Description_10"), 2);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerTrxDesignDocumentBuilder._u670D_u52A1_u5668_u8BBF_u95EE_u53CA_u62A5_u6587_u5B9A_u4E49_171"));
        XMLNode reqNode = this.TellerTrxNode.getChild("srvRequest");
        if (reqNode != null && reqNode.getChilds() != null && reqNode.getChilds().size() > 0) {
            this.document.moveDown(5, 1);
            this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6807_u9898_3_173"));
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u8BF7_u6C42_u62A5_u6587_uFF1A_r_n_174"));
            this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_175"));
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u5F15_u7528_u62A5_u6587_u5934_uFF1A_176"));
            if ("true".equals(this.TellerTrxNode.getAttrValue("refReqHead"))) {
                this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u65E0_r_n_179"));
            } else {
                this.document.typeText("SisalRequestFmt\r\n");
            }
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u62A5_u6587_u4F53_uFF1A_r_n_181"));
            try {
                String[] fieldNames = new String[]{Messages.getString("TellerTrxDesignDocumentBuilder._u540D_u79F0_182"), Messages.getString("TellerTrxDesignDocumentBuilder._u4E2D_u6587_u540D_u79F0_183"), Messages.getString("TellerTrxDesignDocumentBuilder._u5907_u6CE8_184"), ""};
                this.document.addTable(2, 3, fieldNames);
                int k = 0;
                while (k < reqNode.getChilds().size()) {
                    XMLNode reqField = (XMLNode)reqNode.getChilds().elementAt(k);
                    if (!"#text".equals(reqField.getNodeName())) {
                        String refId = reqField.getAttrValue("refId");
                        this.document.typeText(refId);
                        this.document.moveRight(1, 1);
                        try {
                            XMLNode childNode = this.dataDictionary.findChildNode(refId);
                            this.document.typeText(childNode.getAttrValue("label"));
                            this.document.moveRight(1, 1);
                            if ("refColl".equals(reqField.getNodeName())) {
                                this.document.typeText("iColl");
                            }
                        }
                        catch (Exception childNode) {
                            // empty catch block
                        }
                        this.document.insertRowsBelow(1);
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                String msg = String.valueOf(Messages.getString("TellerTrxDesignDocumentBuilder.Error_failed_to_build_request_fmt_for_Server_Exception___192")) + e;
                super.reportProblem(2, msg, this.srcFileName);
                e.printStackTrace();
            }
        }
        if ((repNode = this.TellerTrxNode.getChild("srvReply")) != null && repNode.getChilds() != null && repNode.getChilds().size() > 0) {
            this.document.moveDown(5, 1);
            this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6807_u9898_3_195"));
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u54CD_u5E94_u62A5_u6587_uFF1A_r_n_196"));
            this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_197"));
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u5F15_u7528_u62A5_u6587_u5934_uFF1A_198"));
            if ("true".equals(this.TellerTrxNode.getAttrValue("refRepHead"))) {
                this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u65E0_r_n_201"));
            } else {
                this.document.typeText("SisalReplyFmt\r\n");
            }
            this.document.typeText(Messages.getString("TellerTrxDesignDocumentBuilder._u62A5_u6587_u4F53_uFF1A_r_n_203"));
            try {
                String[] fieldNames = new String[]{Messages.getString("TellerTrxDesignDocumentBuilder._u540D_u79F0_204"), Messages.getString("TellerTrxDesignDocumentBuilder._u4E2D_u6587_u540D_u79F0_205"), Messages.getString("TellerTrxDesignDocumentBuilder._u5907_u6CE8_206"), ""};
                this.document.addTable(2, 3, fieldNames);
                int k = 0;
                while (k < repNode.getChilds().size()) {
                    XMLNode repField = (XMLNode)repNode.getChilds().elementAt(k);
                    if (!"#text".equals(repField.getNodeName())) {
                        String refId = repField.getAttrValue("refId");
                        this.document.typeText(refId);
                        this.document.moveRight(1, 1);
                        try {
                            XMLNode childNode = this.dataDictionary.findChildNode(refId);
                            this.document.typeText(childNode.getAttrValue("label"));
                            this.document.moveRight(1, 1);
                            if ("refColl".equals(repField.getNodeName())) {
                                this.document.typeText("iColl");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.document.insertRowsBelow(1);
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                String msg = String.valueOf(Messages.getString("TellerTrxDesignDocumentBuilder.Error_failed_to_build_request_fmt_for_Server_Exception___214")) + e;
                super.reportProblem(2, msg, this.srcFileName);
                e.printStackTrace();
            }
        }
    }

    private void buildLinkTask() {
        this.reportProgress(Messages.getString("TellerTrxDesignDocumentBuilder.Build_Teller_Transaction_Link_Description_11"), 1);
        XMLNode linkTasks = this.TellerTrxNode.getChild("trxLinks");
        if (linkTasks == null || linkTasks.getChilds() == null || linkTasks.getChilds().size() == 0) {
            return;
        }
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("TellerTrxDesignDocumentBuilder._u8054_u52A8_u4EA4_u6613_u5B9A_u4E49_12"));
        this.document.moveDown(5, 1);
        this.document.setStyle(Messages.getString("TellerTrxDesignDocumentBuilder._u6B63_u6587_159"));
        String[] titles = new String[]{Messages.getString("TellerTrxDesignDocumentBuilder._u8054_u52A8_u4EA4_u6613_13"), Messages.getString("TellerTrxDesignDocumentBuilder._u8054_u52A8_u65B9_u5F0F_14"), Messages.getString("TellerTrxDesignDocumentBuilder._u8054_u52A8_u6761_u4EF6_15"), Messages.getString("TellerTrxDesignDocumentBuilder._u4F20_u51FA_u6570_u636E_16"), Messages.getString("TellerTrxDesignDocumentBuilder._u4F20_u5165_u6570_u636E_17"), ""};
        this.document.addTable(2, 5, titles);
        int i = 0;
        while (i < linkTasks.getChilds().size()) {
            XMLNode linkTask = (XMLNode)linkTasks.getChilds().elementAt(i);
            if (!"#text".equals(linkTask.getNodeName())) {
                this.document.typeText(linkTask.getAttrValue("trxCode"));
                this.document.moveRight(1, 1);
                this.document.typeText(linkTask.getAttrValue("linkType"));
                this.document.moveRight(1, 1);
                this.document.typeText(linkTask.getAttrValue("condition"));
                this.document.moveRight(1, 1);
                XMLNode outNode = linkTask.getChild("linkOutData");
                if (outNode != null) {
                    String outData = "";
                    int j = 0;
                    while (outNode.getChilds() != null && j < outNode.getChilds().size()) {
                        XMLNode aNode = (XMLNode)outNode.getChilds().elementAt(j);
                        if (!"#text".equals(aNode.getNodeName())) {
                            outData = String.valueOf(outData) + aNode.getAttrValue("refId") + ";";
                        }
                        ++j;
                    }
                    this.document.typeText(outData);
                }
                this.document.moveRight(1, 1);
                XMLNode inNode = linkTask.getChild("linkInData");
                if (inNode != null) {
                    String inData = "";
                    int j = 0;
                    while (inNode.getChilds() != null && j < inNode.getChilds().size()) {
                        XMLNode aNode = (XMLNode)inNode.getChilds().elementAt(j);
                        if (!"#text".equals(aNode.getNodeName())) {
                            inData = String.valueOf(inData) + aNode.getAttrValue("refId") + ";";
                        }
                        ++j;
                    }
                    this.document.typeText(inData);
                }
                this.document.insertRowsBelow(1);
            }
            ++i;
        }
    }

    private void saveFile(String fileName) {
        try {
            this.document.saveAs(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDataDefine(XMLNode dictionaryNode, String defaultValue) {
        String nodeName = dictionaryNode.getNodeName();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getDocument());
            if (defaultValue != null) {
                this.document.moveRight(1, 1);
                this.document.typeText(defaultValue);
            }
        } else if (nodeName.equals("dataCollection")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 2);
            this.document.typeText(" " + dictionaryNode.getDocument());
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.document.insertRowsBelow(1);
                    this.document.typeText(String.valueOf(dictionaryNode.getAttrValue("id")) + ".");
                    this.addDataDefine(aNode, null);
                }
                ++i;
            }
        } else if (nodeName.equals("refData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
        } else if (nodeName.equals("selectData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getDocument());
            if (dictionaryNode.getAttrValue("refDataColl") != null) {
                this.document.typeText(" " + dictionaryNode.getAttrValue("refDataColl"));
            }
            if (dictionaryNode.getAttrValue("values") != null) {
                this.document.typeText(" " + dictionaryNode.getAttrValue("values"));
            }
        }
    }
}

