/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.io.File;
import java.util.Vector;
import org.eclipse.core.resources.IProject;

public class UIFBuilder
extends AbstractBuilder {
    private XMLNode dataDictionary;
    private XMLNode flow;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;

    public void buildUIFModel(String srcFile) {
        this.srcFileName = srcFile;
        try {
            XMLNode action;
            XMLNode uiFlow = this.loadXMLContent(this.srcFileName);
            if (uiFlow == null) {
                return;
            }
            XMLNode destNode = new XMLNode("actionDefines");
            destNode.add(uiFlow);
            Vector<XMLNode> actions = new Vector<XMLNode>();
            Vector bizs = new Vector();
            int i = 0;
            while (i < uiFlow.getChilds().size()) {
                XMLNode child = (XMLNode)uiFlow.getChilds().elementAt(i);
                if (!"#text".equals(child.getNodeName())) {
                    if ("viewAction".equals(child.getNodeName())) {
                        actions.add(child);
                    }
                    if ("bizAction".equals(child.getNodeName())) {
                        actions.add(child);
                    }
                }
                ++i;
            }
            uiFlow.removeAllChilds();
            uiFlow = this.removeAttr(uiFlow);
            XMLNode actionList = new XMLNode("List");
            actionList.setAttrValue("name", "actions");
            uiFlow.add(actionList);
            XMLNode viewMap = new XMLNode("Map");
            viewMap.setAttrValue("name", "views");
            uiFlow.add(viewMap);
            XMLNode refFlow = new XMLNode("refFlow");
            refFlow.setAttrValue("flowId", uiFlow.getAttrValue("bizId"));
            uiFlow.add(refFlow);
            int i2 = 0;
            while (i2 < actions.size()) {
                action = (XMLNode)actions.elementAt(i2);
                if ("viewAction".equals(action.getNodeName())) {
                    XMLNode jspView = new XMLNode("jspView");
                    jspView.setAttrValue("id", action.getAttrValue("id"));
                    jspView.setAttrValue("url", action.getAttrValue("url"));
                    viewMap.add(jspView);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < actions.size()) {
                action = (XMLNode)actions.elementAt(i2);
                action = this.removeAttr(action);
                actionList.add(action);
                ++i2;
            }
            File file = new File(srcFile);
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            this.saveXMLFile(String.valueOf(this.dstPath) + "/" + fileName + ".xml", destNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static UIFBuilder getInstance(IProject prj) {
        IDEProjectSettings prjSettings = IDEContent.getPRJSettings(prj);
        String settingsPath = String.valueOf(prjSettings.getWebContentPath()) + "/WEB-INF";
        String targetPath = prj.getLocation() + "/" + settingsPath;
        UIFBuilder builder = new UIFBuilder();
        builder.setOutputPath(targetPath);
        if (prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(prjSettings.getXMLEncoding());
        }
        return builder;
    }

    private XMLNode removeAttr(XMLNode node) {
        node.setAttrValue("x", null);
        node.setAttrValue("y", null);
        node.setAttrValue("width", null);
        node.setAttrValue("height", null);
        node.setAttrValue("url", null);
        node.setAttrValue("name", null);
        node.setAttrValue("fileName", null);
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode child = (XMLNode)node.getChilds().elementAt(i);
            XMLNode xMLNode = this.removeAttr(child);
            ++i;
        }
        return node;
    }
}

