/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;

public class WFBuilder
extends AbstractBuilder {
    private XMLNode wfsNode = new XMLNode();
    private XMLNode modelDefNode = null;

    public void buildWFModel(String srcFile) {
        this.srcFileName = srcFile;
        try {
            this.reportProgress("Load WorkFlow File: " + this.srcFileName, 1);
            this.wfsNode.setNodeName("wfs");
            this.modelDefNode = this.loadXMLContent(this.srcFileName);
            XMLNode wfNode = new XMLNode("wf");
            this.addWFNodeAtrr(this.modelDefNode, wfNode);
            int i = 0;
            while (i < this.modelDefNode.getChilds().size()) {
                XMLNode childNode = (XMLNode)this.modelDefNode.getChilds().elementAt(i);
                XMLNode node = new XMLNode("node");
                this.addWFNodeAtrr(childNode, node);
                int j = 0;
                while (j < childNode.getChilds().size()) {
                    XMLNode routeNode = new XMLNode("route");
                    XMLNode childChildNode = (XMLNode)childNode.getChilds().elementAt(j);
                    if (!"#text".equals(childChildNode.getNodeName())) {
                        this.addRouteAttr(routeNode, childChildNode);
                        node.add(routeNode);
                    }
                    ++j;
                }
                wfNode.add(node);
                ++i;
            }
            this.wfsNode.add(wfNode);
            File file = new File(this.srcFileName);
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            this.saveXMLFile(String.valueOf(this.dstPath) + "/" + fileName + ".xml", this.wfsNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addWFNodeAtrr(XMLNode modelDefNode, XMLNode node) {
        node.setAttrValue("id", modelDefNode.getAttrValue("id"));
        node.setAttrValue("name", modelDefNode.getAttrValue("name"));
        Hashtable attrs = modelDefNode.getAttrs();
        Enumeration key = attrs.keys();
        while (key.hasMoreElements()) {
            XMLNode propertyNode = new XMLNode("property");
            Object attr = key.nextElement();
            if (attr.equals("id") || attr.equals("name") || attr.equals("x") || attr.equals("height") || attr.equals("width") || attr.equals("y")) continue;
            propertyNode.setAttrValue(attr.toString(), attrs.get(attr).toString());
            node.add(propertyNode);
        }
    }

    private void addRouteAttr(XMLNode node, XMLNode referenceNode) {
        node.setAttrValue("id", referenceNode.getAttrValue("name"));
        Hashtable attrs = referenceNode.getAttrs();
        Enumeration key = attrs.keys();
        while (key.hasMoreElements()) {
            XMLNode propertyNode = new XMLNode("property");
            Object attr = key.nextElement();
            if (attr.equals("name") || attr.equals("#text")) continue;
            if (attr.equals("dest")) {
                propertyNode.setAttrValue("noderouternodeid", propertyNode.getAttrValue("dest"));
            } else {
                propertyNode.setAttrValue(attr.toString(), attrs.get(attr).toString());
            }
            node.add(propertyNode);
        }
    }

    public static WFBuilder getInstance(IProject prj) {
        IDEProjectSettings prjSettings = IDEContent.getPRJSettings(prj);
        String settingsPath = String.valueOf(prjSettings.getWebContentPath()) + "/WEB-INF";
        String targetPath = prj.getLocation() + "/" + settingsPath;
        WFBuilder builder = new WFBuilder();
        builder.setOutputPath(targetPath);
        if (prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(prjSettings.getXMLEncoding());
        }
        return builder;
    }
}

