/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import org.eclipse.core.resources.IProject;

public class WSDLBuilder
extends AbstractBuilder {
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private XMLNode MCITrxNode;
    private XMLNode trxNode;
    private String targetURL = "http://localhost:8080/EMPTest/EMPService/";
    private XMLNode schemaNode;

    public void setFlowEditorProfile(EditorProfile profile) {
        this.flowEditorProfile = profile;
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void buildMCITransaction(String srcFile) {
        this.srcFileName = srcFile;
        try {
            this.reportProgress(Messages.getString("MCITransactionBuilder.Load_MCI_Transactio_File_..._1"), 1);
            String filePath = this.dstPath;
            this.MCITrxNode = this.loadXMLContent(this.srcFileName);
            this.reportProgress(Messages.getString("MCITransactionBuilder.Build_the_trx_..._2"), 1);
            String classify = null;
            try {
                classify = this.MCITrxNode.getAttrValue("classify");
                super.createFolder(classify);
                if (classify != null && classify.length() > 0) {
                    filePath = String.valueOf(this.dstPath) + "/" + classify;
                }
            }
            catch (Exception e) {
                super.reportProblem(2, String.valueOf(Messages.getString("MCITransactionBuilder.Faild_to_create_classify_folder_[_4")) + classify + "]. Exception: " + e, this.srcFileName);
            }
            String trxCode = this.MCITrxNode.getAttrValue("trxCode");
            XMLNode wsdlNode = new XMLNode("definitions");
            wsdlNode.setAttrValue("name", trxCode);
            wsdlNode.setAttrValue("targetNamespace", "urn:" + trxCode + ".wsdl");
            wsdlNode.setAttrValue("xmlns:tns", "urn:" + trxCode + ".wsdl");
            wsdlNode.setAttrValue("xmlns:xsd1", String.valueOf(trxCode) + ".xsd");
            wsdlNode.setAttrValue("xmlns:soap", "http://schemas.xmlsoap.org/wsdl/soap/");
            wsdlNode.setAttrValue("xmlns", "http://schemas.xmlsoap.org/wsdl/");
            XMLNode typesNode = new XMLNode("types");
            wsdlNode.add(typesNode);
            this.schemaNode = new XMLNode("schema");
            this.schemaNode.setAttrValue("targetNamespace", String.valueOf(trxCode) + ".xsd");
            this.schemaNode.setAttrValue("xmlns", "http://www.w3.org/2001/XMLSchema");
            typesNode.add(this.schemaNode);
            XMLNode portTypeNode = new XMLNode("portType");
            portTypeNode.setAttrValue("name", String.valueOf(trxCode) + "PortType");
            XMLNode bindingNode = new XMLNode("binding");
            bindingNode.setAttrValue("name", String.valueOf(trxCode) + "Binding");
            bindingNode.setAttrValue("type", "tns:" + trxCode + "PortType");
            XMLNode soapBindingNode = new XMLNode("soap:binding");
            soapBindingNode.setAttrValue("transport", "http://schemas.xmlsoap.org/soap/http");
            bindingNode.add(soapBindingNode);
            XMLNode serviceNode = new XMLNode("service");
            serviceNode.setAttrValue("name", trxCode);
            if (this.MCITrxNode.getDocument() != null) {
                XMLNode docNode = new XMLNode("documentation");
                serviceNode.add(docNode);
                XMLNode txtNode = new XMLNode("#text");
                txtNode.setTextValue(this.MCITrxNode.getDocument());
                docNode.add(txtNode);
            }
            int i = 0;
            while (i < this.MCITrxNode.getChilds().size()) {
                XMLNode node = (XMLNode)this.MCITrxNode.getChilds().get(i);
                if ("operation".equals(node.getNodeName())) {
                    XMLNode outputNode;
                    String opName = node.getAttrValue("id");
                    XMLNode inputNode = node.getChild("input");
                    XMLNode operationNode = new XMLNode("operation");
                    operationNode.setAttrValue("name", opName);
                    portTypeNode.add(operationNode);
                    if (node.getDocument() != null) {
                        XMLNode docNode = new XMLNode("documentation");
                        operationNode.add(docNode);
                        XMLNode txtNode = new XMLNode("#text");
                        txtNode.setTextValue(node.getDocument());
                        docNode.add(txtNode);
                    }
                    XMLNode bindingOpNode = new XMLNode("operation");
                    bindingOpNode.setAttrValue("name", opName);
                    bindingNode.add(bindingOpNode);
                    XMLNode soapOpNode = new XMLNode("soap:operation");
                    soapOpNode.setAttrValue("soapAction", opName);
                    bindingOpNode.add(soapOpNode);
                    XMLNode oInputNode = new XMLNode("input");
                    bindingOpNode.add(oInputNode);
                    XMLNode bodyNode = new XMLNode("soap:body");
                    bodyNode.setAttrValue("use", "encoded");
                    bodyNode.setAttrValue("namespace", "urn:" + trxCode + ".wsdl");
                    bodyNode.setAttrValue("encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
                    oInputNode.add(bodyNode);
                    XMLNode oOutputNode = new XMLNode("output");
                    bindingOpNode.add(oOutputNode);
                    oOutputNode.add(bodyNode);
                    XMLNode portNode = new XMLNode("port");
                    portNode.setAttrValue("name", opName);
                    portNode.setAttrValue("binding", "tns:" + trxCode + "Binding");
                    serviceNode.add(portNode);
                    XMLNode soapAddrNode = new XMLNode("soap:address");
                    soapAddrNode.setAttrValue("location", String.valueOf(this.targetURL) + trxCode + "." + opName);
                    portNode.add(soapAddrNode);
                    if (inputNode != null) {
                        XMLNode complexTypeNode = new XMLNode("complexType");
                        complexTypeNode.setAttrValue("name", String.valueOf(opName) + "InputType");
                        this.schemaNode.add(complexTypeNode);
                        XMLNode allNode = new XMLNode("all");
                        complexTypeNode.add(allNode);
                        this.createTypeNode(allNode, inputNode);
                        XMLNode messageNode = new XMLNode("message");
                        messageNode.setAttrValue("name", String.valueOf(opName) + "Input");
                        XMLNode partNode = new XMLNode("part");
                        messageNode.add(partNode);
                        partNode.setAttrValue("name", String.valueOf(opName) + "Input");
                        partNode.setAttrValue("type", "xsd1:" + opName + "InputType");
                        wsdlNode.add(messageNode);
                        XMLNode aInputNode = new XMLNode("input");
                        aInputNode.setAttrValue("message", "tns:" + opName + "Input");
                        operationNode.add(aInputNode);
                    }
                    if ((outputNode = node.getChild("output")) != null) {
                        XMLNode complexTypeNode = new XMLNode("complexType");
                        complexTypeNode.setAttrValue("name", String.valueOf(opName) + "OutputType");
                        this.schemaNode.add(complexTypeNode);
                        XMLNode allNode = new XMLNode("all");
                        complexTypeNode.add(allNode);
                        this.createTypeNode(allNode, outputNode);
                        XMLNode messageNode = new XMLNode("message");
                        messageNode.setAttrValue("name", String.valueOf(opName) + "Output");
                        XMLNode partNode = new XMLNode("part");
                        messageNode.add(partNode);
                        partNode.setAttrValue("name", String.valueOf(opName) + "Output");
                        partNode.setAttrValue("type", "xsd1:" + opName + "OutputType");
                        wsdlNode.add(messageNode);
                        XMLNode aOutputNode = new XMLNode("output");
                        aOutputNode.setAttrValue("message", "tns:" + opName + "Output");
                        operationNode.add(aOutputNode);
                    }
                }
                ++i;
            }
            wsdlNode.add(portTypeNode);
            wsdlNode.add(bindingNode);
            wsdlNode.add(serviceNode);
            this.reportProgress(Messages.getString("MCITransactionBuilder.Save_to_file..._3"), 1);
            String fileName = String.valueOf(filePath) + "/" + trxCode + ".wsdl";
            wsdlNode.setEncoding("UTF-8");
            this.saveXMLFile(fileName, wsdlNode);
        }
        catch (Exception e) {
            super.reportProblem(2, String.valueOf(Messages.getString("MCITransactionBuilder.Failed_to_build_the_mci_transaction_!_Exception___37")) + e, this.srcFileName);
        }
        this.reportProgress(Messages.getString("MCITransactionBuilder.Build_finished._4"), 10);
    }

    private void createTypeNode(XMLNode pNode, XMLNode inputNode) {
        XMLNode datas = inputNode;
        if (datas == null || datas.getChilds() == null) {
            return;
        }
        this.reportProgress(Messages.getString("MCITransactionBuilder.Buidl_MCI_Transaction_Data_10"), 3);
        int i = 0;
        while (i < datas.getChilds().size()) {
            XMLNode refNode = (XMLNode)datas.getChilds().elementAt(i);
            if (!"#text".equals(refNode.getNodeName())) {
                if ("dataGroup".equals(refNode.getNodeName())) {
                    XMLNode elementNode = new XMLNode("element");
                    elementNode.setAttrValue("name", refNode.getAttrValue("id"));
                    elementNode.setAttrValue("type", "tns:" + refNode.getAttrValue("id"));
                    pNode.add(elementNode);
                    XMLNode complexTypeNode = new XMLNode("complexType");
                    XMLNode allNode = new XMLNode("all");
                    complexTypeNode.add(allNode);
                    this.schemaNode.add(complexTypeNode);
                    int k = 0;
                    while (k < refNode.getChilds().size()) {
                        XMLNode aRefNode = (XMLNode)refNode.getChilds().elementAt(k);
                        String nodeName = aRefNode.getNodeName();
                        if (!"#text".equals(nodeName)) {
                            String refId = aRefNode.getAttrValue("refId");
                            String defaultValue = aRefNode.getAttrValue("defaultValue");
                            XMLNode childNode = this.dataDictionary.findChildNode(refId);
                            if (childNode == null) {
                                String msg = String.valueOf(Messages.getString("MCITransactionBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_66")) + refId + "]!";
                                super.reportProblem(2, msg, this.srcFileName);
                            } else {
                                this.addDataDefine(allNode, childNode);
                            }
                        }
                        ++k;
                    }
                } else {
                    String refId = refNode.getAttrValue("refId");
                    XMLNode childNode = this.dataDictionary.findChildNode(refId);
                    if (childNode == null) {
                        String msg = String.valueOf(Messages.getString("MCITransactionBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_66")) + refId + "]!";
                        super.reportProblem(2, msg, this.srcFileName);
                    } else {
                        this.addDataDefine(pNode, childNode);
                    }
                }
            }
            ++i;
        }
    }

    private void addDataDefine(XMLNode pNode, XMLNode dictionaryNode) {
        String nodeName = dictionaryNode.getNodeName();
        XMLNode node = new XMLNode();
        if (nodeName.equals("dataElement")) {
            XMLNode elementNode = new XMLNode("element");
            elementNode.setAttrValue("name", dictionaryNode.getAttrValue("id"));
            elementNode.setAttrValue("type", "string");
            pNode.add(elementNode);
        } else if (nodeName.equals("dataCollection")) {
            XMLNode elementNode = new XMLNode("element");
            String iCollName = dictionaryNode.getAttrValue("id");
            elementNode.setAttrValue("name", iCollName);
            pNode.add(elementNode);
            XMLNode complexTypeNode = new XMLNode("complexType");
            elementNode.add(complexTypeNode);
            XMLNode allNode = new XMLNode("sequence");
            complexTypeNode.add(allNode);
            XMLNode aElementNode = new XMLNode("element");
            aElementNode.setAttrValue("name", String.valueOf(iCollName) + "Item");
            aElementNode.setAttrValue("type", "xsd1:" + iCollName + "Item");
            aElementNode.setAttrValue("minOccurs", "0");
            aElementNode.setAttrValue("maxOccurs", "unbounded");
            allNode.add(aElementNode);
            XMLNode aComplexTypeNode = new XMLNode("complexType");
            aComplexTypeNode.setAttrValue("name", String.valueOf(iCollName) + "Item");
            this.schemaNode.add(aComplexTypeNode);
            XMLNode newAllNode = new XMLNode("all");
            aComplexTypeNode.add(newAllNode);
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName()) && "refData".equals(aNode.getNodeName())) {
                    String refId = aNode.getAttrValue("refId");
                    XMLNode dicNode = this.dataDictionary.findChildNode(refId);
                    if (dicNode == null) {
                        String msg = "Collection [" + node.getAttrValue("id") + "] data refer to [" + refId + "] Not define in dictionary!";
                        this.reportProblem(2, msg, "");
                    } else {
                        this.addDataDefine(newAllNode, dicNode);
                    }
                }
                ++i;
            }
        }
    }

    public static WSDLBuilder getInstance(IProject project, String groupId) {
        WSDLBuilder builder = new WSDLBuilder();
        try {
            builder.setDataDictionaryEditorProfile(IDEProfile.getEditorProfile(project, 1));
            builder.setDataDictionary(IDEContent.getSettingNode(project, 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder;
    }
}

