/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder.document;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.document.word.WordDocument;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.visualeditor.VisualContentToImage;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.File;
import org.eclipse.core.resources.IProject;

public class DocBIZBuilder
extends AbstractBuilder {
    WordDocument document = null;
    private String srcFileName = null;
    private XMLNode dataDictionary;
    private XMLNode hostSettings;
    private XMLNode packageType;
    private XMLNode service;
    private XMLNode flow;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile serviceEditorProfile;
    private XMLLoader xmlLoader = null;
    private XMLNode bizNode;
    private IProject project;
    private XMLNode channelSettingsNode;
    private XMLNode commonFlowNode;

    public void buildDoc(String srcFile, WordDocument doc) {
        this.srcFileName = srcFile;
        this.document = doc;
        try {
            this.reportProgress("\u6b63\u5728\u751f\u6210\u4e1a\u52a1\u903b\u8f91\u6784\u4ef6\u8bbe\u8ba1\u6587\u6863...", 1);
            String filePath = this.dstPath;
            this.bizNode = this.loadXMLContent(this.srcFileName);
            String trxCode = this.bizNode.getAttrValue("trxCode");
            String trxName = this.bizNode.getAttrValue("trxName");
            String trxDes = this.bizNode.getDocument();
            this.document.find("EMPBIZID");
            this.document.typeText(trxName);
            this.document.typeText("\u7248\u6743\u8bf4\u660e");
            this.reportProgress("\u751f\u6210\u4e1a\u52a1\u903b\u8f91\u6784\u4ef6\u5c5e\u6027\u63cf\u8ff0...", 1);
            this.document.gotoFirst(1);
            this.document.find("\u57fa\u672c\u4fe1\u606f");
            this.document.moveDown(5, 1);
            this.document.setStyle("\u6b63\u6587");
            this.document.typeText(trxDes + "\r\n");
            String[] titles = new String[5];
            titles[0] = "\u6784\u4ef6\u540d\u79f0";
            titles[1] = "\u6784\u4ef6ID";
            titles[2] = "\u63cf\u8ff0";
            this.document.addTable(2, 3, titles);
            this.document.typeText(trxName);
            this.document.moveRight(1, 1);
            this.document.typeText(trxCode);
            this.document.moveRight(1, 1);
            this.document.typeText(trxDes);
            this.buildData();
            this.buildFormats();
            this.buildSepFormats();
            this.buildServices();
            this.buildFlow();
            this.reportProgress("\u4fdd\u5b58\u5230\u6587\u4ef6", 1);
            String fileName = String.valueOf(filePath) + "/EMP\u4e1a\u52a1\u903b\u8f91\u6784\u4ef6_" + trxCode + "_\u8be6\u7ec6\u8bbe\u8ba1\u6587\u6863.doc";
            this.saveFile(fileName);
        }
        catch (Exception e) {
            String fileName = String.valueOf(this.dstPath) + "errorMCITrxDocument.doc";
            this.saveFile(fileName);
            e.printStackTrace();
            super.reportProblem(2, String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Failed_to_build_the_mci_transaction_!_Exception___32")) + e, this.srcFileName);
        }
        this.reportProgress(Messages.getString("MCITrxDesignDocumentBuilder.Build_finished._5"), 10);
    }

    private void buildServices() {
        this.reportProgress(Messages.getString("MCITrxDesignDocumentBuilder.Build_MCI_Transaction_Service_Description_6"), 1);
        XMLNode servicesNode = this.bizNode.getChild("services");
        if (servicesNode == null || servicesNode.getChilds() == null) {
            return;
        }
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("MCITrxDesignDocumentBuilder._u670D_u52A1_u5B9A_u4E49_35"));
        int i = 0;
        int m = 0;
        while (i < servicesNode.getChilds().size()) {
            XMLNode serviceNode = (XMLNode)servicesNode.getChilds().elementAt(i);
            if (!"#text".equals(serviceNode.getNodeName())) {
                String svcId = serviceNode.getAttrValue("id");
                this.document.moveDown(5, 1);
                this.document.setStyle("\u4e34\u65f6\u6807\u9898 3");
                this.document.typeText("1.4." + ++m + " " + svcId + "\r\n");
                this.document.setStyle(Messages.getString("MCITrxDesignDocumentBuilder._u6B63_u6587_40"));
                String[] titles = new String[]{Messages.getString("MCITrxDesignDocumentBuilder._u670D_u52A1ID_41"), Messages.getString("MCITrxDesignDocumentBuilder._u670D_u52A1_u7C7B_u578B_42"), Messages.getString("MCITrxDesignDocumentBuilder._u8BF4_u660E_43"), ""};
                this.document.addTable(2, 3, titles);
                this.document.typeText(svcId);
                this.document.moveRight(1, 1);
                this.document.typeText(serviceNode.getNodeName());
                this.document.moveRight(1, 1);
                this.document.typeText(serviceNode.getDocument() + "\r\n");
            }
            ++i;
        }
    }

    private void buildFlow() {
        if (this.document == null) {
            return;
        }
        this.reportProgress(Messages.getString("MCITrxDesignDocumentBuilder.Build_MCI_Transaction_Flow_Description_7"), 2);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u529f\u80fd\u5217\u8868");
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6b63\u6587");
        int NodeChildSize = 0;
        int m = 0;
        while (NodeChildSize < this.bizNode.getChilds().size()) {
            XMLNode Node2 = (XMLNode)this.bizNode.getChilds().elementAt(NodeChildSize);
            if (Node2 == null) {
                return;
            }
            if (Node2.getNodeName().equals("operation")) {
                XMLNode flowNode = Node2.getChild("flow");
                if (flowNode == null) {
                    return;
                }
                if (flowNode.getChilds() == null) {
                    return;
                }
                String operationID = Node2.getAttrValue("id");
                String operationName = Node2.getAttrValue("name");
                String operationDes = Node2.getChild("document").getNodeValue();
                String[] titles = new String[]{"\u4ea4\u6613ID", "\u4ea4\u6613\u540d\u79f0", "\u4ea4\u6613\u63cf\u8ff0", ""};
                this.document.moveDown(5, 1);
                this.document.setStyle("\u4e34\u65f6\u6807\u9898 3");
                this.document.typeText("1.5." + ++m + " " + operationName + "\u4ea4\u6613\u4fe1\u606f\u4e3a:\r\n");
                this.document.setStyle("\u6b63\u6587");
                this.document.addTable(2, 3, titles);
                this.document.typeText(operationID);
                this.document.moveRight(1, 1);
                this.document.typeText(operationName);
                this.document.moveRight(1, 1);
                this.document.typeText(operationDes);
                this.document.moveDown(5, 1);
                this.document.moveDown(5, 1);
                String[] titles2 = new String[]{"\u8f93\u5165", "\u8f93\u51fa", ""};
                this.document.addTable(2, 2, titles2);
                XMLNode inputNode = Node2.getChild("input");
                int inputChildSize = 0;
                while (inputChildSize < inputNode.getChilds().size()) {
                    XMLNode refData = (XMLNode)inputNode.getChilds().elementAt(inputChildSize);
                    if (!"#text".equals(refData.getNodeName())) {
                        String ref = refData.getAttrValue("refId");
                        if (inputChildSize < inputNode.getChilds().size() - 2) {
                            this.document.typeText(String.valueOf(ref) + "\n");
                        } else {
                            this.document.typeText(ref);
                        }
                    }
                    ++inputChildSize;
                }
                this.document.moveRight(1, 1);
                XMLNode outputNode = Node2.getChild("output");
                int outputChildSize = 0;
                while (outputChildSize < outputNode.getChilds().size()) {
                    XMLNode refData = (XMLNode)outputNode.getChilds().elementAt(outputChildSize);
                    if (!"#text".equals(refData.getNodeName())) {
                        String ref = refData.getAttrValue("refId");
                        if (outputChildSize < outputNode.getChilds().size() - 2) {
                            this.document.typeText(String.valueOf(ref) + "\r\n");
                        } else {
                            this.document.typeText(ref);
                        }
                    }
                    ++outputChildSize;
                }
                this.document.moveDown(5, 1);
                this.document.moveDown(5, 1);
                VisualContentToImage visual = new VisualContentToImage();
                try {
                    visual.setFlowEditorProfile(this.flowEditorProfile);
                    visual.setCommonFlowNode(this.commonFlowNode);
                    visual.setXMLContent(flowNode);
                }
                catch (Exception e) {
                    return;
                }
                visual.saveToImageFile(String.valueOf(this.dstPath) + "/flowImage.jpg", 0);
                visual.isImageOK();
                this.document.addPicture(String.valueOf(this.dstPath) + "/flowImage.jpg");
                File imageFile = new File(String.valueOf(this.dstPath) + "/flowImage.jpg");
                imageFile.delete();
            }
            ++NodeChildSize;
        }
    }

    private void buildData() {
        XMLNode datas = this.bizNode.getChild("datas");
        if (datas == null || datas.getChilds() == null) {
            return;
        }
        this.reportProgress(Messages.getString("MCITrxDesignDocumentBuilder.Build_MCI_Transaction_Data_Description_11"), 2);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u6570\u636e\u5b9a\u4e49");
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6b63\u6587");
        String[] titles = new String[]{"\u6570\u636eID", "\u6570\u636e\u540d\u79f0", "\u7c7b\u578b\u8bbe\u5b9a", "\u7f3a\u7701\u503c", "\u8bf4\u660e", ""};
        this.document.addTable(2, 5, titles);
        int i = 0;
        while (i < datas.getChilds().size()) {
            XMLNode refNode = (XMLNode)datas.getChilds().elementAt(i);
            if (!"#text".equals(refNode.getNodeName())) {
                String refId = refNode.getAttrValue("refId");
                String defaultValue = refNode.getAttrValue("defaultValue");
                if ("dataGroup".equals(refNode.getNodeName())) {
                    this.addDataDefine(refNode, defaultValue);
                    this.document.insertRowsBelow(1);
                } else if ("refData".equals(refNode.getNodeName())) {
                    this.addDataDefine(refNode, defaultValue);
                    this.document.insertRowsBelow(1);
                } else {
                    XMLNode childNode = this.dataDictionary.findChildNode(refId);
                    if (childNode == null) {
                        String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_104")) + refId + "]!";
                        super.reportProblem(2, msg, this.srcFileName);
                    } else if ("private".equals(childNode.getAttrValue("access"))) {
                        this.addDataDefine(childNode, defaultValue);
                        this.document.insertRowsBelow(1);
                    }
                }
            }
            ++i;
        }
        this.document.typeText("\r\n");
    }

    private void addDataDefine(XMLNode dictionaryNode, String defaultValue) {
        String nodeName = dictionaryNode.getNodeName();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText(defaultValue);
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getDocument());
        } else if (nodeName.equals("dataCollection")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 3);
            this.document.typeText(dictionaryNode.getDocument());
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.document.insertRowsBelow(1);
                    this.document.typeText(String.valueOf(dictionaryNode.getAttrValue("id")) + ".");
                    this.addDataDefine(aNode, null);
                }
                ++i;
            }
        } else if ("dataGroup".equals(nodeName)) {
            this.document.typeText("\u6570\u636e\u7ec4 [" + dictionaryNode.getAttrValue("name") + "]");
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.document.insertRowsBelow(1);
                    this.addDataDefine(aNode, null);
                }
                ++i;
            }
            this.document.insertRowsBelow(1);
            this.document.typeText("\u6570\u636e\u7ec4 [" + dictionaryNode.getAttrValue("name") + "] \u7ed3\u675f");
        } else if ("refCommData".equals(nodeName)) {
            this.document.typeText(dictionaryNode.getAttrValue("refId"));
            this.document.moveRight(1, 4);
            this.document.typeText("\u516c\u5171\u6570\u636e\u5b9a\u4e49\u5f15\u7528");
            this.document.insertRowsBelow(1);
        } else if (nodeName.equals("refData")) {
            XMLNode dataNode = this.dataDictionary.findChildNode(dictionaryNode.getAttrValue("refId"));
            this.document.typeText(dataNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(dataNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText(dataNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText("");
            this.document.moveRight(1, 1);
            this.document.typeText(dataNode.getDocument());
        } else if (nodeName.equals("selectData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText(" " + dictionaryNode.getDocument());
            if (dictionaryNode.getAttrValue("refDataColl") != null) {
                this.document.typeText(" " + dictionaryNode.getAttrValue("refDataColl"));
            }
            if (dictionaryNode.getAttrValue("values") != null) {
                this.document.typeText(" " + dictionaryNode.getAttrValue("values"));
            }
        }
    }

    private void buildSepFormats() {
        XMLNode fmtsNode = this.bizNode.getChild("formats");
        int i = 0;
        int m = 0;
        while (i < fmtsNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)fmtsNode.getChilds().elementAt(i);
            if ("format".equals(aNode.getNodeName())) {
                this.document.moveDown(5, 1);
                this.document.setStyle("\u4e34\u65f6\u6807\u9898 3");
                this.document.typeText("1.3." + ++m + " \u62a5\u6587\u5b9a\u4e49\uff1a" + aNode.getAttrValue("id") + "\r\n");
                this.document.setStyle("\u6b63\u6587");
                this.document.typeText(aNode.getDocument());
                XMLNode fmtNode = aNode.getChild("datas");
                this.buildHostAccessDef(fmtNode, "");
            }
            ++i;
        }
    }

    private void buildFormats() {
        if (this.document == null) {
            return;
        }
        this.reportProgress(Messages.getString("MCITrxDesignDocumentBuilder.Build_MCI_Transaction_Format_Description_12"), 1);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u62a5\u6587\u5b9a\u4e49");
        String trxCode = this.bizNode.getAttrValue("trxCode");
        XMLNode hostAccessNode = this.bizNode.getChild("hostAccess");
        if (hostAccessNode == null || hostAccessNode.getChilds() == null) {
            return;
        }
        int i = 0;
        while (i < hostAccessNode.getChilds().size()) {
            XMLNode hostNode = (XMLNode)hostAccessNode.getChilds().elementAt(i);
            if ("host".equals(hostNode.getNodeName())) {
                XMLNode repNode;
                XMLNode reqNode;
                String id = hostNode.getAttrValue("id");
                String hostId = hostNode.getAttrValue("hostId");
                this.document.moveDown(5, 1);
                this.document.setStyle("\u6b63\u6587");
                this.document.typeText(String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder._u8BBF_u95EE_u4E3B_u673A_uFF1A_115")) + hostId + "\r\n");
                if (id.equals("default")) {
                    id = "";
                }
                if ((reqNode = hostNode.getChild("request")) != null && reqNode.getChilds() != null && reqNode.getChilds().size() > 0) {
                    this.document.setStyle("\u6b63\u6587");
                    this.document.typeText(Messages.getString("MCITrxDesignDocumentBuilder._u8BF7_u6C42_u62A5_u6587_uFF1A_r_n_121"));
                    this.document.setStyle(Messages.getString("MCITrxDesignDocumentBuilder._u6B63_u6587_122"));
                    this.document.typeText(Messages.getString("MCITrxDesignDocumentBuilder._u5F15_u7528_u62A5_u6587_u5934_uFF1A_123"));
                    String refHeadFlag = reqNode.getAttrValue("refToHead");
                    if ("true".equals(refHeadFlag)) {
                        this.document.typeText(String.valueOf(hostId) + "ReqHeadFmt\r\n");
                    } else {
                        this.document.typeText(Messages.getString("MCITrxDesignDocumentBuilder._u65E0_r_n_127"));
                    }
                    this.buildHostAccessDef(reqNode, hostId);
                }
                if ((repNode = hostNode.getChild("reply")) != null && repNode.getChilds() != null && repNode.getChilds().size() > 0) {
                    this.document.moveDown(5, 1);
                    this.document.setStyle(Messages.getString("MCITrxDesignDocumentBuilder._u6807_u9898_4_162"));
                    this.document.typeText(Messages.getString("MCITrxDesignDocumentBuilder._u54CD_u5E94_u62A5_u6587_uFF1A_r_n_163"));
                    this.document.setStyle(Messages.getString("MCITrxDesignDocumentBuilder._u6B63_u6587_164"));
                    this.document.typeText(Messages.getString("MCITrxDesignDocumentBuilder._u5F15_u7528_u62A5_u6587_u5934_uFF1A_165"));
                    String refHeadFlag = repNode.getAttrValue("refToHead");
                    if ("true".equals(refHeadFlag)) {
                        this.document.typeText(String.valueOf(hostId) + "RepHeadFmt\r\n");
                    } else {
                        this.document.typeText(Messages.getString("MCITrxDesignDocumentBuilder._u65E0_r_n_169"));
                    }
                    this.buildHostAccessDef(repNode, hostId);
                }
            }
            ++i;
        }
    }

    private void buildHostAccessDef(XMLNode reqNode, String hostId) {
        String pkgType = reqNode.getAttrValue("packageType");
        if (pkgType == null) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_Warnning_packageType_not_defined_for_host_[_129")) + hostId + Messages.getString("MCITrxDesignDocumentBuilder.]__s_request_!_130");
            super.reportProblem(2, msg, this.srcFileName);
            return;
        }
        this.document.typeText("\u62a5\u6587\u5b9a\u4e49\r\n");
        this.document.typeText("\u62a5\u6587\u7c7b\u578b\uff1a" + pkgType + "\r\n");
        XMLNode pkgNode = this.packageType.findChildNode(pkgType);
        if (pkgNode == null) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_Unknown_package_type_[_135")) + pkgType + Messages.getString("MCITrxDesignDocumentBuilder.]_for_host_[_136") + hostId + Messages.getString("MCITrxDesignDocumentBuilder.]__s_request_!_137");
            super.reportProblem(2, msg, this.srcFileName);
            return;
        }
        String fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
        if (fmtBuilderClass == null) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_140")) + pkgType + "]!";
            super.reportProblem(2, msg, this.srcFileName);
            return;
        }
        try {
            this.document.typeText("\u62a5\u6587\u5c5e\u6027\u5b9a\u4e49\uff1a\r\n");
            XMLNode attrs = pkgNode.getChild("attributes");
            int j = 0;
            while (j < attrs.getChilds().size()) {
                XMLNode attr = (XMLNode)attrs.getChilds().elementAt(j);
                if (!"#text".equals(attr.getNodeName())) {
                    this.document.typeText(String.valueOf(attr.getAttrValue("name")) + ": ");
                    this.document.typeText(String.valueOf(reqNode.getAttrValue(attr.getAttrValue("id"))) + "\r\n");
                }
                ++j;
            }
            XMLNode fieldAttrs = pkgNode.getChild("dataAttributes");
            String[] fieldNames = new String[]{"\u6570\u636eID", "\u6570\u636e\u540d\u79f0", "\u5c5e\u6027\u8bbe\u5b9a", ""};
            this.document.addTable(2, 3, fieldNames);
            this.addFmtDataFieldDef(reqNode, fieldAttrs);
            this.document.typeText("\r\n");
        }
        catch (Exception e) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_failed_to_build_request_fmt_for_host_[_158")) + hostId + "] Exception: " + e;
            super.reportProblem(2, msg, this.srcFileName);
            e.printStackTrace();
        }
    }

    private void addFmtDataFieldDef(XMLNode reqNode, XMLNode fieldAttrs) {
        int k = 0;
        while (k < reqNode.getChilds().size()) {
            XMLNode reqField = (XMLNode)reqNode.getChilds().elementAt(k);
            if (!"#text".equals(reqField.getNodeName())) {
                String dataName = reqField.getNodeName();
                if ("dataGroup".equals(dataName)) {
                    this.document.typeText("\u6570\u636e\u5206\u7ec4\u5f00\u59cb");
                    this.document.moveRight(1, 2);
                    this.addAttrDefine(reqField, fieldAttrs);
                    this.document.insertRowsBelow(1);
                    this.addFmtDataFieldDef(reqField, fieldAttrs);
                    this.document.typeText("\u6570\u636e\u5206\u7ec4\u7ed3\u675f");
                    this.document.insertRowsBelow(1);
                } else if ("refData".equals(dataName) || "refColl".equals(dataName)) {
                    String refId = reqField.getAttrValue("refId");
                    this.document.typeText(refId);
                    this.document.moveRight(1, 1);
                    try {
                        int idx = refId.indexOf(46);
                        if (idx != -1) {
                            refId = refId.substring(idx + 1);
                        }
                        XMLNode childNode = this.dataDictionary.findChildNode(refId);
                        this.document.typeText(childNode.getAttrValue("label"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.document.moveRight(1, 1);
                    this.addAttrDefine(reqField, fieldAttrs);
                    this.document.insertRowsBelow(1);
                }
            }
            ++k;
        }
    }

    private void addAttrDefine(XMLNode refNode, XMLNode fieldAttrs) {
        int j = 0;
        while (j < fieldAttrs.getChilds().size()) {
            String attrValue;
            XMLNode attr = (XMLNode)fieldAttrs.getChilds().elementAt(j);
            if (!"#text".equals(attr.getNodeName()) && (attrValue = refNode.getAttrValue(attr.getAttrValue("id"))) != null) {
                this.document.typeText(String.valueOf(attr.getAttrValue("name")) + "=");
                this.document.typeText(String.valueOf(attrValue) + "\r\n");
            }
            ++j;
        }
    }

    private void saveFile(String fileName) {
        try {
            this.document.saveAs(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DocBIZBuilder getInstance(IProject project, String groupId) {
        DocBIZBuilder builder = new DocBIZBuilder();
        try {
            builder.project = project;
            builder.dataEditorProfile = IDEProfile.getEditorProfile(project, 1);
            builder.flowEditorProfile = ModuleUtility.getActionFlowProfile(project);
            builder.serviceEditorProfile = ModuleUtility.getServiceProfile(project);
            builder.dataDictionary = IDEContent.getSettingNode(project, 0);
            builder.flow = IDEContent.getSettingNode(project, groupId, 5);
            builder.hostSettings = IDEContent.getSettingNode(project, groupId, 11);
            builder.packageType = ModuleUtility.getPackageTypeNode(project);
            builder.channelSettingsNode = IDEContent.getSettingNode(project, groupId, 19);
            builder.commonFlowNode = IDEContent.getSettingNode(project, groupId, 5);
        }
        catch (Exception e) {
            return null;
        }
        return builder;
    }
}

