/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder.document;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.document.word.WordDocument;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.visualeditor.VisualContentToImage;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class DocPrjBuilder
extends AbstractBuilder {
    private IProject project;
    private XMLNode dataDictionary;
    private XMLNode hostSettings;
    private XMLNode packageType;
    private XMLNode services;
    private XMLNode flows;
    private XMLNode dataTypeDefNode;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile serviceEditorProfile;
    private XMLNode channelSettings;
    private String projectRootPath;
    private Vector opStepList = null;
    private Vector opList = null;
    private Vector htmlOpList = null;
    private WordDocument document;
    private XMLNode formatDefsNode;

    public void buildDoc(WordDocument doc) {
        this.document = doc;
        try {
            String filePath = this.dstPath;
            this.document.moveToHome();
            this.document.find("\u8be6\u7ec6\u8bbe\u8ba1\u6587\u6863");
            this.document.moveDown(5, 1);
            this.document.setStyle("\u6b63\u6587");
            this.document.typeText(String.valueOf(this.project.getName()) + "\u9879\u76ee\r\n");
            this.buildDataType();
            this.buildData();
            this.buildCommonFlow();
            this.buildSepFormats();
            this.buildOpStepProfile();
            this.buildOpStatistic();
            String fileName = String.valueOf(filePath) + "EMP\u9879\u76ee_\u8bbe\u8ba1\u6587\u6863.doc";
            this.saveFile(fileName);
        }
        catch (Exception e) {
            String fileName = String.valueOf(this.dstPath) + "EMP\u9879\u76ee_\u8bbe\u8ba1\u6587\u6863.doc";
            this.saveFile(fileName);
            e.printStackTrace();
            super.reportProblem(2, String.valueOf(Messages.getString("MCIProjectDocumentBuilder.Failed_to_build_the_MCI_Project_!_Exception___3")) + e, "");
        }
        this.toConsole(Messages.getString("MCIProjectDocumentBuilder.Bulid_finished_!_1"));
    }

    private void buildServices() {
        if (this.document == null) {
            return;
        }
        if (this.services == null || this.services.getChilds() == null) {
            return;
        }
        this.toConsole(Messages.getString("MCIProjectDocumentBuilder.Buidl_MCI_Common_Service_Description_2"));
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find(Messages.getString("MCIProjectDocumentBuilder._u516C_u5171_u670D_u52A1_u5B9A_u4E49_5"));
        this.document.moveDown(5, 1);
        int i = 0;
        while (i < this.services.getChilds().size()) {
            XMLNode serviceNode = (XMLNode)this.services.getChilds().elementAt(i);
            if (!"#text".equals(serviceNode.getNodeName())) {
                String svcId = serviceNode.getAttrValue("id");
                this.document.setStyle(Messages.getString("MCIProjectDocumentBuilder._u6807_u9898_2_7"));
                this.document.typeText(String.valueOf(svcId) + "\r\n");
                this.document.setStyle(Messages.getString("MCIProjectDocumentBuilder._u6B63_u6587_10"));
                String[] titles = new String[]{Messages.getString("MCIProjectDocumentBuilder._u670D_u52A1ID_11"), Messages.getString("MCIProjectDocumentBuilder._u670D_u52A1_u7C7B_u578B_12"), Messages.getString("MCIProjectDocumentBuilder._u8BF4_u660E_13"), ""};
                this.document.addTable(2, 3, titles);
                this.document.typeText(svcId);
                this.document.moveRight(1, 1);
                this.document.typeText(serviceNode.getNodeName());
                this.document.moveRight(1, 1);
                this.document.typeText(String.valueOf(serviceNode.getDocument()) + "\r\n");
                this.document.moveDown(5, 1);
                this.document.typeText(Messages.getString("MCIProjectDocumentBuilder._u5B9A_u4E49_u63CF_u8FF0_uFF1A_r_n_20"));
                StringBuffer sBuff = new StringBuffer();
                serviceNode.toXMLContent(0, sBuff);
                this.document.typeText(String.valueOf(sBuff.toString()) + "\r\n");
            }
            ++i;
        }
    }

    private void buildCommonFlow() {
        if (this.document == null) {
            return;
        }
        this.toConsole("\u751f\u6210EMP\u516c\u5171\u6d41\u7a0b\u5b9a\u4e49\u8bf4\u660e");
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u516c\u5171\u6d41\u7a0b\u5b9a\u4e49");
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6b63\u6587");
        int n = 0;
        while (n < this.flows.getChilds().size()) {
            XMLNode flowNode = (XMLNode)this.flows.getChilds().elementAt(n);
            if (!"#text".equals(flowNode.getNodeName())) {
                if (flowNode.getChilds() == null) {
                    return;
                }
                this.document.setStyle("\u6807\u9898 2");
                this.document.typeText("\u6d41\u7a0b[" + flowNode.getAttrValue("id") + "]\r\n");
                this.document.setStyle("\u6b63\u6587");
                try {
                    this.document.typeText(String.valueOf(flowNode.getDocument()) + "\r\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int k = 0;
                while (k < flowNode.getChilds().size()) {
                    XMLNode actionNode = (XMLNode)flowNode.getChilds().elementAt(k);
                    if (!"#text".equals(actionNode.getNodeName()) && !actionNode.getNodeName().equals("attributes")) {
                        XMLNode stepNode = new XMLNode();
                        stepNode.setNodeName("opStep");
                        stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                        if (this.flowEditorProfile.getElement(actionNode.getNodeName()) != null) {
                            stepNode.setAttrValue("implClass", this.flowEditorProfile.getElement(actionNode.getNodeName()).getImplClass());
                        } else {
                            this.toConsole("\u5c5e\u6027implClass\u672a\u5b9a\u4e49\uff0c\u5143\u7d20\u5b9a\u4e49[" + actionNode.getNodeName() + "]!");
                        }
                        Enumeration keys = actionNode.getAttrs().keys();
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height")) continue;
                            stepNode.setAttrValue(key, actionNode.getAttrValue(key));
                        }
                        if (actionNode.getChilds() != null) {
                            int j = 0;
                            while (j < actionNode.getChilds().size()) {
                                XMLNode transitionNode = (XMLNode)actionNode.getChilds().elementAt(j);
                                if (!"#text".equals(transitionNode.getNodeName())) {
                                    String dst = transitionNode.getAttrValue("dest");
                                    String idStr = transitionNode.getAttrValue("id");
                                    if (dst != null && idStr != null) {
                                        String key = "on" + idStr + "Do";
                                        stepNode.setAttrValue(key, dst);
                                    }
                                }
                                ++j;
                            }
                            String comment = "";
                            comment = actionNode.getDocument();
                            Element element = this.flowEditorProfile.getElement(actionNode.getNodeName());
                            Vector attrs = null;
                            if (element != null) {
                                attrs = element.getAttributes();
                            }
                            if (attrs != null) {
                                int i = 0;
                                while (i < attrs.size()) {
                                    ElementAttribute elementAttr = (ElementAttribute)attrs.elementAt(i);
                                    if ("states".equals(elementAttr.getAttrID())) {
                                        comment = String.valueOf(comment) + " " + elementAttr.getValueListStr();
                                        break;
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    ++k;
                }
                VisualContentToImage visual = new VisualContentToImage();
                try {
                    visual.setFlowEditorProfile(this.flowEditorProfile);
                    visual.setXMLContent(flowNode);
                }
                catch (Exception e) {
                    return;
                }
                visual.saveToImageFile(String.valueOf(this.dstPath) + "/flowImage.jpg", 0);
                visual.isImageOK();
                this.document.addPicture(String.valueOf(this.dstPath) + "/flowImage.jpg");
                this.document.typeText("\r\n");
                File imageFile = new File(String.valueOf(this.dstPath) + "/flowImage.jpg");
                imageFile.delete();
            }
            ++n;
        }
    }

    private void buildDataType() {
        if (this.document == null) {
            return;
        }
        this.toConsole("\u751f\u6210\u516c\u5171\u6570\u636e\u7c7b\u578b\u5b9a\u4e49\u8bf4\u660e");
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u6570\u636e\u7c7b\u578b\u5b9a\u4e49");
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6b63\u6587");
        int i = 0;
        while (i < this.dataTypeDefNode.getChilds().size()) {
            XMLNode node = (XMLNode)this.dataTypeDefNode.getChilds().elementAt(i);
            if ("dataType".equals(node.getNodeName())) {
                this.document.setStyle("\u6807\u9898 3");
                this.document.typeText(String.valueOf(node.getAttrValue("name")) + "\r\n");
                this.document.setStyle("\u6b63\u6587");
                this.document.typeText("\u6570\u636e\u7c7b\u578bID:\t");
                this.document.typeText(node.getAttrValue("id"));
                this.document.typeText("\r\n");
                this.document.typeText("\u7c7b\u578b\u8f6c\u6362\u7c7b:\t");
                this.document.typeText(node.getAttrValue("convertorClass"));
                this.document.typeText("\r\n");
                this.document.typeText("\u7c7b\u578b\u6821\u9a8c\u7c7b:\t");
                this.document.typeText(node.getAttrValue("validatorClass"));
                this.document.typeText("\r\n");
                this.document.typeText("\u8bf4\u660e:\r\n");
                this.document.typeText(node.getDocument());
                this.document.typeText("\r\n\u5c5e\u6027\u5b9a\u4e49\uff1a\r\n");
                XMLNode attrsNode = node.getChild("attributes");
                if (attrsNode.getChilds().size() != 0) {
                    String[] title = new String[]{"\u5c5e\u6027ID", "\u5c5e\u6027\u540d\u79f0", "\u8bf4\u660e"};
                    this.document.addTable(2, 3, title);
                    int k = 0;
                    while (k < attrsNode.getChilds().size()) {
                        XMLNode attrNode = (XMLNode)attrsNode.getChilds().elementAt(k);
                        if ("attr".equals(attrNode.getNodeName())) {
                            this.document.typeText(attrNode.getAttrValue("id"));
                            this.document.moveRight(1, 1);
                            this.document.typeText(attrNode.getAttrValue("name"));
                            this.document.moveRight(1, 1);
                            this.document.typeText(attrNode.getDocument());
                            this.document.insertRowsBelow(1);
                        }
                        ++k;
                    }
                    this.document.moveDown(5, 1);
                    this.document.typeText("\r\n");
                }
            }
            ++i;
        }
    }

    private void buildCommData() {
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6807\u9898 2");
        this.document.typeText("\u516c\u5171\u6570\u636e\u5b9a\u4e49\r\n");
        this.document.setStyle("\u6b63\u6587");
        XMLNode commDataNode = this.dataDictionary.getChild("CommonData");
        this.buildDataRefTable(commDataNode);
        this.document.moveDown(5, 1);
    }

    private void addDataDefine(XMLNode dictionaryNode, String defaultValue) {
        String nodeName = dictionaryNode.getNodeName();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText(defaultValue);
        } else if (nodeName.equals("dataCollection")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("label"));
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.document.insertRowsBelow(1);
                    this.document.typeText(String.valueOf(dictionaryNode.getAttrValue("id")) + ".");
                    this.addDataDefine(aNode, null);
                }
                ++i;
            }
        } else if ("dataGroup".equals(nodeName)) {
            this.document.typeText("\u6570\u636e\u7ec4 [" + dictionaryNode.getAttrValue("name") + "]");
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.document.insertRowsBelow(1);
                    this.addDataDefine(aNode, null);
                }
                ++i;
            }
            this.document.insertRowsBelow(1);
            this.document.typeText("\u6570\u636e\u7ec4 [" + dictionaryNode.getAttrValue("name") + "] \u7ed3\u675f");
        } else if ("refCommData".equals(nodeName)) {
            this.document.typeText(dictionaryNode.getAttrValue("refId"));
            this.document.moveRight(1, 3);
            this.document.typeText("\u516c\u5171\u6570\u636e\u5b9a\u4e49\u5f15\u7528");
            this.document.insertRowsBelow(1);
        } else if (nodeName.equals("refData")) {
            XMLNode dataNode = this.dataDictionary.findChildNode(dictionaryNode.getAttrValue("refId"));
            if (dataNode == null) {
                return;
            }
            this.document.typeText(dataNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(dataNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText(dataNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText("");
        }
    }

    private void buildData() {
        this.toConsole("\u751f\u6210\u6570\u636e\u5b57\u5178...");
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u6570\u636e\u5b57\u5178\u5b9a\u4e49");
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6b63\u6587");
        String[] titles = new String[]{"ID", "\u4e2d\u6587\u540d\u79f0", "\u96c6\u5408", "\u7c7b\u578b", "\u63cf\u8ff0", ""};
        this.document.addTable(2, 5, titles);
        int i = 0;
        while (i < this.dataDictionary.getChilds().size()) {
            XMLNode childNode = (XMLNode)this.dataDictionary.getChilds().elementAt(i);
            if (!("#text".equals(childNode.getNodeName()) || childNode == null || "DataTypes".equals(childNode.getNodeName()) || "CommonData".equals(childNode.getNodeName()))) {
                if ("dataGroup".equals(childNode.getNodeName())) {
                    this.document.typeText(childNode.getAttrValue("name"));
                    this.document.insertRowsBelow(1);
                    int k = 0;
                    while (k < childNode.getChilds().size()) {
                        XMLNode aChildNode = (XMLNode)childNode.getChilds().elementAt(k);
                        if (!"#text".equals(aChildNode.getNodeName())) {
                            this.addDataDefine(aChildNode);
                            if (i < this.dataDictionary.getChilds().size() - 1) {
                                this.document.insertRowsBelow(1);
                            }
                        }
                        ++k;
                    }
                } else {
                    this.addDataDefine(childNode);
                    if (i < this.dataDictionary.getChilds().size() - 1) {
                        this.document.insertRowsBelow(1);
                    }
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void buildFormats() {
        if (this.document == null) {
            return;
        }
        this.toConsole("\u751f\u6210\u516c\u5171\u62a5\u6587\u5b9a\u4e49");
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u4e3b\u673a\u8bbf\u95ee\u53ca\u62a5\u6587\u5934\u5b9a\u4e49");
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6b63\u6587");
        i = 0;
        while (i < this.hostSettings.getChilds().size()) {
            block41: {
                hostNode = (XMLNode)this.hostSettings.getChilds().elementAt(i);
                if ("#text".equals(hostNode.getNodeName())) break block41;
                id = hostNode.getAttrValue("id");
                this.document.setStyle("\u6807\u9898 2");
                this.document.typeText("\u8bbf\u95ee\u4e3b\u673a" + id + "\r\n");
                this.document.setStyle("\u6b63\u6587");
                reqNode = hostNode.getChild("request").getChild("datas");
                if (reqNode == null || reqNode.getChilds() == null || reqNode.getChilds().size() <= 0) ** GOTO lbl95
                this.document.setStyle(Messages.getString("MCIProjectDocumentBuilder._u6807_u9898_3_96"));
                this.document.typeText(Messages.getString("MCIProjectDocumentBuilder._u8BF7_u6C42_u62A5_u6587_u5934_uFF1A_r_n_97"));
                this.document.setStyle(Messages.getString("MCIProjectDocumentBuilder._u6B63_u6587_98"));
                pkgType = reqNode.getAttrValue("packageType");
                if (pkgType == null) {
                    msg = String.valueOf(Messages.getString("MCIProjectDocumentBuilder.Error_Warnning_packageType_not_defined_for_host_[_100")) + id + Messages.getString("MCIProjectDocumentBuilder.]__s_request_!_101");
                    super.reportProblem(2, msg, "");
                } else {
                    this.document.typeText(String.valueOf(Messages.getString("MCIProjectDocumentBuilder._u62A5_u6587_u7C7B_u578B_u2014_u2014_103")) + pkgType + "\r\n");
                    pkgNode = this.packageType.findChildNode(pkgType);
                    if (pkgNode == null) {
                        msg = String.valueOf(Messages.getString("MCIProjectDocumentBuilder.Error_Unknown_package_type_[_105")) + pkgType + Messages.getString("MCIProjectDocumentBuilder.]_for_host_[_106") + id + Messages.getString("MCIProjectDocumentBuilder.]__s_request_!_107");
                        super.reportProblem(2, msg, "");
                    } else {
                        fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
                        if (fmtBuilderClass == null) {
                            msg = String.valueOf(Messages.getString("MCIProjectDocumentBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_110")) + pkgType + "]!";
                            super.reportProblem(2, msg, "");
                        } else {
                            try {
                                attrs = pkgNode.getChild("attributes");
                                j = 0;
                                while (j < attrs.getChilds().size()) {
                                    attr = (XMLNode)attrs.getChilds().elementAt(j);
                                    if (!"#text".equals(attr.getNodeName())) {
                                        this.document.typeText(String.valueOf(attr.getAttrValue("name")) + Messages.getString("MCIProjectDocumentBuilder._u2014_u2014_115"));
                                        this.document.typeText(String.valueOf(reqNode.getAttrValue(attr.getAttrValue("id"))) + "\r\n");
                                    }
                                    ++j;
                                }
                                fieldAttrs = pkgNode.getChild("dataAttributes");
                                fieldAttrsNum = fieldAttrs.getChilds().size();
                                fieldNames = new String[fieldAttrsNum + 2];
                                fieldNames[0] = Messages.getString("MCIProjectDocumentBuilder._u540D_u79F0_119");
                                fieldNames[1] = Messages.getString("MCIProjectDocumentBuilder._u4E2D_u6587_u540D_u79F0_120");
                                idx = 0;
                                k = 0;
                                while (k < fieldAttrsNum) {
                                    aNode = (XMLNode)fieldAttrs.getChilds().elementAt(k);
                                    if (!"#text".equals(aNode.getNodeName())) {
                                        fieldNames[idx + 2] = aNode.getAttrValue("name");
                                        ++idx;
                                    }
                                    ++k;
                                }
                                this.document.addTable(2, idx + 2, fieldNames);
                                k = 0;
                                while (k < reqNode.getChilds().size()) {
                                    reqField = (XMLNode)reqNode.getChilds().elementAt(k);
                                    if (!"#text".equals(reqField.getNodeName())) {
                                        refId = reqField.getAttrValue("refId");
                                        this.document.typeText(refId);
                                        this.document.moveRight(1, 1);
                                        try {
                                            childNode = this.dataDictionary.findChildNode(refId);
                                            if (childNode != null) {
                                                this.document.typeText(childNode.getAttrValue("label"));
                                            }
                                        }
                                        catch (Exception childNode) {
                                            // empty catch block
                                        }
                                        l = 0;
                                        while (l < fieldAttrsNum) {
                                            attrNode = (XMLNode)fieldAttrs.getChilds().elementAt(l);
                                            if (!"#text".equals(attrNode.getNodeName())) {
                                                this.document.moveRight(1, 1);
                                                attrID = attrNode.getAttrValue("id");
                                                this.document.typeText(reqField.getAttrValue(attrID));
                                            }
                                            ++l;
                                        }
                                        this.document.insertRowsBelow(1);
                                    }
                                    ++k;
                                }
                                this.document.moveDown(5, 1);
                            }
                            catch (Exception e) {
                                msg = String.valueOf(Messages.getString("MCIProjectDocumentBuilder.Error_failed_to_build_request_fmt_for_host_[_128")) + id + "] Exception: " + e;
                                super.reportProblem(2, msg, "");
                                e.printStackTrace();
                            }
                        }
                    }
lbl95:
                    // 5 sources

                    if ((repNode = hostNode.getChild("reply").getChild("datas")) != null && repNode.getChilds() != null && repNode.getChilds().size() > 0) {
                        this.document.setStyle(Messages.getString("MCIProjectDocumentBuilder._u6807_u9898_3_133"));
                        this.document.typeText(Messages.getString("MCIProjectDocumentBuilder._u54CD_u5E94_u62A5_u6587_u5934_uFF1A_r_n_134"));
                        this.document.setStyle(Messages.getString("MCIProjectDocumentBuilder._u6B63_u6587_135"));
                        pkgType = repNode.getAttrValue("packageType");
                        if (pkgType == null) {
                            msg = String.valueOf(Messages.getString("MCIProjectDocumentBuilder.Error_Warnning_packageType_not_defined_for_host_[_137")) + id + Messages.getString("MCIProjectDocumentBuilder.]__s_request_!_138");
                            super.reportProblem(2, msg, "");
                        } else {
                            this.document.typeText(String.valueOf(Messages.getString("MCIProjectDocumentBuilder._u62A5_u6587_u7C7B_u578B_u2014_u2014_140")) + pkgType + "\r\n");
                            pkgNode = this.packageType.findChildNode(pkgType);
                            if (pkgNode == null) {
                                msg = String.valueOf(Messages.getString("MCIProjectDocumentBuilder.Error_Unknown_package_type_[_142")) + pkgType + Messages.getString("MCIProjectDocumentBuilder.]_for_host_[_143") + id + Messages.getString("MCIProjectDocumentBuilder.]__s_request_!_144");
                                super.reportProblem(2, msg, "");
                            } else {
                                fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
                                if (fmtBuilderClass == null) {
                                    msg = String.valueOf(Messages.getString("MCIProjectDocumentBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_147")) + pkgType + "]!";
                                    super.reportProblem(2, msg, "");
                                } else {
                                    try {
                                        attrs = pkgNode.getChild("attributes");
                                        j = 0;
                                        while (j < attrs.getChilds().size()) {
                                            attr = (XMLNode)attrs.getChilds().elementAt(j);
                                            if (!"#text".equals(attr.getNodeName())) {
                                                this.document.typeText(String.valueOf(attr.getAttrValue("name")) + Messages.getString("MCIProjectDocumentBuilder._u2014_u2014_152"));
                                                this.document.typeText(String.valueOf(reqNode.getAttrValue(attr.getAttrValue("id"))) + "\r\n");
                                            }
                                            ++j;
                                        }
                                        fieldAttrs = pkgNode.getChild("dataAttributes");
                                        fieldAttrsNum = fieldAttrs.getChilds().size();
                                        fieldNames = new String[fieldAttrsNum + 2];
                                        fieldNames[0] = Messages.getString("MCIProjectDocumentBuilder._u540D_u79F0_156");
                                        fieldNames[1] = Messages.getString("MCIProjectDocumentBuilder._u4E2D_u6587_u540D_u79F0_157");
                                        idx = 0;
                                        k = 0;
                                        while (k < fieldAttrsNum) {
                                            attrNode = (XMLNode)fieldAttrs.getChilds().elementAt(k);
                                            if (!"#text".equals(attrNode.getNodeName())) {
                                                fieldNames[idx + 2] = attrNode.getAttrValue("name");
                                                ++idx;
                                            }
                                            ++k;
                                        }
                                        this.document.addTable(2, idx + 2, fieldNames);
                                        k = 0;
                                        while (k < repNode.getChilds().size()) {
                                            repField = (XMLNode)repNode.getChilds().elementAt(k);
                                            if (!"#text".equals(repField.getNodeName())) {
                                                refId = repField.getAttrValue("refId");
                                                this.document.typeText(refId);
                                                this.document.moveRight(1, 1);
                                                try {
                                                    childNode = this.dataDictionary.findChildNode(refId);
                                                    if (childNode != null) {
                                                        this.document.typeText(childNode.getAttrValue("label"));
                                                    }
                                                }
                                                catch (Exception childNode) {
                                                    // empty catch block
                                                }
                                                l = 0;
                                                while (l < fieldAttrsNum) {
                                                    attrNode = (XMLNode)fieldAttrs.getChilds().elementAt(l);
                                                    if (!"#text".equals(attrNode.getNodeName())) {
                                                        this.document.moveRight(1, 1);
                                                        attrID = attrNode.getAttrValue("id");
                                                        this.document.typeText(repField.getAttrValue(attrID));
                                                    }
                                                    ++l;
                                                }
                                                this.document.insertRowsBelow(1);
                                            }
                                            ++k;
                                        }
                                        this.document.moveDown(5, 1);
                                    }
                                    catch (Exception e) {
                                        msg = String.valueOf(Messages.getString("MCIProjectDocumentBuilder.Error_failed_to_build_request_fmt_for_host_[_165")) + id + "] Exception: " + e;
                                        super.reportProblem(2, msg, "");
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void buildChannelSetting() {
        if (this.document == null) {
            return;
        }
        this.toConsole("\u751f\u6210\u6e20\u9053\u5b9a\u4e49\u8bf4\u660e");
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u6e20\u9053\u5b9a\u4e49");
        this.document.moveDown(5, 1);
        int i = 0;
        while (i < this.channelSettings.getChilds().size()) {
            XMLNode channelNode = (XMLNode)this.channelSettings.getChilds().elementAt(i);
            if (!"#text".equals(channelNode.getNodeName())) {
                String id = channelNode.getAttrValue("id");
                String description = channelNode.getDocument();
                if (description == null || description.length() == 0) {
                    description = channelNode.getAttrValue("desc");
                }
                this.document.setStyle("\u6807\u9898 2");
                this.document.typeText("\u6e20\u9053:" + id + "\r\n");
                this.document.setStyle("\u6b63\u6587");
                this.document.typeText(String.valueOf(description) + "\r\n");
                this.document.setStyle("\u6807\u9898 3");
                this.document.typeText("\u6570\u636e\u5f15\u7528\u5b9a\u4e49\r\n");
                this.document.setStyle("\u6b63\u6587");
                XMLNode datasRefNode = channelNode.getChild("sessionDatas");
                this.buildDataRefTable(datasRefNode);
                this.document.moveDown(5, 1);
                this.document.setStyle("\u6807\u9898 3");
                this.document.typeText("\u670d\u52a1\u5f15\u7528\u5b9a\u4e49\r\n");
                this.document.setStyle("\u6b63\u6587");
                String[] titles1 = new String[]{"Id", "\u8bbf\u95ee\u65b9\u5f0f", ""};
                this.document.addTable(2, 3, titles1);
                XMLNode servicesRefNode = channelNode.getChild("refServices");
                int j = 0;
                while (servicesRefNode.getChilds().size() > 0 && j < servicesRefNode.getChilds().size()) {
                    XMLNode serviceRef = (XMLNode)servicesRefNode.getChilds().elementAt(j);
                    if (!"#text".equals(serviceRef.getNodeName())) {
                        this.document.typeText(serviceRef.getAttrValue("id"));
                        this.document.moveRight(1, 1);
                        this.document.typeText(serviceRef.getAttrValue("access"));
                        this.document.insertRowsBelow(1);
                    }
                    ++j;
                }
                this.document.moveDown(5, 1);
                if (servicesRefNode.getChilds().size() == 0) {
                    this.document.moveDown(5, 1);
                }
            }
            ++i;
        }
    }

    private void buildDataRefTable(XMLNode datasRefNode) {
        String[] titles = new String[]{"Id", "\u6570\u636e\u540d\u79f0", "\u8bbf\u95ee\u65b9\u5f0f", "\u521d\u59cb\u503c", ""};
        this.document.addTable(2, 4, titles);
        int i = 0;
        while (i < datasRefNode.getChilds().size()) {
            XMLNode refNode = (XMLNode)datasRefNode.getChilds().elementAt(i);
            if (!"#text".equals(refNode.getNodeName())) {
                String refId = refNode.getAttrValue("refId");
                String defaultValue = refNode.getAttrValue("defaultValue");
                if ("dataGroup".equals(refNode.getNodeName())) {
                    this.addDataDefine(refNode, defaultValue);
                    this.document.insertRowsBelow(1);
                } else if ("refCommData".equals(refNode.getNodeName())) {
                    this.addDataDefine(refNode, defaultValue);
                    this.document.insertRowsBelow(1);
                } else {
                    XMLNode childNode = this.dataDictionary.findChildNode(refId);
                    if (childNode == null) {
                        String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_104")) + refId + "]!";
                        super.reportProblem(2, msg, "");
                    } else {
                        this.addDataDefine(childNode, defaultValue);
                        this.document.insertRowsBelow(1);
                    }
                }
            }
            ++i;
        }
    }

    private boolean buildDataRef(XMLNode datasRefNode) {
        boolean haveContent = false;
        int j = 0;
        while (datasRefNode.getChilds().size() > 0 && j < datasRefNode.getChilds().size()) {
            XMLNode dataRef = (XMLNode)datasRefNode.getChilds().elementAt(j);
            if (!"#text".equals(dataRef.getNodeName())) {
                haveContent = true;
                String dataName = dataRef.getNodeName();
                if ("refData".equals(dataName)) {
                    XMLNode dataNode = this.dataDictionary.findChildNode(dataRef.getAttrValue("refId"));
                    this.document.typeText(dataRef.getAttrValue("refId"));
                    this.document.moveRight(1, 1);
                    this.document.typeText(dataNode.getAttrValue("label"));
                    this.document.moveRight(1, 1);
                    this.document.typeText(dataRef.getAttrValue("access"));
                    this.document.moveRight(1, 1);
                    if (dataRef.getAttrValue("defaultValue") != null) {
                        this.document.typeText(dataRef.getAttrValue("defaultValue"));
                    }
                    this.document.insertRowsBelow(1);
                } else if ("dataGroup".equals(dataName)) {
                    this.document.typeText("\u6570\u636e\u7ec4 [" + dataRef.getAttrValue("name") + "]");
                    this.document.insertRowsBelow(1);
                    this.buildDataRef(dataRef);
                    this.document.typeText("\u6570\u636e\u7ec4 [" + dataRef.getAttrValue("name") + "] \u7ed3\u675f");
                    this.document.insertRowsBelow(1);
                } else if ("refCommData".equals(dataName)) {
                    this.document.typeText(dataRef.getAttrValue("refId"));
                    this.document.moveRight(1, 1);
                    this.document.typeText("\u516c\u5171\u6570\u636e\u5b9a\u4e49\u5f15\u7528");
                    this.document.insertRowsBelow(1);
                }
            }
            ++j;
        }
        return haveContent;
    }

    private void buildOpStatistic() {
        XMLNode opStepNode;
        if (this.document == null) {
            return;
        }
        this.toConsole("\u751f\u6210EMP\u4ea4\u6613\u548c\u4ea4\u6613\u6b65\u9aa4\u7edf\u8ba1");
        this.opStepList = new Vector();
        Vector childs = this.flowEditorProfile.getElement("flow").getChilds();
        int i = 0;
        while (i < childs.size()) {
            ElementChild child = (ElementChild)childs.elementAt(i);
            opStepNode = new XMLNode();
            opStepNode.setNodeName(child.getChildElementId());
            opStepNode.setAttrValue("refInOp", "");
            this.opStepList.add(opStepNode);
            ++i;
        }
        this.opList = new Vector();
        this.scanMCIOpList(this.project.getFolder("/designFiles/bizs"));
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u4ea4\u6613\u6b65\u9aa4\u7edf\u8ba1");
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6b63\u6587");
        String[] titles1 = new String[]{"EMPAction", "\u540d\u79f0", "\u5f15\u7528Op", ""};
        this.document.addTable(2, 3, titles1);
        int i2 = 0;
        while (i2 < this.opStepList.size()) {
            opStepNode = (XMLNode)this.opStepList.elementAt(i2);
            if (!"#text".equals(opStepNode.getNodeName())) {
                this.document.typeText(opStepNode.getNodeName());
                this.document.moveRight(1, 1);
                String desc = null;
                try {
                    desc = this.flowEditorProfile.getElement(opStepNode.getNodeName()).getDocument();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (desc == null) {
                    desc = "";
                }
                this.document.typeText(desc);
                this.document.moveRight(1, 1);
                String refOp = opStepNode.getAttrValue("refInOp");
                if (refOp == null) {
                    refOp = " ";
                }
                this.document.typeText(refOp.replace(';', '\n'));
                this.document.insertRowsBelow(1);
            }
            ++i2;
        }
        this.document.moveDown(5, 1);
    }

    private void buildOpStepProfile() {
        if (this.document == null) {
            return;
        }
        this.toConsole("\u751f\u6210EMPAction\u7edf\u8ba1\u6570\u636e...");
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u4ea4\u6613\u6b65\u9aa4\u63cf\u8ff0");
        this.document.moveDown(5, 1);
        Vector stepCatalog = this.flowEditorProfile.getCagalogs();
        int i = 0;
        while (i < stepCatalog.size()) {
            ElementCatalog catalog = (ElementCatalog)stepCatalog.elementAt(i);
            if (!(catalog.getCatalogName().equals("Flow") || catalog.getCatalogName().equals("flow") || catalog.getIsBuildIn())) {
                this.document.setStyle("\u6807\u9898 2");
                this.document.typeText(String.valueOf(catalog.getLabel()) + "\r\n");
                long start = System.currentTimeMillis();
                int j = 0;
                while (j < catalog.getElements().size()) {
                    Element stepEle = (Element)catalog.getElements().elementAt(j);
                    if (!stepEle.getIsBuildIn()) {
                        long endtime = System.currentTimeMillis();
                        this.toConsole("\u751f\u6210" + stepEle.getElementName() + "\u4fe1\u606f...");
                        start = System.currentTimeMillis();
                        this.document.setStyle("\u6807\u9898 3");
                        this.document.typeText(String.valueOf(stepEle.getElementName()) + "\r\n");
                        this.document.setStyle("\u6b63\u6587");
                        this.document.typeText("\u540d\u79f0:  " + stepEle.getLabel() + "\r\n");
                        this.document.typeText("\u5b9e\u73b0\u7c7b:  ");
                        this.document.typeText(stepEle.getImplClass());
                        this.document.typeText("\r\n");
                        this.document.typeText("\u63cf\u8ff0:\r\n");
                        this.document.typeText(stepEle.getDocument());
                        this.document.typeText("\r\n");
                        if (stepEle.getAttributes() != null && stepEle.getAttributes().size() > 0) {
                            this.document.typeText("\u5c5e\u6027\u5b9a\u4e49:\r\n");
                            String[] title = new String[]{"\u5c5e\u6027ID", "\u7c7b\u578b", "\u53ef\u9009\u503c", "\u8bf4\u660e", ""};
                            this.document.addTable(2, 4, title);
                            int k = 0;
                            while (k < stepEle.getAttributes().size()) {
                                ElementAttribute attr = (ElementAttribute)stepEle.getAttributes().elementAt(k);
                                this.document.typeText(attr.getAttrID());
                                this.document.moveRight(1, 1);
                                this.document.typeText(attr.getAttrType());
                                this.document.moveRight(1, 1);
                                this.document.typeText(attr.getValueListStr());
                                this.document.moveRight(1, 1);
                                this.document.typeText(attr.getDocument());
                                if (k < stepEle.getAttributes().size() - 1) {
                                    this.document.insertRowsBelow(1);
                                }
                                ++k;
                            }
                            this.document.insertRowsBelow(1);
                            this.document.typeText("\r\n");
                            this.document.moveDown(5, 1);
                        }
                        this.document.typeText("\r\n");
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void buildServiceProfile() {
        if (this.document == null) {
            return;
        }
        this.toConsole("\u751f\u6210MCI \u670d\u52a1\u5b9a\u4e49\u63cf\u8ff0");
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u670d\u52a1\u5b9a\u4e49\u63cf\u8ff0");
        this.document.moveDown(5, 1);
        Vector stepCatalog = this.serviceEditorProfile.getCagalogs();
        int i = 0;
        while (i < stepCatalog.size()) {
            ElementCatalog catalog = (ElementCatalog)stepCatalog.elementAt(i);
            if (!catalog.getIsBuildIn()) {
                this.document.setStyle("\u6807\u9898 2");
                this.document.typeText(String.valueOf(catalog.getLabel()) + "\u7c7b\r\n");
                int j = 0;
                while (j < catalog.getElements().size()) {
                    Element serviceEle = (Element)catalog.getElements().elementAt(j);
                    if (!serviceEle.getIsBuildIn() && serviceEle.getImplClass() != null && serviceEle.getImplClass().length() != 0) {
                        int k;
                        String[] title;
                        this.document.setStyle("\u6807\u9898 3");
                        this.document.typeText(String.valueOf(serviceEle.getElementName()) + "\r\n");
                        this.document.setStyle("\u6b63\u6587");
                        this.document.typeText("\u540d\u79f0:  " + serviceEle.getLabel() + "\r\n");
                        this.document.typeText("\u5b9e\u73b0\u7c7b:  ");
                        this.document.typeText(serviceEle.getImplClass());
                        this.document.typeText("\r\n");
                        this.document.typeText("\u63cf\u8ff0:\r\n");
                        this.document.typeText(serviceEle.getDocument());
                        this.document.typeText("\r\n");
                        if (serviceEle.getAttributes() != null && serviceEle.getAttributes().size() > 0) {
                            this.document.typeText("\u5c5e\u6027\u5b9a\u4e49:\r\n");
                            title = new String[]{"\u5c5e\u6027ID", "\u7c7b\u578b", "\u53ef\u9009\u503c", "\u8bf4\u660e", ""};
                            this.document.addTable(2, 4, title);
                            k = 0;
                            while (k < serviceEle.getAttributes().size()) {
                                ElementAttribute attr = (ElementAttribute)serviceEle.getAttributes().elementAt(k);
                                this.document.typeText(attr.getAttrID());
                                this.document.moveRight(1, 1);
                                this.document.typeText(attr.getAttrType());
                                this.document.moveRight(1, 1);
                                this.document.typeText(attr.getValueListStr());
                                this.document.moveRight(1, 1);
                                this.document.typeText(attr.getDocument());
                                this.document.insertRowsBelow(1);
                                ++k;
                            }
                            this.document.typeText("\r\n");
                            this.document.moveDown(5, 1);
                        }
                        if (serviceEle.getChilds() != null && serviceEle.getChilds().size() > 0) {
                            this.document.typeText("\u5b50\u5143\u7d20\u5b9a\u4e49:\r\n");
                            title = new String[]{"\u5b50\u5143\u7d20ID", "\u5141\u8bb8\u4e2a\u6570", ""};
                            this.document.addTable(2, 2, title);
                            k = 0;
                            while (k < serviceEle.getChilds().size()) {
                                ElementChild child = (ElementChild)serviceEle.getChilds().elementAt(k);
                                this.document.typeText(child.getChildElementId());
                                this.document.moveRight(1, 1);
                                this.document.typeText(child.getAlowCount());
                                this.document.insertRowsBelow(1);
                                ++k;
                            }
                            this.document.typeText("\r\n");
                            this.document.moveDown(5, 1);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void scanMCIOpList(IFolder folder) {
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                IFile file;
                if (resources[i] instanceof IFolder) {
                    this.scanMCIOpList((IFolder)resources[i]);
                }
                if ((file = (IFile)resources[i]).getName().endsWith(".biz")) {
                    try {
                        InputStream in = file.getContents();
                        if (in != null) {
                            XMLNode bizNode = this.loadXMLContent(in);
                            in.close();
                            String classify = null;
                            if (classify == null || classify.length() == 0) {
                                classify = "";
                            }
                            String bizId = bizNode.getAttrValue("trxCode");
                            String bizName = bizNode.getAttrValue("trxName");
                            String flowId = "";
                            XMLNode operations = bizNode.getChild("operation");
                            if (operations != null) {
                                int w = 0;
                                while (w < operations.getChilds().size()) {
                                    XMLNode flowNode = (XMLNode)operations.getChilds().elementAt(w);
                                    if ("flow".equals(flowNode.getNodeName())) {
                                        int j = 0;
                                        while (j < flowNode.getChilds().size()) {
                                            XMLNode opStepNode = (XMLNode)flowNode.getChilds().elementAt(j);
                                            if (!"#text".equals(opStepNode.getNodeName())) {
                                                this.registOpStep(opStepNode.getNodeName(), String.valueOf(file.getProjectRelativePath().toString()) + "[" + flowNode.getAttrValue("name") + "]");
                                            }
                                            ++j;
                                        }
                                    }
                                    ++w;
                                }
                            }
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void scanHtmlOpList(String path) {
        try {
            File TrxPathFolder = new File(path);
            String[] files = TrxPathFolder.list();
            int i = 0;
            while (i < files.length) {
                try {
                    FileInputStream in = new FileInputStream(String.valueOf(path) + "/" + files[i]);
                    if (in != null) {
                        if (!files[i].endsWith(".htx")) {
                            ((InputStream)in).close();
                        } else {
                            XMLNode HtmlTrxNode = this.loadXMLContent(in);
                            ((InputStream)in).close();
                            String classify = HtmlTrxNode.getAttrValue("classify");
                            if (classify == null || classify.length() == 0) {
                                classify = "";
                            }
                            String opCode = HtmlTrxNode.getAttrValue("trxCode");
                            String name = HtmlTrxNode.getAttrValue("trxName");
                            XMLNode opNode = new XMLNode();
                            opNode.setNodeName("Op");
                            opNode.setAttrValue("code", opCode);
                            opNode.setAttrValue("classify", classify);
                            opNode.setAttrValue("name", name);
                            opNode.setAttrValue("jsp", "");
                            opNode.setAttrValue("refJsp", "");
                            opNode.setAttrValue("refSrvOp", "");
                            this.htmlOpList.add(opNode);
                            XMLNode jsps = HtmlTrxNode.getChild("jsps");
                            if (jsps == null || jsps.getChilds().size() == 0) {
                                return;
                            }
                            int j = 0;
                            while (j < jsps.getChilds().size()) {
                                XMLNode jspNode = (XMLNode)jsps.getChilds().elementAt(j);
                                if (jspNode.getNodeName().equals("jsp")) {
                                    String jsp = opNode.getAttrValue("jsp");
                                    if (jsp == null) {
                                        jsp = "";
                                    }
                                    opNode.setAttrValue("jsp", String.valueOf(jsp) + jspNode.getAttrValue("name") + ";");
                                } else if (jspNode.getNodeName().equals("refJsp")) {
                                    String refJsp = opNode.getAttrValue("refJsp");
                                    if (refJsp == null) {
                                        refJsp = "";
                                    }
                                    opNode.setAttrValue("refJsp", String.valueOf(refJsp) + jspNode.getAttrValue("name") + ";");
                                } else if (jspNode.getNodeName().equals("refSrvOp")) {
                                    String refSrvOp = opNode.getAttrValue("refSrvOp");
                                    if (refSrvOp == null) {
                                        refSrvOp = "";
                                    }
                                    opNode.setAttrValue("refSrvOp", String.valueOf(refSrvOp) + jspNode.getAttrValue("name") + ";");
                                }
                                ++j;
                            }
                        }
                    }
                }
                catch (FileNotFoundException ee) {
                    this.scanHtmlOpList(String.valueOf(path) + "/" + files[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registOpStep(String opStepName, String opCode) {
        int i = 0;
        while (i < this.opStepList.size()) {
            XMLNode opStepNode = (XMLNode)this.opStepList.elementAt(i);
            if (opStepNode.getNodeName().equals(opStepName)) {
                String refInOp = opStepNode.getAttrValue("refInOp");
                if (refInOp == null) {
                    refInOp = "";
                }
                if (refInOp.indexOf(opCode) != -1) break;
                opStepNode.setAttrValue("refInOp", String.valueOf(refInOp) + opCode + ";");
                break;
            }
            ++i;
        }
    }

    private void buildHtmlTrxStatistic() {
        if (this.document == null) {
            return;
        }
        this.toConsole("\u751f\u6210HTML \u4ea4\u6613\u7edf\u8ba1");
        this.htmlOpList = new Vector();
        String HTMLTrxPath = (String.valueOf(this.projectRootPath) + "/designFiles/htmlTrxs").replace('\\', '/');
        this.scanHtmlOpList(HTMLTrxPath);
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("HTML\u4ea4\u6613\u7edf\u8ba1");
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6807\u9898 2");
        this.document.typeText("Html \u4ea4\u6613\u5217\u8868\r\n");
        this.document.setStyle("\u6b63\u6587");
        String[] titles = new String[]{"OpCode", "\u4ea4\u6613\u5206\u7ec4", "\u4ea4\u6613\u540d\u79f0", "\u81ea\u5b9a\u4e49Jsp", "\u5f15\u7528Jsp", "\u5f15\u7528SrvOp", ""};
        this.document.addTable(2, 6, titles);
        int i = 0;
        while (i < this.htmlOpList.size()) {
            XMLNode opNode = (XMLNode)this.htmlOpList.elementAt(i);
            if (!"#text".equals(opNode.getNodeName())) {
                this.document.typeText(opNode.getAttrValue("code"));
                this.document.moveRight(1, 1);
                this.document.typeText(opNode.getAttrValue("classify"));
                this.document.moveRight(1, 1);
                this.document.typeText(opNode.getAttrValue("name"));
                this.document.moveRight(1, 1);
                String jsp = opNode.getAttrValue("jsp");
                if (jsp == null) {
                    jsp = " ";
                }
                this.document.typeText(jsp.replace(';', '\n'));
                this.document.moveRight(1, 1);
                String refJsp = opNode.getAttrValue("refJsp");
                if (refJsp == null) {
                    refJsp = " ";
                }
                this.document.typeText(refJsp.replace(';', '\n'));
                this.document.moveRight(1, 1);
                String refOp = opNode.getAttrValue("refSrvOp");
                if (refOp == null) {
                    refOp = " ";
                }
                this.document.typeText(refOp.replace(';', '\n'));
                this.document.insertRowsBelow(1);
            }
            ++i;
        }
        this.document.moveDown(5, 1);
    }

    private XMLNode loadXMLContent(InputStream in) {
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        try {
            XMLNode node = (XMLNode)xmlLoader.loadXMLContent(in);
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void saveFile(String fileName) {
        try {
            this.document.saveAs(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDataDefine(XMLNode dictionaryNode) {
        String nodeName = dictionaryNode.getNodeName();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText("\u5b57\u6bb5");
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getDocument());
        } else if (nodeName.equals("dataCollection")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText("\u96c6\u5408");
            this.document.moveRight(1, 2);
            this.document.typeText(dictionaryNode.getDocument());
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.document.insertRowsBelow(1);
                    this.document.typeText(String.valueOf(dictionaryNode.getAttrValue("id")) + ".");
                    this.addDataDefine(aNode);
                }
                ++i;
            }
        } else if (nodeName.equals("refData")) {
            String refId = dictionaryNode.getAttrValue("refId");
            XMLNode dataNode = this.dataDictionary.findChildNode(refId);
            this.document.typeText(refId);
            this.document.moveRight(1, 1);
            if (dataNode != null) {
                this.document.typeText(dataNode.getAttrValue("label"));
            }
        } else if (nodeName.equals("selectData")) {
            this.document.typeText(dictionaryNode.getAttrValue("id"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("label"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getAttrValue("dataType"));
            this.document.moveRight(1, 1);
            this.document.typeText(dictionaryNode.getDocument());
            if (dictionaryNode.getAttrValue("refDataColl") != null) {
                this.document.typeText(" " + dictionaryNode.getAttrValue("refDataColl"));
            }
            if (dictionaryNode.getAttrValue("values") != null) {
                this.document.typeText(dictionaryNode.getAttrValue("values"));
            }
        }
    }

    public XMLNode getFlow() {
        return this.flows;
    }

    public void setFlow(XMLNode flow) {
        this.flows = flow;
    }

    private void buildSepFormats() {
        XMLNode fmtsNode = this.formatDefsNode;
        this.document.moveToHome();
        this.document.gotoFirst(1);
        this.document.find("\u516c\u5171\u62a5\u6587\u5b9a\u4e49");
        this.document.moveDown(5, 1);
        this.document.setStyle("\u6b63\u6587");
        int i = 0;
        while (i < fmtsNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)fmtsNode.getChilds().elementAt(i);
            if ("format".equals(aNode.getNodeName())) {
                this.document.setStyle("\u6807\u9898 2");
                this.document.typeText("\u62a5\u6587\u5b9a\u4e49[" + aNode.getAttrValue("id") + "]\r\n");
                this.document.setStyle("\u6b63\u6587");
                this.document.typeText(aNode.getDocument());
                XMLNode fmtNode = aNode.getChild("datas");
                this.buildHostAccessDef(fmtNode, "");
            }
            ++i;
        }
    }

    private void buildHostAccessDef(XMLNode reqNode, String hostId) {
        String pkgType = reqNode.getAttrValue("packageType");
        if (pkgType == null) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_Warnning_packageType_not_defined_for_host_[_129")) + hostId + Messages.getString("MCITrxDesignDocumentBuilder.]__s_request_!_130");
            super.reportProblem(2, msg, "");
            return;
        }
        this.document.typeText("\u62a5\u6587\u5b9a\u4e49\r\n");
        this.document.typeText("\u62a5\u6587\u7c7b\u578b\uff1a" + pkgType + "\r\n");
        XMLNode pkgNode = this.packageType.findChildNode(pkgType);
        if (pkgNode == null) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_Unknown_package_type_[_135")) + pkgType + Messages.getString("MCITrxDesignDocumentBuilder.]_for_host_[_136") + hostId + Messages.getString("MCITrxDesignDocumentBuilder.]__s_request_!_137");
            super.reportProblem(2, msg, "");
            return;
        }
        String fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
        if (fmtBuilderClass == null) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_140")) + pkgType + "]!";
            super.reportProblem(2, msg, "");
            return;
        }
        try {
            this.document.typeText("\u62a5\u6587\u5c5e\u6027\u5b9a\u4e49\uff1a\r\n");
            XMLNode attrs = pkgNode.getChild("attributes");
            int j = 0;
            while (j < attrs.getChilds().size()) {
                XMLNode attr = (XMLNode)attrs.getChilds().elementAt(j);
                if (!"#text".equals(attr.getNodeName())) {
                    this.document.typeText(String.valueOf(attr.getAttrValue("name")) + ": ");
                    this.document.typeText(String.valueOf(reqNode.getAttrValue(attr.getAttrValue("id"))) + "\r\n");
                }
                ++j;
            }
            XMLNode fieldAttrs = pkgNode.getChild("dataAttributes");
            String[] fieldNames = new String[]{"\u6570\u636eID", "\u6570\u636e\u540d\u79f0", "\u5c5e\u6027\u8bbe\u5b9a", ""};
            this.document.addTable(2, 3, fieldNames);
            this.addFmtDataFieldDef(reqNode, fieldAttrs);
        }
        catch (Exception e) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_failed_to_build_request_fmt_for_host_[_158")) + hostId + "] Exception: " + e;
            super.reportProblem(2, msg, "");
            e.printStackTrace();
        }
    }

    private void addFmtDataFieldDef(XMLNode reqNode, XMLNode fieldAttrs) {
        int k = 0;
        while (k < reqNode.getChilds().size()) {
            XMLNode reqField = (XMLNode)reqNode.getChilds().elementAt(k);
            if (!"#text".equals(reqField.getNodeName())) {
                String dataName = reqField.getNodeName();
                if ("dataGroup".equals(dataName)) {
                    this.document.typeText("\u6570\u636e\u5206\u7ec4\u5f00\u59cb");
                    this.document.moveRight(1, 2);
                    this.addAttrDefine(reqField, fieldAttrs);
                    this.document.insertRowsBelow(1);
                    this.addFmtDataFieldDef(reqField, fieldAttrs);
                    this.document.typeText("\u6570\u636e\u5206\u7ec4\u7ed3\u675f");
                    this.document.insertRowsBelow(1);
                } else if ("refData".equals(dataName)) {
                    String refId = reqField.getAttrValue("refId");
                    this.document.typeText(refId);
                    this.document.moveRight(1, 1);
                    try {
                        int idx = refId.indexOf(46);
                        if (idx != -1) {
                            refId = refId.substring(idx + 1);
                        }
                        XMLNode childNode = this.dataDictionary.findChildNode(refId);
                        this.document.typeText(childNode.getAttrValue("label"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.document.moveRight(1, 1);
                    this.addAttrDefine(reqField, fieldAttrs);
                    this.document.insertRowsBelow(1);
                }
            }
            ++k;
        }
    }

    private void addAttrDefine(XMLNode refNode, XMLNode fieldAttrs) {
        int j = 0;
        while (j < fieldAttrs.getChilds().size()) {
            String attrValue;
            XMLNode attr = (XMLNode)fieldAttrs.getChilds().elementAt(j);
            if (!"#text".equals(attr.getNodeName()) && (attrValue = refNode.getAttrValue(attr.getAttrValue("id"))) != null) {
                this.document.typeText(String.valueOf(attr.getAttrValue("name")) + "=");
                this.document.typeText(String.valueOf(attrValue) + "\r\n");
            }
            ++j;
        }
    }

    public static DocPrjBuilder getInstance(IProject project) {
        DocPrjBuilder builder = new DocPrjBuilder();
        try {
            builder.dataEditorProfile = IDEProfile.getEditorProfile(project, 1);
            builder.flowEditorProfile = ModuleUtility.getActionFlowProfile(project);
            builder.serviceEditorProfile = IDEProfile.getEditorProfile(project, 13);
            builder.dataDictionary = IDEContent.getSettingNode(project, 0);
            builder.flows = IDEContent.getSettingNode(project, IDEContent.getDefaultBizGrpId(project), 5);
            builder.hostSettings = IDEContent.getSettingNode(project, IDEContent.getDefaultBizGrpId(project), 11);
            builder.packageType = IDEContent.getSettingNode(project, 14);
            builder.services = IDEContent.getSettingNode(project, IDEContent.getDefaultBizGrpId(project), 12);
            builder.channelSettings = IDEContent.getSettingNode(project, 19);
            builder.formatDefsNode = IDEContent.getSettingNode(project, IDEContent.getDefaultBizGrpId(project), 25);
            builder.dataTypeDefNode = IDEContent.getSettingNode(project, 33);
            builder.project = project;
        }
        catch (Exception e) {
            return null;
        }
        return builder;
    }
}

