/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder.document;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.builder.document.PdfReport;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.visualeditor.VisualContentToImage;
import com.ecc.util.xmlloader.XMLLoader;
import com.lowagie.text.Document;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.core.resources.IProject;

public class PdfBIZBuilder
extends AbstractBuilder {
    Document document = null;
    private String srcFileName = null;
    private XMLNode dataDictionary;
    private XMLNode hostSettings;
    private XMLNode packageType;
    private XMLNode service;
    private XMLNode flow;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile serviceEditorProfile;
    private XMLLoader xmlLoader = null;
    private XMLNode bizNode;
    private IProject project;
    PdfReport per = new PdfReport();
    ArrayList list = new ArrayList();
    private XMLNode channelSettingsNode;
    private File imageFile = null;
    String[] image = null;

    public void buildPdf(String srcFile) {
        this.bizNode = this.loadXMLContent(srcFile);
        String trxCode = this.bizNode.getAttrValue("trxCode");
        String trxName = this.bizNode.getAttrValue("trxName");
        String trxDes = this.bizNode.getDocument();
        String str = "                                                                         \t\u7248\u6743\u8bf4\u660e\r\n           \u672c\u6587\u4ef6\u7cfbEMP Web\u5e94\u7528\u57fa\u7840\u5e73\u53f0\u7684\u8bf4\u660e\u6027\u6587\u6863\u3002\u6587\u6863\u4e2d\u51fa\u73b0\u7684\u4efb\u4f55\u6587\u5b57\u53d9\u8ff0\u3001\u6587\u6863\u683c\u5f0f\u3001\u63d2\u56fe\u3001\u7167\u7247\u3001\u65b9\u6cd5\u3001\u8fc7\u7a0b\u7b49\u5185\u5bb9\uff0c\u9664\u53e6\u6709\u7279\u522b\u6ce8\u660e\uff0c\u7248\u6743\u5747\u5c5e\u5317\u4eac\u5b87\u4fe1\u6613\u8bda\u79d1\u6280\u6709\u9650\u516c\u53f8\u6240\u6709\uff0c\u53d7\u5230\u6709\u5173\u4ea7\u6743\u53ca\u7248\u6743\u6cd5\u4fdd\u62a4\u3002\u4efb\u4f55\u4e2a\u4eba\u3001\u673a\u6784\u672a\u7ecf\u5317\u4eac\u5b87\u4fe1\u6613\u8bda\u79d1\u6280\u6709\u9650\u516c\u53f8\u7684\u4e66\u9762\u6388\u6743\u8bb8\u53ef\uff0c\u4e0d\u5f97\u590d\u5236\u6216\u5f15\u7528\u672c\u6587\u4ef6\u7684\u4efb\u4f55\u7247\u65ad\uff0c\u65e0\u8bba\u662f\u901a\u8fc7\u7535\u5b50\u5f62\u5f0f\u6216\u975e\u7535\u5b50\u5f62\u5f0f\u3002\n\n1.  \u57fa\u672c\u4fe1\u606f";
        this.per.buildContent0(this.list, str);
        String[] tableHeader = new String[]{"\u6784\u4ef6\u540d\u79f0", "\u6784\u4ef6ID", "\u63cf\u8ff0"};
        ArrayList dataList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", trxDes);
        map.put("2", trxName);
        map.put("3", trxCode);
        dataList.add(map);
        this.per.buildContent1(this.list, tableHeader, dataList);
        try {
            this.buildData();
            this.buildSepFormats();
            this.buildServices();
            this.buildFlow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.per.buildPdfReport("", "", "\u5317\u4eac\u5b87\u4fe1\u6613\u8bda", this.getTime(), String.valueOf(trxCode) + "biz\u8bbe\u8ba1\u6587\u6863", this.list, String.valueOf(this.dstPath) + trxCode + ".pdf");
        int i = 0;
        while (i < this.image.length) {
            if (this.image[i] == null) {
                return;
            }
            this.imageFile = new File(this.image[i]);
            this.imageFile.delete();
            ++i;
        }
    }

    private void buildData() {
        XMLNode datas = this.bizNode.getChild("datas");
        if (datas == null || datas.getChilds() == null) {
            return;
        }
        String str = "\n\n2.  \u6570\u636e\u5b9a\u4e49\n";
        this.per.buildContent0(this.list, str);
        String[] tableHeader = new String[]{"\u6570\u636eID", "\u6570\u636e\u540d\u79f0", "\u7c7b\u578b\u8bbe\u5b9a", "\u7f3a\u7701\u503c", "\u8bf4\u660e"};
        ArrayList dataList = new ArrayList();
        int i = 0;
        while (i < datas.getChilds().size()) {
            XMLNode refNode = (XMLNode)datas.getChilds().elementAt(i);
            if (!"#text".equals(refNode.getNodeName())) {
                String refId = refNode.getAttrValue("refId");
                String defaultValue = refNode.getAttrValue("defaultValue");
                if ("dataGroup".equals(refNode.getNodeName())) {
                    this.addDataDefine(refNode, defaultValue, dataList);
                } else if ("refData".equals(refNode.getNodeName())) {
                    this.addDataDefine(refNode, defaultValue, dataList);
                } else {
                    XMLNode childNode = this.dataDictionary.findChildNode(refId);
                    if (childNode == null) {
                        String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_104")) + refId + "]!";
                        super.reportProblem(2, msg, this.srcFileName);
                    } else if ("private".equals(childNode.getAttrValue("access"))) {
                        this.addDataDefine(childNode, defaultValue, dataList);
                    }
                }
            }
            ++i;
        }
        this.per.buildContent1(this.list, tableHeader, dataList);
    }

    private void addDataDefine(XMLNode dictionaryNode, String defaultValue, ArrayList dataList) {
        String nodeName = dictionaryNode.getNodeName();
        HashMap<String, String> map2 = new HashMap<String, String>();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            map2.put("1", dictionaryNode.getAttrValue("dataType"));
            map2.put("2", dictionaryNode.getAttrValue("label"));
            map2.put("3", dictionaryNode.getAttrValue("id"));
            map2.put("4", defaultValue);
            map2.put("5", dictionaryNode.getDocument());
        } else if (nodeName.equals("dataCollection")) {
            map2.put("1", "");
            map2.put("2", dictionaryNode.getAttrValue("label"));
            map2.put("3", dictionaryNode.getAttrValue("id"));
            map2.put("4", "");
            map2.put("5", dictionaryNode.getDocument());
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    map2.put("1", String.valueOf(dictionaryNode.getAttrValue("id")) + ".");
                    map2.put("2", "");
                    map2.put("3", "");
                    map2.put("4", "");
                    map2.put("5", "");
                    this.addDataDefine(aNode, null, dataList);
                }
                ++i;
            }
        } else if ("dataGroup".equals(nodeName)) {
            map2.put("1", "\u6570\u636e\u7ec4 [" + dictionaryNode.getAttrValue("name") + "]");
            map2.put("2", "");
            map2.put("3", "");
            map2.put("4", "");
            map2.put("5", "");
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.addDataDefine(aNode, null, dataList);
                }
                ++i;
            }
        } else if ("refCommData".equals(nodeName)) {
            map2.put("1", dictionaryNode.getAttrValue("refId"));
            map2.put("2", "");
            map2.put("3", "");
            map2.put("4", "");
            map2.put("5", "\u516c\u5171\u6570\u636e\u5b9a\u4e49\u5f15\u7528");
        } else if (nodeName.equals("refData")) {
            XMLNode dataNode = this.dataDictionary.findChildNode(dictionaryNode.getAttrValue("refId"));
            map2.put("1", dataNode.getAttrValue("dataType"));
            map2.put("2", dataNode.getAttrValue("label"));
            map2.put("3", dataNode.getAttrValue("id"));
            map2.put("4", "");
            map2.put("5", dataNode.getDocument());
        } else if (nodeName.equals("selectData")) {
            map2.put("1", dictionaryNode.getAttrValue("dataType"));
            map2.put("2", dictionaryNode.getAttrValue("id"));
            map2.put("3", dictionaryNode.getAttrValue("label"));
            map2.put("4", dictionaryNode.getDocument());
            if (dictionaryNode.getAttrValue("refDataColl") != null) {
                map2.put("5", dictionaryNode.getAttrValue("refDataColl"));
            }
            if (dictionaryNode.getAttrValue("values") != null) {
                map2.put("5", dictionaryNode.getAttrValue("values"));
            }
        }
        dataList.add(map2);
    }

    private void buildFormats() {
        String trxCode = this.bizNode.getAttrValue("trxCode");
        XMLNode hostAccessNode = this.bizNode.getChild("hostAccess");
        if (hostAccessNode == null || hostAccessNode.getChilds() == null) {
            return;
        }
        int i = 0;
        while (i < hostAccessNode.getChilds().size()) {
            XMLNode hostNode = (XMLNode)hostAccessNode.getChilds().elementAt(i);
            if ("host".equals(hostNode.getNodeName())) {
                String id = hostNode.getAttrValue("id");
                String hostId = hostNode.getAttrValue("hostId");
                String str = "\n\n6.  \u62a5\u6587\u5b9a\u4e49\uff082\uff09\n";
                this.per.buildContent0(this.list, str);
                str = "\u8bbf\u95ee\u4e3b\u673a\n";
                this.per.buildContent0(this.list, str);
            }
            ++i;
        }
    }

    private void buildSepFormats() {
        XMLNode fmtsNode = this.bizNode.getChild("formats");
        String str = "\n3.   \u62a5\u6587\u5b9a\u4e49\n";
        this.per.buildContent0(this.list, str);
        int i = 0;
        int j = 1;
        while (i < fmtsNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)fmtsNode.getChilds().elementAt(i);
            if ("format".equals(aNode.getNodeName())) {
                str = "3." + j + "   \u62a5\u6587\u5b9a\u4e49\uff1a" + aNode.getAttrValue("id") + "\r\n\n" + aNode.getDocument();
                ++j;
                this.per.buildContent0(this.list, str);
                XMLNode fmtNode = aNode.getChild("datas");
                this.buildHostAccessDef(fmtNode, "");
            }
            ++i;
        }
    }

    private void buildHostAccessDef(XMLNode reqNode, String hostId) {
        String pkgType = reqNode.getAttrValue("packageType");
        if (pkgType == null) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_Warnning_packageType_not_defined_for_host_[_129")) + hostId + Messages.getString("MCITrxDesignDocumentBuilder.]__s_request_!_130");
            super.reportProblem(2, msg, this.srcFileName);
            return;
        }
        String str = "\n\u62a5\u6587\u5b9a\u4e49\n\u62a5\u6587\u7c7b\u578b:" + pkgType + "\r\n";
        this.per.buildContent0(this.list, str);
        XMLNode pkgNode = this.packageType.findChildNode(pkgType);
        if (pkgNode == null) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_Unknown_package_type_[_135")) + pkgType + Messages.getString("MCITrxDesignDocumentBuilder.]_for_host_[_136") + hostId + Messages.getString("MCITrxDesignDocumentBuilder.]__s_request_!_137");
            super.reportProblem(2, msg, this.srcFileName);
            return;
        }
        String fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
        if (fmtBuilderClass == null) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_fmtGenClass_not_set_for_pacakge_type_[_140")) + pkgType + "]!";
            super.reportProblem(2, msg, this.srcFileName);
            return;
        }
        try {
            str = "\u62a5\u6587\u5c5e\u6027\u5b9a\u4e49\uff1a\r\n";
            XMLNode attrs = pkgNode.getChild("attributes");
            int j = 0;
            while (j < attrs.getChilds().size()) {
                XMLNode attr = (XMLNode)attrs.getChilds().elementAt(j);
                if (!"#text".equals(attr.getNodeName())) {
                    str = String.valueOf(str) + attr.getAttrValue("name") + ": ";
                    str = String.valueOf(str) + reqNode.getAttrValue(attr.getAttrValue("id")) + "\r\n";
                }
                ++j;
            }
            this.per.buildContent0(this.list, str);
            ArrayList dataList = new ArrayList();
            String[] tableHeader = new String[]{"\u6570\u636eID", "\u6570\u636e\u540d\u79f0", "\u5c5e\u6027\u8bbe\u5b9a"};
            XMLNode fieldAttrs = pkgNode.getChild("dataAttributes");
            this.addFmtDataFieldDef(reqNode, fieldAttrs, dataList);
            this.per.buildContent1(this.list, tableHeader, dataList);
        }
        catch (Exception e) {
            String msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_failed_to_build_request_fmt_for_host_[_158")) + hostId + "] Exception: " + e;
            super.reportProblem(2, msg, this.srcFileName);
            e.printStackTrace();
        }
    }

    private void addFmtDataFieldDef(XMLNode reqNode, XMLNode fieldAttrs, ArrayList dataList) {
        int k = 0;
        while (k < reqNode.getChilds().size()) {
            XMLNode reqField = (XMLNode)reqNode.getChilds().elementAt(k);
            if (!"#text".equals(reqField.getNodeName())) {
                HashMap<String, String> map = new HashMap<String, String>();
                String dataName = reqField.getNodeName();
                if ("dataGroup".equals(dataName)) {
                    map.put("1", "");
                    map.put("2", "\u6570\u636e\u5206\u7ec4\u5f00\u59cb");
                    map.put("3", "");
                    dataList.add(map);
                    this.addAttrDefine(reqField, fieldAttrs, dataList);
                } else if ("refData".equals(dataName)) {
                    String refId = reqField.getAttrValue("refId");
                    String label = "";
                    try {
                        int idx = refId.indexOf(46);
                        if (idx != -1) {
                            refId = refId.substring(idx + 1);
                        }
                        XMLNode childNode = this.dataDictionary.findChildNode(refId);
                        label = childNode.getAttrValue("label");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    map.put("1", refId);
                    map.put("2", label);
                    map.put("3", refId);
                    dataList.add(map);
                    this.addAttrDefine(reqField, fieldAttrs, dataList);
                }
            }
            ++k;
        }
    }

    private void addAttrDefine(XMLNode refNode, XMLNode fieldAttrs, ArrayList dataList) {
        int j = 0;
        while (j < fieldAttrs.getChilds().size()) {
            String attrValue;
            XMLNode attr = (XMLNode)fieldAttrs.getChilds().elementAt(j);
            if (!"#text".equals(attr.getNodeName()) && (attrValue = refNode.getAttrValue(attr.getAttrValue("id"))) != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("1", attrValue);
                map.put("2", attr.getAttrValue("name"));
                map.put("3", "");
                dataList.add(map);
            }
            ++j;
        }
    }

    private void buildServices() {
        String str = "\n4.   \u670d\u52a1\u5b9a\u4e49";
        this.per.buildContent0(this.list, str);
        XMLNode servicesNode = this.bizNode.getChild("services");
        if (servicesNode == null || servicesNode.getChilds() == null) {
            return;
        }
        int i = 0;
        int m = 0;
        while (i < servicesNode.getChilds().size()) {
            XMLNode serviceNode = (XMLNode)servicesNode.getChilds().elementAt(i);
            if (!"#text".equals(serviceNode.getNodeName())) {
                String svcId = serviceNode.getAttrValue("id");
                str = "\n4." + ++m + "   " + svcId + "\r\n";
                this.per.buildContent0(this.list, str);
                String[] tableHeader = new String[]{"\u670d\u52a1ID", "\u670d\u52a1\u7c7b\u578b", "\u8bf4\u660e"};
                ArrayList dataList = new ArrayList();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("1", serviceNode.getDocument());
                map.put("2", serviceNode.getNodeName());
                map.put("3", svcId);
                dataList.add(map);
                this.per.buildContent1(this.list, tableHeader, dataList);
                str = "\n\u5b9a\u4e49\u63cf\u8ff0\n";
                this.per.buildContent0(this.list, str);
                StringBuffer sBuff = new StringBuffer();
                serviceNode.toXMLContent(0, sBuff);
                this.per.buildContent0(this.list, String.valueOf(sBuff.toString()) + "\r\n");
            }
            ++i;
        }
    }

    private void buildFlow() {
        String str = "\n\n5.   \u529f\u80fd\u5217\u8868(\u5982\u679c\u6ca1\u6709\u8f93\u5165\u8f93\u51fa\u8868\u683c\uff0c\u5219\u4ee3\u8868\u6b64\u4ea4\u6613\u6ca1\u6709\u5b9a\u4e49\u8f93\u5165\u8f93\u51fa)\n";
        this.per.buildContent0(this.list, str);
        this.image = new String[this.bizNode.getChilds().size()];
        int NodeChildSize = 0;
        int m = 0;
        while (NodeChildSize < this.bizNode.getChilds().size()) {
            XMLNode Node2 = (XMLNode)this.bizNode.getChilds().elementAt(NodeChildSize);
            if (Node2 == null) {
                return;
            }
            if (Node2.getNodeName().equals("operation")) {
                String ref;
                XMLNode refData;
                XMLNode flowNode = Node2.getChild("flow");
                if (flowNode == null) {
                    return;
                }
                if (flowNode.getChilds() == null) {
                    return;
                }
                String operationID = Node2.getAttrValue("id");
                String operationName = Node2.getAttrValue("name");
                String operationDes = Node2.getChild("document").getNodeValue();
                str = "\n\r5." + ++m + "   " + operationName + "\u4ea4\u6613\u4fe1\u606f\u4e3a:";
                this.per.buildContent0(this.list, str);
                String[] tableHeader = new String[]{"\u4ea4\u6613ID", "\u4ea4\u6613\u540d\u79f0", "\u4ea4\u6613\u63cf\u8ff0"};
                ArrayList dataList = new ArrayList();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("1", operationDes);
                map.put("2", operationName);
                map.put("3", operationID);
                dataList.add(map);
                this.per.buildContent1(this.list, tableHeader, dataList);
                this.per.buildContent0(this.list, "\n");
                String[] tableHeader2 = new String[]{"\u8f93\u5165", "\u8f93\u51fa"};
                ArrayList dataList2 = new ArrayList();
                XMLNode inputNode = Node2.getChild("input");
                XMLNode outputNode = Node2.getChild("output");
                String[] input = new String[inputNode.getChilds().size()];
                String[] output = new String[outputNode.getChilds().size()];
                int inputChildSize = 0;
                int sign = 0;
                while (inputChildSize < inputNode.getChilds().size()) {
                    refData = (XMLNode)inputNode.getChilds().elementAt(inputChildSize);
                    if (!"#text".equals(refData.getNodeName())) {
                        input[sign] = ref = refData.getAttrValue("refId");
                        ++sign;
                    }
                    ++inputChildSize;
                }
                int outputChildSize = 0;
                sign = 0;
                while (outputChildSize < outputNode.getChilds().size()) {
                    refData = (XMLNode)outputNode.getChilds().elementAt(outputChildSize);
                    if (!"#text".equals(refData.getNodeName())) {
                        output[sign] = ref = refData.getAttrValue("refId");
                        ++sign;
                    }
                    ++outputChildSize;
                }
                this.bulidFlowData(input, output, dataList2);
                this.per.buildContent1(this.list, tableHeader2, dataList2);
                VisualContentToImage visual = new VisualContentToImage();
                try {
                    visual.setFlowEditorProfile(this.flowEditorProfile);
                    visual.setXMLContent(flowNode);
                }
                catch (Exception e) {
                    return;
                }
                visual.saveToImageFile(String.valueOf(this.dstPath) + "/flowImage" + m + ".jpg", 0);
                visual.isImageOK();
                this.per.buildContent2(this.list, String.valueOf(this.dstPath) + "/flowImage" + m + ".jpg");
                this.image[m - 1] = String.valueOf(this.dstPath) + "flowImage" + m + ".jpg";
            }
            ++NodeChildSize;
        }
    }

    private void bulidFlowData(String[] str1, String[] str2, ArrayList data) {
        if (str1.length < str2.length) {
            this.getIOdata(str1, str2, data);
        } else {
            this.getIOdata2(str1, str2, data);
        }
    }

    private void getIOdata(String[] str1, String[] str2, ArrayList data) {
        HashMap<String, String> map;
        int i = 0;
        while (i < str1.length) {
            if (str1[i] != null && str2[i] != null) {
                map = new HashMap<String, String>();
                map.put("1", str2[i]);
                map.put("2", str1[i]);
                data.add(map);
            } else if (str1[i] == null && str2[i] != null) {
                map = new HashMap();
                map.put("1", str2[i]);
                map.put("2", "");
                data.add(map);
            } else if (str1[i] != null && str2[i] == null) {
                map = new HashMap();
                map.put("1", "");
                map.put("2", str1[i]);
                data.add(map);
            } else {
                return;
            }
            ++i;
        }
        i = str1.length;
        while (i < str2.length) {
            if (str2[i] == null) {
                return;
            }
            map = new HashMap();
            map.put("1", str2[i]);
            map.put("2", "");
            data.add(map);
            ++i;
        }
    }

    private void getIOdata2(String[] str1, String[] str2, ArrayList data) {
        HashMap<String, String> map;
        int i = 0;
        while (i < str2.length) {
            if (str1[i] != null && str2[i] != null) {
                map = new HashMap<String, String>();
                map.put("1", str2[i]);
                map.put("2", str1[i]);
                data.add(map);
            } else if (str1[i] == null && str2[i] != null) {
                map = new HashMap();
                map.put("1", str2[i]);
                map.put("2", "");
                data.add(map);
            } else if (str1[i] != null && str2[i] == null) {
                map = new HashMap();
                map.put("1", "");
                map.put("2", str1[i]);
                data.add(map);
            } else {
                return;
            }
            ++i;
        }
        i = str2.length;
        while (i < str1.length) {
            if (str1[i] == null) {
                return;
            }
            map = new HashMap();
            map.put("1", "");
            map.put("2", str1[i]);
            data.add(map);
            ++i;
        }
    }

    private String getTime() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("", Locale.SIMPLIFIED_CHINESE);
        formatter.applyPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
        String time = formatter.format(date);
        return time;
    }

    public static PdfBIZBuilder getInstance(IProject project, String groupId) {
        PdfBIZBuilder builder = new PdfBIZBuilder();
        try {
            builder.project = project;
            builder.dataEditorProfile = IDEProfile.getEditorProfile(project, 1);
            builder.flowEditorProfile = ModuleUtility.getActionFlowProfile(project);
            builder.serviceEditorProfile = ModuleUtility.getServiceProfile(project);
            builder.dataDictionary = IDEContent.getSettingNode(project, 0);
            builder.flow = IDEContent.getSettingNode(project, groupId, 5);
            builder.hostSettings = IDEContent.getSettingNode(project, groupId, 11);
            builder.packageType = ModuleUtility.getPackageTypeNode(project);
            builder.channelSettingsNode = IDEContent.getSettingNode(project, groupId, 19);
        }
        catch (Exception e) {
            return null;
        }
        return builder;
    }
}

