/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder.document;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.builder.document.PdfReport;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.visualeditor.VisualContentToImage;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import com.lowagie.text.Document;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.resources.IProject;

public class PdfPrjBuilder
extends AbstractBuilder {
    private XMLNode dataDictionary;
    private XMLNode hostSettings;
    private XMLNode packageType;
    private XMLNode services;
    private XMLNode flows;
    private XMLNode dataTypeDefNode;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowEditorProfile;
    private EditorProfile serviceEditorProfile;
    private XMLNode channelSettings;
    private String projectRootPath;
    private Vector opStepList = null;
    private Vector opList = null;
    private Vector htmlOpList = null;
    private XMLNode formatDefsNode;
    private Document document;
    private PdfReport per = new PdfReport();
    private ArrayList list = new ArrayList();
    private File imageFile = null;
    private String[] image = null;

    public void buildPdf() {
        String str = "                                                                         \t\u7248\u6743\u8bf4\u660e\r\n           \u672c\u6587\u4ef6\u7cfbEMP Web\u5e94\u7528\u57fa\u7840\u5e73\u53f0\u7684\u8bf4\u660e\u6027\u6587\u6863\u3002\u6587\u6863\u4e2d\u51fa\u73b0\u7684\u4efb\u4f55\u6587\u5b57\u53d9\u8ff0\u3001\u6587\u6863\u683c\u5f0f\u3001\u63d2\u56fe\u3001\u7167\u7247\u3001\u65b9\u6cd5\u3001\u8fc7\u7a0b\u7b49\u5185\u5bb9\uff0c\u9664\u53e6\u6709\u7279\u522b\u6ce8\u660e\uff0c\u7248\u6743\u5747\u5c5e\u5317\u4eac\u5b87\u4fe1\u6613\u8bda\u79d1\u6280\u6709\u9650\u516c\u53f8\u6240\u6709\uff0c\u53d7\u5230\u6709\u5173\u4ea7\u6743\u53ca\u7248\u6743\u6cd5\u4fdd\u62a4\u3002\u4efb\u4f55\u4e2a\u4eba\u3001\u673a\u6784\u672a\u7ecf\u5317\u4eac\u5b87\u4fe1\u6613\u8bda\u79d1\u6280\u6709\u9650\u516c\u53f8\u7684\u4e66\u9762\u6388\u6743\u8bb8\u53ef\uff0c\u4e0d\u5f97\u590d\u5236\u6216\u5f15\u7528\u672c\u6587\u4ef6\u7684\u4efb\u4f55\u7247\u65ad\uff0c\u65e0\u8bba\u662f\u901a\u8fc7\u7535\u5b50\u5f62\u5f0f\u6216\u975e\u7535\u5b50\u5f62\u5f0f\u3002\n\n";
        this.per.buildContent0(this.list, str);
        try {
            this.buildData();
            this.buildDataType();
            this.buildCommData();
            this.buildCommonFlow();
            this.buildFormats();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.per.buildPdfReport("", "", "\u5317\u4eac\u5b87\u4fe1\u6613\u8bda", this.getTime(), "\u5de5\u7a0b\u8bbe\u8ba1\u6587\u6863", this.list, String.valueOf(this.dstPath) + "/Project.pdf");
        int i = 0;
        while (i < this.image.length) {
            if (this.image[i] == null) {
                return;
            }
            this.imageFile = new File(this.image[i]);
            this.imageFile.delete();
            ++i;
        }
    }

    private void buildData() {
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("contentType", "0");
        newMap.put("content", "1.  \u6570\u636e\u5b57\u5178\n\r");
        this.list.add(newMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] tableHeader = new String[]{"\u4e2d\u6587\u540d\u79f0", "\u7c7b\u578b", "\u63cf\u8ff0", "ID"};
        ArrayList dataList = new ArrayList();
        int i = 0;
        while (i < this.dataDictionary.getChilds().size()) {
            XMLNode childNode = (XMLNode)this.dataDictionary.getChilds().elementAt(i);
            if (!"#text".equals(childNode.getNodeName())) {
                if (childNode == null) {
                    String msg = Messages.getString("MCIProjectDocumentBuilder.MCI_dictionary__file_error__!_81");
                    super.reportProblem(2, msg, "");
                } else if ("dataGroup".equals(childNode.getNodeName())) {
                    int k = 0;
                    while (k < childNode.getChilds().size()) {
                        XMLNode aChildNode = (XMLNode)childNode.getChilds().elementAt(k);
                        if (!"#text".equals(aChildNode.getNodeName())) {
                            this.addDataDefine(aChildNode, dataList);
                        }
                        ++k;
                    }
                } else {
                    this.addDataDefine(childNode, dataList);
                }
            }
            ++i;
        }
        map.put("contentType", "1");
        map.put("dataList", dataList);
        map.put("tableHeader", tableHeader);
        this.list.add(map);
    }

    private void addDataDefine(XMLNode dictionaryNode, ArrayList list) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        String nodeName = dictionaryNode.getNodeName();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            map1.put("1", dictionaryNode.getDocument());
            map1.put("2", dictionaryNode.getAttrValue("dataType"));
            map1.put("3", dictionaryNode.getAttrValue("label"));
            map1.put("4", dictionaryNode.getAttrValue("id"));
        } else if (nodeName.equals("dataCollection")) {
            map1.put("1", dictionaryNode.getDocument());
            map1.put("2", "");
            map1.put("3", dictionaryNode.getAttrValue("label"));
            map1.put("4", dictionaryNode.getAttrValue("id"));
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.addDataDefine(aNode, list);
                }
                ++i;
            }
        } else if (nodeName.equals("refData")) {
            String refId = dictionaryNode.getAttrValue("refId");
            XMLNode dataNode = this.dataDictionary.findChildNode(refId);
            if (dataNode != null) {
                map1.put("1", "");
                map1.put("2", "");
                map1.put("3", dataNode.getAttrValue("label"));
                map1.put("4", refId);
            } else {
                map1.put("1", "");
                map1.put("2", "");
                map1.put("3", "");
                map1.put("4", refId);
            }
        } else if (nodeName.equals("selectData")) {
            map1.put("1", dictionaryNode.getDocument());
            map1.put("2", dictionaryNode.getAttrValue("dataType"));
            map1.put("3", dictionaryNode.getAttrValue("label"));
            map1.put("4", dictionaryNode.getAttrValue("id"));
        }
        list.add(map1);
    }

    private void buildDataType() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contentType", "0");
        map.put("content", "\n\r2.  \u7c7b\u578b\u5b9a\u4e49\n\r");
        this.list.add(map);
        int i = 0;
        while (i < this.dataTypeDefNode.getChilds().size()) {
            XMLNode node = (XMLNode)this.dataTypeDefNode.getChilds().elementAt(i);
            if ("dataType".equals(node.getNodeName())) {
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("contentType", "0");
                map1.put("content", String.valueOf(node.getAttrValue("name")) + "\n" + "\u6570\u636e\u7c7b\u578bID: \t" + node.getAttrValue("id") + "\r\n" + "\u7c7b\u578b\u8f6c\u6362\u7c7b:  \t" + node.getAttrValue("convertorClass") + "\r\n" + "\u7c7b\u578b\u6821\u9a8c\u7c7b:  \t" + node.getAttrValue("validatorClass") + "\r\n" + "\u8bf4\u660e:  " + node.getDocument() + "\r\n\u5c5e\u6027\u5b9a\u4e49\r\n");
                this.list.add(map1);
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                String[] tableHeader = new String[]{"\u5c5e\u6027ID", "\u5c5e\u6027\u540d\u79f0", "\u8bf4\u660e"};
                ArrayList dataList = new ArrayList();
                XMLNode attrsNode = node.getChild("attributes");
                if (attrsNode.getChilds().size() != 0) {
                    int k = 0;
                    while (k < attrsNode.getChilds().size()) {
                        XMLNode attrNode = (XMLNode)attrsNode.getChilds().elementAt(k);
                        if ("attr".equals(attrNode.getNodeName())) {
                            HashMap<String, String> dataMap = new HashMap<String, String>();
                            dataMap.put("1", attrNode.getDocument());
                            dataMap.put("2", attrNode.getAttrValue("name"));
                            dataMap.put("3", attrNode.getAttrValue("id"));
                            dataList.add(dataMap);
                        }
                        ++k;
                    }
                    map2.put("contentType", "1");
                    map2.put("dataList", dataList);
                    map2.put("tableHeader", tableHeader);
                    this.list.add(map2);
                }
            }
            ++i;
        }
    }

    private void buildCommData() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contentType", "0");
        map.put("content", "\r\n3.  \u516c\u5171\u6570\u636e\u5b9a\u4e49\r\n");
        this.list.add(map);
        XMLNode commDataNode = this.dataDictionary.getChild("CommonData");
        this.buildDataRefTable(commDataNode);
    }

    /*
     * Unable to fully structure code
     */
    private void buildDataRefTable(XMLNode datasRefNode) {
        map = new HashMap<String, Object>();
        tableHeader = new String[]{"ID", "\u6570\u636e\u540d\u79f0", "\u8bbf\u95ee\u65b9\u5f0f", "\u521d\u59cb\u503c"};
        dataList = new ArrayList<E>();
        i = 0;
        while (i < datasRefNode.getChilds().size()) {
            block5: {
                block6: {
                    refNode = (XMLNode)datasRefNode.getChilds().elementAt(i);
                    if ("#text".equals(refNode.getNodeName())) break block5;
                    refId = refNode.getAttrValue("refId");
                    defaultValue = refNode.getAttrValue("defaultValue");
                    if (!"dataGroup".equals(refNode.getNodeName())) break block6;
                    this.addDataDefine(refNode, defaultValue, dataList);
                    ** GOTO lbl-1000
                }
                if ("refCommData".equals(refNode.getNodeName())) {
                    this.addDataDefine(refNode, defaultValue, dataList);
                } else lbl-1000:
                // 2 sources

                {
                    childNode = this.dataDictionary.findChildNode(refId);
                    if (childNode == null) {
                        msg = String.valueOf(Messages.getString("MCITrxDesignDocumentBuilder.Error_MCI_Transaction_file_refer_to_unknow_dataDefine_[_104")) + refId + "]!";
                        super.reportProblem(2, msg, "");
                    } else {
                        this.addDataDefine(childNode, defaultValue, dataList);
                    }
                }
            }
            ++i;
        }
        map.put("contentType", "1");
        map.put("dataList", dataList);
        map.put("tableHeader", tableHeader);
        this.list.add(map);
    }

    private void addDataDefine(XMLNode dictionaryNode, String defaultValue, ArrayList list) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        String nodeName = dictionaryNode.getNodeName();
        if (nodeName.equals("dataElement") || nodeName.equals("selectData")) {
            map1.put("1", dictionaryNode.getDocument());
            map1.put("2", dictionaryNode.getAttrValue("dataType"));
            map1.put("3", dictionaryNode.getAttrValue("label"));
            map1.put("4", dictionaryNode.getAttrValue("id"));
        } else if (nodeName.equals("dataCollection")) {
            map1.put("1", dictionaryNode.getDocument());
            map1.put("2", "");
            map1.put("3", dictionaryNode.getAttrValue("label"));
            map1.put("4", dictionaryNode.getAttrValue("id"));
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.addDataDefine(aNode, null, list);
                }
                ++i;
            }
        } else if ("dataGroup".equals(nodeName)) {
            int i = 0;
            while (i < dictionaryNode.getChilds().size()) {
                XMLNode aNode = (XMLNode)dictionaryNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    this.addDataDefine(aNode, null, list);
                }
                ++i;
            }
        } else if ("refCommData".equals(nodeName)) {
            map1.put("1", "");
            map1.put("2", "");
            map1.put("3", "\u516c\u5171\u6570\u636e\u5b9a\u4e49\u5f15\u7528");
            map1.put("4", dictionaryNode.getAttrValue("refId"));
        } else if (nodeName.equals("refData")) {
            XMLNode dataNode = this.dataDictionary.findChildNode(dictionaryNode.getAttrValue("refId"));
            if (dataNode == null) {
                return;
            }
            map1.put("1", "");
            map1.put("2", dataNode.getAttrValue("dataType"));
            map1.put("3", dataNode.getAttrValue("label"));
            map1.put("4", dataNode.getAttrValue("id"));
        }
        list.add(map1);
    }

    private void buildCommonFlow() {
        String str = "\n4.  \u516c\u5171\u6d41\u7a0b\u5b9a\u4e49\n";
        this.per.buildContent0(this.list, str);
        int n = 0;
        int m = 0;
        while (n < this.flows.getChilds().size()) {
            XMLNode flowNode = (XMLNode)this.flows.getChilds().elementAt(n);
            if (!"#text".equals(flowNode.getNodeName())) {
                if (flowNode.getChilds() == null) {
                    return;
                }
                str = "\n+4." + ++m + "    \u6d41\u7a0b" + flowNode.getAttrValue("id") + "\r\n";
                this.per.buildContent0(this.list, str);
                int k = 0;
                while (k < flowNode.getChilds().size()) {
                    XMLNode actionNode = (XMLNode)flowNode.getChilds().elementAt(k);
                    if (!"#text".equals(actionNode.getNodeName()) && !actionNode.getNodeName().equals("attributes")) {
                        XMLNode stepNode = new XMLNode();
                        stepNode.setNodeName("opStep");
                        stepNode.setAttrValue("id", actionNode.getAttrValue("name"));
                        if (this.flowEditorProfile.getElement(actionNode.getNodeName()) != null) {
                            stepNode.setAttrValue("implClass", this.flowEditorProfile.getElement(actionNode.getNodeName()).getImplClass());
                        } else {
                            super.reportProblem(2, String.valueOf(Messages.getString("MCIProjectDocumentBuilder.No_set_implement_class_for_OpStep[_4")) + actionNode.getNodeName() + "]!", "");
                        }
                        Enumeration keys = actionNode.getAttrs().keys();
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            if (key.equals("name") || key.equals("x") || key.equals("y") || key.equals("width") || key.equals("height")) continue;
                            stepNode.setAttrValue(key, actionNode.getAttrValue(key));
                        }
                        if (actionNode.getChilds() != null) {
                            int j = 0;
                            while (j < actionNode.getChilds().size()) {
                                XMLNode transitionNode = (XMLNode)actionNode.getChilds().elementAt(j);
                                if (!"#text".equals(transitionNode.getNodeName())) {
                                    String dst = transitionNode.getAttrValue("dest");
                                    String idStr = transitionNode.getAttrValue("id");
                                    if (dst != null && idStr != null) {
                                        String key = "on" + idStr + "Do";
                                        stepNode.setAttrValue(key, dst);
                                    }
                                }
                                ++j;
                            }
                            String comment = "";
                            comment = actionNode.getDocument();
                            Element element = this.flowEditorProfile.getElement(actionNode.getNodeName());
                            Vector attrs = null;
                            if (element != null) {
                                attrs = element.getAttributes();
                            }
                            if (attrs != null) {
                                int i = 0;
                                while (i < attrs.size()) {
                                    ElementAttribute elementAttr = (ElementAttribute)attrs.elementAt(i);
                                    if ("states".equals(elementAttr.getAttrID())) {
                                        comment = String.valueOf(comment) + " " + elementAttr.getValueListStr();
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            str = "<!--" + comment + "-->";
                            this.per.buildContent0(this.list, str);
                            StringBuffer sBuff = new StringBuffer();
                            stepNode.toXMLContent(0, sBuff);
                            this.per.buildContent0(this.list, sBuff.toString());
                            VisualContentToImage visual = new VisualContentToImage();
                            try {
                                visual.setFlowEditorProfile(this.flowEditorProfile);
                                visual.setXMLContent(flowNode);
                            }
                            catch (Exception e) {
                                return;
                            }
                            visual.saveToImageFile(String.valueOf(this.dstPath) + "/flowImage" + m + ".jpg", 0);
                            visual.isImageOK();
                            this.per.buildContent2(this.list, String.valueOf(this.dstPath) + "/flowImage" + m + ".jpg");
                            this.image[m - 1] = String.valueOf(this.dstPath) + "flowImage" + m + ".jpg";
                        }
                    }
                    ++k;
                }
            }
            ++n;
        }
    }

    private void buildFormats() {
        String str = "\n5.  \u62a5\u6587\u5b9a\u4e49\n";
        this.per.buildContent0(this.list, str);
        int i = 0;
        int m = 0;
        while (i < this.hostSettings.getChilds().size()) {
            XMLNode hostNode = (XMLNode)this.hostSettings.getChilds().elementAt(i);
            if (!"#text".equals(hostNode.getNodeName())) {
                String pkgType;
                String id = hostNode.getAttrValue("id");
                str = "5." + ++m + "   \u8bbf\u95ee\u4e3b\u673a" + id + "\r\n";
                this.per.buildContent0(this.list, str);
                XMLNode reqNode = hostNode.getChild("request").getChild("datas");
                if (reqNode != null && reqNode.getChilds() != null && reqNode.getChilds().size() > 0 && (pkgType = reqNode.getAttrValue("packageType")) == null) {
                    String msg = String.valueOf(Messages.getString("MCIProjectDocumentBuilder.Error_Warnning_packageType_not_defined_for_host_[_100")) + id + Messages.getString("MCIProjectDocumentBuilder.]__s_request_!_101");
                    super.reportProblem(2, msg, "");
                }
            }
            ++i;
        }
    }

    private String getTime() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("", Locale.SIMPLIFIED_CHINESE);
        formatter.applyPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
        String time = formatter.format(date);
        return time;
    }

    private XMLNode loadXMLContent(InputStream in) {
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        try {
            XMLNode node = (XMLNode)xmlLoader.loadXMLContent(in);
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PdfPrjBuilder getInstance(IProject project) {
        PdfPrjBuilder builder = new PdfPrjBuilder();
        try {
            builder.dataEditorProfile = IDEProfile.getEditorProfile(project, 1);
            builder.flowEditorProfile = IDEProfile.getEditorProfile(project, 5);
            builder.serviceEditorProfile = IDEProfile.getEditorProfile(project, 13);
            builder.dataDictionary = IDEContent.getSettingNode(project, 0);
            builder.flows = IDEContent.getSettingNode(project, 5);
            builder.hostSettings = IDEContent.getSettingNode(project, 11);
            builder.packageType = IDEContent.getSettingNode(project, 14);
            builder.services = IDEContent.getSettingNode(project, 12);
            builder.channelSettings = IDEContent.getSettingNode(project, 19);
            builder.formatDefsNode = IDEContent.getSettingNode(project, 25);
            builder.dataTypeDefNode = IDEContent.getSettingNode(project, 33);
        }
        catch (Exception e) {
            return null;
        }
        return builder;
    }
}

