/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder.document;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PdfReport
extends PdfPageEventHelper {
    private static PdfPTable table;
    private static PdfGState gstate;
    private static PdfTemplate tpl;
    private static BaseFont helv;
    private static Font fontChinese;
    private static String pdfHeader;
    private static String dateHeader;

    PdfReport() {
    }

    public void buildContent0(ArrayList list, String str) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("contentType", "0");
        map1.put("content", str);
        list.add(map1);
    }

    public void buildContent1(ArrayList list, String[] tableHeader, ArrayList dataList) {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("contentType", "1");
        map2.put("dataList", dataList);
        map2.put("tableHeader", tableHeader);
        list.add(map2);
    }

    public void buildContent2(ArrayList list, String url) {
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("contentType", "2");
        map3.put("url", url);
        list.add(map3);
    }

    public void buildPdfReport(String pageSize, String pageType, String pdfHeader, String dateHeader, String title, ArrayList dataList, String fileName) {
        PdfReport.pdfHeader = pdfHeader;
        PdfReport.dateHeader = dateHeader;
        Document doc = PdfReport.newDocument(pageSize, pageType);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(fileName));
            PdfReport pageEvent = new PdfReport();
            writer.setPageEvent((PdfPageEvent)pageEvent);
            doc.open();
            PdfReport.documentContent(doc, title, dataList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        doc.close();
    }

    public PdfReport(String pageSize, String pageType, String pdfHeader, String dateHeader, String title, ArrayList dataList, ByteArrayOutputStream output) {
        Document doc = PdfReport.newDocument(pageSize, pageType);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)output);
            PdfReport pageEvent = new PdfReport();
            writer.setPageEvent((PdfPageEvent)pageEvent);
            doc.open();
            PdfReport.documentContent(doc, title, dataList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        doc.close();
    }

    private static Document newDocument(String pageSize, String pageType) {
        Rectangle rectangle = null;
        Document doc = null;
        if (pageSize == null || pageSize.equals("") || pageSize.equalsIgnoreCase("A4")) {
            rectangle = PageSize.A4;
        } else if (pageSize.equalsIgnoreCase("A5")) {
            rectangle = PageSize.A5;
        }
        if (pageType != null && pageType.equals("0")) {
            rectangle = rectangle.rotate();
        }
        doc = new Document(rectangle, 50.0f, 50.0f, 50.0f, 72.0f);
        return doc;
    }

    private static void documentContent(Document doc, String title, ArrayList dataList) {
        PdfReport.setTitle(String.valueOf(title) + "\n\n", doc);
        int i = 0;
        while (i < dataList.size()) {
            HashMap map = (HashMap)dataList.get(i);
            String contentType = (String)map.get("contentType");
            if (contentType.endsWith("0")) {
                String content = (String)map.get("content");
                PdfReport.documentPhrase(doc, content);
            } else if (contentType.endsWith("1")) {
                ArrayList data = (ArrayList)map.get("dataList");
                String[] tableHeader = (String[])map.get("tableHeader");
                PdfReport.tableBuilder(doc, tableHeader, data);
            } else if (contentType.endsWith("2")) {
                String url = (String)map.get("url");
                PdfReport.image(doc, url);
            }
            ++i;
        }
    }

    private static void image(Document doc, String url) {
        try {
            Image img = Image.getInstance((String)url);
            img.setAlignment(1);
            img.setBorder(2);
            img.scalePercent(80.0f);
            doc.add((Element)img);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void documentPhrase(Document doc, String content) {
        try {
            Phrase phrase = new Phrase(content, new Font(helv, 14.0f, 0, Color.black));
            doc.add((Element)phrase);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private static void tableBuilder(Document document, String[] tableHeader, ArrayList list) {
        try {
            PdfPTable datatable = new PdfPTable(tableHeader.length);
            datatable.getDefaultCell().setPadding(1.0f);
            datatable.setWidthPercentage(100.0f);
            datatable.setSpacingBefore(3.0f);
            datatable.getDefaultCell().setBorderWidth(1.0f);
            datatable.getDefaultCell().setHorizontalAlignment(1);
            int i = 0;
            while (i < tableHeader.length) {
                PdfPCell cell = new PdfPCell((Phrase)new Paragraph(tableHeader[i], fontChinese));
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(new Color(192, 192, 192));
                cell.setMinimumHeight(20.0f);
                datatable.addCell(cell);
                ++i;
            }
            datatable.setHeaderRows(1);
            datatable.getDefaultCell().setBorderWidth(0.0f);
            i = 0;
            while (i < list.size()) {
                HashMap map = (HashMap)list.get(i);
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    PdfPCell cell = new PdfPCell((Phrase)new Paragraph((String)map.get((String)it.next()), fontChinese));
                    cell.setHorizontalAlignment(1);
                    datatable.addCell(cell);
                }
                ++i;
            }
            document.add((Element)datatable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setTitle(String title, Document document) {
        Paragraph par = new Paragraph(title, new Font(helv, 14.0f, 0, Color.black));
        par.setAlignment(1);
        par.setLeading(20.0f);
        try {
            document.add((Element)par);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        try {
            helv = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            fontChinese = new Font(helv, 8.0f, 0, Color.black);
            table = new PdfPTable(2);
            Phrase p = new Phrase();
            Chunk ck = new Chunk(String.valueOf(pdfHeader) + "\n", new Font(helv, 8.0f, 0, Color.black));
            p.add((Object)ck);
            Phrase pp = new Phrase();
            Chunk ckk = new Chunk(String.valueOf(dateHeader) + "\n", new Font(helv, 8.0f, 0, Color.black));
            pp.add((Object)ckk);
            table.getDefaultCell().setBorderWidth(0.0f);
            table.addCell(p);
            table.getDefaultCell().setHorizontalAlignment(2);
            table.addCell(pp);
            gstate = new PdfGState();
            gstate.setFillOpacity(0.3f);
            gstate.setStrokeOpacity(0.3f);
            tpl = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            tpl.setBoundingBox(new Rectangle(-20.0f, -20.0f, 50.0f, 50.0f));
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        table.setTotalWidth(document.right() - document.left());
        table.writeSelectedRows(0, -1, document.left(), document.getPageSize().height() - 20.0f, cb);
        String text = "\u7b2c  " + writer.getPageNumber() + "  \u9875   \u5171  ";
        float textSize = helv.getWidthPoint(text, 8.0f);
        float textBase = document.bottom() - 20.0f;
        cb.beginText();
        cb.setFontAndSize(helv, 8.0f);
        cb.setTextMatrix(document.right() / 2.0f, textBase);
        cb.showText(String.valueOf(text) + "    \u9875 ");
        cb.endText();
        cb.addTemplate(tpl, document.right() / 2.0f + textSize, textBase);
    }

    public void onStartPage(PdfWriter writer, Document document) {
        if (writer.getPageNumber() < 3) {
            PdfContentByte cb = writer.getDirectContentUnder();
            cb.saveState();
            cb.setColorFill(Color.pink);
            cb.beginText();
            cb.setFontAndSize(helv, 48.0f);
            cb.endText();
            cb.restoreState();
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        tpl.beginText();
        tpl.setFontAndSize(helv, 8.0f);
        tpl.setTextMatrix(0.0f, 0.0f);
        tpl.showText("" + (writer.getPageNumber() - 1));
        tpl.endText();
    }
}

