/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder.format;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.format.FormatGenerator;
import com.ecc.ide.editor.XMLNode;
import java.util.Enumeration;
import org.eclipse.core.resources.IProject;

public class BOB8583FormatGenerator
implements FormatGenerator {
    private BuildProblemReporter reporter;

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public XMLNode generateFormatNode(XMLNode refDataNode, XMLNode dataDictionary, IProject project) {
        XMLNode node = new XMLNode();
        node.setNodeName("fmtDef");
        XMLNode recordNode = new XMLNode();
        recordNode.setNodeName("BCCBISO8583Format");
        if ("EBCDIC".equals(refDataNode.getAttrValue("codeSet"))) {
            recordNode.setAttrValue("EBCDIC", "true");
        }
        node.add(recordNode);
        this.addAttributesToNode(recordNode, refDataNode);
        int i = 0;
        while (i < refDataNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)refDataNode.getChilds().elementAt(i);
            this.addFmtElementDefine(recordNode, aNode);
            ++i;
        }
        return node;
    }

    private void addFmtElementDefine(XMLNode pNode, XMLNode dataNode) {
        String nodeName = dataNode.getNodeName();
        if (nodeName.equals("refData")) {
            XMLNode strNode = new XMLNode();
            strNode.setNodeName("BCCBISO8583Field");
            strNode.setAttrValue("dataName", dataNode.getAttrValue("refId"));
            pNode.add(strNode);
            this.addAttributesToNode(strNode, dataNode);
        }
    }

    private void addAttributesToNode(XMLNode node, XMLNode src) {
        Enumeration keys = src.getAttrs().keys();
        while (keys.hasMoreElements()) {
            String aKey = (String)keys.nextElement();
            if (!aKey.equals("refFmt") && !aKey.equals("maxMessageSize") && !aKey.equals("msgTypeField") && !aKey.equals("msgType") && !aKey.equals("fieldIdx") && !aKey.equals("IOType") && !aKey.equals("fieldState")) continue;
            node.setAttrValue(aKey, src.getAttrValue(aKey));
        }
    }

    public void setMessageHeadID(String s) {
    }
}

