/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder.format;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.format.FormatGenerator;
import com.ecc.ide.editor.XMLNode;
import org.eclipse.core.resources.IProject;

public class ICBCXMLFormatGenerator
implements FormatGenerator {
    private String msgHeadID = null;
    private BuildProblemReporter reporter;

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public XMLNode generateFormatNode(XMLNode refDataNode, XMLNode dataDictionary, IProject project) {
        XMLNode node = new XMLNode();
        node.setNodeName("fmtDef");
        XMLNode recordNode = new XMLNode();
        recordNode.setNodeName("record");
        node.add(recordNode);
        if (this.msgHeadID != null && this.msgHeadID.length() > 0) {
            XMLNode refHeadNode = new XMLNode();
            refHeadNode.setNodeName("refFmt");
            refHeadNode.setAttrValue("refId", this.msgHeadID);
            recordNode.add(refHeadNode);
        }
        XMLNode headNode = new XMLNode("xmlHead");
        headNode.setAttrValue("version", refDataNode.getParent().getAttrValue("version"));
        headNode.setAttrValue("encoding", refDataNode.getParent().getAttrValue("encoding"));
        headNode.setAttrValue("standalone", refDataNode.getParent().getAttrValue("standalone"));
        recordNode.add(headNode);
        this.addFmtElementDefine(recordNode, refDataNode);
        return node;
    }

    private void addFmtElementDefine(XMLNode pNode, XMLNode dataNode) {
        int i = 0;
        while (i < dataNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)dataNode.getChilds().elementAt(i);
            String nodeName = aNode.getNodeName();
            if (nodeName.equals("refData")) {
                XMLNode strNode = new XMLNode();
                String refId = aNode.getAttrValue("refId");
                if ("constant".equals(refId)) {
                    strNode.setNodeName("xmlConstantTag");
                    strNode.setAttrValue("tagName", aNode.getAttrValue("tagName"));
                    strNode.setAttrValue("value", aNode.getAttrValue("value"));
                    strNode.setAttrValue("format", aNode.getAttrValue("format"));
                } else {
                    strNode.setNodeName("xmlFullTag");
                    strNode.setAttrValue("tagName", aNode.getAttrValue("tagName"));
                    strNode.setAttrValue("dataName", aNode.getAttrValue("refId"));
                }
                pNode.add(strNode);
            } else if (nodeName.equals("refColl")) {
                XMLNode iNode = new XMLNode("iCollF");
                iNode.setAttrValue("append", aNode.getAttrValue("append"));
                iNode.setAttrValue("times", aNode.getAttrValue("times"));
                iNode.setAttrValue("dataName", aNode.getAttrValue("refId"));
                pNode.add(iNode);
                XMLNode recordNode = new XMLNode("record");
                iNode.add(recordNode);
                this.addFmtElementDefine(recordNode, aNode);
            } else if (nodeName.equals("dataGroup")) {
                this.addDataGroupDefine(pNode, aNode);
            }
            ++i;
        }
    }

    private void addDataGroupDefine(XMLNode pNode, XMLNode defNode) {
        XMLNode node = new XMLNode("xmlTag");
        node.setAttrValue("tagName", defNode.getAttrValue("tagName"));
        pNode.add(node);
        int i = 0;
        while (i < defNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)defNode.getChilds().elementAt(i);
            String nodeName = aNode.getNodeName();
            if (nodeName.equals("refData")) {
                XMLNode strNode = new XMLNode();
                String refId = aNode.getAttrValue("refId");
                if ("constant".equals(refId)) {
                    strNode.setNodeName("xmlConstantTag");
                    strNode.setAttrValue("tagName", aNode.getAttrValue("tagName"));
                    strNode.setAttrValue("value", aNode.getAttrValue("value"));
                    strNode.setAttrValue("format", aNode.getAttrValue("format"));
                } else {
                    strNode.setNodeName("xmlFullTag");
                    strNode.setAttrValue("tagName", aNode.getAttrValue("tagName"));
                    strNode.setAttrValue("dataName", aNode.getAttrValue("refId"));
                }
                pNode.add(strNode);
            } else if (nodeName.equals("refColl")) {
                XMLNode iNode = new XMLNode("iCollF");
                iNode.setAttrValue("append", aNode.getAttrValue("append"));
                iNode.setAttrValue("times", aNode.getAttrValue("times"));
                iNode.setAttrValue("dataName", aNode.getAttrValue("refId"));
                pNode.add(iNode);
                XMLNode recordNode = new XMLNode("record");
                iNode.add(recordNode);
                this.addFmtElementDefine(recordNode, aNode);
            } else if (nodeName.equals("dataGroup")) {
                this.addDataGroupDefine(pNode, aNode);
            }
            ++i;
        }
        XMLNode endNode = new XMLNode("xmlEndTag");
        endNode.setAttrValue("tagName", defNode.getAttrValue("tagName"));
        pNode.add(endNode);
    }

    public void setMessageHeadID(String headID) {
        this.msgHeadID = headID;
    }
}

