/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.builder.format;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.format.FormatGenerator;
import com.ecc.ide.editor.XMLNode;
import java.util.Enumeration;
import org.eclipse.core.resources.IProject;

public class ISO8583FormatGenerator
implements FormatGenerator {
    private BuildProblemReporter reporter;

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public XMLNode generateFormatNode(XMLNode refDataNode, XMLNode dataDictionary, IProject project) {
        XMLNode node = new XMLNode();
        node.setNodeName("fmtDef");
        node.setAttrValue("isBin", "true");
        XMLNode recordNode = new XMLNode();
        recordNode.setNodeName("ISO8583PkgFmt");
        recordNode.setAttrValue("codeSet", refDataNode.getAttrValue("codeSet"));
        recordNode.setAttrValue("msgType", refDataNode.getAttrValue("msgType"));
        recordNode.setAttrValue("maxMessageSize", refDataNode.getAttrValue("maxMessageSize"));
        recordNode.setAttrValue("formatDefine", refDataNode.getAttrValue("formatDefine"));
        node.add(recordNode);
        this.addAttributesToNode(recordNode, refDataNode);
        int i = 0;
        while (i < refDataNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)refDataNode.getChilds().elementAt(i);
            this.addFmtElementDefine(recordNode, aNode);
            ++i;
        }
        return node;
    }

    private void addFmtElementDefine(XMLNode pNode, XMLNode dataNode) {
        String nodeName = dataNode.getNodeName();
        if (nodeName.equals("refData")) {
            XMLNode strNode = new XMLNode();
            strNode.setNodeName("ISO8583Field");
            strNode.setAttrValue("dataName", dataNode.getAttrValue("refId"));
            pNode.add(strNode);
            this.addAttributesToNode(strNode, dataNode);
        }
    }

    private void addAttributesToNode(XMLNode node, XMLNode src) {
        Enumeration keys = src.getAttrs().keys();
        while (keys.hasMoreElements()) {
            String aKey = (String)keys.nextElement();
            if (!aKey.equals("codeSet") && !aKey.equals("fieldType") && !aKey.equals("fieldLength") && !aKey.equals("fieldValue") && !aKey.equals("padchar") && !aKey.equals("alignment") && !aKey.equals("fieldIdx") && !aKey.equals("IOType") && !aKey.equals("fieldState") && !aKey.equals("codeConvert") && !aKey.equals("refFormat")) continue;
            node.setAttrValue(aKey, src.getAttrValue(aKey));
        }
    }

    public void setMessageHeadID(String headID) {
    }
}

