/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.classloader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class DynamicClassLoader
extends ClassLoader {
    private String dir;

    public DynamicClassLoader(ClassLoader parent, String dir) {
        super(parent);
        this.dir = dir;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.loadClassBytes(name);
        Class<?> theClass = this.defineClass(name, bytes, 0, bytes.length);
        if (theClass == null) {
            throw new ClassFormatError();
        }
        return theClass;
    }

    private byte[] loadClassBytes(String className) throws ClassNotFoundException {
        try {
            int i;
            String classFile = this.getClassFile(className);
            FileInputStream fStream = new FileInputStream(classFile);
            FileChannel fChannel = fStream.getChannel();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            WritableByteChannel outChannel = Channels.newChannel(outStream);
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            while ((i = fChannel.read(buffer)) != 0 && i != -1) {
                buffer.flip();
                outChannel.write(buffer);
                buffer.clear();
            }
            fStream.close();
            return outStream.toByteArray();
        }
        catch (IOException fnfe) {
            throw new ClassNotFoundException(className);
        }
    }

    private String getClassFile(String name) {
        StringBuffer buffer = new StringBuffer(this.dir);
        name = String.valueOf(name.replace('.', File.separatorChar)) + ".class";
        buffer.append(String.valueOf(File.separator) + name);
        return buffer.toString();
    }

    protected URL findResource(String name) {
        try {
            URL url = super.findResource(name);
            if (url != null) {
                return url;
            }
            url = new URL("file:///" + this.converName(name));
            return url;
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private String converName(String name) {
        StringBuffer buffer = new StringBuffer(this.dir);
        name = name.replace('.', File.separatorChar);
        buffer.append(String.valueOf(File.separator) + name);
        return buffer.toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        System.out.println("JsportsClassLoader has been finalized.");
    }

    public static Object loadDynamicObject(IProject project, String className) {
        String path = null;
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            path = project.getFile(javaProject.getOutputLocation().removeFirstSegments(1)).getLocation().toString();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!(loader instanceof DynamicClassLoader)) {
            loader = new DynamicClassLoader(Thread.currentThread().getContextClassLoader(), path);
        }
        try {
            Object o = loader.loadClass(className).newInstance();
            return o;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

