/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.document.word;

public class WordDocument {
    private long documentHandler;
    private boolean isOpened = false;
    private boolean isClosed = false;

    public WordDocument(long handler) {
        this.documentHandler = handler;
        this.isOpened = true;
    }

    public WordDocument() {
        this.documentHandler = this.createNewDocument();
        this.isOpened = true;
    }

    public WordDocument(String fileName) {
        this.createDocument(fileName);
        this.isOpened = true;
    }

    public void createDocument(String fileName) {
        this.documentHandler = this._createDocument(fileName.getBytes());
        this.isOpened = true;
    }

    public void typeText(String text) {
        if (!this.isOpened) {
            System.out.println("Please open the documnet first!");
            return;
        }
        if (text != null) {
            this.typeText(this.documentHandler, text.getBytes());
        }
    }

    public void moveDown(int unit, int count) {
        this.moveDown(this.documentHandler, unit, count);
    }

    public void moveUp(int unit, int count) {
        this.moveUp(this.documentHandler, unit, count);
    }

    public void moveRight(int unit, int count) {
        this.moveRight(this.documentHandler, unit, count);
    }

    public void setStyle(String style) {
        this.setStyle(this.documentHandler, style.getBytes());
    }

    public void addTable(int rows, int columns, String[] titles) {
        byte[][] titleBytes = new byte[columns][];
        int i = 0;
        while (i < columns) {
            titleBytes[i] = titles[i].getBytes();
            ++i;
        }
        this.addTable(this.documentHandler, rows, columns, titleBytes);
    }

    public void moveToHome() {
        this.moveToHome(this.documentHandler);
    }

    public void insertRowsBelow(int count) {
        this.insertRowsBelow(this.documentHandler, count);
    }

    public void addPicture(String fileName) {
        this.addPicture(this.documentHandler, fileName.getBytes());
    }

    public void saveAs(String fileName) {
        this.saveAs(this.documentHandler, fileName.getBytes());
    }

    public void gotoFirst(int titleId) {
        this.gotoFirst(this.documentHandler, titleId);
    }

    public void close() {
        this.close(this.documentHandler);
    }

    public void find(String content) {
        this.find(this.documentHandler, content.getBytes());
    }

    public void moveToNextTitle(int count) {
        this.moveToNextTitle(this.documentHandler, count);
    }

    private native long _createDocument(byte[] var1);

    private native long createNewDocument();

    private native void typeText(long var1, byte[] var3);

    private native void moveDown(long var1, int var3, int var4);

    private native void moveUp(long var1, int var3, int var4);

    private native void moveRight(long var1, int var3, int var4);

    private native void saveAs(long var1, byte[] var3);

    private native void close(long var1);

    private native void insertRowsBelow(long var1, int var3);

    private native void setStyle(long var1, byte[] var3);

    private native void addTable(long var1, int var3, int var4, byte[][] var5);

    private native void addPicture(long var1, byte[] var3);

    private native void find(long var1, byte[] var3);

    private native void moveToNextTitle(long var1, int var3);

    private native void moveToHome(long var1);

    private native void gotoFirst(long var1, int var3);
}

