/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.editor.CustomPropertyDialog;
import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.Messages;
import com.ecc.ide.editor.PropertyEditor;
import com.ecc.ide.editor.Wrapper;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

public class CustomProperty
implements SelectionListener,
KeyListener {
    private Wrapper wrapper;
    private PropertyEditor editor;
    private Button button;
    private String attrName;
    protected EditorBeanPropertyPanel propertyPanel;

    public CustomProperty(Wrapper wrapper, PropertyEditor editor, Button button, String attrName) {
        this.wrapper = wrapper;
        this.editor = editor;
        this.button = button;
        this.attrName = attrName;
        button.addSelectionListener((SelectionListener)this);
        button.addKeyListener((KeyListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        CustomPropertyDialog dialog = new CustomPropertyDialog(this.button.getShell(), 0);
        dialog.setText(String.valueOf(Messages.getString("CustomProperty.Setting_attribute_of_--__1")) + this.attrName);
        dialog.setPropertyEditor(this.editor);
        Object result = dialog.open();
        if (result != null) {
            try {
                this.editor.setValue(result);
                this.wrapper.setAttrValue(this.attrName, result);
                this.propertyPanel.updatePropertyPanel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 13) {
            this.propertyPanel.editNextProperty();
        } else if (e.keyCode == 0x1000001) {
            this.propertyPanel.editLastProperty();
        } else if (e.keyCode == 0x1000002) {
            this.propertyPanel.editNextProperty();
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

