/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.editor.CustomProperty;
import com.ecc.ide.editor.Editor;
import com.ecc.ide.editor.Messages;
import com.ecc.ide.editor.PropertyEditor;
import com.ecc.ide.editor.PropertyEditorSuport;
import com.ecc.ide.editor.SelectProperty;
import com.ecc.ide.editor.SelectPropertyEditor;
import com.ecc.ide.editor.TextProperty;
import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.util.formula.CFormula;
import com.ecc.util.formula.FormulaValue;
import com.ecc.util.formula.LexicalAnalyser;
import com.ecc.util.formula.VariableController;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class EditorBeanPropertyPanel
extends Composite
implements MouseListener,
FocusListener,
ControlListener,
MouseMoveListener,
VariableController {
    private Wrapper wrapper;
    int leftWidth = 50;
    int grideHeight = 20;
    int buttonWidth = 20;
    private Control propertyEditorControl;
    private Control secondpropertyEditorControl;
    private SelectProperty selectProperty;
    private TextProperty textProperty;
    private CustomProperty customProperty;
    private int curIdx = -1;
    private int moveIdx = -1;
    private String curAttrValue;
    private String curAttrName;
    boolean isDrage = false;
    public Editor mainEditor;
    private Hashtable propertyEditors = new Hashtable();
    private Vector boolValueList = new Vector(10);
    private Vector curProperties = new Vector();
    private DropTarget dropTarget;

    public EditorBeanPropertyPanel(Composite parent, int style) {
        super(parent, style);
        this.boolValueList.addElement("true");
        this.boolValueList.addElement("false");
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                EditorBeanPropertyPanel.this.paint(event);
            }
        });
        parent.addControlListener((ControlListener)this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.creatDictDropTarget();
    }

    public void controlResized(ControlEvent ce) {
        Point size = this.getParent().getSize();
        size.y -= 5;
        Vector attrs = null;
        if (this.wrapper != null) {
            Element element = this.wrapper.getElement();
            if (element != null) {
                attrs = element.getAttributes();
            }
            if (attrs != null) {
                int height = this.wrapper.getElement().getAttributes().size() * this.grideHeight;
                if (height > size.y) {
                    size.y = height;
                    size.x -= 20;
                } else {
                    size.x -= 5;
                }
            }
        }
        this.setSize(size);
        if (this.propertyEditorControl != null) {
            if (this.propertyEditorControl instanceof Button) {
                this.propertyEditorControl.setBounds(this.getSize().x - this.buttonWidth, this.curIdx * this.grideHeight + 1, this.buttonWidth, this.grideHeight - 2);
            } else {
                this.propertyEditorControl.setBounds(this.leftWidth + 2, this.curIdx * this.grideHeight + 1, this.getSize().x - this.leftWidth, this.grideHeight - 2);
            }
        }
    }

    public void controlMoved(ControlEvent ce) {
    }

    public void paint(PaintEvent event) {
        Vector attrs = null;
        if (this.wrapper != null) {
            Element element = this.wrapper.getElement();
            if (element == null) {
                return;
            }
            attrs = element.getAttributes();
        }
        Point size = this.getSize();
        Image image = new Image((Device)Display.getDefault(), size.x, size.y);
        GC gc = new GC((Drawable)image);
        size = this.getSize();
        int height = size.y - 1;
        int width = this.getSize().x - 1;
        gc.setForeground(this.getDisplay().getSystemColor(16));
        int idx = 0;
        int i = 0;
        while (i < this.curProperties.size()) {
            ElementAttribute attr = (ElementAttribute)this.curProperties.elementAt(i);
            if (attr.getMustSet()) {
                gc.setForeground(this.getDisplay().getSystemColor(3));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(2));
            }
            if (this.getMustSet(attr)) {
                gc.setForeground(this.getDisplay().getSystemColor(3));
            }
            int y = idx * this.grideHeight;
            ++idx;
            String attrName = attr.getAttrName();
            gc.setClipping(2, y, this.leftWidth, this.grideHeight);
            gc.drawString(attrName, 5, y + 2);
            gc.setClipping(this.leftWidth + 2, y, width - this.leftWidth, this.grideHeight);
            PropertyEditor editor = (PropertyEditor)this.propertyEditors.get(attr.getAttrID());
            if (editor == null) {
                editor = this.createPropertyEditor(attr);
            }
            if (editor != null && editor.getAsText() != null) {
                gc.drawString(TextProperty.normalize(editor.getAsText()), this.leftWidth + 5, y + 2);
            }
            try {
                if (this.secondpropertyEditorControl != null && this.secondpropertyEditorControl.getBounds().y < y + 2 && y + 2 < this.secondpropertyEditorControl.getBounds().y + this.secondpropertyEditorControl.getBounds().height) {
                    ((Text)this.secondpropertyEditorControl).setText(editor.getAsText());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        gc.setClipping(0, 0, width, height);
        gc.setForeground(this.getDisplay().getSystemColor(16));
        i = 0;
        while (i <= height) {
            gc.drawLine(0, i, width, i);
            i += this.grideHeight;
        }
        gc.drawLine(this.leftWidth, 0, this.leftWidth, height);
        gc.setForeground(this.getDisplay().getSystemColor(1));
        gc.drawLine(this.leftWidth + 1, 0, this.leftWidth + 1, height);
        event.gc.drawImage(image, 0, 0);
        image.dispose();
        gc.dispose();
    }

    public void showWrapperProperties(Wrapper wrapper) {
        Element element;
        this.wrapper = wrapper;
        if (this.propertyEditorControl != null) {
            this.propertyEditorControl.dispose();
            this.propertyEditorControl = null;
        }
        try {
            if (this.secondpropertyEditorControl != null) {
                this.secondpropertyEditorControl.dispose();
                this.secondpropertyEditorControl = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.curAttrValue = null;
        this.curAttrName = null;
        this.curIdx = -1;
        this.propertyEditors.clear();
        Vector attrs = null;
        if (wrapper != null && (element = wrapper.getElement()) != null) {
            attrs = element.getAttributes();
        }
        this.controlResized(null);
        if (attrs == null) {
            this.updatePropertyPanel();
            this.redraw();
            return;
        }
        int i = 0;
        while (i < attrs.size()) {
            ElementAttribute attr = (ElementAttribute)attrs.elementAt(i);
            this.createPropertyEditor(attr);
            ++i;
        }
        this.updatePropertyPanel();
    }

    private PropertyEditor createPropertyEditor(ElementAttribute attr) {
        if (!attr.getEditable()) {
            return null;
        }
        PropertyEditor editor = null;
        if (attr.getValueList() != null) {
            SelectPropertyEditor propEditor = new SelectPropertyEditor();
            propEditor.setValueList(attr.getValueList());
            propEditor.setValueMapList(attr.getValueMapList());
            propEditor.setAttrType(attr.getAttrType());
            this.propertyEditors.put(attr.getAttrID(), propEditor);
            propEditor.setValue((Object)this.wrapper.getAttrValue(attr.getAttrID()));
            editor = propEditor;
        } else if (attr.getAttrType() != null && attr.getAttrType().equals("boolean")) {
            SelectPropertyEditor propEditor = new SelectPropertyEditor();
            propEditor.setValueList(this.boolValueList);
            propEditor.setAttrType(attr.getAttrType());
            this.propertyEditors.put(attr.getAttrID(), propEditor);
            propEditor.setValue((Object)this.wrapper.getAttrValue(attr.getAttrID()));
            editor = propEditor;
        } else if (attr.getAttrEditorClass() != null) {
            try {
                PropertyEditor propEditor = (PropertyEditor)Class.forName(attr.getAttrEditorClass()).newInstance();
                this.propertyEditors.put(attr.getAttrID(), propEditor);
                propEditor.setValue(this.wrapper.getAttrValue(attr.getAttrID()));
                propEditor.setEditingWrapper(this.wrapper);
                propEditor.setEditor(this.mainEditor);
                editor = propEditor;
            }
            catch (Exception e) {
                e.printStackTrace();
                PropertyEditorSuport propEditor = new PropertyEditorSuport();
                this.propertyEditors.put(attr.getAttrID(), propEditor);
                propEditor.setValue(this.wrapper.getAttrValue(attr.getAttrID()));
                editor = propEditor;
            }
        } else {
            PropertyEditorSuport propEditor = new PropertyEditorSuport();
            this.propertyEditors.put(attr.getAttrID(), propEditor);
            propEditor.setValue(this.wrapper.getAttrValue(attr.getAttrID()));
            editor = propEditor;
        }
        return editor;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.x == this.leftWidth) {
            this.isDrage = true;
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.isDrage) {
            this.leftWidth = e.x;
            this.redraw();
            if (this.propertyEditorControl != null) {
                if (this.propertyEditorControl instanceof Button) {
                    this.propertyEditorControl.setBounds(this.getSize().x - this.buttonWidth, this.curIdx * this.grideHeight + 1, this.buttonWidth, this.grideHeight - 2);
                } else {
                    this.propertyEditorControl.setBounds(this.leftWidth + 2, this.curIdx * this.grideHeight + 1, this.getSize().x - this.leftWidth, this.grideHeight - 2);
                }
            }
        }
        if (e.x == this.leftWidth) {
            this.setCursor(IDEConstance.getCursor(9));
        } else {
            this.setCursor(IDEConstance.getCursor(0));
        }
        int idx = e.y / this.grideHeight;
        if (idx >= this.curProperties.size()) {
            return;
        }
        this.setHelpMsg(idx);
    }

    public void mouseUp(MouseEvent e) {
        this.isDrage = false;
        this.setCursor(IDEConstance.getCursor(0));
        if (this.wrapper == null) {
            return;
        }
        if (this.wrapper.getElement().getAttributes() == null) {
            return;
        }
        int idx = e.y / this.grideHeight;
        if (idx == this.curIdx) {
            return;
        }
        if (idx >= this.curProperties.size()) {
            return;
        }
        this.editProperty(idx);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private Control createPropertyEditorControl(PropertyEditor editor, String attrName) {
        if (editor.getTags() != null) {
            String[] tags = editor.getTags();
            Combo combo = tags.length > 0 ? new Combo((Composite)this, 2048) : new Combo((Composite)this, 2048);
            int i = 0;
            while (i < tags.length) {
                combo.add(tags[i]);
                ++i;
            }
            if (editor.getAsText() != null) {
                combo.setText(editor.getAsText());
            }
            this.selectProperty = new SelectProperty(this.wrapper, editor, combo, attrName);
            this.selectProperty.propertyPanel = this;
            return combo;
        }
        if (editor.isCustomEditor()) {
            Text text = new Text((Composite)this, 2048);
            if (editor.getAsText() != null) {
                text.setText(editor.getAsText());
            }
            this.textProperty = new TextProperty(this.wrapper, editor, text, attrName);
            if (editor instanceof PropertyEditorSuport) {
                ((PropertyEditorSuport)editor).setTextProperty(this.textProperty);
            }
            this.textProperty.propertyPanel = this;
            text.addFocusListener((FocusListener)this);
            text.setBounds(this.leftWidth + 2, this.curIdx * this.grideHeight + 1, this.getSize().x - this.leftWidth - this.buttonWidth, this.grideHeight - 2);
            try {
                if (this.secondpropertyEditorControl != null) {
                    this.secondpropertyEditorControl.dispose();
                    this.secondpropertyEditorControl = null;
                }
            }
            catch (Exception combo) {
                // empty catch block
            }
            this.secondpropertyEditorControl = text;
            Button button = new Button((Composite)this, 2048);
            button.setText(Messages.getString("EditorBeanPropertyPanel...._4"));
            Button button1 = new Button((Composite)this, 2048);
            button1.setText(">");
            this.customProperty = new CustomProperty(this.wrapper, editor, button, attrName);
            this.customProperty.propertyPanel = this;
            return button;
        }
        Text text = new Text((Composite)this, 2048);
        if (editor.getAsText() != null) {
            text.setText(editor.getAsText());
        }
        this.textProperty = new TextProperty(this.wrapper, editor, text, attrName);
        this.textProperty.propertyPanel = this;
        return text;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void editNextProperty() {
        int idx = this.curIdx + 1;
        if (idx >= this.curProperties.size()) {
            return;
        }
        this.editProperty(idx);
    }

    public void editLastProperty() {
        int idx = this.curIdx - 1;
        if (idx < 0) {
            return;
        }
        this.editProperty(idx);
    }

    private void setHelpMsg(int idx) {
        this.moveIdx = idx;
        ElementAttribute attr = (ElementAttribute)this.curProperties.elementAt(idx);
        String attrName = attr.getAttrID();
        String desc = attr.getDocument();
        if (desc == null || desc.length() == 0) {
            desc = attrName;
        }
        this.setToolTipText(desc);
    }

    private void editProperty(int idx) {
        this.curIdx = idx;
        if (this.propertyEditorControl != null) {
            this.propertyEditorControl.dispose();
            this.propertyEditorControl = null;
        }
        try {
            if (this.secondpropertyEditorControl != null) {
                this.secondpropertyEditorControl.dispose();
                this.secondpropertyEditorControl = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ElementAttribute attr = (ElementAttribute)this.curProperties.elementAt(idx);
        String attrName = attr.getAttrID();
        PropertyEditor editor = (PropertyEditor)this.propertyEditors.get(attrName);
        editor.setEditorProperty(attr.getEditorProperty());
        if (editor == null) {
            editor.setAsText(this.wrapper.getAttrValue(attrName));
        }
        this.propertyEditorControl = this.createPropertyEditorControl(editor, attrName);
        if (this.propertyEditorControl instanceof Button) {
            this.propertyEditorControl.setBounds(this.getSize().x - this.buttonWidth, this.curIdx * this.grideHeight + 1, this.buttonWidth, this.grideHeight - 2);
        } else {
            this.propertyEditorControl.setBounds(this.leftWidth + 2, this.curIdx * this.grideHeight + 1, this.getSize().x - this.leftWidth, this.grideHeight - 2);
        }
        this.propertyEditorControl.addFocusListener((FocusListener)this);
        this.propertyEditorControl.setFocus();
    }

    private boolean getEnabled(ElementAttribute attr) {
        String enableFormula = attr.getEnableFormula();
        if (enableFormula == null || enableFormula.length() == 0) {
            return true;
        }
        return this.getFormulaValue(enableFormula);
    }

    private boolean getMustSet(ElementAttribute attr) {
        String mustInputFormula = attr.getMustInputFormula();
        if (mustInputFormula == null || mustInputFormula.length() == 0) {
            return false;
        }
        return this.getFormulaValue(mustInputFormula);
    }

    private boolean getFormulaValue(String formula) {
        if (formula != null && formula.length() != 0) {
            LexicalAnalyser lexical = new LexicalAnalyser();
            CFormula valueFormula = new CFormula();
            try {
                lexical.string2TokenSequence(formula);
                valueFormula.setVariableController((VariableController)this);
                valueFormula.setContent(lexical);
                FormulaValue value = valueFormula.getValue();
                return value.bBooleanValue();
            }
            catch (Exception exception) {
                return true;
            }
        }
        return true;
    }

    public FormulaValue getVariableValue(String variableName) throws Exception {
        String var = variableName;
        char flag = var.charAt(0);
        var = var.substring(1);
        if (flag == '$') {
            FormulaValue formulaValue = new FormulaValue();
            formulaValue.nDataType = 6;
            try {
                String value = null;
                if (var.indexOf("parent_") != -1) {
                    var = var.substring(7);
                    XMLNode parentNode = ((XMLNode)this.wrapper.getWrappedObject()).getParent();
                    value = parentNode.getAttrValue(var);
                } else {
                    value = this.wrapper.getAttrValue(var);
                }
                formulaValue.nDataType = 2;
                formulaValue.sStringValue(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return formulaValue;
        }
        FormulaValue formulaValue = new FormulaValue();
        formulaValue.nDataType = 6;
        return formulaValue;
    }

    public void updatePropertyPanel() {
        Vector attrs = null;
        if (this.wrapper != null) {
            Element element = this.wrapper.getElement();
            if (element == null) {
                return;
            }
            attrs = element.getAttributes();
        }
        this.curProperties = new Vector();
        int i = 0;
        while (attrs != null && i < attrs.size()) {
            ElementAttribute attr = (ElementAttribute)attrs.elementAt(i);
            if (attr.getEditable() && this.getEnabled(attr)) {
                this.curProperties.addElement(attr);
            }
            ++i;
        }
        this.redraw();
    }

    public void creatDictDropTarget() {
        this.dropTarget = new DropTarget((Control)this, 3);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        this.dropTarget.setTransfer(types);
        this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                TextTransfer transfer = TextTransfer.getInstance();
                if (transfer.isSupportedType(event.currentDataType)) {
                    String source = (String)event.data;
                    int idx1 = source.indexOf(":");
                    if (idx1 >= 0) {
                        source = source.substring(idx1 + 1);
                    }
                    if (source.indexOf(";") == source.lastIndexOf(";")) {
                        source = source.substring(0, source.length() - 1);
                    }
                    int temp = EditorBeanPropertyPanel.this.getBounds().y;
                    Composite obj = EditorBeanPropertyPanel.this.getParent();
                    while (obj != null) {
                        temp += obj.getBounds().y;
                        obj = obj.getParent();
                    }
                    int idx = (temp = event.y - temp) / EditorBeanPropertyPanel.this.grideHeight - 2;
                    if (idx >= EditorBeanPropertyPanel.this.curProperties.size()) {
                        return;
                    }
                    try {
                        ElementAttribute attr = (ElementAttribute)EditorBeanPropertyPanel.this.curProperties.elementAt(idx);
                        String attrName = attr.getAttrID();
                        String desc = attr.getDocument();
                        if (desc == null || desc.length() == 0) {
                            desc = attrName;
                        }
                        EditorBeanPropertyPanel.this.wrapper.setAttrValue(attrName, source);
                        PropertyEditor editor = (PropertyEditor)EditorBeanPropertyPanel.this.propertyEditors.get(desc);
                        if (editor == null) {
                            editor = EditorBeanPropertyPanel.this.createPropertyEditor(attr);
                        }
                        editor.setAsText(source);
                        EditorBeanPropertyPanel.this.updatePropertyPanel();
                        EditorBeanPropertyPanel.this.redraw();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }
}

