/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.editor.Editor;
import com.ecc.ide.editor.ElementInfoPanel;
import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editorprofile.Element;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EditorBeanTreePanel
extends Composite {
    private Tree tree;
    private ElementInfoPanel text;
    private TreeItem rootItem;
    public Editor editor;

    public EditorBeanTreePanel(Composite parent, int style) {
        super(parent, style);
        StackLayout layout = new StackLayout();
        this.setLayout((Layout)layout);
        this.tree = new Tree((Composite)this, 2048);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = EditorBeanTreePanel.this.tree.getSelection();
                if (items.length <= 0) {
                    return;
                }
                Wrapper wrapper = (Wrapper)items[0].getData();
                if (EditorBeanTreePanel.this.editor != null) {
                    EditorBeanTreePanel.this.editor.setActivateWrapper(wrapper);
                }
            }
        });
        layout.topControl = this.tree;
        this.tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    EditorBeanTreePanel.this.deleteSelectedElement();
                }
            }

            public void keyReleased(KeyEvent event) {
            }
        });
        this.text = new ElementInfoPanel(this, 2048);
        this.layout();
    }

    public void deleteSelectedElement() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length <= 0) {
            return;
        }
        Wrapper wrapper = (Wrapper)items[0].getData();
        if (this.editor != null) {
            this.editor.deleteActivateComponent();
        }
    }

    public void setRootWrapper(Wrapper wrapper) {
        this.tree.removeAll();
        this.rootItem = new TreeItem(this.tree, 0);
        this.rootItem.setData((Object)wrapper);
        this.rootItem.setText(wrapper.getObjectName());
        Element element = wrapper.getElement();
        if (element != null && element.getImage() != null) {
            this.rootItem.setImage(element.getImage());
        }
        wrapper.setBeanTreeObject(this.rootItem);
    }

    public void addWrapper(Wrapper parent, Wrapper wrapper) {
        TreeItem item = new TreeItem((TreeItem)parent.getBeanTreeObject(), 0);
        item.setData((Object)wrapper);
        item.setText(wrapper.getObjectName());
        Element element = wrapper.getElement();
        if (element != null && element.getImage() != null) {
            item.setImage(element.getImage());
        }
        wrapper.setBeanTreeObject(item);
    }

    public void addWrapper(Wrapper parent, Wrapper wrapper, int idx) {
        TreeItem item = new TreeItem((TreeItem)parent.getBeanTreeObject(), 0, idx);
        item.setData((Object)wrapper);
        item.setText(wrapper.getObjectName());
        Element element = wrapper.getElement();
        if (element != null && element.getImage() != null) {
            item.setImage(element.getImage());
        }
        wrapper.setBeanTreeObject(item);
    }

    public void setActiveWrapper(Wrapper wrapper) {
        ((StackLayout)this.getLayout()).topControl = this.tree;
        this.layout();
        TreeItem item = (TreeItem)wrapper.getBeanTreeObject();
        this.tree.showItem(item);
        TreeItem[] items = new TreeItem[]{item};
        this.tree.setSelection(items);
    }

    public void removeWrapper(Wrapper wrapper) {
        TreeItem item = (TreeItem)wrapper.getBeanTreeObject();
        if (item != null) {
            item.dispose();
            this.tree.redraw();
        }
    }

    public void adjustTabOrder(Wrapper parent, Wrapper wrapper, int order) {
        TreeItem item = (TreeItem)wrapper.getBeanTreeObject();
        TreeItem parentItem = (TreeItem)parent.getBeanTreeObject();
        if (item != null) {
            TreeItem newItem = new TreeItem(parentItem, 0, order);
            wrapper.setBeanTreeObject(newItem);
            newItem.setData((Object)wrapper);
            newItem.setText(wrapper.getObjectName());
            Element element = wrapper.getElement();
            if (element != null && element.getImage() != null) {
                newItem.setImage(element.getImage());
            }
            if (item.getItemCount() > 0) {
                this.reConstructTheItemChilds(item, newItem);
            }
            item.dispose();
            this.tree.redraw();
        }
    }

    private void reConstructTheItemChilds(TreeItem item, TreeItem parent) {
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            Wrapper wrapper = (Wrapper)items[i].getData();
            TreeItem newItem = new TreeItem(parent, 0);
            wrapper.setBeanTreeObject(newItem);
            newItem.setData((Object)wrapper);
            newItem.setText(wrapper.getObjectName());
            Element element = wrapper.getElement();
            if (element != null && element.getImage() != null) {
                newItem.setImage(element.getImage());
            }
            if (items[i].getItemCount() > 0) {
                this.reConstructTheItemChilds(items[i], newItem);
            }
            items[i].dispose();
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void beginInsert(Element element) {
        this.text.setElement(element);
        ((StackLayout)this.getLayout()).topControl = this.text;
        this.layout();
    }
}

