/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.editor.EditorToolItemSelectedListener;
import com.ecc.ide.editor.EditorToolPanel;
import com.ecc.ide.editorprofile.Element;
import java.util.Vector;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class EditorToolItem
extends Composite {
    Vector itemSelectedListeners;
    boolean isSelected = false;
    boolean isGroup = false;
    boolean isMouseIn = false;
    String text;
    private Image image;
    Vector items = null;
    protected Element element = null;
    public static Image folderImage = null;
    static /* synthetic */ Class class$0;

    public void setElement(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public EditorToolItem(Composite parent, int style) {
        super(parent, style);
        if (parent instanceof EditorToolPanel) {
            EditorToolPanel toolPanel = (EditorToolPanel)parent;
            this.addEditorToolItemSelectedListener(toolPanel);
        }
        if (folderImage == null) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.ecc.ide.editor.EditorToolItem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ImageData source = new ImageData(clazz.getResourceAsStream("/images/openFolder.gif"));
                ImageData mask = source.getTransparencyMask();
                folderImage = new Image(null, source, mask);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setupAdaptors();
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setImageName(String imageName) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ecc.ide.editor.EditorToolItem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ImageData source = new ImageData(clazz.getResourceAsStream(imageName));
            ImageData mask = source.getTransparencyMask();
            this.image = new Image(null, source, mask);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void addItem(EditorToolItem item) {
        this.isGroup = true;
        if (this.items == null) {
            this.items = new Vector(10);
        }
        this.items.addElement(item);
        item.setVisible(false);
    }

    public Vector getChilds() {
        return this.items;
    }

    public boolean getIsSelected() {
        return this.isSelected;
    }

    public void setIsSelected(boolean value) {
        this.isSelected = value;
    }

    public boolean getIsGroup() {
        return this.isGroup;
    }

    private void setupAdaptors() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                Point size = EditorToolItem.this.getSize();
                int height = size.y - 1;
                int width = EditorToolItem.this.getSize().x - 1;
                if (EditorToolItem.this.isGroup) {
                    gc.setForeground(EditorToolItem.this.getDisplay().getSystemColor(1));
                    gc.drawLine(0, 0, width, 0);
                    gc.drawLine(0, 0, 0, height);
                    gc.setForeground(EditorToolItem.this.getDisplay().getSystemColor(16));
                    gc.drawLine(width, 0, width, height);
                    gc.drawLine(0, height, width, height);
                    if (EditorToolItem.this.image != null) {
                        int x = (width - 2 - 25) / 2;
                        gc.drawImage(EditorToolItem.this.image, x, 2);
                    } else if (folderImage != null) {
                        gc.drawImage(folderImage, 2, 2);
                    }
                } else {
                    if (EditorToolItem.this.isSelected) {
                        gc.setForeground(EditorToolItem.this.getDisplay().getSystemColor(16));
                        gc.drawLine(1, 1, width - 2, 1);
                        gc.drawLine(1, 1, 1, height);
                        gc.setForeground(EditorToolItem.this.getDisplay().getSystemColor(1));
                        gc.drawLine(width - 2, 1, width - 2, height);
                        gc.drawLine(1, height, width - 2, height);
                    } else if (EditorToolItem.this.isMouseIn) {
                        gc.setForeground(EditorToolItem.this.getDisplay().getSystemColor(1));
                        gc.drawLine(1, 1, width - 2, 1);
                        gc.drawLine(1, 1, 1, height);
                        gc.setForeground(EditorToolItem.this.getDisplay().getSystemColor(16));
                        gc.drawLine(width - 2, 1, width - 2, height);
                        gc.drawLine(1, height, width - 2, height);
                    }
                    if (EditorToolItem.this.image != null) {
                        int x = 2;
                        if (EditorToolItem.this.text == null) {
                            x = (width - 2 - 25) / 2;
                        }
                        gc.drawImage(EditorToolItem.this.image, x, 2);
                    } else if (EditorToolItem.this.element != null && EditorToolItem.this.element.getImage() != null) {
                        int x = 2;
                        if (EditorToolItem.this.text == null) {
                            x = (width - 2 - 25) / 2;
                        }
                        gc.drawImage(EditorToolItem.this.element.getImage(), x, 2);
                    }
                }
                gc.setForeground(EditorToolItem.this.getDisplay().getSystemColor(2));
                if (EditorToolItem.this.text != null) {
                    gc.drawText(EditorToolItem.this.text, 25, 5);
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (!EditorToolItem.this.isSelected) {
                    EditorToolItem.this.isSelected = true;
                    EditorToolItem.this.redraw();
                    EditorToolItem.this.fireEditorToolItemSelectedEvent();
                }
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                EditorToolItem.this.isMouseIn = true;
                EditorToolItem.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                EditorToolItem.this.isMouseIn = false;
                EditorToolItem.this.redraw();
            }
        });
    }

    public void addEditorToolItemSelectedListener(EditorToolItemSelectedListener listener) {
        if (this.itemSelectedListeners == null) {
            this.itemSelectedListeners = new Vector(5);
        }
        this.itemSelectedListeners.addElement(listener);
    }

    private void fireEditorToolItemSelectedEvent() {
        if (this.itemSelectedListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.itemSelectedListeners.size()) {
            EditorToolItemSelectedListener listener = (EditorToolItemSelectedListener)this.itemSelectedListeners.elementAt(i);
            listener.EditorToolItemSelected(this);
            ++i;
        }
    }

    public static Image getFolderImage() {
        if (folderImage == null) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.ecc.ide.editor.EditorToolItem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ImageData source = new ImageData(clazz.getResourceAsStream("/images/openFolder.gif"));
                ImageData mask = source.getTransparencyMask();
                folderImage = new Image(null, source, mask);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return folderImage;
    }

    public void dispose() {
        super.dispose();
        if (this.items == null) {
            return;
        }
        int i = 0;
        while (i < this.items.size()) {
            EditorToolItem item = (EditorToolItem)((Object)this.items.elementAt(i));
            item.setVisible(false);
            item.dispose();
            ++i;
        }
    }

    protected void checkSubclass() {
    }
}

