/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.editor.Editor;
import com.ecc.ide.editor.EditorToolItem;
import com.ecc.ide.editor.EditorToolItemSelectedListener;
import com.ecc.ide.editor.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import java.util.Vector;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class EditorToolPanel
extends Composite
implements EditorToolItemSelectedListener,
KeyListener {
    private Vector items;
    private int toolHeight = 20;
    private EditorToolItem curItem;
    private EditorToolItem curGroup;
    private Editor editor;
    private EditorToolItem selectItem;
    private EditorToolItem moveUpItem;
    private EditorToolItem moveDownItem;
    private int curBegin = 0;

    public EditorToolPanel(Composite parent, int style) {
        super(parent, style);
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent event) {
                EditorToolPanel.this.layout(true);
            }

            public void controlMoved(ControlEvent event) {
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                boolean offset = false;
                Point size = EditorToolPanel.this.getSize();
                int height = size.y - 1;
                int width = EditorToolPanel.this.getSize().x - 1;
                Color white = new Color((Device)Display.getDefault(), 255, 255, 255);
                Color darkGray = new Color((Device)Display.getDefault(), 128, 128, 128);
                gc.setForeground(darkGray);
                gc.drawLine(0, 0, width, 0);
                gc.drawLine(0, 0, 0, height);
                gc.setForeground(white);
                gc.drawLine(width, 0, width, height);
                gc.drawLine(0, height, width, height);
                white.dispose();
                darkGray.dispose();
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    public void addItem(EditorToolItem item) {
        if (this.items == null) {
            this.items = new Vector(20);
        }
        this.items.addElement(item);
    }

    public void EditorToolItemSelected(EditorToolItem item) {
        if (item == this.moveDownItem) {
            ++this.curBegin;
            this.layout(true);
            item.isSelected = false;
            return;
        }
        if (item == this.moveUpItem) {
            --this.curBegin;
            this.layout(true);
            item.isSelected = false;
            return;
        }
        if (item.getIsGroup()) {
            if (this.curGroup != null) {
                this.curGroup.setIsSelected(false);
                Vector childs = this.curGroup.getChilds();
                if (childs != null) {
                    int i = 0;
                    while (i < childs.size()) {
                        EditorToolItem item1 = (EditorToolItem)((Object)childs.elementAt(i));
                        item1.setVisible(false);
                        ++i;
                    }
                }
            }
            this.curGroup = item;
            this.layout();
        } else {
            try {
                if (this.curItem != null) {
                    this.curItem.setIsSelected(false);
                    this.curItem.redraw();
                }
                this.curItem = item;
                if (this.editor != null) {
                    this.editor.doInsert(item.getElement());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.layout(true);
    }

    public void setSize(Point size) {
        this.setSize(size.x, size.y);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.layout(true);
    }

    public void setBounds(Rectangle rec) {
        super.setBounds(rec);
        this.layout(true);
    }

    public void layout(boolean changed) {
        if (this.items == null) {
            return;
        }
        int idx = 0;
        Point size = this.getSize();
        int maxItems = (size.y - 2 - this.toolHeight * this.items.size()) / this.toolHeight;
        int offset = 2;
        int i = 0;
        while (i < this.items.size()) {
            EditorToolItem item = (EditorToolItem)((Object)this.items.elementAt(i));
            item.setBounds(1, offset + idx * this.toolHeight, size.x - 2, this.toolHeight);
            ++idx;
            if (item == this.curGroup) {
                EditorToolItem aItem;
                Vector childs = item.getChilds();
                if (childs.size() <= maxItems) {
                    this.curBegin = 0;
                }
                int count = 0;
                if (this.curBegin > 0) {
                    this.moveUpItem.setBounds(1, offset + idx * this.toolHeight, size.x - 2, this.toolHeight);
                    ++idx;
                    this.moveUpItem.setVisible(true);
                } else {
                    this.moveUpItem.setVisible(false);
                }
                int j = 0;
                j = 0;
                while (j < childs.size()) {
                    aItem = (EditorToolItem)((Object)childs.elementAt(j));
                    aItem.setVisible(false);
                    ++j;
                }
                j = this.curBegin;
                while (j < childs.size()) {
                    aItem = (EditorToolItem)((Object)childs.elementAt(j));
                    aItem.setBounds(1, offset + idx * this.toolHeight, size.x - 2, this.toolHeight);
                    aItem.setVisible(true);
                    ++idx;
                    if (this.curBegin > 0 && ++count == maxItems - 1 || this.curBegin == 0 && count > maxItems - 1) break;
                    ++j;
                }
                if (j < childs.size()) {
                    idx = 0;
                    offset = size.y - (this.items.size() - i - 1) * this.toolHeight;
                    this.moveDownItem.setBounds(1, offset - this.toolHeight, size.x - 2, this.toolHeight);
                    this.moveDownItem.setVisible(true);
                } else {
                    this.moveDownItem.setVisible(false);
                }
                idx = 0;
                offset = size.y - (this.items.size() - i - 1) * this.toolHeight;
            }
            ++i;
        }
    }

    public void setEditorProfile(EditorProfile profile) {
        Vector catalogs = profile.getCagalogs();
        if (this.items != null) {
            int i = 0;
            while (i < this.items.size()) {
                EditorToolItem item = (EditorToolItem)((Object)this.items.elementAt(i));
                item.dispose();
                ++i;
            }
            this.items = new Vector();
            this.curItem = null;
            this.curGroup = null;
            this.selectItem = null;
            this.curBegin = 0;
        }
        EditorToolItem item = new EditorToolItem(this, 0);
        item.setText(Messages.getString("EditorToolPanel.Selector_1"));
        item.setImageName("/images/select.gif");
        this.selectItem = item;
        this.addItem(item);
        this.moveUpItem = new EditorToolItem(this, 0);
        this.moveUpItem.setImageName("/images/moveUp.gif");
        this.moveUpItem.isGroup = false;
        this.moveDownItem = new EditorToolItem(this, 0);
        this.moveDownItem.setImageName("/images/moveDown.gif");
        this.moveDownItem.isGroup = false;
        int i = 0;
        while (i < catalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)catalogs.elementAt(i);
            if (catalog.getShowInToolPanel()) {
                EditorToolItem toolItem = new EditorToolItem(this, 0);
                toolItem.setText(catalog.getLabel());
                this.addItem(toolItem);
                toolItem.isGroup = true;
                Vector elements = catalog.getElements();
                int j = 0;
                while (j < elements.size()) {
                    Element element = (Element)elements.elementAt(j);
                    EditorToolItem toolItem1 = new EditorToolItem(this, 0);
                    toolItem1.setElement(element);
                    toolItem1.addKeyListener(this);
                    toolItem.addItem(toolItem1);
                    toolItem1.setText(element.getLabel());
                    String toolTip = element.getDocument();
                    if (toolTip != null) {
                        toolItem1.setToolTipText(toolTip);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.setSize(this.getSize());
    }

    public void keyPressed(KeyEvent event) {
        if (event.keyCode == 27) {
            this.editor.cancelCurrentAction();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void reset() {
        this.EditorToolItemSelected(this.selectItem);
    }
}

