/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.editor.DefinedClassSelectDialog;
import com.ecc.ide.editor.ElementAttributePropertyDlg;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.AttrFormulaEditDialog;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.Messages;
import com.ecc.ide.editorprofile.ValueListEditorDialog;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ElementAttributePanel
extends Composite {
    private Text descText;
    private Table attrListTable;
    private Combo attrTypeCombo;
    private Text editorClassText;
    private Text valueListText;
    private Text dftValueText;
    private Combo editableCombo;
    private Combo mustInputCombo;
    private Text attrNameText;
    private Text attrIDText;
    private Vector attributes;
    private Text enableFormulaText;
    private Text mustInputFormulaText;
    private XMLNode attrNode = null;
    private XMLNode definedClassTypeNode;

    public void setDefinedClassType(XMLNode definedClassTypeNode) {
        this.definedClassTypeNode = definedClassTypeNode;
    }

    public void setAttributesXMLNode(XMLNode node) {
        this.attrNode = node;
        this.attrListTable.removeAll();
        Vector childs = null;
        if (node != null) {
            childs = node.getChilds();
        }
        this.attributes = new Vector();
        if (childs == null) {
            this.setAttributes(this.attributes);
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                ElementAttribute attr = new ElementAttribute(aNode);
                this.attributes.addElement(attr);
            }
            ++i;
        }
        this.setAttributes(this.attributes);
    }

    public void setAttributes(Vector attrs) {
        if (attrs == null || attrs.size() == 0) {
            this.clearAttribute();
            this.attributes = attrs;
            return;
        }
        this.attributes = attrs;
        int i = 0;
        while (i < attrs.size()) {
            ElementAttribute attr = (ElementAttribute)attrs.elementAt(i);
            TableItem item = new TableItem(this.attrListTable, 0);
            String[] itemTexts = new String[]{attr.getAttrID(), attr.getAttrName(), String.valueOf(attr.getMustSet()), String.valueOf(attr.getEditable()), attr.getAttrType(), attr.getAttrEditorClass(), attr.getDocument()};
            item.setText(itemTexts);
            item.setData((Object)attr);
            ++i;
        }
        if (attrs.size() > 0) {
            this.attrListTable.setSelection(0);
            this.setActivateAttribute();
        }
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public ElementAttributePanel(Composite parent, boolean editable, int style) {
        super(parent, style);
        this.createControl(parent, editable, style);
    }

    public ElementAttributePanel(Composite parent, int style) {
        super(parent, style);
        this.createControl(parent, true, style);
    }

    private void createControl(Composite parent, boolean editable, int style) {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 4;
        this.setLayout((Layout)gridLayout1);
        Label label = new Label((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("ElementAttributePanel.Attributes_settings_1"));
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("ElementAttributePanel.Attribute_ID__2"));
        this.attrIDText = new Text((Composite)this, 2048);
        GridData gridData_1 = new GridData();
        this.attrIDText.setLayoutData((Object)gridData_1);
        this.attrIDText.setEditable(false);
        Label label_2 = new Label((Composite)this, 0);
        label_2.setText(Messages.getString("ElementAttributePanel.Attribute_Name__3"));
        this.attrNameText = new Text((Composite)this, 2048);
        GridData gridData_7 = new GridData();
        this.attrNameText.setLayoutData((Object)gridData_7);
        this.attrNameText.setEditable(false);
        Label label_3 = new Label((Composite)this, 0);
        label_3.setText(Messages.getString("ElementAttributePanel.Must_Input__4"));
        this.mustInputCombo = new Combo((Composite)this, 0);
        this.mustInputCombo.add("true");
        this.mustInputCombo.add("false");
        this.mustInputCombo.setEnabled(false);
        Label label_4 = new Label((Composite)this, 0);
        label_4.setText(Messages.getString("ElementAttributePanel.Editable__7"));
        this.editableCombo = new Combo((Composite)this, 0);
        this.editableCombo.add("true");
        this.editableCombo.add("false");
        this.editableCombo.setEnabled(false);
        Label label_8 = new Label((Composite)this, 0);
        label_8.setText(Messages.getString("ElementAttributePanel.Attribute_Type__10"));
        this.attrTypeCombo = new Combo((Composite)this, 0);
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 115;
        this.attrTypeCombo.setLayoutData((Object)gridData_8);
        this.attrTypeCombo.setEnabled(false);
        this.attrTypeCombo.add("");
        this.attrTypeCombo.add("boolean");
        this.attrTypeCombo.add("string");
        Label label_5 = new Label((Composite)this, 0);
        label_5.setText("Default Value:");
        this.dftValueText = new Text((Composite)this, 2048);
        GridData gridData_2 = new GridData(768);
        this.dftValueText.setLayoutData((Object)gridData_2);
        this.dftValueText.setEditable(false);
        Composite composite = new Composite((Composite)this, 0);
        GridData compositeGridData = new GridData(768);
        compositeGridData.horizontalSpan = 4;
        composite.setLayoutData((Object)compositeGridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 4;
        composite.setLayout((Layout)gridLayout2);
        Label label_6 = new Label(composite, 0);
        label_6.setText(Messages.getString("ElementAttributePanel.Value_List__15"));
        this.valueListText = new Text(composite, 2048);
        GridData gridData_3 = new GridData(768);
        gridData_3.horizontalSpan = 2;
        this.valueListText.setLayoutData((Object)gridData_3);
        this.valueListText.setEditable(false);
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ValueListEditorDialog dia = new ValueListEditorDialog(ElementAttributePanel.this.getShell(), 0);
                    String valueListStr = ElementAttributePanel.this.valueListText.getText();
                    valueListStr = dia.open(valueListStr);
                    if (valueListStr != null) {
                        ElementAttributePanel.this.valueListText.setText(valueListStr);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 64;
        button.setLayoutData((Object)gridData_6);
        button.setText(Messages.getString("ElementAttributePanel.Edit_16"));
        button.setEnabled(false);
        Label label_7 = new Label(composite, 0);
        label_7.setText(Messages.getString("ElementAttributePanel.Edit_Class__17"));
        this.editorClassText = new Text(composite, 2048);
        GridData gridData_5 = new GridData(768);
        gridData_5.horizontalSpan = 2;
        this.editorClassText.setLayoutData((Object)gridData_5);
        this.editorClassText.setEnabled(false);
        Button button_1 = new Button(composite, 0);
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 63;
        button_1.setLayoutData((Object)gridData_4);
        button_1.setText(Messages.getString("ElementAttributePanel.>>_18"));
        button_1.setEnabled(false);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefinedClassSelectDialog dlg = new DefinedClassSelectDialog(ElementAttributePanel.this.getShell());
                dlg.setDefinedClassType(ElementAttributePanel.this.definedClassTypeNode);
                String result = dlg.open("propertyEditor");
                if (result != null) {
                    ElementAttributePanel.this.editorClassText.setText(result);
                }
            }
        });
        Label enableLabel = new Label(composite, 0);
        enableLabel.setText("Enable Formula:");
        this.enableFormulaText = new Text(composite, 2048);
        GridData enable_gridData = new GridData(768);
        enable_gridData.horizontalSpan = 2;
        this.enableFormulaText.setLayoutData((Object)enable_gridData);
        this.enableFormulaText.setEnabled(false);
        Button enableFormulaButton = new Button(composite, 0);
        enableFormulaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String formulaStr = ElementAttributePanel.this.enableFormulaText.getText();
                if ((formulaStr = ElementAttributePanel.this.editFormula(formulaStr)) != null) {
                    ElementAttributePanel.this.enableFormulaText.setText(formulaStr);
                }
            }
        });
        GridData enableButtonGridData = new GridData();
        enableButtonGridData.widthHint = 63;
        enableFormulaButton.setLayoutData((Object)enableButtonGridData);
        enableFormulaButton.setText(Messages.getString("ElementAttributePanel.Edit_16"));
        enableFormulaButton.setEnabled(false);
        Label mustInputLabel = new Label(composite, 0);
        mustInputLabel.setText("MustInput Formula:");
        this.mustInputFormulaText = new Text(composite, 2048);
        GridData mustInput_gridData = new GridData(768);
        mustInput_gridData.horizontalSpan = 2;
        this.mustInputFormulaText.setLayoutData((Object)mustInput_gridData);
        this.mustInputFormulaText.setEnabled(false);
        Button mustInputFormulaButton = new Button(composite, 0);
        mustInputFormulaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String formulaStr = ElementAttributePanel.this.mustInputFormulaText.getText();
                if ((formulaStr = ElementAttributePanel.this.editFormula(formulaStr)) != null) {
                    ElementAttributePanel.this.mustInputFormulaText.setText(formulaStr);
                }
            }
        });
        GridData mustInputButtonGridData = new GridData();
        mustInputButtonGridData.widthHint = 63;
        mustInputFormulaButton.setLayoutData((Object)mustInputButtonGridData);
        mustInputFormulaButton.setText(Messages.getString("ElementAttributePanel.Edit_16"));
        mustInputFormulaButton.setEnabled(false);
        Label label_9 = new Label((Composite)this, 0);
        GridData gridData_14 = new GridData();
        gridData_14.horizontalSpan = 4;
        label_9.setLayoutData((Object)gridData_14);
        label_9.setText(Messages.getString("ElementAttributePanel.Description__19"));
        this.descText = new Text((Composite)this, 2818);
        GridData gridData_15 = new GridData(768);
        gridData_15.heightHint = 25;
        gridData_15.horizontalSpan = 4;
        this.descText.setLayoutData((Object)gridData_15);
        this.descText.setEnabled(false);
        if (editable) {
            Composite composite1 = new Composite((Composite)this, 0);
            GridData gridData_12 = new GridData(128);
            gridData_12.horizontalSpan = 4;
            composite1.setLayoutData((Object)gridData_12);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            composite1.setLayout((Layout)gridLayout);
            Button button_2 = new Button(composite1, 0);
            button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementAttributePanel.this.createNewAttribute();
                }
            });
            GridData gridData_9 = new GridData();
            gridData_9.widthHint = 80;
            button_2.setLayoutData((Object)gridData_9);
            button_2.setText(Messages.getString("ElementAttributePanel.Create_20"));
            Button button_3 = new Button(composite1, 0);
            button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementAttributePanel.this.updateCurAttribute();
                }
            });
            GridData gridData_10 = new GridData();
            gridData_10.widthHint = 80;
            button_3.setLayoutData((Object)gridData_10);
            button_3.setText(Messages.getString("ElementAttributePanel.Update_21"));
            Button button_4 = new Button(composite1, 0);
            button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementAttributePanel.this.deleteCurAttribute();
                }
            });
            GridData gridData_11 = new GridData();
            gridData_11.widthHint = 80;
            button_4.setLayoutData((Object)gridData_11);
            button_4.setText(Messages.getString("ElementAttributePanel.Delete_22"));
        }
        this.attrListTable = new Table((Composite)this, 67584);
        this.attrListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementAttributePanel.this.setActivateAttribute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ElementAttributePanel.this.updateCurAttribute();
            }
        });
        GridData gridData_13 = new GridData(1808);
        gridData_13.horizontalSpan = 4;
        this.attrListTable.setLayoutData((Object)gridData_13);
        this.attrListTable.setLinesVisible(true);
        this.attrListTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.attrListTable, 0);
        tableColumn.setWidth(82);
        tableColumn.setText(Messages.getString("ElementAttributePanel.Attr_ID_23"));
        TableColumn tableColumn_1 = new TableColumn(this.attrListTable, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("ElementAttributePanel.Attr_Name_24"));
        TableColumn tableColumn_2 = new TableColumn(this.attrListTable, 0);
        tableColumn_2.setWidth(77);
        tableColumn_2.setText(Messages.getString("ElementAttributePanel.Must_Input_25"));
        TableColumn tableColumn_3 = new TableColumn(this.attrListTable, 0);
        tableColumn_3.setWidth(72);
        tableColumn_3.setText(Messages.getString("ElementAttributePanel.Editable_26"));
        TableColumn tableColumn_4 = new TableColumn(this.attrListTable, 0);
        tableColumn_4.setWidth(83);
        tableColumn_4.setText(Messages.getString("ElementAttributePanel.Attr_Type_27"));
        TableColumn tableColumn_5 = new TableColumn(this.attrListTable, 0);
        tableColumn_5.setWidth(100);
        tableColumn_5.setText(Messages.getString("ElementAttributePanel.editor_class_28"));
        TableColumn tableColumn_6 = new TableColumn(this.attrListTable, 0);
        tableColumn_6.setWidth(100);
        tableColumn_6.setText(Messages.getString("ElementAttributePanel.Description_29"));
    }

    private void createNewAttribute() {
        ElementAttributePropertyDlg dlg = new ElementAttributePropertyDlg(this.getShell());
        dlg.setAttrDefNode(this.attrNode);
        dlg.setAttributes(this.attributes);
        dlg.setDefinedClassType(this.definedClassTypeNode);
        XMLNode attrNode = (XMLNode)dlg.open();
        if (attrNode != null) {
            this.clearAttribute();
            ElementAttribute attr = null;
            attr = new ElementAttribute(attrNode);
            this.attributes.addElement(attr);
            TableItem item = new TableItem(this.attrListTable, 0);
            item.setData((Object)attr);
            this.attrNode.add(attrNode);
            item.setText(attrNode.getAttrValue("id"));
            String attrName = attrNode.getAttrValue("name");
            if (attrName != null) {
                this.attrIDText.setText(attrNode.getAttrValue("id"));
            }
            if (attrNode.getAttrValue("name") != null) {
                item.setText(1, attrName);
                this.attrNameText.setText(attrNode.getAttrValue("name"));
            }
            if (attrNode.getAttrValue("mustSet") != null) {
                item.setText(2, attrNode.getAttrValue("mustSet"));
                this.mustInputCombo.setText(attrNode.getAttrValue("mustSet"));
            }
            if (attrNode.getDocument() != null) {
                item.setText(6, attrNode.getDocument());
                this.descText.setText(attrNode.getDocument());
            }
            if (attrNode.getAttrValue("attrType") != null) {
                item.setText(4, attrNode.getAttrValue("attrType"));
                this.attrTypeCombo.setText(attrNode.getAttrValue("attrType"));
            }
            if (attrNode.getAttrValue("editorClass") != null) {
                item.setText(5, attrNode.getAttrValue("editorClass"));
                this.editorClassText.setText(attrNode.getAttrValue("editorClass"));
            }
            if (attrNode.getAttrValue("valueList") != null) {
                this.valueListText.setText(attrNode.getAttrValue("valueList"));
            }
            if (attrNode.getAttrValue("defaultValue") != null) {
                this.dftValueText.setText(attrNode.getAttrValue("defaultValue"));
            }
            if (attrNode.getAttrValue("editable") != null) {
                item.setText(3, attrNode.getAttrValue("editable"));
                this.editableCombo.setText(attrNode.getAttrValue("editable"));
            }
            if (attrNode.getAttrValue("enableFormula") != null) {
                this.enableFormulaText.setText(attrNode.getAttrValue("enableFormula"));
            }
            if (attrNode.getAttrValue("mustInputFormula") != null) {
                this.mustInputFormulaText.setText(attrNode.getAttrValue("mustInputFormula"));
            }
            TableItem[] items = new TableItem[]{item};
            this.attrListTable.setSelection(items);
        }
    }

    private void updateCurAttribute() {
        TableItem[] selects = this.attrListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        ElementAttribute attr = (ElementAttribute)selects[0].getData();
        ElementAttributePropertyDlg dlg = new ElementAttributePropertyDlg(this.getShell());
        dlg.setAttrDefNode(this.attrNode);
        dlg.setAttributes(this.attributes);
        dlg.setAttrNode(attr.getXMLNode());
        dlg.setDefinedClassType(this.definedClassTypeNode);
        XMLNode attrNode = (XMLNode)dlg.open();
        if (attrNode != null) {
            this.clearAttribute();
            this.attributes.remove(attr);
            attr = new ElementAttribute(attrNode);
            this.attributes.addElement(attr);
            TableItem item = selects[0];
            item.setData((Object)attr);
            item.setText(attrNode.getAttrValue("id"));
            String attrName = attrNode.getAttrValue("name");
            if (attrName != null) {
                this.attrIDText.setText(attrNode.getAttrValue("id"));
            }
            if (attrNode.getAttrValue("name") != null) {
                item.setText(1, attrName);
                this.attrNameText.setText(attrNode.getAttrValue("name"));
            }
            if (attrNode.getAttrValue("mustSet") != null) {
                item.setText(2, attrNode.getAttrValue("mustSet"));
                this.mustInputCombo.setText(attrNode.getAttrValue("mustSet"));
            }
            if (attrNode.getDocument() != null) {
                item.setText(6, attrNode.getDocument());
                this.descText.setText(attrNode.getDocument());
            }
            if (attrNode.getAttrValue("attrType") != null) {
                item.setText(4, attrNode.getAttrValue("attrType"));
                this.attrTypeCombo.setText(attrNode.getAttrValue("attrType"));
            }
            if (attrNode.getAttrValue("editorClass") != null) {
                item.setText(5, attrNode.getAttrValue("editorClass"));
                this.editorClassText.setText(attrNode.getAttrValue("editorClass"));
            }
            if (attrNode.getAttrValue("valueList") != null) {
                this.valueListText.setText(attrNode.getAttrValue("valueList"));
            }
            if (attrNode.getAttrValue("defaultValue") != null) {
                this.dftValueText.setText(attrNode.getAttrValue("defaultValue"));
            }
            if (attrNode.getAttrValue("editable") != null) {
                item.setText(3, attrNode.getAttrValue("editable"));
                this.editableCombo.setText(attrNode.getAttrValue("editable"));
            }
            if (attrNode.getAttrValue("enableFormula") != null) {
                this.enableFormulaText.setText(attrNode.getAttrValue("enableFormula"));
            }
            if (attrNode.getAttrValue("mustInputFormula") != null) {
                this.mustInputFormulaText.setText(attrNode.getAttrValue("mustInputFormula"));
            }
        }
    }

    private void deleteCurAttribute() {
        TableItem[] selects = this.attrListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"are you sure...", (String)"Are you sure to delete the selected attribute define item?")) {
            return;
        }
        ElementAttribute attr = (ElementAttribute)selects[0].getData();
        this.attributes.removeElement(attr);
        this.attrListTable.remove(this.attrListTable.indexOf(selects[0]));
        if (this.attrNode != null) {
            this.attrNode.getChilds().removeElement(attr.getXMLNode());
        }
    }

    private void setActivateAttribute() {
        TableItem[] selects = this.attrListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        ElementAttribute attr = (ElementAttribute)selects[0].getData();
        this.attrIDText.setText(attr.getAttrID());
        if (attr.getAttrName() != null) {
            this.attrNameText.setText(attr.getAttrName());
        } else {
            this.attrNameText.setText("");
        }
        if (attr.getMustSet()) {
            this.mustInputCombo.select(0);
        } else {
            this.mustInputCombo.select(1);
        }
        if (attr.getEditable()) {
            this.editableCombo.select(0);
        } else {
            this.editableCombo.select(1);
        }
        if (attr.getAttrType() != null) {
            this.attrTypeCombo.select(this.attrTypeCombo.indexOf(attr.getAttrType()));
        } else {
            this.attrTypeCombo.select(0);
        }
        if (attr.getMustInputFormula() != null) {
            this.mustInputFormulaText.setText(attr.getMustInputFormula());
        } else {
            this.mustInputFormulaText.setText("");
        }
        if (attr.getEnableFormula() != null) {
            this.enableFormulaText.setText(attr.getEnableFormula());
        } else {
            this.enableFormulaText.setText("");
        }
        if (attr.getDefaultValue() != null) {
            this.dftValueText.setText(attr.getDefaultValue());
        } else {
            this.dftValueText.setText("");
        }
        if (attr.getValueListStr() != null) {
            this.valueListText.setText(attr.getValueListStr());
        } else {
            this.valueListText.setText("");
        }
        if (attr.getAttrEditorClass() != null) {
            this.editorClassText.setText(attr.getAttrEditorClass());
        } else {
            this.editorClassText.setText("");
        }
        if (attr.getDocument() != null) {
            this.descText.setText(attr.getDocument());
        } else {
            this.descText.setText("");
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void clearAttribute() {
        this.attrIDText.setText("");
        this.attrNameText.setText("");
        this.mustInputCombo.select(1);
        this.editableCombo.select(1);
        this.attrTypeCombo.select(0);
        this.dftValueText.setText("");
        this.valueListText.setText("");
        this.editorClassText.setText("");
        this.descText.setText("");
        this.mustInputFormulaText.setText("");
        this.enableFormulaText.setText("");
    }

    private String editFormula(String formulaStr) {
        AttrFormulaEditDialog dialog = new AttrFormulaEditDialog(this.getShell());
        dialog.setAttributeDefine(this.attributes);
        return (String)dialog.open();
    }
}

