/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.PropertyEditor;
import com.ecc.ide.editor.Wrapper;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;

public class SelectProperty
implements SelectionListener,
KeyListener {
    private Wrapper wrapper;
    private PropertyEditor editor;
    private Combo combo;
    private String oldValue;
    private String attrName;
    protected EditorBeanPropertyPanel propertyPanel;

    public SelectProperty(Wrapper wrapper, PropertyEditor editor, Combo combo, String attrName) {
        this.wrapper = wrapper;
        this.editor = editor;
        this.combo = combo;
        this.attrName = attrName;
        this.oldValue = combo.getText();
        combo.addSelectionListener((SelectionListener)this);
        combo.addKeyListener((KeyListener)this);
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 13) {
            String text = this.combo.getText();
            if (!text.equals(this.oldValue)) {
                this.oldValue = text;
                this.editor.setAsText(text);
                Object obj = this.editor.getValue();
                this.wrapper.setAttrValue(this.attrName, obj);
                this.propertyPanel.updatePropertyPanel();
            }
            this.propertyPanel.editNextProperty();
        } else if (e.keyCode == 0x1000001) {
            this.propertyPanel.editLastProperty();
        } else if (e.keyCode == 0x1000002) {
            this.propertyPanel.editNextProperty();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String text = this.combo.getText();
        if (!text.equals(this.oldValue)) {
            this.oldValue = text;
            this.editor.setAsText(text);
            Object obj = this.editor.getValue();
            this.wrapper.setAttrValue(this.attrName, obj);
            this.propertyPanel.updatePropertyPanel();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

