/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.editor.PropertyEditorSuport;
import java.util.Vector;

public class SelectPropertyEditor
extends PropertyEditorSuport {
    private String attrType;
    private Vector valueList;
    private Vector valueMapList;

    public void setAttrType(String attrType) {
        this.attrType = attrType;
    }

    public void setValueList(Vector valueList) {
        this.valueList = valueList;
    }

    public void setValueMapList(Vector valueMapList) {
        this.valueMapList = valueMapList;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        int i = 0;
        while (i < this.valueList.size()) {
            String valueStr = (String)this.valueList.elementAt(i);
            if (valueStr.equals(text)) {
                if (this.valueMapList != null) {
                    this.setValue((String)this.valueMapList.elementAt(i));
                    break;
                }
                this.setValue(text);
                break;
            }
            ++i;
        }
    }

    private void setValue(String value) {
        if (this.attrType == null || this.attrType.equals("string")) {
            super.setValue(value);
        } else if (this.attrType.equals("boolean")) {
            super.setValue(new Boolean(value));
        } else if (this.attrType.equals("int")) {
            super.setValue(new Integer(value));
        } else {
            super.setValue(value);
        }
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        if (this.valueMapList != null) {
            String valueStr = this.value.toString();
            int i = 0;
            while (i < this.valueMapList.size()) {
                String aValueStr = (String)this.valueMapList.elementAt(i);
                if (valueStr.equals(aValueStr)) {
                    return (String)this.valueList.elementAt(i);
                }
                ++i;
            }
            return null;
        }
        return this.value.toString();
    }

    public String[] getTags() {
        int size = this.valueList.size();
        String[] tags = new String[size];
        int i = 0;
        while (i < size) {
            tags[i] = (String)this.valueList.elementAt(i);
            ++i;
        }
        return tags;
    }
}

