/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.PropertyEditor;
import com.ecc.ide.editor.Wrapper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Text;

public class TextProperty
implements KeyListener,
FocusListener,
DisposeListener {
    private Wrapper wrapper;
    private PropertyEditor editor;
    private Text text;
    private String oldValue;
    private String attrName;
    protected EditorBeanPropertyPanel propertyPanel;

    public TextProperty(Wrapper wrapper, PropertyEditor editor, Text text, String attrName) {
        this.wrapper = wrapper;
        this.editor = editor;
        this.text = text;
        this.attrName = attrName;
        this.oldValue = text.getText();
        this.oldValue = TextProperty.normalize(this.oldValue);
        text.setText(this.oldValue);
        text.addKeyListener((KeyListener)this);
        text.addFocusListener((FocusListener)this);
        text.addDisposeListener((DisposeListener)this);
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 13) {
            this.updateAttrValue();
            this.propertyPanel.editNextProperty();
        } else if (e.keyCode == 0x1000001) {
            this.updateAttrValue();
            this.propertyPanel.editLastProperty();
        } else if (e.keyCode == 0x1000002) {
            this.updateAttrValue();
            this.propertyPanel.editNextProperty();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.updateAttrValue();
    }

    public void widgetDisposed(DisposeEvent event) {
        this.updateAttrValue();
    }

    private void updateAttrValue() {
        String value = this.text.getText();
        if (!value.equals(this.oldValue)) {
            String val = TextProperty.unNormalize(value);
            this.editor.setAsText(val);
            this.oldValue = value;
            try {
                Object objValue = this.editor.getValue();
                this.wrapper.setAttrValue(this.attrName, objValue);
                this.propertyPanel.updatePropertyPanel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch < ' ') {
                str.append("&#");
                str.append(String.valueOf((int)ch));
                str.append(";");
            } else {
                str.append(ch);
            }
            ++i;
        }
        return str.toString();
    }

    public static String unNormalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == '&' && i < len - 1) {
                char ch1 = s.charAt(i + 1);
                if (ch1 == '#') {
                    ++i;
                    int k = 0;
                    do {
                        ch1 = s.charAt(i + 1);
                        ++i;
                        if (ch1 == ';') break;
                        k = 10 * k + ch1 - 48;
                    } while (i <= len);
                    ch1 = (char)k;
                    str.append(ch1);
                } else {
                    str.append(ch);
                }
            } else {
                str.append(ch);
            }
            ++i;
        }
        return str.toString();
    }

    public void setOldValue(String aOldValue) {
        this.oldValue = TextProperty.normalize(aOldValue);
    }
}

