/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.editorprofile.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ValueListEditPanel
extends Composite {
    private Text valueText;
    private Label textLabel;
    private Text textText;
    private Table itemList;
    private String result = null;
    private TableColumn column2;
    private String valueListStr;
    private boolean withValueDesc = true;

    public ValueListEditPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label valueLabel = new Label((Composite)this, 0);
        valueLabel.setText(Messages.getString("ValueListEditorDialog.Value__3"));
        this.valueText = new Text((Composite)this, 2048);
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 100;
        this.valueText.setLayoutData((Object)gridData_8);
        final Button button_2 = new Button((Composite)this, 32);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueListEditPanel.this.withValueDesc = button_2.getSelection();
                if (ValueListEditPanel.this.withValueDesc) {
                    ValueListEditPanel.this.column2 = new TableColumn(ValueListEditPanel.this.itemList, 18432);
                    ValueListEditPanel.this.column2.setText(Messages.getString("ValueListEditorDialog.text_9"));
                    ValueListEditPanel.this.column2.setWidth(262);
                    ValueListEditPanel.this.textLabel.setVisible(true);
                    ValueListEditPanel.this.textText.setVisible(true);
                } else {
                    ValueListEditPanel.this.column2.dispose();
                    ValueListEditPanel.this.textLabel.setVisible(false);
                    ValueListEditPanel.this.textText.setVisible(false);
                }
            }
        });
        GridData gridData_9 = new GridData();
        gridData_9.horizontalSpan = 2;
        button_2.setLayoutData((Object)gridData_9);
        button_2.setText(Messages.getString("ValueListEditorDialog.With_Value_Description_2"));
        if (this.withValueDesc) {
            button_2.setSelection(true);
        } else {
            button_2.setSelection(false);
        }
        this.textLabel = new Label((Composite)this, 0);
        this.textLabel.setText(Messages.getString("ValueListEditorDialog.Text__4"));
        this.textText = new Text((Composite)this, 2048);
        this.textText.setLayoutData((Object)new GridData(768));
        if (this.withValueDesc) {
            this.textLabel.setVisible(true);
            this.textText.setVisible(true);
        } else {
            this.textLabel.setVisible(false);
            this.textText.setVisible(false);
        }
        Composite composite_2 = new Composite((Composite)this, 0);
        GridData gridData_4 = new GridData(640);
        gridData_4.horizontalSpan = 2;
        composite_2.setLayoutData((Object)gridData_4);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_2);
        Button addButton = new Button(composite_2, 0);
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 90;
        addButton.setLayoutData((Object)gridData_5);
        addButton.setText(Messages.getString("ValueListEditorDialog.add_5"));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueListEditPanel.this.addNewValue();
            }
        });
        Button delButton = new Button(composite_2, 0);
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 90;
        delButton.setLayoutData((Object)gridData_6);
        delButton.setText(Messages.getString("ValueListEditorDialog.delete_6"));
        delButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TableItem item = ValueListEditPanel.this.itemList.getSelection()[0];
                    item.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Button button = new Button(composite_2, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueListEditPanel.this.updateItemValue();
            }
        });
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 90;
        button.setLayoutData((Object)gridData_7);
        button.setText(Messages.getString("ValueListEditorDialog.Update_7"));
        this.itemList = new Table((Composite)this, 67584);
        this.itemList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueListEditPanel.this.setActiveItem();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.itemList.setLayoutData((Object)gridData);
        this.itemList.setHeaderVisible(true);
        this.itemList.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.itemList, 18432);
        column1.setText(Messages.getString("ValueListEditorDialog.value_8"));
        column1.setWidth(134);
        if (this.withValueDesc) {
            this.column2 = new TableColumn(this.itemList, 18432);
            this.column2.setText(Messages.getString("ValueListEditorDialog.text_9"));
            this.column2.setWidth(262);
        }
        this.setSize(450, 380);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void addNewValue() {
        String valueStr = this.valueText.getText();
        String textStr = this.textText.getText();
        if (valueStr.length() == 0 || valueStr.indexOf(";") != -1 || valueStr.indexOf(":") != -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ValueListEditorDialog.Warning_17"), (String)Messages.getString("ValueListEditorDialog.Please_input_correct_value_String,_________;___are_not_allowed_!_18"));
            return;
        }
        if (this.withValueDesc && (textStr.length() == 0 || textStr.indexOf(";") != -1 || textStr.indexOf(":") != -1)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ValueListEditorDialog.Warning_21"), (String)Messages.getString("ValueListEditorDialog.Please_input_correct_Text_String,_________;___are_not_allowed_!_22"));
            return;
        }
        TableItem item = new TableItem(this.itemList, 0);
        item.setText(0, valueStr);
        if (this.withValueDesc) {
            item.setText(1, textStr);
        }
    }

    private void updateItemValue() {
        TableItem[] items = this.itemList.getSelection();
        if (items.length != 1) {
            return;
        }
        String valueStr = this.valueText.getText();
        String textStr = this.textText.getText();
        if (valueStr.length() == 0 || valueStr.indexOf(";") != -1 || valueStr.indexOf(":") != -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ValueListEditorDialog.Warning_25"), (String)Messages.getString("ValueListEditorDialog.Please_input_correct_value_String,_________;___are_not_allowed_!_26"));
            return;
        }
        if (this.withValueDesc && (textStr.length() == 0 || textStr.indexOf(";") != -1 || textStr.indexOf(":") != -1)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ValueListEditorDialog.Warning_29"), (String)Messages.getString("ValueListEditorDialog.Please_input_correct_Text_String,_________;___are_not_allowed_!_30"));
            return;
        }
        items[0].setText(0, valueStr);
        if (this.withValueDesc) {
            items[0].setText(1, textStr);
        }
    }

    private void setActiveItem() {
        TableItem[] items = this.itemList.getSelection();
        if (items.length != 1) {
            this.textText.setText("");
            this.valueText.setText("");
            return;
        }
        this.valueText.setText(items[0].getText());
        if (this.withValueDesc) {
            this.textText.setText(items[0].getText(1));
        }
    }

    public void setValue(String aValue) {
        this.valueListStr = aValue;
        try {
            int idx;
            int offset = 0;
            while ((idx = this.valueListStr.indexOf(59, offset)) != -1) {
                String key;
                String aStr = this.valueListStr.substring(offset, idx);
                int idx1 = aStr.indexOf(61);
                if (idx1 != -1) {
                    key = aStr.substring(0, idx1);
                    String value = aStr.substring(idx1 + 1);
                    TableItem aitem = new TableItem(this.itemList, 0);
                    aitem.setText(key);
                    aitem.setText(1, value);
                } else {
                    key = aStr;
                    TableItem aitem = new TableItem(this.itemList, 0);
                    aitem.setText(key);
                }
                if ((offset = idx + 1) != this.valueListStr.length()) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getValue() {
        TableItem[] items = this.itemList.getItems();
        this.result = "";
        int i = 0;
        while (i < items.length) {
            this.result = this.withValueDesc ? String.valueOf(this.result) + items[i].getText() + "=" + items[i].getText(1) + ";" : String.valueOf(this.result) + items[i].getText() + ";";
            ++i;
        }
        return this.result;
    }
}

