/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.util.xmlloader.Externalizable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNode
implements Externalizable {
    private String encoding = null;
    private boolean isLineEnd = true;
    private Hashtable attributes = new Hashtable();
    private String text;
    private String CDataValue;
    boolean isComment = false;
    private Vector childs = new Vector(20);
    private String nodeName;
    private String id;
    private XMLNode parent;
    private String textValue;
    private Vector contentListeners;
    private Hashtable listenerInfos;

    public XMLNode() {
    }

    public void setChilds(Vector childs) {
        this.childs = childs;
    }

    public XMLNode(String nodeName) {
        this.nodeName = nodeName;
    }

    public Externalizable initializeFrom(Node node) {
        if (node.getNodeType() == 4) {
            this.CDataValue = node.getNodeValue();
        } else if (node.getNodeType() == 3) {
            this.setTextValue(node.getNodeValue());
        } else if (node.getNodeType() == 8) {
            this.setAttrValue("value", node.getNodeValue());
        }
        NamedNodeMap nm = node.getAttributes();
        if (nm == null) {
            return this;
        }
        int i = 0;
        while (i < nm.getLength()) {
            Node aNode = nm.item(i);
            this.attributes.put(aNode.getNodeName(), aNode.getNodeValue());
            ++i;
        }
        NodeList children = node.getChildNodes();
        int childrenSize = children.getLength();
        return this;
    }

    public void add(Externalizable obj) {
        this.childs.addElement(obj);
        XMLNode node = (XMLNode)obj;
        node.parent = this;
        this.fireContentChangedEvent();
    }

    public void add(Externalizable obj, int idx) {
        this.childs.insertElementAt(obj, idx);
        XMLNode node = (XMLNode)obj;
        node.parent = this;
        this.fireContentChangedEvent();
    }

    public void remove(XMLNode node) {
        this.childs.remove(node);
        this.fireContentChangedEvent();
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Vector getChilds() {
        return this.childs;
    }

    public Hashtable getAttrs() {
        return this.attributes;
    }

    public String getIdentityString() {
        String name;
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(this.nodeName);
        String idStr = (String)this.attributes.get("id");
        if (idStr != null) {
            strBuf.append(" id=\"");
            strBuf.append(idStr);
            strBuf.append("\"");
        }
        if ((name = (String)this.attributes.get("name")) != null) {
            strBuf.append(" name=\"");
            strBuf.append(name);
            strBuf.append("\"");
        }
        return strBuf.toString();
    }

    public String toString() {
        String name;
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(this.nodeName);
        String idStr = (String)this.attributes.get("id");
        if (idStr != null) {
            strBuf.append(" id=\"");
            strBuf.append(idStr);
            strBuf.append("\"");
        }
        if ((name = (String)this.attributes.get("name")) != null) {
            strBuf.append(" name=\"");
            strBuf.append(name);
            strBuf.append("\"");
        }
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if ("id".equals(key) || "name".equals(key)) continue;
            String value = (String)this.attributes.get(key);
            strBuf.append(" ");
            strBuf.append(key);
            strBuf.append("=\"");
            strBuf.append(value);
            strBuf.append("\"");
        }
        if (this.textValue != null) {
            strBuf.append(":");
            strBuf.append(this.textValue);
        }
        return strBuf.toString();
    }

    public String getAttributesString() {
        String name;
        StringBuffer strBuf = new StringBuffer();
        String idStr = (String)this.attributes.get("id");
        if (idStr != null) {
            strBuf.append(" id=\"");
            strBuf.append(idStr);
            strBuf.append("\"");
        }
        if ((name = (String)this.attributes.get("name")) != null) {
            strBuf.append(" name=\"");
            strBuf.append(name);
            strBuf.append("\"");
        }
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if ("id".equals(key) || "name".equals(key) || "desc".equals(key)) continue;
            String value = (String)this.attributes.get(key);
            strBuf.append(" ");
            strBuf.append(key);
            strBuf.append("=\"");
            strBuf.append(value);
            strBuf.append("\"");
        }
        return strBuf.toString();
    }

    public void toXMLContent(int n, StringBuffer strBuf) {
        this.toXMLContent(n, strBuf, false);
    }

    public void toXMLContent(int n, StringBuffer strBuf, boolean ignoreDocumentNode) {
        String name;
        String lineWrap = "\r\n";
        if (n == 0 && strBuf.toString().indexOf("<?xml") == -1) {
            strBuf.append("<?xml version=\"1.0\" encoding=\"");
            if (this.encoding != null) {
                strBuf.append(this.encoding);
            } else {
                strBuf.append(IDEConstance.encoding);
            }
            strBuf.append("\" ?>");
            strBuf.append(lineWrap);
            strBuf.append(lineWrap);
        }
        if ("#comment".equals(this.nodeName)) {
            strBuf.append(lineWrap);
            int i = 0;
            while (i < n) {
                strBuf.append("\t");
                ++i;
            }
            strBuf.append("<!--");
            strBuf.append(this.getAttrValue("value"));
            strBuf.append("-->");
            return;
        }
        if ("#text".equals(this.nodeName)) {
            String value = this.getTextValue();
            if (value.trim().length() > 0) {
                strBuf.append(this.normalizeTextValue(value));
            }
            return;
        }
        if ("#cdata-section".equals(this.nodeName)) {
            if (this.CDataValue != null) {
                strBuf.append("<![CDATA[");
                strBuf.append(this.CDataValue);
                strBuf.append("]]>");
            }
            return;
        }
        strBuf.append(lineWrap);
        int i = 0;
        while (i < n) {
            strBuf.append("\t");
            ++i;
        }
        strBuf.append("<");
        strBuf.append(this.nodeName);
        String idStr = (String)this.attributes.get("id");
        if (idStr != null) {
            strBuf.append(" id=\"");
            strBuf.append(idStr);
            strBuf.append("\"");
        }
        if ((name = (String)this.attributes.get("name")) != null) {
            strBuf.append(" name=\"");
            strBuf.append(name);
            strBuf.append("\"");
        }
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if ("id".equals(key) || "name".equals(key)) continue;
            String value = (String)this.attributes.get(key);
            strBuf.append(" ");
            strBuf.append(key);
            strBuf.append("=\"");
            strBuf.append(this.normalize(value));
            strBuf.append("\"");
        }
        if (this.childs.size() <= 0) {
            if (this.isLineEnd()) {
                strBuf.append("/>");
            } else {
                strBuf.append("></" + this.getNodeName() + ">");
            }
        } else {
            String value;
            XMLNode aNode = (XMLNode)this.childs.elementAt(0);
            if (this.childs.size() == 1 && "#text".equals(aNode.getNodeName()) && ((value = aNode.getTextValue()) == null || value.trim().length() == 0)) {
                strBuf.append("/>");
                return;
            }
            strBuf.append(">");
            int i2 = 0;
            while (i2 < this.childs.size()) {
                XMLNode child = (XMLNode)this.childs.elementAt(i2);
                if (!(child == null || ignoreDocumentNode && child.getNodeName().equals("document"))) {
                    child.toYUIContent(n + 1, strBuf, ignoreDocumentNode);
                }
                ++i2;
            }
            if (this.childs.size() == 1 && "#text".equals(aNode.getNodeName())) {
                strBuf.append("</");
                strBuf.append(this.nodeName);
                strBuf.append(">");
            } else {
                strBuf.append(lineWrap);
                i2 = 0;
                while (i2 < n) {
                    strBuf.append("\t");
                    ++i2;
                }
                strBuf.append("</");
                strBuf.append(this.nodeName);
                strBuf.append(">");
            }
        }
    }

    public void toYUIContent(int n, StringBuffer strBuf, boolean ignoreDocumentNode) {
        String name;
        String lineWrap = "\r\n";
        if (n == 0 && strBuf.toString().indexOf("<?xml") == -1) {
            strBuf.append("<?xml version=\"1.0\" encoding=\"");
            if (this.encoding != null) {
                strBuf.append(this.encoding);
            } else {
                strBuf.append(IDEConstance.encoding);
            }
            strBuf.append("\" ?>");
            strBuf.append(lineWrap);
            strBuf.append(lineWrap);
        }
        if ("#comment".equals(this.nodeName)) {
            strBuf.append(lineWrap);
            int i = 0;
            while (i < n) {
                strBuf.append("\t");
                ++i;
            }
            strBuf.append("<!--");
            strBuf.append(this.getAttrValue("value"));
            strBuf.append("-->");
            return;
        }
        if ("#text".equals(this.nodeName)) {
            String value = this.getTextValue();
            if (value.trim().length() > 0) {
                strBuf.append(value);
            }
            return;
        }
        if ("#cdata-section".equals(this.nodeName)) {
            if (this.CDataValue != null) {
                strBuf.append("<![CDATA[");
                strBuf.append(this.CDataValue);
                strBuf.append("]]>");
            }
            return;
        }
        strBuf.append(lineWrap);
        int i = 0;
        while (i < n) {
            strBuf.append("\t");
            ++i;
        }
        strBuf.append("<");
        strBuf.append(this.nodeName);
        String idStr = (String)this.attributes.get("id");
        if (idStr != null) {
            strBuf.append(" id=\"");
            strBuf.append(idStr);
            strBuf.append("\"");
        }
        if ((name = (String)this.attributes.get("name")) != null) {
            strBuf.append(" name=\"");
            strBuf.append(name);
            strBuf.append("\"");
        }
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if ("id".equals(key) || "name".equals(key)) continue;
            String value = (String)this.attributes.get(key);
            strBuf.append(" ");
            strBuf.append(key);
            strBuf.append("=\"");
            strBuf.append(this.normalize(value));
            strBuf.append("\"");
        }
        if (this.childs.size() <= 0) {
            if (this.isLineEnd()) {
                strBuf.append("/>");
            } else {
                strBuf.append("></" + this.getNodeName() + ">");
            }
        } else {
            String value;
            XMLNode aNode = (XMLNode)this.childs.elementAt(0);
            if (this.childs.size() == 1 && "#text".equals(aNode.getNodeName()) && ((value = aNode.getTextValue()) == null || value.trim().length() == 0)) {
                strBuf.append("/>");
                return;
            }
            strBuf.append(">");
            int i2 = 0;
            while (i2 < this.childs.size()) {
                XMLNode child = (XMLNode)this.childs.elementAt(i2);
                if (!(child == null || ignoreDocumentNode && child.getNodeName().equals("document"))) {
                    child.toYUIContent(n + 1, strBuf, ignoreDocumentNode);
                }
                ++i2;
            }
            if (this.childs.size() == 1 && "#text".equals(aNode.getNodeName())) {
                strBuf.append("</");
                strBuf.append(this.nodeName);
                strBuf.append(">");
            } else {
                strBuf.append(lineWrap);
                i2 = 0;
                while (i2 < n) {
                    strBuf.append("\t");
                    ++i2;
                }
                strBuf.append("</");
                strBuf.append(this.nodeName);
                strBuf.append(">");
            }
        }
    }

    public void toWMLContent(int n, StringBuffer strBuf, boolean ignoreDocumentNode) {
        String name;
        String lineWrap = "\r\n";
        if (n == 0 && strBuf.toString().indexOf("<?xml") == -1) {
            strBuf.append("<?xml version=\"1.0\" encoding=\"");
            if (this.encoding != null) {
                strBuf.append(this.encoding);
            } else {
                strBuf.append(IDEConstance.encoding);
            }
            strBuf.append("\" ?>");
            strBuf.append(lineWrap);
            strBuf.append(lineWrap);
        }
        if ("#comment".equals(this.nodeName)) {
            strBuf.append("<!--");
            strBuf.append(this.getAttrValue("value"));
            strBuf.append("-->");
            return;
        }
        if ("#text".equals(this.nodeName)) {
            String value = this.getTextValue();
            strBuf.append(this.normalizeTextValue(value));
            return;
        }
        strBuf.append("<");
        strBuf.append(this.nodeName);
        String idStr = (String)this.attributes.get("id");
        if (idStr != null) {
            strBuf.append(" id=\"");
            strBuf.append(idStr);
            strBuf.append("\"");
        }
        if ((name = (String)this.attributes.get("name")) != null) {
            strBuf.append(" name=\"");
            strBuf.append(name);
            strBuf.append("\"");
        }
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if ("id".equals(key) || "name".equals(key)) continue;
            String value = (String)this.attributes.get(key);
            strBuf.append(" ");
            strBuf.append(key);
            strBuf.append("=\"");
            strBuf.append(this.normalize(value));
            strBuf.append("\"");
        }
        if (this.childs.size() <= 0) {
            strBuf.append("/>");
        } else {
            String value;
            XMLNode aNode = (XMLNode)this.childs.elementAt(0);
            if (this.childs.size() == 1 && "#text".equals(aNode.getNodeName()) && ((value = aNode.getTextValue()) == null || value.trim().length() == 0)) {
                strBuf.append("/>");
                return;
            }
            strBuf.append(">");
            int i = 0;
            while (i < this.childs.size()) {
                XMLNode child = (XMLNode)this.childs.elementAt(i);
                if (!ignoreDocumentNode || !child.getNodeName().equals("document")) {
                    child.toXMLContent(n + 1, strBuf, ignoreDocumentNode);
                }
                ++i;
            }
            if (this.childs.size() == 1 && "#text".equals(aNode.getNodeName())) {
                strBuf.append("</");
                strBuf.append(this.nodeName);
                strBuf.append(">");
            } else {
                strBuf.append("</");
                strBuf.append(this.nodeName);
                strBuf.append(">");
            }
        }
    }

    public void toHTMLContent(int n, StringBuffer strBuf, boolean ignoreDocumentNode) {
        String name;
        String lineWrap = "\r\n";
        if ("#document".equals(this.nodeName)) {
            int i = 0;
            while (i < this.childs.size()) {
                XMLNode child = (XMLNode)this.childs.elementAt(i);
                if (!ignoreDocumentNode || !child.getNodeName().equals("document")) {
                    child.toHTMLContent(n + 1, strBuf, ignoreDocumentNode);
                }
                ++i;
            }
            return;
        }
        if ("#comment".equals(this.nodeName)) {
            strBuf.append("<!--");
            strBuf.append(this.getAttrValue("value"));
            strBuf.append("-->");
            return;
        }
        if ("#text".equals(this.nodeName)) {
            if (this.getTextValue() != null) {
                strBuf.append(this.getTextValue());
            }
            return;
        }
        strBuf.append("<");
        strBuf.append(this.nodeName);
        String idStr = (String)this.attributes.get("id");
        if (idStr != null) {
            strBuf.append(" id=\"");
            strBuf.append(idStr);
            strBuf.append("\"");
        }
        if ((name = (String)this.attributes.get("name")) != null) {
            strBuf.append(" name=\"");
            strBuf.append(name);
            strBuf.append("\"");
        }
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if ("id".equals(key) || "name".equals(key)) continue;
            String value = (String)this.attributes.get(key);
            strBuf.append(" ");
            strBuf.append(key);
            strBuf.append("=\"");
            strBuf.append(this.normalizeHtmlStr(value));
            strBuf.append("\"");
        }
        if (this.childs.size() <= 0) {
            strBuf.append("/>");
        } else {
            strBuf.append(">");
            int i = 0;
            while (i < this.childs.size()) {
                XMLNode child = (XMLNode)this.childs.elementAt(i);
                if (!ignoreDocumentNode || !child.getNodeName().equals("document")) {
                    child.toHTMLContent(n + 1, strBuf, ignoreDocumentNode);
                }
                ++i;
            }
            strBuf.append("</");
            strBuf.append(this.nodeName);
            strBuf.append(">");
        }
    }

    public void toHTMLContent(int n, StringBuffer strBuf) {
        String name;
        if ("#text".equals(this.nodeName)) {
            if (this.getTextValue() != null) {
                strBuf.append(this.getTextValue());
            }
            return;
        }
        if (this.nodeName == null) {
            int i = 0;
            while (i < this.childs.size()) {
                XMLNode child = (XMLNode)this.childs.elementAt(i);
                strBuf = strBuf.append("\n");
                child.toHTMLContent(n, strBuf);
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < n) {
            strBuf.append("\t");
            ++i;
        }
        strBuf.append("<");
        strBuf.append(this.nodeName);
        String idStr = (String)this.attributes.get("id");
        if (idStr != null) {
            strBuf.append(" id=\"");
            strBuf.append(idStr);
            strBuf.append("\"");
        }
        if ((name = (String)this.attributes.get("name")) != null) {
            strBuf.append(" name=\"");
            strBuf.append(name);
            strBuf.append("\"");
        }
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if ("id".equals(key) || "name".equals(key)) continue;
            String value = (String)this.attributes.get(key);
            strBuf.append(" ");
            strBuf.append(key);
            strBuf.append("=\"");
            strBuf.append(this.normalizeHtmlStr(value));
            strBuf.append("\"");
        }
        if (this.childs.size() <= 0) {
            strBuf.append("/>");
        } else {
            strBuf.append(">");
            int i2 = 0;
            while (i2 < this.childs.size()) {
                XMLNode child = (XMLNode)this.childs.elementAt(i2);
                strBuf = strBuf.append("\n");
                child.toHTMLContent(n + 1, strBuf);
                ++i2;
            }
            strBuf = strBuf.append("\n");
            i2 = 0;
            while (i2 < n) {
                strBuf.append("\t");
                ++i2;
            }
            strBuf.append("</");
            strBuf.append(this.nodeName);
            strBuf.append(">");
        }
    }

    protected String normalizeHtmlStr(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                default: {
                    if (ch < ' ') {
                        str.append("&#");
                        str.append(String.valueOf((int)ch));
                        str.append(";");
                        break;
                    }
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                default: {
                    if (ch < ' ') {
                        str.append("&#");
                        str.append(String.valueOf((int)ch));
                        str.append(";");
                        break;
                    }
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    protected String normalizeTextValue(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public String getNodeValue() {
        if ("#text".equalsIgnoreCase(this.nodeName)) {
            return this.getTextValue();
        }
        XMLNode node = this.getChild("#text");
        if (node != null) {
            return node.getTextValue();
        }
        return null;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String value) {
        this.textValue = value;
    }

    public String getAttrValue(String key) {
        if (key == null) {
            return null;
        }
        if ("nodeValue".equals(key)) {
            return this.getNodeValue();
        }
        return (String)this.attributes.get(key);
    }

    public void setAttrValue(String key, String value) {
        if ("nodeValue".equals(key)) {
            if ("#text".equalsIgnoreCase(this.nodeName)) {
                this.setTextValue(value);
            } else {
                XMLNode node = this.getChild("#text");
                if (node == null) {
                    node = new XMLNode("#text");
                    this.add(node);
                }
                node.setTextValue(value);
            }
            this.fireContentChangedEvent();
            return;
        }
        if (value == null || value.length() == 0) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        this.fireContentChangedEvent();
    }

    public XMLNode findChildNode(String nodeName, String id) {
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.childs.size()) {
            XMLNode node = (XMLNode)this.childs.elementAt(i);
            if (node.getNodeName().equals(nodeName) && id.equals(node.getAttrValue("id"))) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public XMLNode findIgnoreCaseThrowChildNode(String nodeName, String id) {
        XMLNode node;
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            if (node.getNodeName().equals(nodeName) && id.equalsIgnoreCase(node.getAttrValue("id"))) {
                return node;
            }
            ++i;
        }
        i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            XMLNode aNode = node.findIgnoreCaseThrowChildNode(nodeName, id);
            if (aNode != null) {
                return aNode;
            }
            ++i;
        }
        return null;
    }

    public XMLNode findChildNodeNamed(String nodeName, String name) {
        XMLNode node;
        int i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            if (node.getNodeName().equals(nodeName) && name.equals(node.getAttrValue("name"))) {
                return node;
            }
            ++i;
        }
        i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            XMLNode aNode = node.findChildNodeNamed(nodeName, name);
            if (aNode != null) {
                return aNode;
            }
            ++i;
        }
        return null;
    }

    public XMLNode findChildNodeWithAttrValue(String nodeName, String attrName, String attrValue) {
        XMLNode node;
        int i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            if (node.getNodeName().equals(nodeName) && attrValue.equals(node.getAttrValue(attrName))) {
                return node;
            }
            ++i;
        }
        i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            XMLNode aNode = node.findChildNodeWithAttrValue(nodeName, attrName, attrValue);
            if (aNode != null) {
                return aNode;
            }
            ++i;
        }
        return null;
    }

    public XMLNode findChildNodeNamed(String name) {
        int i = 0;
        while (i < this.childs.size()) {
            XMLNode node = (XMLNode)this.childs.elementAt(i);
            if (name.equals(node.getAttrValue("name"))) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public XMLNode findChildNode(String id) {
        XMLNode node;
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            if (id.equals(node.getAttrValue("id"))) {
                return node;
            }
            ++i;
        }
        i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            XMLNode aNode = node.findChildNode(id);
            if (aNode != null) {
                return aNode;
            }
            ++i;
        }
        return null;
    }

    public XMLNode getChildNode(String id) {
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.childs.size()) {
            XMLNode node = (XMLNode)this.childs.elementAt(i);
            if (id.equals(node.getAttrValue("id"))) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public XMLNode getChildNode(String attrName, String attrValue) {
        if (attrValue == null) {
            return null;
        }
        int i = 0;
        while (i < this.childs.size()) {
            XMLNode node = (XMLNode)this.childs.elementAt(i);
            if (attrValue.equals(node.getAttrValue(attrName))) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public XMLNode findChildNodeIgnoreCase(String id) {
        XMLNode node;
        int i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            if (id.equalsIgnoreCase(node.getAttrValue("id"))) {
                return node;
            }
            ++i;
        }
        i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            XMLNode aNode = node.findChildNodeIgnoreCase(id);
            if (aNode != null) {
                return aNode;
            }
            ++i;
        }
        return null;
    }

    public XMLNode getChild(String nodeName) {
        int i = 0;
        while (i < this.childs.size()) {
            XMLNode node = (XMLNode)this.childs.elementAt(i);
            if (node.getNodeName().equals(nodeName)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public XMLNode findChild(String nodeName) {
        XMLNode node;
        int i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            if (node.getNodeName().equals(nodeName)) {
                return node;
            }
            ++i;
        }
        i = 0;
        while (i < this.childs.size()) {
            node = (XMLNode)this.childs.elementAt(i);
            XMLNode aNode = node.findChild(nodeName);
            if (aNode != null) {
                return aNode;
            }
            ++i;
        }
        return null;
    }

    public void adjustNodeOrder(XMLNode child, int order) {
        this.childs.remove(child);
        this.childs.insertElementAt(child, order);
        this.fireContentChangedEvent();
    }

    public Object clone() {
        XMLNode node = new XMLNode();
        node.setNodeName(this.nodeName);
        Enumeration keyList = this.attributes.keys();
        while (keyList.hasMoreElements()) {
            String key = (String)keyList.nextElement();
            node.setAttrValue(key, (String)this.attributes.get(key));
        }
        if (this.childs == null) {
            node.parent = this.parent;
            return node;
        }
        int i = 0;
        while (i < this.childs.size()) {
            XMLNode childNode = (XMLNode)this.childs.elementAt(i);
            node.add((XMLNode)childNode.clone());
            ++i;
        }
        node.parent = this.parent;
        node.setTextValue(this.textValue);
        node.setCDataValue(this.CDataValue);
        return node;
    }

    public void copyFromNode(XMLNode node) {
        Enumeration keyList = node.attributes.keys();
        while (keyList.hasMoreElements()) {
            String key = (String)keyList.nextElement();
            this.setAttrValue(key, (String)node.attributes.get(key));
        }
        this.setTextValue(node.getTextValue());
    }

    public void addContentChangedListener(ContentChangedListener contentListener, Object owner, int sourceType) {
        if (this.contentListeners == null) {
            this.contentListeners = new Vector(5);
            this.listenerInfos = new Hashtable();
        }
        this.contentListeners.addElement(contentListener);
        ListenerInfo listenerInfo = new ListenerInfo(owner, sourceType, contentListener);
        this.listenerInfos.put(contentListener, listenerInfo);
    }

    public void removeContentChangedListener(ContentChangedListener listener) {
        if (this.contentListeners == null) {
            return;
        }
        this.contentListeners.removeElement(listener);
        this.listenerInfos.remove(listener);
    }

    public void fireContentChangedEvent() {
        if (this.contentListeners == null || this.contentListeners.size() == 0) {
            if (this.parent != null) {
                this.parent.fireContentChangedEvent();
            }
        } else {
            int i = 0;
            while (i < this.contentListeners.size()) {
                ContentChangedListener contentListener = (ContentChangedListener)this.contentListeners.elementAt(i);
                ListenerInfo listenerInfo = (ListenerInfo)this.listenerInfos.get(contentListener);
                ContentChangedEvent event = new ContentChangedEvent(this, listenerInfo.owner, listenerInfo.sourceType);
                contentListener.contentChanged(event);
                ++i;
            }
        }
    }

    public XMLNode getParent() {
        return this.parent;
    }

    public void setParent(XMLNode pNode) {
        this.parent = pNode;
    }

    public void setDocument(String docStr) {
        XMLNode docNode = this.getChild("document");
        if (docNode == null) {
            docNode = new XMLNode();
            docNode.setNodeName("document");
            docNode.setAttrValue("nodeValue", docStr);
            this.add(docNode);
        } else {
            docNode.setAttrValue("nodeValue", docStr);
        }
    }

    public String getDocument() {
        XMLNode docNode = this.getChild("document");
        if (docNode == null) {
            return "";
        }
        String value = docNode.getNodeValue();
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void replaceNode(XMLNode src, XMLNode dst) {
        int i = 0;
        while (i < this.childs.size()) {
            XMLNode aNode = (XMLNode)this.childs.elementAt(i);
            if (aNode == src) {
                this.childs.setElementAt(dst, i);
                dst.parent = this;
                this.fireContentChangedEvent();
                break;
            }
            ++i;
        }
    }

    public int getIntAttrValue(String attrName) {
        String valueStr = (String)this.attributes.get(attrName);
        if (valueStr == null) {
            return 0;
        }
        try {
            return Integer.parseInt(valueStr);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public XMLNode getFirstNode() {
        for (int idx = 0; idx < this.childs.size(); ++idx) {
            XMLNode aNode = (XMLNode)this.childs.elementAt(idx);
            if ("#text".equals(aNode.getNodeName())) continue;
            return aNode;
        }
        return null;
    }

    public void removeAllChilds() {
        this.childs = new Vector(20);
        this.fireContentChangedEvent();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getCDataValue() {
        return this.CDataValue;
    }

    public void setCDataValue(String dataValue) {
        this.CDataValue = dataValue;
    }

    public void setLineEnd(boolean flag) {
        this.isLineEnd = flag;
    }

    public boolean isLineEnd() {
        if (this.isLineEnd) {
            if (this.getParent() != null) {
                return this.getParent().isLineEnd();
            }
            return this.isLineEnd;
        }
        return this.isLineEnd;
    }

    public Vector getContentListeners() {
        return this.contentListeners;
    }

    public class ListenerInfo {
        private Object owner;
        private int sourceType;
        private ContentChangedListener contentListener;

        public ListenerInfo(Object owner, int sourceType, ContentChangedListener contentListener) {
            this.owner = owner;
            this.sourceType = sourceType;
            this.contentListener = contentListener;
        }
    }
}

