/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.business;

import com.ecc.emp.ide.biz.operation.AddOperationWizard;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.business.DataDefPanel;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.ide.editor.visualflow.VisualFlowFramePanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.Messages;
import com.swtdesigner.ResourceManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class BusinessFlowPanel
extends Composite {
    private Text documentText;
    private Text opNameText;
    private Text opIdText;
    private Combo refFlowIdText;
    private Tree operationTree;
    private CTabFolder tabFolder;
    private VisualFlowFramePanel visualFlowFramePanel;
    private DataDefPanel inDataPanel;
    private DataDefPanel outDataPanel;
    private Composite opInfoPanel;
    private boolean flag = false;
    XMLNode trxNode;
    private XMLNode commonSvcNode;
    private XMLNode selfDefNode;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private EditorProfile flowProfile;
    private XMLNode commonFlowNode;
    private XMLNode channelSettings;
    static /* synthetic */ Class class$0;

    public BusinessFlowPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Label operationLabel = new Label((Composite)this, 0);
        operationLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        operationLabel.setText("\u4e1a\u52a1\u903b\u8f91\u5b9a\u4e49");
        SashForm sashForm = new SashForm((Composite)this, 0);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new FillLayout());
        Composite treeComp = new Composite(composite, 0);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.verticalSpacing = 0;
        gridLayout_2.horizontalSpacing = 0;
        gridLayout_2.marginHeight = 0;
        gridLayout_2.marginWidth = 0;
        treeComp.setLayout((Layout)gridLayout_2);
        this.operationTree = new Tree(treeComp, 2048);
        this.operationTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        this.operationTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = BusinessFlowPanel.this.operationTree.getSelection();
                if (items.length == 0) {
                    return;
                }
                TreeItem item = items[0];
                XMLNode curNode = (XMLNode)item.getData("operation");
                if (curNode == null) {
                    BusinessFlowPanel.this.tabFolder.setVisible(false);
                    return;
                }
                BusinessFlowPanel.this.showActiveFlow(curNode, item);
            }
        });
        GridLayout treeLayout = new GridLayout();
        treeLayout.numColumns = 1;
        treeLayout.verticalSpacing = 5;
        Composite opComp = new Composite((Composite)sashForm, 0);
        opComp.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder(opComp, 3072);
        CTabItem item1 = new CTabItem(this.tabFolder, 0);
        item1.setText(Messages.getString("BusinessFlowPanel.GeneralInfo"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.editor.business.BusinessFlowPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        item1.setImage(ResourceManager.getImage(clazz, "/images/data_view.gif"));
        this.createOpInfoPanel();
        item1.setControl((Control)this.opInfoPanel);
        CTabItem item2 = new CTabItem(this.tabFolder, 0);
        item2.setText(Messages.getString("BusinessFlowPanel.flow"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ecc.ide.editor.business.BusinessFlowPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        item2.setImage(ResourceManager.getImage(clazz2, "/images/operation.gif"));
        this.visualFlowFramePanel = new VisualFlowFramePanel((Composite)this.tabFolder, 0);
        this.visualFlowFramePanel.addMaximizedItem();
        item2.setControl((Control)this.visualFlowFramePanel);
        this.tabFolder.setSelection(1);
        Composite comp = new Composite((Composite)this, 0);
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_1 = new GridLayout(2, true);
        gridLayout_1.verticalSpacing = 0;
        gridLayout_1.marginHeight = 0;
        comp.setLayout((Layout)gridLayout_1);
        Button addButton = new Button(comp, 0x800000);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusinessFlowPanel.this.createNewOperation();
            }
        });
        addButton.setText("\u6dfb\u52a0");
        addButton.setLayoutData((Object)new GridData());
        Button deleteButton = new Button(comp, 0);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusinessFlowPanel.this.deleteTheOperation();
            }
        });
        deleteButton.setText("\u5220\u9664");
        deleteButton.setLayoutData((Object)new GridData());
        sashForm.setWeights(new int[]{1, 4});
    }

    private void createOpInfoPanel() {
        this.opInfoPanel = new Composite((Composite)this.tabFolder, 0);
        this.opInfoPanel.setLayout((Layout)new GridLayout(1, true));
        Group infoGroup = new Group(this.opInfoPanel, 0);
        infoGroup.setLayoutData((Object)new GridData(768));
        infoGroup.setText(Messages.getString("BusinessFlowPanel.GeneralInfo"));
        infoGroup.setLayout((Layout)new GridLayout(2, false));
        Label documentLabel = new Label((Composite)infoGroup, 0);
        documentLabel.setLayoutData((Object)new GridData(3, 2, true, false, 2, 1));
        documentLabel.setText(Messages.getString("BusinessFlowPanel.Document"));
        Composite comp = new Composite((Composite)infoGroup, 0);
        comp.setLayoutData((Object)new GridData(1, 4, false, true, 1, 4));
        comp.setLayout((Layout)new GridLayout(2, false));
        Label operationidLabel = new Label(comp, 0);
        operationidLabel.setText(Messages.getString("BusinessFlowPanel.OperationId"));
        this.opIdText = new Text(comp, 2048);
        this.opIdText.setLayoutData((Object)new GridData(150, -1));
        this.opIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BusinessFlowPanel.this.updateTheOperation();
            }
        });
        Label operationnameLabel = new Label(comp, 0);
        operationnameLabel.setText(Messages.getString("BusinessFlowPanel.OperationName"));
        this.opNameText = new Text(comp, 2048);
        this.opNameText.setLayoutData((Object)new GridData(150, -1));
        this.opNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BusinessFlowPanel.this.updateTheOperation();
            }
        });
        Label refFlowLabel = new Label(comp, 0);
        refFlowLabel.setText(Messages.getString("BusinessFlowPanel.refToCommonFlow"));
        this.refFlowIdText = new Combo(comp, 2048);
        this.refFlowIdText.setLayoutData((Object)new GridData(150, -1));
        this.addTemplatCombo();
        this.refFlowIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BusinessFlowPanel.this.updateTheOperation();
            }
        });
        this.documentText = new Text((Composite)infoGroup, 2882);
        this.documentText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        this.documentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BusinessFlowPanel.this.updateTheOperation();
            }
        });
        Group dataGroup = new Group(this.opInfoPanel, 0);
        dataGroup.setLayoutData((Object)new GridData(1808));
        dataGroup.setText("\u4e1a\u52a1\u903b\u8f91\u8bbf\u95ee\u63a5\u53e3");
        dataGroup.setLayout((Layout)new GridLayout(4, false));
        Button inButton = new Button((Composite)dataGroup, 16);
        inButton.setText(Messages.getString("BusinessFlowPanel.input"));
        inButton.setSelection(true);
        Button outButton = new Button((Composite)dataGroup, 16);
        outButton.setText(Messages.getString("BusinessFlowPanel.output"));
        final Composite dataPanel = new Composite((Composite)dataGroup, 0);
        dataPanel.setLayoutData((Object)new GridData(4, 4, true, true, 4, 4));
        final StackLayout dataLayout = new StackLayout();
        dataPanel.setLayout((Layout)dataLayout);
        this.inDataPanel = new DataDefPanel(dataPanel, 0);
        this.outDataPanel = new DataDefPanel(dataPanel, 0);
        dataLayout.topControl = this.inDataPanel;
        dataPanel.layout();
        inButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dataLayout.topControl = BusinessFlowPanel.this.inDataPanel;
                dataPanel.layout();
            }
        });
        outButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dataLayout.topControl = BusinessFlowPanel.this.outDataPanel;
                dataPanel.layout();
            }
        });
    }

    private void showActiveFlow(XMLNode curNode, TreeItem item) {
        this.flag = true;
        if (curNode == null) {
            this.tabFolder.setVisible(false);
            return;
        }
        this.tabFolder.setVisible(true);
        this.opIdText.setText(curNode.getAttrValue("id"));
        if (curNode.getDocument() != null) {
            this.documentText.setText(curNode.getDocument());
        } else {
            this.documentText.setText("");
        }
        if (curNode.getAttrValue("name") != null) {
            this.opNameText.setText(curNode.getAttrValue("name"));
        } else {
            this.opNameText.setText("");
        }
        if (curNode.getAttrValue("refFlowId") != null) {
            this.refFlowIdText.setText(curNode.getAttrValue("refFlowId"));
            this.visualFlowFramePanel.setMainFlow(false);
        } else {
            this.refFlowIdText.setText("");
            this.visualFlowFramePanel.setMainFlow(true);
        }
        try {
            XMLNode flowNode = curNode.getChild("flow");
            if (flowNode == null) {
                flowNode = new XMLNode("flow");
                flowNode.setAttrValue("x", "10");
                flowNode.setAttrValue("y", "10");
                flowNode.setAttrValue("width", "500");
                flowNode.setAttrValue("height", "400");
                curNode.add(flowNode);
            }
            flowNode = this.mergeCommonFlow(curNode, item);
            this.visualFlowFramePanel.setXMLContent(flowNode);
            XMLNode inDataNode = curNode.getChild("input");
            if (inDataNode == null) {
                inDataNode = new XMLNode("input");
                curNode.add(inDataNode);
            }
            this.inDataPanel.setHostAccessDataNode(inDataNode);
            XMLNode outDataNode = curNode.getChild("output");
            if (outDataNode == null) {
                outDataNode = new XMLNode("output");
                curNode.add(outDataNode);
            }
            this.outDataPanel.setHostAccessDataNode(outDataNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flag = false;
    }

    private XMLNode mergeCommonFlow(XMLNode opNode, TreeItem item) {
        XMLNode extendedAction;
        XMLNode flowNode = opNode.getChild("flow");
        String refFlowId = opNode.getAttrValue("refFlowId");
        if (refFlowId == null || refFlowId.trim().length() == 0) {
            return flowNode;
        }
        XMLNode refFlow = (XMLNode)item.getData("refFlow");
        if (refFlow != null) {
            return refFlow;
        }
        refFlow = (XMLNode)this.commonFlowNode.findChildNode(refFlowId).clone();
        if (refFlow == null) {
            return flowNode;
        }
        int i = 0;
        while (i < refFlow.getChilds().size()) {
            XMLNode extendedAction2 = (XMLNode)refFlow.getChilds().elementAt(i);
            if ("ExtendedAction".equals(extendedAction2.getNodeName())) {
                XMLNode eAction = flowNode.findChildNodeWithAttrValue("ExtendedAction", "extendId", extendedAction2.getAttrValue("extendId"));
                if (eAction == null) {
                    flowNode.add(extendedAction2);
                } else {
                    XMLNode node;
                    XMLNode parent = eAction.getParent();
                    int j = 0;
                    while (j < eAction.getChilds().size()) {
                        node = (XMLNode)eAction.getChilds().elementAt(j);
                        if ("transition".equals(node.getNodeName())) {
                            eAction.getChilds().remove(node);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < extendedAction2.getChilds().size()) {
                        node = (XMLNode)extendedAction2.getChilds().elementAt(j);
                        if ("transition".equals(node.getNodeName())) {
                            node.setParent(eAction);
                            eAction.getChilds().addElement(node);
                        }
                        ++j;
                    }
                    refFlow.replaceNode(extendedAction2, eAction);
                    eAction.setParent(parent);
                }
            }
            ++i;
        }
        XMLNode tempNode = new XMLNode("tempNode");
        int i2 = 0;
        while (i2 < refFlow.getChilds().size()) {
            extendedAction = (XMLNode)refFlow.getChilds().elementAt(i2);
            if (!"ExtendedAction".equals(extendedAction.getNodeName())) {
                ++i2;
                continue;
            }
            refFlow.getChilds().remove(extendedAction);
            tempNode.getChilds().add(extendedAction);
        }
        i2 = 0;
        while (i2 < tempNode.getChilds().size()) {
            extendedAction = (XMLNode)tempNode.getChilds().elementAt(i2);
            refFlow.getChilds().add(extendedAction);
            ++i2;
        }
        i2 = 0;
        while (i2 < flowNode.getChilds().size()) {
            XMLNode eAction;
            extendedAction = (XMLNode)flowNode.getChilds().elementAt(i2);
            if ("ExtendedAction".equals(extendedAction.getNodeName()) && (eAction = refFlow.findChildNodeWithAttrValue("ExtendedAction", "extendId", extendedAction.getAttrValue("extendId"))) == null) {
                flowNode.remove(extendedAction);
            }
            ++i2;
        }
        item.setData("refFlow", (Object)refFlow);
        return refFlow;
    }

    private void createNewOperation() {
        AddOperationWizard wizard = new AddOperationWizard();
        XMLNode flowNode = wizard.getXMLNode(IDEContent.getCurrentProject(), this.trxNode, this.commonFlowNode);
        if (flowNode == null) {
            return;
        }
        String displayLabel = flowNode.getAttrValue("id");
        if (flowNode.getAttrValue("name") != null) {
            displayLabel = String.valueOf(displayLabel) + "[" + flowNode.getAttrValue("name") + "]";
        }
        TreeItem item = new TreeItem(this.operationTree.getItem(0), 0);
        item.setText(displayLabel);
        item.setData("operation", (Object)flowNode);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.editor.business.BusinessFlowPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        item.setImage(ResourceManager.getImage(clazz, "/images/operation.gif"));
        this.operationTree.setSelection(new TreeItem[]{item});
        this.trxNode.add(flowNode);
        this.showActiveFlow(flowNode, item);
    }

    private void deleteTheOperation() {
        TreeItem[] sItems = this.operationTree.getSelection();
        if (sItems == null || sItems.length < 1) {
            return;
        }
        XMLNode curNode = (XMLNode)sItems[0].getData("operation");
        if (curNode == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"\u63d0\u793a", (String)"\u786e\u5b9a\u5220\u9664\u6240\u9009\u5b9a\u7684\u4e1a\u52a1\u903b\u8f91?")) {
            return;
        }
        this.trxNode.remove(curNode);
        sItems[0].dispose();
    }

    private void updateTheOperation() {
        if (this.flag) {
            return;
        }
        TreeItem[] sItems = this.operationTree.getSelection();
        if (sItems == null || sItems.length < 1) {
            return;
        }
        XMLNode curNode = (XMLNode)sItems[0].getData("operation");
        if (curNode == null) {
            return;
        }
        String flowId = this.opIdText.getText();
        String flowName = this.opNameText.getText();
        String refFlowId = this.refFlowIdText.getText();
        String desc = this.documentText.getText();
        if (flowId.equals(curNode.getAttrValue("id")) && flowName.equals(curNode.getAttrValue("name")) && desc.equals(curNode.getDocument()) && (refFlowId.equals(curNode.getAttrValue("refFlowId")) || refFlowId.length() == 0 && curNode.getAttrValue("refFlowId") == null)) {
            return;
        }
        boolean tempflag = false;
        if (!refFlowId.equals(curNode.getAttrValue("refFlowId")) && refFlowId.length() > 0) {
            boolean result = MessageDialog.openConfirm((Shell)this.getShell(), (String)"\u66ff\u6362", (String)"\u786e\u8ba4\u4fee\u6539\u6240\u5f15\u7528\u7684\u516c\u5171\u6d41\u7a0b?");
            if (!result) {
                return;
            }
            tempflag = true;
        }
        if (flowId == null || flowId.length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"error", (String)Messages.getString("BusinessFlowPanel.properId"));
            return;
        }
        XMLNode aFlowNode = this.trxNode.findChildNode("operation", flowId);
        if (aFlowNode != null && aFlowNode != curNode) {
            MessageDialog.openError((Shell)this.getShell(), (String)"error", (String)Messages.getString("BusinessFlowPanel.duplicateId"));
            return;
        }
        curNode.setAttrValue("id", flowId);
        curNode.setAttrValue("name", flowName);
        curNode.setAttrValue("refFlowId", refFlowId);
        curNode.setDocument(this.documentText.getText());
        String displayLabel = String.valueOf(flowId) + "[" + flowName + "]";
        sItems[0].setText(displayLabel);
        if (tempflag) {
            this.operationTree.setSelection(new TreeItem[]{this.operationTree.getSelection()[0]});
            TreeItem[] items = this.operationTree.getSelection();
            if (items.length == 0) {
                return;
            }
            TreeItem item = items[0];
            curNode = (XMLNode)item.getData("operation");
            if (curNode == null) {
                this.tabFolder.setVisible(false);
                return;
            }
            item.setData("refFlow", null);
            this.showActiveFlow(curNode, item);
        }
    }

    public void setTrxNode(XMLNode node) {
        this.trxNode = node;
        if (this.trxNode == null) {
            return;
        }
        this.operationTree.removeAll();
        TreeItem pItem = new TreeItem(this.operationTree, 0);
        pItem.setText("\u4e1a\u52a1\u903b\u8f91\u5217\u8868");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.editor.business.BusinessFlowPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        pItem.setImage(ResourceManager.getImage(clazz, "/images/folder.png"));
        int i = 0;
        while (i < this.trxNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)this.trxNode.getChilds().elementAt(i);
            if ("operation".equals(aNode.getNodeName())) {
                TreeItem item = new TreeItem(pItem, 0);
                item.setData("operation", (Object)aNode);
                item.setText(String.valueOf(aNode.getAttrValue("id")) + "[" + aNode.getAttrValue("name") + "]");
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("com.ecc.ide.editor.business.BusinessFlowPanel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                item.setImage(ResourceManager.getImage(clazz2, "/images/operation.gif"));
            }
            ++i;
        }
        pItem.setExpanded(true);
        if (pItem.getItemCount() > 0) {
            this.operationTree.setSelection(new TreeItem[]{pItem.getItem(0)});
            this.showActiveFlow((XMLNode)pItem.getItem(0).getData("operation"), pItem.getItem(0));
        } else {
            this.showActiveFlow(null, null);
        }
    }

    public void setCommonFlowNode(XMLNode flowNode) {
        this.commonFlowNode = flowNode;
        this.addTemplatCombo();
    }

    public void setFlowEditorProfile(EditorProfile profile) {
        this.flowProfile = profile;
        this.visualFlowFramePanel.setEditorProfile(profile);
    }

    public EditorProfile getEditorProfile() {
        return this.flowProfile;
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonSvcNode = node;
        this.visualFlowFramePanel.setCommonServiceNode(node);
    }

    public void setChannelSettings(XMLNode node) {
        this.channelSettings = node;
        this.visualFlowFramePanel.setChannelSettings(node);
    }

    public void setSelfDefineNode(XMLNode node) {
        this.selfDefNode = node;
        this.visualFlowFramePanel.setSelfDefineNode(node);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.visualFlowFramePanel.setDataDictionary(node);
        this.inDataPanel.setDataDictionary(this.dataDictionary);
        this.outDataPanel.setDataDictionary(this.dataDictionary);
    }

    public void setExternResource(XMLNode value) {
        this.visualFlowFramePanel.setExternResource(value);
    }

    public void setFunctionProfile(EditorProfile profile) {
        this.visualFlowFramePanel.setFunctionProfile(profile);
    }

    public void setFunctionNode(XMLNode node) {
        this.visualFlowFramePanel.setFunctionNode(node);
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
        this.visualFlowFramePanel.setDataEditorProfile(profile);
        this.inDataPanel.setDataEditorProfile(this.dataEditorProfile);
        this.outDataPanel.setDataEditorProfile(this.dataEditorProfile);
    }

    public void setDataProvider(DataProvider provider) {
        this.inDataPanel.setDataProvider(provider);
        this.outDataPanel.setDataProvider(provider);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setOp(String opId) {
        TreeItem[] items = this.operationTree.getItems()[0].getItems();
        if (items.length == 0) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            XMLNode curNode = (XMLNode)item.getData("operation");
            if (curNode != null && curNode.getAttrValue("id").equals(opId)) {
                this.operationTree.setSelection(new TreeItem[]{item});
                this.showActiveFlow(curNode, item);
            }
            ++i;
        }
    }

    private void addTemplatCombo() {
        if (this.commonFlowNode != null) {
            this.refFlowIdText.removeAll();
            this.refFlowIdText.add("");
            int i = 0;
            while (i < this.commonFlowNode.getChilds().size()) {
                XMLNode child = (XMLNode)this.commonFlowNode.getChilds().elementAt(i);
                if ("flow".equals(child.getNodeName())) {
                    this.refFlowIdText.add(child.getAttrValue("id"));
                }
                ++i;
            }
        }
    }
}

