/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.html;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.html.Messages;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.function.FunctionSelectDialog;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConditionEditorPanel
extends Composite {
    private Combo combo;
    private Text formulaText;
    private XMLNode functionNode;
    private EditorProfile functionProfile;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;

    public ConditionEditorPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Messages.getString("FormulaEditorPanel.formula_define__1"));
        this.formulaText = new Text((Composite)this, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.formulaText.setLayoutData((Object)gridData);
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("ConditionEditorPanel.Operator__1"));
        this.combo = new Combo((Composite)this, 0);
        this.combo.setItems(new String[]{"+", "-", "*", "/", "=", "<>", ">=", "<=", ">", "<", "!", "!=", "and", "or"});
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 68;
        this.combo.setLayoutData((Object)gridData_1);
        Button button_2 = new Button((Composite)this, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String op = ConditionEditorPanel.this.combo.getText();
                ConditionEditorPanel.this.formulaText.insert(op);
            }
        });
        button_2.setText(Messages.getString("ConditionEditorPanel.Insert_16"));
        Button button_1 = new Button((Composite)this, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionEditorPanel.this.insertFunction();
            }
        });
        button_1.setToolTipText(Messages.getString("ViewFormulaEditorPanel.Insert_a_function_define_3"));
        button_1.setText(Messages.getString(Messages.getString("ConditionEditorPanel.ViewFormulaEditorPanel.InsertFunction_4_18")));
        Button button = new Button((Composite)this, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionEditorPanel.this.insertDataParamater();
            }
        });
        button.setText("InsertDataParam");
        this.setSize(400, 200);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setValue(Object value) {
        if (value != null && this.formulaText != null) {
            this.formulaText.setText(value.toString());
        }
    }

    public void setFunctionXMLNode(XMLNode node) {
        this.functionNode = node;
    }

    public Object getValue() {
        try {
            return this.formulaText.getText();
        }
        catch (Exception e) {
            return "";
        }
    }

    private void insertFunction() {
        FunctionSelectDialog dialog = new FunctionSelectDialog(this.getShell());
        dialog.setProfile(this.functionProfile);
        dialog.setFunctionNode(this.functionNode);
        String result = (String)dialog.open();
        if (result != null) {
            this.formulaText.insert(result);
        }
    }

    private void insertDataParamater() {
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell());
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        Vector datas = (Vector)dialog.open();
        if (datas != null) {
            XMLNode node = (XMLNode)datas.elementAt(0);
            String dataName = node.getAttrValue("id");
            this.formulaText.insert("$" + dataName);
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setFunctionProfile(EditorProfile profile) {
        this.functionProfile = profile;
    }

    public String getFormulaStr() {
        return this.formulaText.getText();
    }

    public void setFormulaStr(String str) {
        this.formulaText.setText(str);
    }
}

