/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.html;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualJsp.JSPLoader;
import com.ecc.ide.editorprofile.EditorProfile;
import com.swtdesigner.ResourceManager;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class HtmlTrxJspDefinePanel
extends Composite {
    private Label divIdLabel;
    private Text divIdText;
    private Button toBeLayoutContentButton;
    protected IProject project;
    private String rootPath;
    private Text documentText;
    private Text jspFileText;
    private Text encodingText;
    private Table jspListTable;
    private XMLNode jsFunctionNode;
    private String htmlTrxFileName;
    private boolean toBeLayoutContent = false;
    private int[] weights;
    private XMLNode dataDictionary;
    private EditorProfile dataProfile;
    private EditorProfile jspFileProfile;
    private XMLNode xmlContent;
    private XMLNode currentJspNode = null;
    private XMLNode patternNode;
    private EditorProfile patternProfile;
    private BuildProblemReporter reporter;
    private XMLNode externResourceNode;
    static /* synthetic */ Class class$0;

    public void setJSPFileEditorProfile(EditorProfile profile) {
        this.jspFileProfile = profile;
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataProfile = profile;
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setPatternNode(XMLNode node) {
        this.patternNode = node;
    }

    public void setPatternProfile(EditorProfile profile) {
        this.patternProfile = profile;
    }

    public HtmlTrxJspDefinePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        this.weights = new int[2];
        this.weights[0] = 1;
        this.weights[1] = 3;
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite.setLayout((Layout)gridLayout_1);
        Label label_1 = new Label(composite, 0);
        label_1.setText(Messages.getString("HTMLJSPDefinePanel.JSPFileName__2"));
        this.jspFileText = new Text(composite, 2048);
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 230;
        this.jspFileText.setLayoutData((Object)gridData_4);
        Label encodingLabel = new Label(composite, 0);
        encodingLabel.setText("JSP page encoding:");
        this.encodingText = new Text(composite, 2048);
        this.encodingText.setText(System.getProperty("file.encoding"));
        this.toBeLayoutContentButton = new Button(composite, 32);
        this.toBeLayoutContentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HtmlTrxJspDefinePanel.this.toBeLayoutContentButton.getSelection()) {
                    HtmlTrxJspDefinePanel.this.divIdLabel.setVisible(true);
                    HtmlTrxJspDefinePanel.this.divIdText.setVisible(true);
                    HtmlTrxJspDefinePanel.this.toBeLayoutContent = true;
                } else {
                    HtmlTrxJspDefinePanel.this.divIdLabel.setVisible(false);
                    HtmlTrxJspDefinePanel.this.divIdText.setVisible(false);
                    HtmlTrxJspDefinePanel.this.toBeLayoutContent = false;
                }
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.toBeLayoutContentButton.setLayoutData((Object)gridData);
        this.toBeLayoutContentButton.setText("As a Layout content JSP");
        this.divIdLabel = new Label(composite, 0);
        this.divIdLabel.setText("Content DIV ID:");
        this.divIdLabel.setVisible(false);
        this.divIdText = new Text(composite, 2048);
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 126;
        this.divIdText.setLayoutData((Object)gridData_5);
        if (IDEConstance.contentDivID != null) {
            this.divIdText.setText(IDEConstance.contentDivID);
        }
        this.divIdText.setVisible(false);
        Label label_3 = new Label(composite, 0);
        label_3.setText(Messages.getString("HTMLJSPDefinePanel.Document__3"));
        this.documentText = new Text(composite, 2818);
        GridData gridData_6 = new GridData(776);
        gridData_6.heightHint = 40;
        gridData_6.horizontalSpan = 4;
        this.documentText.setLayoutData((Object)gridData_6);
        Composite composite_2 = new Composite(composite, 0);
        GridData gridData_7 = new GridData(768);
        gridData_7.horizontalSpan = 4;
        composite_2.setLayoutData((Object)gridData_7);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_2);
        Button button = new Button(composite_2, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HtmlTrxJspDefinePanel.this.addNewJSPFile();
            }
        });
        button.setText(Messages.getString("HTMLJSPDefinePanel.create_4"));
        Button button_2 = new Button(composite_2, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HtmlTrxJspDefinePanel.this.deleteSelectedJSPFile();
            }
        });
        button_2.setText(Messages.getString("HTMLJSPDefinePanel.delete_5"));
        Button button_3 = new Button(composite_2, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HtmlTrxJspDefinePanel.this.updateSelectedJSP();
            }
        });
        button_3.setText(Messages.getString("HTMLJSPDefinePanel.Update_1"));
        Button button_4 = new Button(composite_2, 0);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HtmlTrxJspDefinePanel.this.rebuildJspFlowModel();
            }
        });
        button_4.setText(Messages.getString("HtmlTrxJspDefinePanel.rebuildJspFlow"));
        Label label = new Label(composite, 0);
        GridData gridData_2 = new GridData();
        gridData_2.horizontalSpan = 4;
        label.setLayoutData((Object)gridData_2);
        label.setText(Messages.getString("JSP_List"));
        this.jspListTable = new Table(composite, 67584);
        this.jspListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HtmlTrxJspDefinePanel.this.setActivateJSP();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                HtmlTrxJspDefinePanel.this.editJSP(HtmlTrxJspDefinePanel.this.currentJspNode);
            }
        });
        GridData gridData_3 = new GridData(1808);
        gridData_3.horizontalSpan = 4;
        this.jspListTable.setLayoutData((Object)gridData_3);
        this.jspListTable.setLinesVisible(true);
        this.jspListTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.jspListTable, 0);
        tableColumn.setWidth(163);
        tableColumn.setText(Messages.getString("HTMLJSPDefinePanel.JSP_FileName_7"));
        TableColumn tableColumn_2 = new TableColumn(this.jspListTable, 0);
        tableColumn_2.setWidth(256);
        tableColumn_2.setText(Messages.getString("HTMLJSPDefinePanel.document__8"));
        Menu popupmenu = new Menu((Control)this.jspListTable);
        MenuItem menuItem_2 = new MenuItem(popupmenu, 0);
        menuItem_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HtmlTrxJspDefinePanel.this.editJSP(HtmlTrxJspDefinePanel.this.currentJspNode);
            }
        });
        menuItem_2.setText(Messages.getString("HtmlTrxJspDefinePanel.open"));
        new MenuItem(popupmenu, 2);
        MenuItem menuItem_4 = new MenuItem(popupmenu, 0);
        menuItem_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HtmlTrxJspDefinePanel.this.deleteSelectedJSPFile();
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.editor.xml.XMLContentPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        menuItem_4.setImage(ResourceManager.getImage(clazz, "/images/delete_edit.gif"));
        menuItem_4.setText(Messages.getString("XMLContentPanel.Delete_8"));
        this.jspListTable.setMenu(popupmenu);
    }

    public void setXMLContent(XMLNode node) {
        this.xmlContent = node;
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode jspNode = (XMLNode)childs.elementAt(i);
            if ("jsp".equals(jspNode.getNodeName())) {
                TableItem item = new TableItem(this.jspListTable, 0);
                item.setText(jspNode.getAttrValue("fileName"));
                if (jspNode.getDocument() != null) {
                    item.setText(1, jspNode.getDocument());
                }
                item.setData((Object)jspNode);
            }
            ++i;
        }
        if (childs.size() > 0) {
            this.jspListTable.setSelection(0);
            this.setActivateJSP();
        }
    }

    private void setActivateJSP() {
        TableItem[] items = this.jspListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (node == this.currentJspNode) {
            return;
        }
        this.currentJspNode = node;
        this.jspFileText.setText(node.getAttrValue("fileName"));
        if (node.getDocument() != null) {
            this.documentText.setText(node.getDocument());
        } else {
            this.documentText.setText("");
        }
        if ("true".equals(node.getAttrValue("toBeLayoutContent"))) {
            this.toBeLayoutContentButton.setSelection(true);
            this.divIdLabel.setVisible(true);
            this.divIdText.setVisible(true);
            if (node.getAttrValue("contentDivId") != null) {
                this.divIdText.setText(node.getAttrValue("contentDivId"));
            } else {
                this.divIdText.setText(IDEConstance.contentDivID);
            }
            this.toBeLayoutContent = true;
        } else {
            this.toBeLayoutContentButton.setSelection(false);
            this.divIdLabel.setVisible(false);
            this.divIdText.setVisible(false);
            this.divIdText.setText(IDEConstance.contentDivID);
            this.toBeLayoutContent = false;
        }
        String encoding = node.getAttrValue("encoding");
        if (encoding != null) {
            this.encodingText.setText(encoding);
        } else {
            this.encodingText.setText("");
        }
    }

    private void addNewJSPFile() {
        String jspFileName = this.jspFileText.getText();
        int idx = jspFileName.toLowerCase().indexOf(".jsp");
        if (jspFileName.length() == 0 || idx == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.Please_input_proper_JSPFileName_2"));
            return;
        }
        if (idx != jspFileName.length() - 4) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.Please_input_proper_JSPFileName_2"));
            return;
        }
        String classify = this.xmlContent.getParent().getAttrValue("classify");
        if (this.xmlContent == null) {
            return;
        }
        Vector childs = this.xmlContent.getChilds();
        int i = 0;
        while (childs != null && i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (jspFileName.equalsIgnoreCase(aNode.getAttrValue("fileName"))) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_3"), (String)Messages.getString("HTMLJSPDefinePanel.duplicated_jspFileName_4"));
                return;
            }
            ++i;
        }
        if (this.checkDuplicatedJSPFileName(jspFileName)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.JSP_file_was_exisit_!_2"));
            return;
        }
        XMLNode jspNode = new XMLNode("jsp");
        jspNode.setAttrValue("fileName", this.jspFileText.getText());
        jspNode.setAttrValue("name", this.jspFileText.getText());
        String htmlTrxCode = this.xmlContent.getParent().getAttrValue("trxCode");
        String contentDivId = this.divIdText.getText();
        if (contentDivId.length() == 0) {
            contentDivId = IDEConstance.contentDivID;
        }
        jspNode.setAttrValue("toBeLayoutContent", String.valueOf(this.toBeLayoutContent));
        jspNode.setAttrValue("contentDivId", contentDivId);
        jspNode.setAttrValue("encoding", this.encodingText.getText());
        jspNode.setDocument(this.documentText.getText());
        this.xmlContent.add(jspNode);
        TableItem item = new TableItem(this.jspListTable, 0);
        item.setText(this.jspFileText.getText());
        item.setText(1, this.documentText.getText());
        item.setData((Object)jspNode);
        this.createJSPFile(jspFileName);
        this.editJSP(jspNode);
    }

    private void updateSelectedJSP() {
        TableItem[] items = this.jspListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        String jspFileName = this.jspFileText.getText();
        int idx = jspFileName.toLowerCase().indexOf(".jsp");
        if (jspFileName.length() == 0 || idx == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.Please_input_proper_JSPFileName_2"));
            return;
        }
        if (idx != jspFileName.length() - 4) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.Please_input_proper_JSPFileName_2"));
            return;
        }
        Vector childs = this.xmlContent.getChilds();
        int i = 0;
        while (childs != null && i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (jspFileName.equalsIgnoreCase(aNode.getAttrValue("fileName")) && aNode != node) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_3"), (String)Messages.getString("HTMLJSPDefinePanel.duplicated_jspFileName_4"));
                return;
            }
            ++i;
        }
        jspFileName.equalsIgnoreCase(node.getAttrValue("fileName"));
        String docStr = this.documentText.getText();
        node.setAttrValue("fileName", jspFileName);
        node.setAttrValue("name", jspFileName);
        node.setDocument(docStr);
        node.setAttrValue("encoding", this.encodingText.getText());
        items[0].setText(jspFileName);
        items[0].setText(1, docStr);
    }

    private void deleteSelectedJSPFile() {
        TableItem[] items = this.jspListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_5"), (String)Messages.getString("HTMLJSPDefinePanel.Are_you_sure_to_delete_the_selected_jsp_define__6"))) {
            return;
        }
        this.deleteJSPFile(node.getAttrValue("fileName"));
        this.xmlContent.remove(node);
        items[0].dispose();
        this.jspFileText.setText("");
        this.documentText.setText("");
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    private void createJSPFile(String fileName) {
        try {
            String filePath;
            String encoding = this.encodingText.getText();
            String emptyJspFileContent = "<%@page language=\"java\" contentType=\"text/html; charset=" + encoding + "\"%>\n" + "<%@taglib uri=\"/WEB-INF/ctp.tld\" prefix=\"ctp\" %>\n\n" + "<%@taglib uri=\"/WEB-INF/emp.tld\" prefix=\"emp\" %>\n\n" + "<%@taglib uri=\"/WEB-INF/c.tld\" prefix=\"c\" %>\n\n" + "<html>\n<head>\n<title>ECC IDE Jsp file</title>\n" + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/>\n" + "<!-- ECC IDE required comment, please don't delete it! -->\n";
            emptyJspFileContent = emptyJspFileContent.replaceAll("GBK", this.encodingText.getText());
            String classify = this.xmlContent.getParent().getAttrValue("classify");
            if (classify != null && classify.length() > 0) {
                filePath = String.valueOf(this.rootPath) + "/WebContent/" + classify;
                File file = new File(filePath);
                if (!file.exists()) {
                    file.mkdirs();
                    this.project.getFolder("WebContent").refreshLocal(2, null);
                }
            } else {
                filePath = String.valueOf(this.rootPath) + "/WebContent";
            }
            FileWriter fw = new FileWriter(String.valueOf(filePath) + "/" + fileName);
            fw.write(emptyJspFileContent);
            String htmlTrxCode = this.xmlContent.getParent().getAttrValue("trxCode");
            String contentDivId = this.divIdText.getText();
            if (contentDivId.length() == 0) {
                contentDivId = IDEConstance.contentDivID;
            }
            fw.write("<!-- htmlTrxCode=\"");
            fw.write(htmlTrxCode);
            fw.write("\" toBeLayoutContent=\"");
            fw.write(String.valueOf(this.toBeLayoutContent));
            fw.write("\" contentDivId=\"");
            fw.write(contentDivId);
            fw.write("\" htmlTrxFileName=\"");
            fw.write(this.htmlTrxFileName);
            fw.write("\" -->\n");
            fw.write("</head>\n<body>\n</body>\n</html>\n");
            fw.close();
            this.project.getFolder("WebContent").refreshLocal(2, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteJSPFile(String fileName) {
        try {
            String classify = this.xmlContent.getParent().getAttrValue("classify");
            String filePath = classify != null && classify.length() > 0 ? String.valueOf(this.rootPath) + "/WebContent/" + classify : String.valueOf(this.rootPath) + "/WebContent";
            File file = new File(String.valueOf(filePath) + "/" + fileName);
            file.delete();
            this.project.getFolder("WebContent").refreshLocal(2, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkDuplicatedJSPFileName(String fileName) {
        try {
            String classify = this.xmlContent.getParent().getAttrValue("classify");
            String filePath = classify != null && classify.length() > 0 ? String.valueOf(this.rootPath) + "/WebContent/" + classify : String.valueOf(this.rootPath) + "/WebContent";
            File file = new File(String.valueOf(filePath) + "/" + fileName);
            if (file.exists()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setJSFunctionNode(XMLNode node) {
        this.jsFunctionNode = node;
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void editJSP(XMLNode contentNode) {
        if (contentNode == null) {
            return;
        }
        String fileName = contentNode.getAttrValue("fileName");
        String classify = this.xmlContent.getParent().getAttrValue("classify");
        String filePath = classify != null && classify.length() > 0 ? "WebContent/" + classify : "WebContent";
        final String aFileName = String.valueOf(filePath) + "/" + fileName;
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IFile file = HtmlTrxJspDefinePanel.this.project.getFile(aFileName);
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setProject(IProject prj) {
        this.project = prj;
    }

    private boolean checkPath(String rootPath, String fileName) {
        int idx = 0;
        int idx1 = rootPath.indexOf(":");
        if (idx1 != -1) {
            char ch1 = rootPath.charAt(0);
            ch1 = Character.toLowerCase(ch1);
            char ch2 = fileName.charAt(0);
            if (ch1 != (ch2 = Character.toLowerCase(ch2))) {
                return false;
            }
            String str1 = rootPath.substring(1);
            String str2 = fileName.substring(1);
            idx = str2.indexOf(str1);
        } else {
            idx = fileName.indexOf(rootPath);
        }
        return idx != -1;
    }

    public XMLNode getExternResource() {
        return this.externResourceNode;
    }

    public void setExternResource(XMLNode node) {
        this.externResourceNode = node;
    }

    private void rebuildJspFlowModel() {
        if (this.xmlContent == null) {
            return;
        }
        Vector childs = this.xmlContent.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode jspDefNode = (XMLNode)childs.elementAt(i);
            if ("jsp".equals(jspDefNode.getNodeName())) {
                String fileName = jspDefNode.getAttrValue("fileName");
                XMLNode jspNode = this.loadJSPFileContent(fileName);
                String document = jspDefNode.getDocument();
                jspDefNode.removeAllChilds();
                jspDefNode.setDocument(document);
                this.addFlowElement(jspDefNode, jspNode);
            }
            ++i;
        }
        this.removeEmptyFlowNode();
    }

    private void addFlowElement(XMLNode jspDefNode, XMLNode jspNode) {
        int i = 0;
        while (i < jspNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)jspNode.getChilds().elementAt(i);
            String nodeName = aNode.getNodeName();
            if (!"#text".equals(nodeName)) {
                if ("ctp:table".equalsIgnoreCase(nodeName)) {
                    jspDefNode.add(aNode);
                } else if ("ctp:form".equalsIgnoreCase(nodeName)) {
                    XMLNode node = new XMLNode("ctp:form");
                    node.copyFromNode(aNode);
                    jspDefNode.add(node);
                } else if ("ctp:jspAction".equalsIgnoreCase(nodeName)) {
                    jspDefNode.add(aNode);
                } else if ("ctp:srvOpAction".equalsIgnoreCase(nodeName)) {
                    jspDefNode.add(aNode);
                } else {
                    this.addFlowElement(jspDefNode, aNode);
                }
            }
            ++i;
        }
    }

    private void removeEmptyFlowNode() {
        Vector childs = this.xmlContent.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode jspDefNode = (XMLNode)childs.elementAt(i);
            if ("jsp".equals(jspDefNode.getNodeName())) {
                int k = 0;
                while (k < jspDefNode.getChilds().size()) {
                    XMLNode aNode = (XMLNode)jspDefNode.getChilds().elementAt(k);
                    if ("ctp:table".equalsIgnoreCase(aNode.getNodeName())) {
                        this.processTableEmptyFlowNode(jspDefNode, aNode);
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    private void processTableEmptyFlowNode(XMLNode jspNode, XMLNode tableNode) {
        boolean isEmptyTable = true;
        int i = 0;
        while (i < tableNode.getChilds().size()) {
            XMLNode columnNode = (XMLNode)tableNode.getChilds().elementAt(i);
            if ("ctp:tableColumn".equalsIgnoreCase(columnNode.getNodeName())) {
                if ("true".equals(columnNode.getAttrValue("selfAction"))) {
                    isEmptyTable = false;
                } else {
                    tableNode.remove(columnNode);
                }
            }
            ++i;
        }
        if (isEmptyTable && !"true".equals(tableNode.getAttrValue("toBeForm"))) {
            jspNode.remove(tableNode);
        }
    }

    private XMLNode loadJSPFileContent(String fileName) {
        String classify = this.xmlContent.getParent().getAttrValue("classify");
        String filePath = classify != null && classify.length() > 0 ? String.valueOf(this.rootPath) + "/WebContent/" + classify : String.valueOf(this.rootPath) + "/WebContent";
        try {
            JSPLoader jspLoader = new JSPLoader();
            jspLoader.addObjectMaker(new XMLElementObjectMaker());
            XMLNode node = (XMLNode)jspLoader.loadJSPFile(String.valueOf(filePath) + "/" + fileName);
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getHtmlTrxFileName() {
        return this.htmlTrxFileName;
    }

    public void setHtmlTrxFileName(String htmlTrxFileName) {
        this.htmlTrxFileName = htmlTrxFileName;
    }
}

